// Persistence of Vision Ray Tracer Scene Description File
// File: pbfaith.pov
// Version: POV-Ray 3.5
// Description: This is my still image for the IRTC of May/June 2003 (Topic: Mystery)
// Date: 22/6/2003
// Author: Paolo Brasolin
// Other: Ask me first if you want to use some of my models or textures!

//------------------------------ Resolutions
// HI
//+H681 +W1600 +A
// MID
//+H340 +W800
// LO
//+H170 +W400

//------------------------------ Includes
#include "woods.inc"

#include "book.inc"
#include "books.inc"
#include "chair.inc"
#include "clock.inc"
#include "cutting.inc"
#include "envelope.inc"
#include "glue.inc"
#include "lamp.inc"
#include "lens.inc"
#include "marker.inc"
#include "necro.inc"
#include "scissors.inc"
#include "sheet.inc"
#include "sheets.inc"
#include "trophy.inc"

//------------------------------ Camera (Techniscope)
camera {
  location  <-5, 50, -45>
  look_at   <0, 0, 27.5>
  right <2.35,0,0>
  angle 72
}

//------------------------------ Moon light
light_source {
  <-1000, 500, -1000>            
  color rgb <0.1,0.1,0.2>
}

//------------------------------ Objects
object { cathedrals_book rotate y*6 translate <-6,0,31> }
object { books_pile rotate y*75 translate <-50,0,55> }
object { chair rotate y*10 translate z*-13 no_shadow }
object { alarm_clock rotate y*30 translate <60,0,55> }
object { ancient_cutting rotate y*5 translate <-30,0,5> }
object { envelope rotate y*-15 translate <50,0.1,15> }
object { glue_stick rotate y*50 translate <51,0,12> }
object { lamp rotate y*40 translate <52,0,62> }
object { magnifying_lens rotate y*-120 translate <-20,0.5,30> }
object { marker rotate z*90 rotate y*-50 translate <20,0.5,10> }
object { necronomicon rotate y*-60 translate <-15,0,40> }
object { scissors translate <-7,0.5,10> }
object { design_sheet rotate y*-6 translate <-1,0,-3> }
object { sheets rotate y*-5 translate <-52,1.15,5> }
object { trophy rotate y*-20 translate <-10,0,70> }

//------------------------------ Table
union {
  box { <-80,-3,0>,<80,0,80> }
  cylinder { <-80,-0.5, 0>,< 80,-0.5, 0>,0.5 }
  cylinder { <-80,-0.5,80>,< 80,-0.5,80>,0.5 }
  cylinder { <-80,-0.5, 0>,<-80,-0.5,80>,0.5 }
  cylinder { < 80,-0.5, 0>,< 80,-0.5,80>,0.5 }
  cylinder { <-80,-1.5, 0>,< 80,-1.5, 0>,0.5 }
  cylinder { <-80,-1.5,80>,< 80,-1.5,80>,0.5 }
  cylinder { <-80,-1.5, 0>,<-80,-1.5,80>,0.5 }
  cylinder { < 80,-1.5, 0>,< 80,-1.5,80>,0.5 }
  cylinder { <-80,-2.5, 0>,< 80,-2.5, 0>,0.5 }
  cylinder { <-80,-2.5,80>,< 80,-2.5,80>,0.5 }
  cylinder { <-80,-2.5, 0>,<-80,-2.5,80>,0.5 }
  cylinder { < 80,-2.5, 0>,< 80,-2.5,80>,0.5 }
  texture { T_Wood6 finish { ambient 0.1 phong 0.1 phong_size 20 } scale 20 rotate z*90 rotate y*70 }
  translate y*-0.001 
}

//------------------------------ Walls and window
union {
  difference {
    box { <-1000,-100,0>,<1000,200,4> }
    box { <0,0,-1>,<40,100,5> }
    box { <50,0,-1>,<90,100,5> }
    box { <100,0,-1>,<140,100,5> }
    rotate y*90
    translate <-128,20,0>
  }
  box {<-90,-100,90>,<1000,100,1000>}
  texture { pigment { color rgb 1 } normal { granite, 0.4 } }
}