// Persistence of Vision Ray Tracer Scene Description File
// File: award.inc
// Vers: 3.5
// Desc: Include file containing the Medals for prize.pov
// Date: June 22, 2003
// Auth: Philip Chan

#ifdef(Award_Inc_Temp)
// do nothing
#else
#declare Award_Inc_Temp=version;

#ifdef(View_POV_Include_Stack)
#debug "including award.inc\n"
#end

#include "colors.inc"
#include "metals.inc"
#include "shapes.inc"
#include "woods.inc"

//----- Textures for Second Place Award -----//
// Silver metal texture
#declare T_2nd = texture {
	pigment { colour rgb <0.85, 0.85, 1.1> }
	finish {
		ambient 0.3
		diffuse 0.9
		brilliance 2
		specular 0.4
		roughness 0.01
		reflection 0.2
		metallic
	}
}

// Texture for engraved text
#declare T_2nd_text = texture {
	pigment { colour rgb <0.6, 0.6, 0.80> }
	finish {
		ambient 0.3
		diffuse 0.4
	}
}
//----- End of Second Place Textures -----//

//----- Textures for Third Place Award -----//
// Silver metal texture
#declare T_3rd = texture {
	pigment { colour rgb <0.95, 0.73, 0.55> }
	finish {
		ambient 0.3
		diffuse 0.9
		brilliance 3
		specular 0.4
		roughness 0.01
		reflection 0.2
		metallic
	}
}

// Texture for engraved text
#declare T_3rd_text = texture {
	pigment { colour rgb <0.65, 0.45, 0.35> }
	finish {
		ambient 0.3
		diffuse 0.4
	}
}
//----- End of Third Place Textures -----//

//----- Text Objects for Awards -----//
#declare IRTC_text = union {
	Circle_Text(
		"Arial.ttf",
		"INTERNET RAYTRACING",
		0.4, 0.0, 0.3, 1.5, false, Align_Center, 90
	)
	Circle_Text(
		"Arial.ttf",
		"COMPETITION",
		0.4, 0.0, 0.3, 1.5, true, Align_Center, -90
	)
	pigment {color White }
	finish { ambient 0.5 }
	rotate x*90
	translate y*0.15
}

#declare Second_text = union {
	object {
		Center_Object( text { ttf "ariblk.ttf", "2", 0.36, 0 }, y )
		rotate x*90
		translate <-0.7, 0, 0>
	}
	object {
		Center_Object( text { ttf "ariblk.ttf", "nd", 0.36, 0 }, y )
		scale <0.65, 0.65, 1>
		rotate x*90
		translate <0, 0, 0>
	}
}

#declare Third_text = union {
	object {
		Center_Object( text { ttf "ariblk.ttf", "3", 0.36, 0 }, y )
		rotate x*90
		translate <-0.7, 0, 0>
	}
	object {
		Center_Object( text { ttf "ariblk.ttf", "rd", 0.36, 0 }, y )
		scale <0.65, 0.65, 1>
		rotate x*90
		translate <0, 0, 0>
	}
}
//----- End of Text Objects -----//

//----- Awards Macro -----//
// T_Metal - Texture for metallic body of the award
// T_Text - Texture for engraved text on the award
// O_Text - Text object for the place number
#macro Award( T_Metal, T_Text, O_Text )
	union {
		// center piece
		difference {
			sphere { <0, 0, 0>, 1
				scale <1.5, 0.3, 1.5>
				texture { T_Metal }
			}
			difference {
				union {
					object {
						Center_Object( object { O_Text }, x )
						scale <1.2, 1, 1.2>
						translate <0, 0.36, 0.55>
					}
					object {
						Center_Object( text { ttf "ariblk.ttf", "PLACE", 0.36, 0 }, x )
						scale <0.65, 0.65, 1>
						rotate x*90
						translate <0, 0.36, -0.65>
					}
				}
				sphere { <0, 0, 0>, 1
					scale <1.5, 0.3, 1.5>
				}
				translate <0, -0.05, 0>
				texture { T_Text }
			}
		}
		// rim
		cylinder { <0, -0.1, 0>, <0, 0.1, 0>, 2
			texture { T_Wood32
				scale 15
				rotate <45, 45, 45>
			}
		}
		// text
		object { IRTC_text }
		// reflection
		difference {
			sphere { <0, 0, 0>, 1 }
			plane { -z, 0 }
			hollow
			no_image
			no_shadow
			texture { pigment { colour rgbt <1, 1, 1, 1> } }
			interior_texture {
				uv_mapping pigment {
					image_map { png "reflect.png" }
					scale <0.5, 1, 1>
				}
				finish { ambient 1.0 }
			}
			rotate <90, 0, 0>
			scale <1.5, 0.3, 1.5>
			translate <0, 0.1, 0>
		}
	}
#end
//----- End of Awards Macro -----//

//----- Award Shape -----/
// for cutouts in the case
#declare Award_Shape = union {
	sphere { <0, 0, 0>, 1
		scale <1.5, 0.3, 1.5> * 1.1 // enlarge slightly for difference operations
	}
	cylinder { <0, -0.15, 0>, <0, 0.15, 0>, 2.05 }
	// for smoothing edges of cut into the case
	cylinder { <0, -0.1, 0>, <0, 0.15, 0>, 2.15 }
}
//----- End of Award Shape -----//

#version Award_Inc_Temp;
#end
