// Persistence of Vision Ray Tracer Scene Description File
// File: book.inc
// Vers: 3.5
// Desc: Contains the coil book object for prize.pov
// Date: June 22, 2003
// Auth: Philip Chan

#ifdef(Book_Inc_Temp)
// do nothing
#else
#declare Book_Inc_Temp=version;

#ifdef(View_POV_Include_Stack)
#debug "including book.inc\n"
#end

#declare P_Writing = pigment {
	bozo
	turbulence 0.25
	octaves 1
	colour_map {
		[ 0.00 colour rgb <1, 1, 1> ]
		[ 0.10 colour rgb <1, 1, 1> ]
		[ 0.12 colour rgb <0.5, 0.5, 0.5> ]
		[ 0.48 colour rgb <0.5, 0.5, 0.5> ]
		[ 0.50 colour rgb <1, 1, 1> ]
		[ 0.60 colour rgb <1, 1, 1> ]
		[ 0.62 colour rgb <0.5, 0.5, 0.5> ]
		[ 1.00 colour rgb <0.5, 0.5, 0.5> ]
	}
	scale 0.5
}
		

#declare Book_side = union {
	difference {
		box { <-5, 0.1, -3.3>, <-0.1, 0.4, 3.3> }
		#declare i = -3.05;
		#while ( i <= 3.3 )
			box { <-0.325, 0, i-0.05>, <-0.25, 0.5, i + 0.25> }
			#declare i = i + 0.5;
		#end
		pigment { colour White }
	}
	// writing
	box { <-4.5, 0.0999, -2.8>, <-0.6, 0.4001, 2.8>
		texture {
			gradient z
			texture_map {
				[ 0.00 pigment { colour rgb <1, 1, 1> } ]
				[ 0.30 pigment { colour rgb <1, 1, 1> } ]
				[ 0.31 pigment { P_Writing } ]
				[ 1.00 pigment { P_Writing } ]
			}
			scale 0.25
		}
	}
}

#declare Book = union {
	// coils
	difference {
		cylinder { <0, 0.3, -3.05>, <0, 0.3, 3.2>, 0.3 }
		cylinder { <0, 0.3, -4>, <0, 0.3, 4>, 0.275 }
		#declare i = -2.85;
		#while ( i <= 3.3 )
			box { <-0.5, 0.1, i>, <0.5, 1, i + 0.3> }
			#declare i = i + 0.5;
		#end
		pigment { color Black }
	}
	object { Book_side }
	object { Book_side
		rotate z*180
		translate y*0.5
	}
}

#version Book_Inc_Temp;
#end
