// Persistence of Vision Ray Tracer Scene Description File
// File: fieldcam.inc
// Vers: 3.5
// Desc: Architectural Field Camera
// Date: December 26, 2002
// Auth: John Guthkelch (Doctor John)
// 			 Packaged into include file format by Philip Chan

#ifdef(Fieldcam_Inc_Temp)
// do nothing
#else
#declare Fieldcam_Inc_Temp=version;

#ifdef(View_POV_Include_Stack)
#debug "including fieldcam.inc\n"
#end
// Created by John Guthkelch (Doctor John) - 26 December 2002

#macro FieldCam (CP, CL)
	#local CD=CL-CP;
	#local HypoXZ=sqrt(pow(CD.x, 2)+pow(CD.z, 2));
	#local CosThetaX=CD.x/HypoXZ;
	#local CosThetaZ=CD.z/HypoXZ;
	#if (CD.x=0)
		#local ShearX=0;
	#else
		#local ShearX=(CD.y/CD.x)*pow(CosThetaX, 2);
	#end
	#if (CD.z=0)
		#local ShearZ=0;
	#else
		#local ShearZ=(CD.y/CD.z)*pow(CosThetaZ, 2);
	#end
	#declare NoFall=transform {
		matrix
			< 1, 0, 0, ShearX,
				1, ShearZ, 0, 0,
				1, 0, 0, 0
		  >
	}
#end

/*
#declare CamPos=<-20, 3, -10>;
#declare CamLook=<0, 16, 4>;

camera {
	FieldCam (CamPos, CamLook)
	perspective
	location CamPos
	transform { NoFall }
	angle 135
	look_at CamLook
}
*/

#version Fieldcam_Inc_Temp;
#end
