
// POV-Ray Object File - A Bathroom
// created 29-May-03
// last update 27-Jun-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Bathroom.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// BathroomGroup
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Bathroom origin is at the center of the floor
// Sky is up

#ifndef (ThisIsMaster) // now we know this include file was not called by another
	#declare RenderMe = 0; // supress self-rendering of other includes files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#include "PipeGroup.inc"
	#include "WaterTanks.inc"
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here


//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare WhitePorcelain =
	texture {
		pigment { color rgb<.991,.993,.999>*1.00 }
		finish { ambient 3.6 specular 0.97 roughness 0.05 } // render test
//		finish { ambient .8 specular 0.97 roughness 0.05 } // render
//		finish { ambient .4 specular 0.97 roughness 0.05 } // object test
	}
#declare FloorTex =
	texture {
		pigment {
//			checker <1,1,1>*0.4, <1,1,1>*0.8 // grey
			checker <.106,.102,.642>*0.8, <1,1,1>*1.34 // blue
			scale 10
		}
		finish { ambient .4 specular 0.97 roughness 0.05 }
	}
	texture { // upper layer
		pigment {
			checker rgbf<.84,.85,.82,.79>, rgbf<.82,.81,.8,.9985> // grey dirt
			turbulence 0.50
			scale 10
		}
		finish { ambient .4 specular 0.97 roughness 0.05 }
	}

#declare WoodTex =
	texture {
		pigment { color rgb <0.976,0.631,0.384>*1.00 }
		finish { specular 0.23 roughness 0.24 }
	}
#declare WindowFrameTex = texture { WoodTex }

#declare BrightAluminum =
	texture {
		pigment { color rgb <0.876,0.831,0.884>*.50 }
//		finish { specular 0.83 roughness 0.04 metallic brilliance 4 }
		finish { specular 0.93 roughness 0.014 metallic reflection .5 }
	}
#declare MirrorTex =
	texture {
		pigment { color rgb <0.66,0.61,0.64>*1.00 }
		finish { specular 0.83 roughness 0.01 metallic brilliance 4 reflection .95 }
	}
#declare WhitePlastic =
	texture {
		pigment { color rgb<.991,.993,.999>*1.00 }
		finish { ambient 0.24 specular 0.17 roughness 0.35 }
	}
#declare GreyPipe =
	texture {
		pigment { color rgb <0.876,0.831,0.884>*.50 }
		finish { specular 0.22 roughness 0.11 metallic }
	}

#declare SpilledWaterTex =
	texture {
		pigment { color rgbf<0.47,0.89,0.90,.58> }
		normal { bumps 0.96 scale 1.3 }
		finish { specular 0.99 roughness 0.008 reflection 0.24 }
	}
#declare SpilledWaterInt =
		interior { ior 1.33 }
#declare SpilledWaterMat =
	material {
		texture { SpilledWaterTex }
		interior { WaterInt }
	}
#declare SquirtTex =
	texture {
		pigment { color rgbf<0.47,0.89,0.90,.58> }
		normal { bumps 0.96 scale 0.8 }
		finish { specular 0.99 ambient 1.83 roughness 0.008 reflection 0.24 }
	}


//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

#declare BathroomFloor =
	union {
		box { // floor
			<-5*Feet,-5*Feet,-.42>,<5*Feet,1*Feet-2,0>
			texture { FloorTex }
		}
		box { // floor structure
			<-5*Feet,-5*Feet,-2>,<5*Feet,1*Feet,-.42>
			texture { WoodTex }
		}
		#declare BeamCount = 0;
		#while (BeamCount < 8)
			box {
				<-1.2,-5*Feet+1,-10>,<1.2,1*Feet-1,-0.5>
				translate <-5*Feet+3+BeamCount*16,0,0>
				texture { WoodTex }
			}
			#declare BeamCount = BeamCount+1;
		#end
	} // end union

#macro WindowFrame(Xlength,Zheight,SillThickness)
// Note: the frame is OUTSIDE the given dimensions!
	union {
		#local ST = SillThickness;
		box { <-0.75,-ST/2,0>,<0,ST/2,Zheight> } // left
		box { <Xlength,-ST/2,0>,<Xlength+0.75,ST/2,Zheight> } // right
		box { <-0.75,-ST/2-1.5,-0.75>,<Xlength+0.75,ST/2,0> } // sill
		box { <-0.75,-ST/2,Zheight>,<Xlength+0.75,ST/2,Zheight+0.75> } // top
		box { <Xlength/2-0.5,-0.5,0>,<Xlength/2+0.5,0.5,Zheight> } // v slat
		box { <0,-0.5,Zheight/2>,<Xlength,0.5,Zheight/2> } // h slat
		texture { WindowFrameTex }
	} // end union
#end

#declare Mirror =
	union {
		difference {
			box { // frame
				<-12.8,-.2,-.8>,<12.8,0.6,28.8>
			}
			box { // cutout
				<-12,-1,0>,<12,1,28>
			}
			texture { BrightAluminum }
		} // end difference
		box { // mirror
			<-12,0,0>,<12,0.1,28>
			texture { MirrorTex }
		}
	} // end union


//---------------- Toilets ----------------------

#declare ToiletS = // simple version
	union {
		cylinder {
			<0,0,0>,<0,0,20>,9
			scale <1,1.2,1>
		}
		box {
			<-12,0,0>,<12,8,16>
			translate <0,9,18>
		}
		texture { WhitePorcelain }
	} // end union

#declare Toilet = // good version
	union {
		cylinder { // bowl
			<0,0,0>,<0,0,16>,9
			scale <1,1.4,1>
		}
		superellipsoid { // bowl lid
			<1.0,.3>
			scale <9,9,1.2>
			scale <1,1.4,1>
			translate <0,0,18>
		}
		superellipsoid { // tank
			<.135,.135>
			scale <12,4,9>
			translate <0,11,24>
		}
		superellipsoid { // lid
			<.3,.3>
			scale <12.4,4.2,1>
			translate <0,11,31.0>
		}
		box { // handle
			<0,0,-0.5>,<3.5,1,0.5>
			texture { BrightAluminum }
			translate <9,6.3,29.5>
		}
		cylinder { // handle
			<0,0,0>,<0,2,0>,.7
			texture { BrightAluminum }
			translate <9,6.3,29.5>
		}
		texture { WhitePorcelain }
	} // end union

#declare BlobToilet = // better version
	union {
		#declare BS=1.00; // blob component strength
		blob {
			threshold .160
			cylinder { <0,-4,0>,<0,6,0>,10,BS scale <0.60,0.98,.2> translate <2.2,0,1> } // base
			cylinder { <0,-4,0>,<0,6,0>,10,BS scale <0.60,0.98,.2> translate <-2.2,0,1> } // base

			sphere { <0,0,0>,16,BS scale <.7,1.0,1> translate <0,-2,16> } // bowl
			sphere { <0,0,0>,16,-3 scale <.7,1,1> translate <0,-2,26>} // flatten bowl top

			cylinder { <0,0,0>,<0,0,4>,5,BS scale <1,1,1> translate <0,-5,0> }
			cylinder { <0,2,0>,<0,10,4>,5,BS scale <1,1,1> translate <0,-5,0> }
			cylinder { <0,2,0>,<0,10,4>,5,BS scale <1,1,1> rotate x*45 translate <0,4,6> }
			cylinder { <0,0,0>,<0,0,4>,7,BS scale <1,1,1> translate <0,9,10> }
			translate <0,0,0>
		}


		superellipsoid { // bowl lid
			<1.0,.3>
			scale <9,9,1.2>
			scale <1,1.4,1>
			translate <0,-2,18>
		}
		superellipsoid { // tank
			<.135,.135>
			scale <12,4,9>
			translate <0,11,24.8>
		}
		superellipsoid { // tank lid
			<.3,.3>
			scale <12.4,4.2,1>
			translate <0,11,31.8>
		}
		superellipsoid { // handle
			<.3,.3>
			scale <2.1,.7,.7>
			translate <2.5,0,0.5>
			texture { BrightAluminum }
			translate <9,6.3,29.5>
		}
		superellipsoid { // handle
			<.95,.3>
			scale <.76,2,.76>
			translate <0,1,0>
			texture { BrightAluminum }
			translate <9,6.3,29.5>
		}
		texture { WhitePorcelain }
	} // end union


//---------------- Sinks ----------------------

#declare SinkS = // simple version, center under drain
	union {
		cylinder { // leg
			<0,0,0>,<0,0,28>,0.9
			translate <-8,-8,0>
			texture { BrightAluminum }
		}
		cylinder { // leg
			<0,0,0>,<0,0,28>,0.9
			translate <8,-8,0>
			texture { BrightAluminum }
		}
		box {
			<-10,-10,0>,<10,10,6>
			translate <0,0,28>
		}
		texture { WhitePorcelain }
	} // end union

#declare Faucet =
	union {
		superellipsoid {
			<.2,.2>
			scale <5,2,0.6>
		}
		sphere_sweep {
			b_spline
			5,
			<0,0,-1>,1.3,<0,0,0>,1.1,<0,-1.1,2>,.8,<0,-3,2.5>,.6,<0,-4,1.8>,.5
		}
		cylinder {
			<0,0,0>,<0,0,2>,.4
			translate <3,0,0>
		}
		superellipsoid {
			<.4,.4>
			scale <1,1,1>
			translate <3,0,1.9>
		}
		superellipsoid {
			<.4,.4>
			scale <1,.2,.7>
			translate <3.5,0,2.2>
		}
		cylinder {
			<0,0,0>,<0,0,2>,.4
			translate <-3,0,0>
		}
		superellipsoid {
			<.4,.4>
			scale <1,1,1>
			translate <-3,0,1.9>
		}
		superellipsoid {
			<.4,.4>
			scale <1,.2,.7>
			translate <-3.5,0,2.2>
		}
		texture { BrightAluminum }
	} // end union

#declare Sink = // better version, center under drain
	union {
		superellipsoid { // main
			<.3,.3>
			scale <10,10,4>
			scale <1,1,1>
			translate <0,0,28>
		}
		superellipsoid { // drain
			<.6,.6>
			scale <6,6,4>
			translate <0,0,25>
		}
		superellipsoid { // backsplash
			<.1,.1>
			scale <9,1,3>
			translate <0,10,33>
		}
		cylinder { // leg
			<0,0,0>,<0,0,28>,0.9
			translate <-8,-8,0>
			texture { BrightAluminum }
		}
		cylinder { // leg
			<0,0,0>,<0,0,28>,0.9
			translate <8,-8,0>
			texture { BrightAluminum }
		}
		texture { WhitePorcelain }
	} // end union

#declare BlobSink =
	union {
		object { Faucet translate <0,8,31> }
		#declare BS=1.00; // blob component strength
		blob {
			threshold .160
			sphere { <0,0,0>,16,BS scale <1,1,.6>}

			sphere { <0,0,0>,14,-2 scale <1,1,.8> translate <0,0,9> } // flatten top
			sphere { <0,0,0>,10,-3 scale <1,1,.8> translate <0,-1.5,6> } // inner bowl

			cylinder { <-9,0,0>,<9,0,0>,4,BS scale <1,.8,1> translate <0,-10,0> }
			cylinder { <-9,0,0>,<9,0,0>,4,BS scale <1,.8,1> rotate z*90 translate <-10,0,0> }
			cylinder { <-9,0,0>,<9,0,0>,4,BS scale <1,.8,1> rotate z*90 translate < 10,0,0> }

			cylinder { <-9,0,0>,<9,0,0>,4,BS scale <1,.8,1> translate <0,-10,-2> }
			cylinder { <-9,0,0>,<9,0,0>,4,BS scale <1,.8,1> rotate z*90 translate <-10,0,-2> }
			cylinder { <-9,0,0>,<9,0,0>,4,BS scale <1,.8,1> rotate z*90 translate < 10,0,-2> }

			cylinder { <-9,0,0>,<9,0,0>,4,BS scale <1,.8,1> translate <0,12,2> } // backsplash
			cylinder { <-9,0,0>,<9,0,0>,4,BS scale <1,.8,1> translate <0,12,4> } // backsplash
			cylinder { <-9,0,0>,<9,0,0>,4,BS scale <1,.8,1> translate <0,12,0> } // backsplash
			cylinder { <-9,0,0>,<9,0,0>,4,BS scale <1,.8,1> translate <0,12,-2> } // backsplash
			translate <0,0,28>
		}
		superellipsoid { // drain
			<.9,.6>
			scale <1.6,1.6,1.0>
			translate <0,-1.6,27.6>
			texture { BrightAluminum }
		}
		cylinder { // leg
			<0,0,0>,<0,0,28>,0.9
			translate <-10,-10,0>
			texture { BrightAluminum }
		}
		cylinder { // leg
			<0,0,0>,<0,0,28>,0.9
			translate <10,-10,0>
			texture { BrightAluminum }
		}
		cylinder { // water
			<0,0,-6>,<0,0,2>,6
			material { SpilledWaterMat }
			translate <0,0,28>
		}
		texture { WhitePorcelain }
	} // end union

#declare SoapDish =
	union {
		#declare BS=1.00; // blob component strength
		blob {
			threshold .160
			sphere { <0,0,0>,16,BS scale <1,1,.6>}
			sphere { <0,0,0>,14,-8 scale <1,1,.6> translate <0,0,9> } // inner bowl
			cylinder { <-9,0,0>,<9,0,0>,4,BS scale <1,.8,1> translate <0,-10,0> }
			cylinder { <-9,0,0>,<9,0,0>,4,BS scale <1,.8,1> rotate z*90 translate <-10,0,0> }
			cylinder { <-9,0,0>,<9,0,0>,4,BS scale <1,.8,1> rotate z*90 translate < 10,0,0> }
			cylinder { <-9,0,0>,<9,0,0>,4,BS scale <1,.8,1> translate <0,-10,-2> }
			cylinder { <-9,0,0>,<9,0,0>,4,BS scale <1,.8,1> rotate z*90 translate <-10,0,-2> }
			cylinder { <-9,0,0>,<9,0,0>,4,BS scale <1,.8,1> rotate z*90 translate < 10,0,-2> }
			cylinder { <-9,0,0>,<9,0,0>,4,BS scale <1,.8,1> translate <0,12,2> } // backsplash
			cylinder { <-9,0,0>,<9,0,0>,4,BS scale <1,.8,1> translate <0,12,4> } // backsplash
		scale <.28,.19,.20>
		}
		texture { WhitePorcelain }
	} // end union
#declare SoapDishL =
	union {
		object { SoapDish }
		difference {
			cone {
				<0,0,0>,1.43,<0,0,4>,1.87
				translate <0,0,0.5>
				texture { pigment { rgbf<.32,.73,.82,.9> } }
			}
			cone {
				<0,0,0>,1.43,<0,0,4>,1.87
				translate <0,0,0.6>
				texture { pigment { rgbf<.32,.73,.82,.9> } }
			}
		} // end difference
	} // end union
#declare SoapDishR =
	union {
		object { SoapDish }
		cylinder {
			<0,0,0>,<0,0,-6>,.217
			scale <.75,1,1>
			translate <2,-1.7,2>
			texture { pigment { rgb<.72,.78,.92> } }
		}
		cylinder {
			<0,0,0>,<0,0,-6>,.217
			scale <.75,1,1>
			translate <-2,-1.7,2.2>
			texture { pigment { rgb<.92,.98,.62> } }
		}
	} // end union


//---------------- Pipes ----------------------

#declare SinkHotPipeArray=
	array[6]
	{<0,0,0>,<0,4,0>,<0,4,-36>,<0,-5.8*Feet,-36>,
	<0,-2*Feet,-36>,<0,-2*Feet,-40>
	}
#declare SinkHotPipes = object { PipeTrackS(SinkHotPipeArray,0.7,CopperTex) }

#declare MainHotPipeArray=
	array[6]
	{<0,0,0>,<-4*Feet,0,0>,<8*Feet-6,0,0>,<8*Feet-6,3.6*Feet,0>,
	<8*Feet,3.6*Feet,0>,<8*Feet,3.6*Feet,-70>
	}
#declare MainHotPipes = object { PipeTrackS(MainHotPipeArray,1.7,CopperTex) }

#declare ColdPipeArray=
	array[7]
	{<0,0,0>,<0,4,0>,<0,4,-36>,<-3*Feet,4,-36>,
	<-3*Feet,4,-6>,<-3*Feet,-3,-6>,<-3*Feet,-3,5>
	}
#declare ColdPipes = object { PipeTrackS(ColdPipeArray,0.7,CopperTex) }

#declare MainColdPipeArray=
	array[11]
	{<0,0,0>,<0,0,-6>,<0,2*Feet,-6>,<0,-5.1*Feet,-6>,
	<0,-3*Feet,-6>,<0,-3*Feet,-12>,<8*Feet,-3*Feet,-12>,<8*Feet,-3*Feet,-40>,
	<8*Feet,-3*Feet+20,-40>,<8*Feet,-3*Feet+20,-80>,<6*Feet,-3*Feet+20,-80>
	}
#declare MainColdPipes = object { PipeTrackS(MainColdPipeArray,1.7,CopperTex) }

#declare ColdToHotPipeArray=
	array[4]
	{<0,0,0>,<32,0,0>,<32,4*Feet,0>,<32,4*Feet,-50>,
	}
#declare ColdToHotPipes = object { PipeTrackS(ColdToHotPipeArray,1.7,CopperTex) }

#declare SinkDrainArray=
	array[6]
	{<0,0,0>,<0,0,-18>,<0,5,-18>,<0,5,-8>,<0,12,-8>,<0,12,-40> }
#declare SinkDrain = object { PipeTrack(SinkDrainArray,2.0,WhitePlastic) }

#declare SewerArray1=
	array[6]
	{<0,0,20>,<0,0,-16>,<3*Feet,0,-16>,<3*Feet,-3*Feet,-16>,
	<3*Feet,-3*Feet,-13*Feet>,<-1.5*Feet,-3*Feet,-13*Feet>
	}
#declare SewerPipes1 = object { PipeTrack(SewerArray1,4.0,WhitePlastic) }

#declare SupplyArray1=
/*
	array[8]
	{<0,0,0>,<36,0,0>,<36,24,0>,<36,24,-24*Feet>,
	<12*Feet-10,24,-24*Feet>,<12*Feet-10,18*Feet,-24*Feet>,
	<12*Feet-10,18*Feet,-40*Feet-4>,<12*Feet-10,14*Feet,-40*Feet-4>
	}
*/
	array[5]
	{<0,0,0>,<36,0,0>,<36,-40,0>,<-6,-40,0>,
	<-6,-40,-30*Feet>

	}
#declare InletValveGroup =
	union {
		cylinder {
			<0,-10,0>,<0,3,0>,3.0
		}
		cylinder {
			<-24,-6,6>,<0,-6,6>,1.8
		}
		cylinder {
			<0,-6,0>,<0,-6,8>,2.0
		}
		cylinder {
			<0,-6,8>,<0,-6,12>,3.2
		}
		sphere {
			<0,0,0>,3.2
			scale <1,1,.3>
			translate <0,-6,12>
		}
		texture { GreyPipe }
	} // end union
#declare SupplyPipes1 =
	union {
		object { PipeTrack(SupplyArray1,2.7,GreyPipe) }
		object { InletValveGroup translate <26,0,0> }
	} // end union

#declare Spill =
	blob {
		threshold 0.85
		sphere { <0,0,0>,40,1.0 }
		sphere { <0,0,0>,12,1.0 translate <10,8,0> }
		sphere { <0,0,0>,18,1.0 translate <-8,-8,0> }
		sphere { <0,0,0>,19,1.0 translate <8,-3,0> }
//		sphere { <0,0,0>,24,1.0 translate <12,4,0> }
		scale <.61,.8,.04>
//		texture { WhitePlastic } // test
		material { SpilledWaterMat }
	}
#declare Squirt =
	sphere_sweep {
		b_spline
		6,
		<-5,0,-6>,0.6,<0,0,3>,0.7,<5,0,10>,0.8,<12,0,0>,0.9,<15,0,-18>,0.5,<20,0,-27>,0.22
		texture { SquirtTex }
	}

#declare BathroomGroup =
	union {

		object { BathroomFloor }
		object { Spill translate <33,-5,0.0> }
		object { Squirt rotate z*38 translate <27,13,7> }
		object { Squirt scale 1.13 rotate <0.2,4.6,46> translate <27,13,7> }
//		object { WindowFrame(24,24,2) rotate z*90 translate <-5*Feet,-3*Feet,40> }
		object { BlobToilet translate <-2*Feet,-5,0> }
		object { BlobSink translate <2*Feet,0*Feet,0> }
		object { SoapDishL translate <2*Feet-10,11,40> }
		object { SoapDishR translate <2*Feet+10,11,40> }
		object { Mirror translate <2*Feet,13,44> }

		object { SinkHotPipes translate <2*Feet+3,8,16> }
		object { SinkDrain translate <2*Feet,0,24> }
		object { MainHotPipes translate <2*Feet,8-2*Feet,16-40> }
		object { ColdPipes translate <2*Feet-3,8,16> }
		object { MainColdPipes translate <-1*Feet,8,16-36> }
		object { ColdToHotPipes translate <-1*Feet,8,16-36>+<8*Feet,-3*Feet,-12> }
		object { HotWaterTank translate <8*Feet+2*Feet,4*Feet-2*Feet,-80-70+20> }
		object { BlueTank translate <5*Feet,-1*Feet,-80-36> }

		object { SewerPipes1 translate <0,10,-36> }
		object { SupplyPipes1 translate <56,-6,-110> }
	} // end union


//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

global_settings {	max_trace_level 50 }
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 50
		location  <12*Feet,-13*Feet, 12*Feet> // overall
		look_at <1*Feet,0*Feet,4*Feet>
	}


light_source
{ <800*Feet,-700*Feet,1000*Feet>, .5
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-400*Feet,-200*Feet,300*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}

plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 10*Feet }


object { BathroomGroup scale 1 rotate z*0 translate <-0*Feet,0,2*Feet> }
object { BathroomGroup scale 1 rotate z*-68 translate <-2*Feet,20*Feet,2*Feet> }  

#end
