//
// Glenn's BlobMan POV-Ray Scene File
// first concept 30-May-97 last update 17-Jun-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )
// This file does not render.  #include "BlobMan35.inc" in another .pov file
//
// Objects:
// BlobMan
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Origin at base of neck
// +X is towards the back of the person.
// Sorry, this system does not incorporate inverse kinematics. 8-)


//===============================================
//             Variable Declarations
//===============================================

#ifndef (ThisIsMaster) // now we know this include file was not called by another
	#declare RenderMe = 0; // supress self-rendering of other includes files
	#declare ThisIsMaster = 1;
	#include "GRuler.inc"
	#include "Colors.inc"
	#include "Textures.inc"
	#include "GIncludeRH.inc"
	#declare RenderMe = 1;
#end

#include "BlobHead31.inc"
#include "BlobHand31.inc"
//#include "Accessories.inc"

#ifndef ( Pose )
// Pose Angles ( in order )
#declare HPan     = 2;   // head, positive = towards his left
#declare HTiltFwd = -30;   // head forward tilt
#declare HCock    = 0;    // head right/left tilt, positive = to the left
#declare TTwist   = 0;    // torso twist, positive = right hip fwd
#declare HipTude  = 0;    // hip attitude, positive = right hip up
#declare RWCock   = 0;    // wrist side-to-side (golf)
#declare RWAng    = 0;    // wrist angle
#declare RETwist  = 80;   // twists the hand, positive = palms up
#declare REAng    = 116;  // elbow
#declare RAFwd    = -32;   // total arm
#declare RARot    = 52;   // claps hands
#declare RAOut    = 32;   // opens underarm
#declare RAFwd2   = -20;    // total arm
#declare RARot2   = -20;    // claps hands
#declare RKnee    = 0;    // knee bend
#declare RLTwist  = 0;    // leg twist
#declare RLAng    = -5;    // leg angle fwd
#declare RLOut    = 5;    // spread eagle
#declare LWCock   = 20;   // wrist side-to-side (golf)
#declare LWAng    = 0;    // wrist angle
#declare LETwist  = 80;  // twists the hand, positive = palms up
#declare LEAng    = 116;   // elbow
#declare LAFwd    = -32;   // total arm
#declare LARot    = 52;   // claps hands
#declare LAOut    = 32;    // opens underarm
#declare LAFwd2   = -20;    // total arm
#declare LARot2   = -20;  // claps hands
#declare LKnee    = 24;    // knee bend
#declare LLTwist  = 0;    // leg twist
#declare LLAng    = -5;    // leg angle fwd
#declare LLOut    = 5;    // spread eagle

// RightHand Pose Angles ( in order )
#end

//===============================================
//             Textures
//===============================================
/*
#declare SuitTex = // Blue
	texture {
		pigment {color rgb<.15,.15,.6> }
		normal {
			crackle 1.2
			scale <1,2,2>
		}
		finish { ambient .08 specular .3 roughness .03 }
	}
#declare ClothTex = texture { SuitTex }
*/
#declare ClothTex = // blue
	texture {
		pigment {color rgb<0.5,0.5,1.0>*0.6 }
		normal {
			crackle 1.2
			scale <1,2,2>
		}
		finish { ambient .3 specular .28 roughness .086 }
	}
#declare PantsTex =
	texture {
		pigment {color rgb<0.35,0.39,0.72>*.5 }
		normal {
			crackle 1.2
			scale <1,2,2>
		}
		finish { ambient .3 specular .28 roughness .086 }
	}
#declare SocksTex =
	texture {
		pigment {color rgb<0.79,0.79,0.76> }
		normal {
			crackle 1.2
			scale <.1,.2,.2>
		}
		finish { ambient .3 specular .28 roughness .086 }
	}
#declare ShoesTex =
	texture {
		pigment {color rgb<0.26,0.29,0.16>*.6 }
		normal {
			crackle 1.2
			scale <1,2,2>*.4
		}
		finish { ambient .3 specular .66 roughness .046 }
	}
#declare HatTex =
	texture {
		pigment {color rgb<1,1,1>*1.1 }
		finish { ambient .3 specular .06 roughness .46 }
	}

//===============================================
//       Objects
//===============================================


#declare TorsoHalf =
	union {
		sphere { // upper shoulders
			<0,0,0>,9
			scale <.4,1,.4>
			texture { ClothTex }
		}
		cylinder { //torso
			<0,0,0>,<0,0,-18>,9
			scale <.4,1,1>
			texture { ClothTex }
		}
		sphere { // lower end
			<0,0,0>,9
			scale <.4,1,.3>
			translate <0,0,-14>
			texture { ClothTex }
		}
		rotate <10,0,0>
		clipped_by { box {<-6,0,6>,<6,-12,-30>}}
	}

#declare Torso = //center where neck/shoulder join each other
	union {
		object { TorsoHalf }
		object { TorsoHalf transform InverseY }
	}
#declare LHand = // points straight down
	object { LeftHand
//	object { LeftHandWithGunFiring
			rotate <0,-90,0> // point downwards
			rotate <0,LWCock,LWAng> // wrist angles
			translate <-0.0,0.6,-1.6> // drop down, move to touch sleeve
		}
#declare LLowerArm =
	union {
		object { LHand }
			cone { //lower sleeve except cuff
				<0,0,2>,1.82,<0,0,11>,2.2
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
		difference {
			cylinder { //lower sleeve outer
				<0,0,0>,<0,0,2.1>,1.9
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
			cylinder { //lower sleeve inner
				<0,0,-.1>,<0,0,6>,1.85
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
		} // end difference
		sphere { // elbow joint
			<0,0,11>,2.2
			texture { ClothTex }
			rotate <0,0,0>
			translate <0,0,>
		}
		translate <0,0,-11> // origin at elbow
	}

#declare LeftArm = //origin at shoulder
	union {
		object { LLowerArm rotate <0,0,LETwist> rotate <0,LEAng,0> }
		sphere { // elbow end
			<0,0,0>,2.2
			texture { ClothTex }
		}
		cone { //upper arm
			<0,0,0>,2.2,<0,0,11>,2.5
			texture { ClothTex }
			rotate <0,0,0>
		}
		sphere { //shoulder end
			<0,0,11>,2.5
			texture { ClothTex }
		}
		translate <0,0,-11> // origin at shoulder
	}

#declare RHand = // points straight down
	object { RightHand
		rotate <0,-90,0> // point downwards
		translate <0.0,-0.6,-1.0> // drop down, move to touch sleeve
	}
#declare RLowerArm =
	union {
		object { RHand }
		difference {
			cone { //lower sleeve outer
				<0,0,0>,1.9,<0,0,11>,2.2
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
			cylinder { //lower sleeve inner
				<0,0,-.1>,<0,0,6>,1.8
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
		} // end difference
		sphere { // elbow joint
			<0,0,11>,2.2
			texture { ClothTex }
			rotate <0,0,0>
			translate <0,0,>
		}
		translate <0,0,-11> // origin at elbow
	}

#declare RightArm = //origin at shoulder
	union {
		object { RLowerArm rotate <0,0,-RETwist> rotate <0,REAng,0> }
		sphere { // elbow end
			<0,0,0>,2.2
			texture { ClothTex }
		}
		cone { //upper arm
			<0,0,0>,2.2,<0,0,11>,2.5
			texture { ClothTex }
			rotate <0,0,0>
		}
		sphere { //shoulder end
			<0,0,11>,2.5
			texture { ClothTex }
		}
		translate <0,0,-11> // origin at shoulder
	}

#declare FootShoe =
	union {
		cylinder {
			<0,0,1>,<0,0,8>,1.85
			scale <1,.6,1>
			texture { SocksTex }
		}
		superellipsoid { // main shoe
			<.5,.5>
			scale <4.6,2.8,2>
			rotate <0,-11,0>
			translate <-4,0,0.8>
			texture { ShoesTex }
		}
		box { // heel
			<-1,-1.5,0>,<1,1.5,.8>
			texture { ShoesTex }
		}
		scale 0.8
	} // end union

#declare RLowerLeg =
	union {
		object { FootShoe translate <0,0,-4> }
		sphere { // knee end
			<0,0,17>,2.8
			texture { PantsTex }
		}
		cone { // lower leg
			<0,0,0>,2.4,<0,0,17>,2.8
			texture { PantsTex }
			rotate <0,0,0>
		}
		translate <0,0,-17> // origin at knee
	}

#declare LLowerLeg =
	union {
		object { FootShoe translate <0,0,-4> }
		sphere { // knee end
			<0,0,17>,2.8
			texture { PantsTex }
		}
		cone { // lower leg
			<0,0,0>,2.4,<0,0,17>,2.8
			texture { PantsTex }
			rotate <0,0,0>
		}
		translate <0,0,-17> // origin at knee
	}

#declare RightLeg = // origin at pelvis joint
	union {
		object { RLowerLeg rotate <0,0,-RLTwist> rotate <0,-RKnee,0> }
		sphere { // knee end
			<0,0,0>,2.8
			texture { PantsTex }
		}
		cone { // upper leg
//			<0,0,0>,2.8,<0,0,18>,3.7
			<0,0,0>,2.5,<0,0,16>,3.5
			texture { PantsTex }
			rotate <0,0,0>
		}
		sphere { // pelvis end
//			<0,0,18>,3.5
			<0,0,16>,3.7
			texture { PantsTex }
		}
//		translate <0,0,-18> // origin at pelvis joint
		translate <0,0,-16> // origin at pelvis joint
	}

#declare LeftLeg = // origin at pelvis joint
	union {
		object { LLowerLeg rotate <0,0,-LLTwist> rotate <0,-LKnee,0> }
		sphere { // knee end
			<0,0,0>,2.8
			texture { PantsTex }
		}
		cone { // upper leg
//			<0,0,0>,2.8,<0,0,18>,3.7
			<0,0,0>,2.5,<0,0,16>,3.5
			texture { PantsTex }
			rotate <0,0,0>
		}
		sphere { // pelvis end
//			<0,0,18>,3.5
			<0,0,16>,3.7
			texture { PantsTex }
		}
//		translate <0,0,-18> // origin at pelvis joint
		translate <0,0,-16> // origin at pelvis joint
	}

#declare Hips =
	union {
		sphere { // top of cyl
			<0,0,0>,5
			scale <.8,1,.4>
			translate <0,0,8>
			texture { ClothTex }
		}
		cylinder { // main part
			<0,0,0>,<0,0,8>,5
			scale <.8,1,1>
			translate <0,0,0>
			texture { ClothTex }
		}
		sphere { // bottom of cyl
			<0,0,0>,5
			scale <.8,1,.4>
			translate <0,0,0>
			texture { ClothTex }
		}
		sphere { // butt cheek RH
			<0,0,0>,5
			scale <.7,.8,1>
			translate <0,-2,0>
			texture { ClothTex }
		}
		sphere { // butt cheek LH
			<0,0,0>,5
			scale <.7,.8,1>
			translate <0,2,0>
			texture { ClothTex }
		}
	} // end union

#declare LowerTorso =
	union {
		object { Hips translate <.5,0,0> }
		object { LeftLeg
			rotate <-LLOut,LLAng,0>
			translate <0,-3,0>
		}
		object { RightLeg
			rotate <RLOut,RLAng,0>
			translate <0,3,0>
		}
	} // end union

#declare BallCap =
	union {
		difference {
			sphere {
				<0,0,0>,4.2
				scale <1,.8,1>
			}
			cylinder {
				<0,0,-0.1>,<0,0,-8>,6
			}
		} // end difference
		box {
			<-4.6,-3,0>,<0,3,.3>
		}
		texture { HatTex }
	} // end union

#declare BlobMan = //center at base of neck
	union {

		object { MaleHead scale 1.25 rotate <0,0,HPan> rotate <HCock,-HTiltFwd,0> }
		object { BallCap scale 1.25 rotate y*20 translate <-1.3,0,8.4> rotate <0,0,HPan> rotate <HCock,-HTiltFwd,0> }
		object { Torso rotate <0,0,0> translate <0,0,0> }
		object { LeftArm
			rotate <0,LAFwd,-LARot>
			rotate <-LAOut,0,0>
			rotate <0,LAFwd2,LARot2>
			translate <0,-8,-1> // hang it on the shoulder
		}
		object { RightArm
			rotate <0,RAFwd,RARot>
			rotate <RAOut,0,0>
			rotate <0,RAFwd2,-RARot2>
			translate <0,8,-1> // hang it on the shoulder
		}

		object { LowerTorso
			rotate <HipTude,0,0>
			rotate <0,0,TTwist>
//			translate <0,0,-18> // hang it on the spine
			translate <0,0,-22> // hang it on the spine
		}
	}

#declare ToolBox =
	union {
		difference {
			box {
				<0,-4,0>,<28,4,8>
			}
			box {
				<-1,-6,0>,<30,6,10>
				rotate x*45
				translate <0,-4,6>
			}
			box {
				<-1,-6,0>,<30,6,10>
				rotate x*-45
				translate <0,4,6>
			}
			texture { pigment { color rgb <1.000,0.071,0.024> } }
		} // end difference
		sphere_sweep {
			b_spline, 6,
			<-0.5,0,-0.5>,0.3,<0,0,0>,0.4,<2,0,2>,0.5,
			<6,0,2>,0.5,<8,0,0>,0.4,<8.5,0,-0.5>,0.3
			translate <12,0,8>
			texture { pigment { color rgb<.03,.04,.03> } }
		}
	} // end union

//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//  location  <-13, -10, 7> // origin closeup
//  look_at   <0.000, 0.000, 0.000>
//  location  <-33, -0, 7> // head front view
//  look_at   <0.000, 0.000, 4.000>
//  location  <2, -30, 4> // head side view
//  look_at   <2, 0, 4>
//  location  <-1, -1, 28> // top view
//  look_at   <0.000, 0.000, 4.000>
//  location  <-9, -4, 2.2> // eye closeup
//  look_at   <0.000, 0.000, 2.200>
//  location  <-25, -22, 7> // 3/4 head view
//  look_at   <0.000, 0.000, 4.000>
//  location  <0, -66, 0> // overall side view
//  look_at   <0, 0, -6>
//  location  <-60, 0, 4> // overall front view
//  look_at   <0, 0, -4>
//  location  <-52, -48, 8> // 3/4 overall view
//  look_at   <0.000, 0.000, -8.000>
  location  <-18, -15*Feet, 58> // render view
  look_at   <-8, 0, 36>
	angle 40
}
camera { Render_Cam }

light_source
{ <40*Feet,-35*Feet,50*Feet>, 2.0
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 12 }


object { BlobMan translate <0,-6,5*Feet> }
object { BlobMan rotate z*90 translate <3*Feet,0,5*Feet> }
object { BlobMan rotate z*-60 translate <-4*Feet,6*Feet,5*Feet> }
object { ToolBox rotate z*0 translate <2*Feet,-2*Feet,0> }
object { ToolBox rotate z*-40 translate <-2*Feet,-2*Feet,0> }
//sphere {<0,0,-3>,3 pigment { White } }

#end
