/*
Glenn's Motion Blur POV-Ray Include File, Version 2.0
This file does not render.  #include "BlurFilt.inc" in another .pov file
created 18-Apr-97  last update 12-Jun-97
copyright 1997 Glenn McCarter   gmccarter@hotmail.com

Creates "filters" for simulating motion blur
Two types of motion blur filters are here --

Type A: StreakBlurFilter and CircBlurFilter
        These filters are an invisible box (or cylinder) which
        refracts light with a special texture.  The effect
        looks like thin "streaks".
Type B: FadeBlurFilter
        This filter is a colored box which fades to clear
        in all directions.  This is a smooth fading blur.

Each filter box lies from 0 to 1 in +X+Y plane, with Z=0.0 to 0.0001
Motion is always blurred in the X-direction

Tips for using BlurFilt.inc
1. Set the parameters as shown below, then "include" this file,
   then align the filter so that it is trailing behind your object.
2. Use a color that is similar to the object you want to blur.
3. Carefully align the top and bottom edges of each box to
   the object you want to blur.
4. Keep it subtle!  The "strength" factor, especially, should
   normally be in the 0.3 to 0.8 range.
*/

//===============================================
//             Type A - Streaks
//===============================================

// copy these into your file to use this motion blur:
/*
  #declare BFX = 3         //blurred area X scale
  #declare BFY = 3         //blurred area Y scale
  #declare BStrength = .8  //amount of blur (range 0 to 1)
  #include "BlurFilt.inc"
  #declare MyBlur = object { StreakBlurFilter }
*/
// The +X and -X ends of the box are not blurred,
// only the center section, from top edge to bottom edge,
// are blurred.
// the entire blur is scaled in the X-direction according
// to the dimensions of the box, but always extends up and
// down to the full Y-dimension


#declare StreakBlurFilter =
		box { //motion blur filter
			<0,0,0>,<BFX,BFY,0.01>
			no_shadow
		  texture {
				pigment { color rgbf<1,1,1,1> } //final render
//				pigment { color rgbf<1,.8,1,.91> } //makes it visible for positioning
				normal {
					gradient x
					normal_map {
						[0.0 granite .001 ] //no blur
						[0.1 granite .001 ] //begin blur here
						[0.5 granite BStrength*.1	turbulence 1.3 scale <12,.8,.8> ] //this is the max blurred area
						[0.9 granite .001 ] //end blur here
						[1.0 granite .001 ] //no blur
						}
					scale <BFX,1,1>
				}
				finish { refraction 1 ior 1.33 }
			}
		}

// motion blur filter, circular with radius = BFX
#declare BlurFilterCirc =
		cylinder {
			<0,0,0>,<0,0,0.01>,BFX
			no_shadow
		  texture {
				pigment { color rgbf<1,1,1,1> } //final render
//				pigment { color rgbf<1,.8,1,.91> } //makes it visible for positioning
				normal {
					onion
			    slope_map { //sine wave
/*
						[0    <BStrength/2, BStrength> ]
						[0.25 <BStrength, 0> ]
						[0.5  <BStrength/2,-BStrength> ]
						[0.75 <0.0, 0> ]
						[1    <BStrength/2, BStrength> ]
*/
						[0    <.5, BStrength> ]
						[0.25 <1, 0> ]
						[0.5  <.5,-BStrength> ]
						[0.75 <0.0, 0> ]
						[1    <.5, BStrength> ]
					}
						scale <.25,.25,.25>
				}
				finish { refraction 1 ior 1.03 }
			}
		}


//===============================================
//             Type B - Fading
//===============================================

// copy these into your file to use this motion blur:
/*
  #declare BColor = color rgb<.6,.6,.2>  // color of filter
  #declare BFX = 3         // blurred area X scale
  #declare BFY = 3         // blurred area Y scale
  #declare BStrength = .8  // 0=clear, 1=opaque at center
  #declare BXMax = .3      // Percentage of distance along X-axis
                           // where color reaches max intensity
  #declare BYSpread = .9   // Spread of the color in the Y-direction
                           // 0=soft fade, 1=full color throughout Y
  #include "BlurFilt.inc"
  #declare MyBlur = object { FadeBlurFilter }
*/
// The +X, -X, +Y, -Y ends of the box are clear,
// only the center section has color.
// The strength is the amount of lowest transparency in the
// center of the box.

#declare FadeColor =
	texture {
		pigment {
			gradient x
			color_map {
				[ 0.00  color rgbt<(BColor.red*1),(BColor.green*1),(BColor.blue*1),1.0> ] // clear
				[ 0.05  color rgbt<(BColor.red*1),(BColor.green*1),(BColor.blue*1),1.0> ] // clear fade
				[ BXMax  color rgbt<(BColor.red*1),(BColor.green*1),(BColor.blue*1),1-BStrength> ] // max color
				[ 0.95  color rgbt<(BColor.red*1),(BColor.green*1),(BColor.blue*1),1.0> ] // clear fade
				[ 1.00  color rgbt<(BColor.red*1),(BColor.green*1),(BColor.blue*1),1.0> ] // clear
			}
		}
	}
#declare ClearTex =
	texture {
		pigment { color rgbt<1,1,1,1> }
	}
#declare FrameBlackTex =
	texture {
		pigment { color rgbt<.01,.01,.01,.01> }
	}
#declare BlurTex =
	texture {
		gradient y
			texture_map {
				[ 0.00 ClearTex ]
				[ 0.05 ClearTex ] // guarantee edges are clear
				[ (.5-BYSpread/2+.05) FadeColor ]
				[ 0.50 FadeColor ]
				[ (.5+BYSpread/2-.05) FadeColor ]
				[ 0.95 ClearTex ] // guarantee edges are clear
//				[ 0.96 FrameBlackTex ] // for debugging
//				[ 1.00 FrameBlackTex ] // for debugging
				[ 1.00 ClearTex ]
			}
	}
#declare FadeBlurFilter =
	box {
		<0,0,0>,<1,1,.0001>
		texture { BlurTex scale <1,1,1> }
		scale <BFX,BFY,1>
	}

#warning concat("\n","Motion blur filters by Glenn McCarter, copyright 1997","\n")
