
// Glenn's POV-Ray Scene File - Plumbing
// created 29-May-03
// last update 29-Jun-03
// copyright 2003 Glenn McCarter (glenn@mccarters.net)
//
// This scene uses RH coordinate system, Z = up.



//===============================================
//             Scene Switches
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare Radiosty = 0; // 0=off, 1=quick, 2=best radiosity
#declare FocalBlur = 0; // 0=off, 1=focal blur
#declare DoFog = 1; // 0=no fog, 1=fog
#declare AreaSun = 0; // 0=normal light, 1=area light for the sun

//===============================================
//             Global Settings
//===============================================
                  
#version 3.5;
global_settings {
	adc_bailout 1/255 // default 1/255
//	ambient_light <1.0,1.0,1.0> // default <1,1,1>, use 0 for radiosity
//	ambient_light <0.5,0.5,0.5>
	ambient_light <0.1,0.1,0.1>
//	ambient_light <0.05,0.05,0.05>
//	ambient_light <0.01,0.01,0.01>
//	ambient_light <0.003,0.003,0.003> // test
//	ambient_light <0.0,0.0,0.0> // this is most realistic with radiosity on
//	ambient_light <-0.1,-0.1,-0.1> // not bad
//	ambient_light <-2,-2,-2> // spoiled orange
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 20
	number_of_waves 10
	noise_generator 2

#switch (Radiosty)
#case (1)
	ambient_light <0.0,0.0,0.0> // this is most realistic with radiosity on
// QUICK TEST
  radiosity{
    adc_bailout 0.01/0.02// CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
		always_sample on     // CHANGE - default on, use off to reduce blotchiness
		brightness 0.5       // CHANGE - default 1.0 for full effect, 0.0 = no radiosity
    count 20             // CHANGE - default 35, 2 is too low, typ 20 to 150, max 1600 rays sent out
    error_bound 1.0      // CHANGE - default 1.8, typ 1 to 3, hi = flat shadows, low = deep shadows
    gray_threshold 0.2   // CHANGE - 0.0 = unrealistically full color bleed, 1.0 = no color bleed
    low_error_factor .6  // leave this, default 0.5
		max_sample -1        // leave this negative unless you have a very bright object causing splotchiness
		media off            // default off, turn on if using media in scene
    minimum_reuse 0.015  // leave this, default 0.015
    nearest_count 5      // CHANGE - default 5, below 4 gets patchy, typ 3 to 10, max 20
		normal off           // default off, turn on for shadow areas to show bumps
    pretrace_start 0.08  // CHANGE - default 0.08, percent of final image size in first mosaic
    pretrace_end   0.04  // CHANGE - default 0.04, percent of final image size in last mosaic
    recursion_limit 3    // CHANGE - default 3, 1 or 2 is often sufficient
  }
#break
#case (2)
// FINAL RENDER
	ambient_light <0.0,0.0,0.0> // this is most realistic with radiosity on
  radiosity{
    adc_bailout 0.01/0.02// CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
		always_sample on     // CHANGE - default on, use off to reduce blotchiness
		brightness 1.0       // CHANGE - default 1.0 for full effect, 0.0 = no radiosity
    count 30             // CHANGE - default 35, 2 is too low, typ 20 to 150, max 1600 rays sent out
    error_bound 1.0      // CHANGE - default 1.8, typ 1 to 3, hi = flat shadows, low = deep shadows
    gray_threshold 0.2   // CHANGE - 0.0 = unrealistically full color bleed, 1.0 = no color bleed
    low_error_factor .5  // leave this, default 0.5
		max_sample -1        // leave this negative unless you have a very bright object causing splotchiness
		media off            // default off, turn on if using media in scene
    minimum_reuse 0.015  // leave this, default 0.015
    nearest_count 8      // CHANGE - default 5, below 4 gets patchy, typ 3 to 10, max 20
		normal off           // default off, turn on for shadow areas to show bumps
    pretrace_start 0.02  // CHANGE - default 0.08, percent of final image size in first mosaic
    pretrace_end   0.004  // CHANGE - default 0.04, percent of final image size in last mosaic
    recursion_limit 7    // CHANGE - default 3, 1 or 2 is often sufficient
  }
   // end radiosity section
#break
#else
#end
}


//===============================================
//             Includes
//===============================================

#include "GIncludeRH.inc" // Glenn's standard includes
#include "PumpsValves.inc"
#include "PipeGroup.inc"
#include "WaterTanks.inc"
#include "Bathroom.inc"
#include "Catwalks.inc"
#include "Piles.inc"
#include "BlobMan36.inc"
#include "LightFixtures.inc"

//#include "GRuler.inc" // for testing only


//===============================================
//             Variables
//===============================================




//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <4/4, 0.0,  0.0>  // aspect ratio
		angle 55
	location <40*Feet,-32*Feet,135*Feet> // more top down
	look_at <-10*Feet,25*Feet,43*Feet>
#if (FocalBlur = 1)
		blur_samples 100 // 100 is ok
		confidence 0.9   // this is a probability
		variance 1/1000  // 1/10000 is pretty good
		aperture 0.6    //lower value = wider range in focus, 10 is very blurry
		focal_point <0,0,1.3+TTH>
	 // end focal blur
#end
}

#declare Special_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
//		right     <16/9,     0.0,  0.0>
		right     <4/3,     0.0,  0.0>
//		angle 60
//	location <40*Feet,-32*Feet,105*Feet> // under bathroom
//	look_at <0*Feet,0*Feet,83*Feet>
//		angle 45
//	location <70*Feet,-62*Feet,135*Feet> // further back
//	look_at <0*Feet,0*Feet,73*Feet>
//		angle 14
//	location <140*Feet,-500*Feet,5*Feet> // distant view
//	look_at <0*Feet,0*Feet,60*Feet> // 
//	angle 50
//	location <140*Feet,-500*Feet,5*Feet> // sky
//	look_at <0*Feet,0*Feet,2000*Feet> // 
//	angle 30
//	location <-10*Feet,50*Feet,15*Feet> // plumber
//	look_at <-45*Feet,97*Feet,6*Feet>
	angle 55
	location <26*Feet,20*Feet,60*Feet> // pump
	look_at <18*Feet,20*Feet,50*Feet>
	}

camera {
//	Special_Cam
	Render_Cam
  }


//===============================================
//             Textures
//===============================================

#declare SteelTex =
	texture {
		pigment { color rgb<.24,.21,.28>*.34 }
		finish { specular 0.6 roughness .08 }
	}
#declare ConcreteTex =
	texture {
		pigment { color rgb<.54,.61,.68>*.94 }
		normal { bumps 0.3 scale 4 }
		finish { specular 0.06 roughness .38 }
	}
#declare GroundPipeTex =
	texture {
		pigment { color rgb<.54,.61,.68>*.94 }
		normal { bumps 0.1 scale 40 }
		finish { specular 0.36 roughness .08 }
	}
#declare HTankTex =
	texture {
		pigment { color rgb<.121,.141,.138> }
		normal { bumps 0.1 scale .2 }
		finish { specular 0.26 roughness .083 }
	}


//===============================================
//             Lighting
//===============================================

object { BareBulbLight translate <-10*Feet,-26*Feet,55*Feet> }

#declare Sun =
	light_source {
		<0,0,0>
		color rgb <0.684,0.639,0.543>*2.3
		#if (AreaSun=1)
			area_light <0,0,0.5*Miles>,<0,0.5*Miles,0>,4,4 adaptive 1 jitter circular orient
		#end
	}

object { Sun
	translate <0,0,.5*Miles> // noon at Equator: directly overhead
	rotate y*-48 // towards left, down low
  rotate z*82// behind camera
}


//===============================================
//             Environment
//===============================================

background { color rgb <0.046, 0.045, 0.053> } // deep blue grey

sky_sphere { // partly cloudy
	pigment {
		bozo
		color_map { // horizon is at about .23, zenith at .75
			[ 0.30 color rgb <0.667,0.669,0.910>*.920 ] // clouds
			[ 0.50 color rgb <0.067,0.169,0.710>*.20 ] // to zenith
		}
		scale .250
		translate <15,25,25>
		turbulence 0.73
		omega 0.5		
	}
}

#declare GroundTex =
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "CrackedPavementS2.png"
				}
				scale 50*Feet/(440*Feet)
				rotate z*90
				translate <8*Feet,6*Feet+8,0>
			}
		}
#declare FadeTex =
	texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "CrazedConcrete.png"
				}
				scale 310*Feet/(440*Feet)
				rotate z*40
				translate <8*Feet,6*Feet+8,0>
			}

	}
#declare BackgroundTex =
	texture {
			gradient x
			texture_map {
				[ 0.20 FadeTex ]
				[ 0.99 GroundTex ]
			}
			scale 440*Feet
			translate <150*Feet,0,0>
	}
#declare GroundPlane =
	plane { z,-0.01
		texture { BackgroundTex }
	}
object { GroundPlane }


//===============================================
//             Object Groups
//===============================================


//---------------- Pipes ----------------------
#declare PipeGroup =
	union {

		object { RPipeTrack(240,4,2*Feet,6*Feet,30129,rgb<.24,.38,.68>) rotate z*180 translate <-3*Feet,-8,36*Feet> }
		object { RPipeTrack(120,3.3,1.6*Feet,8*Feet,12129,rgb<.28,.48,.38>) translate <-23*Feet,-25*Feet,50*Feet> }
		object { RPipeTrack(40,12,4*Feet,12*Feet,50712,rgb<.020,.010,.123>) translate <-20*Feet,-44*Feet,40*Feet> }
		object { RPipeTrack(24,8,1.6*Feet,7*Feet,20875,rgb<.420,.110,.023>) translate <-21*Feet,-19*Feet,60*Feet> }
		object { RPipeTrack(35,8,6*Feet,20*Feet,22111,rgb<.30,.21,.13>) translate <-6*Feet,-10*Feet,46*Feet> }
		object { RPipeTrack(32,12,8*Feet,20*Feet,10494,rgb<.16,.10,.10>) translate <16*Feet,-14*Feet,62*Feet> }

		object { RPipeTrack(40,13,3*Feet,9*Feet,32127,rgb<.063,.030,.021>) translate <49*Feet,-14*Feet,57*Feet> }

		#declare TallArray = array[4]
		{<0,0,0>,<-12*Feet,0,0>,<-12*Feet,0,-8*Feet>,<-12*Feet,10*Feet,-8*Feet>}
		object { PipeTrack(TallArray,12,texture{PipeTex pigment{rgb<.16,.10,.10>}}) translate <16*Feet,-14*Feet,62*Feet> }

		#declare BigFArray1 = array[6] // blue
		{<0,0,-40*Feet>,<0,0,0>,<-12*Feet,0,0>,<-12*Feet,0,-8*Feet>,<-12*Feet,20*Feet,-8*Feet>,<-24*Feet,20*Feet,-8*Feet>}
		object { FlangedPipeTrack(BigFArray1,20,texture{PipeTex pigment{rgb<.17,.10,.32>}}) translate <26*Feet,-18*Feet,60*Feet> }
		object { FlangedPipeTrack(BigFArray1,30,texture{PipeTex pigment{rgb<.67,.30,.32>}}) rotate z*-90 translate <-20*Feet,-38*Feet,40*Feet> }

		#declare BigFArray2 = array[5] // green
		{<0,0,-40*Feet>,<0,0,0>,<-12*Feet,0,0>,<-12*Feet,-16*Feet,0>,<-12*Feet,-16*Feet,-20*Feet>}
		object { FlangedPipeTrack(BigFArray2,20,texture{PipeTex pigment{rgb<.06,.41,.12>}}) translate <12*Feet,-22*Feet,54*Feet> }

		#declare TripleArray = array[4]
		{<0,0,-90>,<0,0,0>,<-48,0,0>,<-48,0,-12*Feet>}
		object { PipeTrack(TripleArray,8,texture{PipeTex pigment{rgb<.083,.162,.286>}}) translate <-6*Feet,0,64*Feet> }
		object { PipeTrack(TripleArray,8,texture{PipeTex pigment{rgb<.083,.162,.286>}}) translate <-6*Feet,-14,64*Feet> }
		object { PipeTrack(TripleArray,8,texture{PipeTex pigment{rgb<.083,.162,.286>}}) translate <-6*Feet,14,64*Feet> }

		#declare DoubleArray = array[4]
		{<0,0,-20*Feet>,<0,0,0>,<0,78,0>,<0,78,-62*Feet>}
		object { PipeTrack(DoubleArray,15,texture{PipeTex pigment{rgb<.013,.232,.033>}}) translate <-12,3*Feet,66*Feet> }
		object { PipeTrack(DoubleArray,15,texture{PipeTex pigment{rgb<.013,.232,.033>}}) translate < 12,3*Feet,66*Feet> }

	} // end union
#declare SepticTank =
	union {
		box { <0,0,0>,<3*Feet,5*Feet,3*Feet> }
		cylinder { <0,0,0>,<0,0,6>,11 translate <3*Feet/2,5*Feet/2-16,3*Feet-2> } 
		cylinder { <0,0,0>,<0,0,6>,11 translate <3*Feet/2,5*Feet/2+16,3*Feet-2> } 
		box { <-3,-0.5,6>,<3,.5,6.5> translate <3*Feet/2,5*Feet/2-16,3*Feet-2> texture{pigment{rgb 0.1}}}  
		box { <-3,-0.5,6>,<3,.5,6.5> translate <3*Feet/2,5*Feet/2+16,3*Feet-2> texture{pigment{rgb 0.1}}}  
		texture { ConcreteTex }
	} // end union
#declare WhitePipeGrid =
	union {
		object { SepticTank translate <-15,-5*Feet,-100> }
		#declare InletArray = array[5]
		{<0,0,6>,<0,-8*Feet,6>,<0,-8*Feet,-8*Feet>,<0,-10*Feet,-8*Feet>,<-3*Feet,-10*Feet,-8*Feet>}
		object { PipeTrack(InletArray,4,WhitePlastic) translate <0,0,-80> }
		object { PipeLoop(16*Feet,26*Feet,4,WhitePlastic) translate <-4*Feet-8*Feet,-10*Feet-26*Feet,-8*Feet-80>}
		#declare CG=16;
		#while (CG<16*Feet)
			cylinder { <0,0,0>,<0,26*Feet,0>,3/2 translate <CG,0,0> texture { WhitePlastic }
				translate <-4*Feet-8*Feet,-10*Feet-26*Feet,-8*Feet-80>}
			#declare CG=CG+24;
		#end
		#declare OutletArray = array[5]
		{<0,8,0>,<0,-2*Feet,0>,<0,-2*Feet,-8*Feet>,<0,14*Feet,-8*Feet>,<0,14*Feet,-18*Feet>}
		object { PipeTrack(OutletArray,5,WhitePlastic) translate <-4*Feet+3*Feet,-10*Feet-26*Feet,-8*Feet-80> }
	} // end union


//---------------- Catwalks ----------------------
#declare Level1Catwalks = // lowest level
	union {
		object { Catwalk(30*Feet,10*Feet,40,40) rotate z*180 translate <10*Feet,0,0> }
		object { Catwalk(30*Feet,10*Feet,40,40) rotate z*180 translate <10*Feet,20*Feet,0> }
	} // end union

#declare Level2Catwalks =
	union {
		object { Catwalk(40*Feet,40*Feet,40,40) rotate z*180 translate <20*Feet,1*Feet,0> }
		object { Catwalk(40*Feet,10*Feet,40,40) rotate z*180 translate <20*Feet,-20*Feet,0> }
	} // end union

#declare Level3Catwalks =
	union {
		object { Catwalk(40*Feet,8*Feet,140,40) rotate z*0 translate <-24*Feet,0,0> }
		object { Catwalk(8*Feet,20*Feet,40,40) rotate z*0 translate <20*Feet,8*Feet,0> }
		object { Stairs(16*Feet,40) translate <40,0,0> rotate z*0 translate <20*Feet,8*Feet,0> }
		object { ClearTank(80,30,40) translate <24*Feet,15*Feet,0> }
		object { ClearTank(80,30,40) translate <24*Feet,19*Feet,0> }
		object { ClearTank(80,30,40) translate <24*Feet,23*Feet,0> }
	} // end union

#declare Level4Catwalks = // this is the big one
	union {
		difference {
			object { Catwalk(40*Feet,40*Feet,20*Feet,40) rotate z*0 translate <-20*Feet,-20*Feet,0> }
			cylinder { <0,0,-8*Feet>,<0,0,8*Feet>,10*Feet texture {CGrayTex} translate <0,0,0> }
		} // end difference
		object { Stairs(22*Feet,40) translate <20*Feet,0,0> rotate z*0 translate <-20*Feet,-20*Feet,0> }
	} // end union

#declare Level5Catwalks =
	union {
		object { Catwalk(22*Feet,6*Feet,10*Feet,40) rotate z*0 translate <-40*Feet,-29*Feet,0> }
		object { BigPump scale 1.8 rotate z*180 translate <-32*Feet,-25.3*Feet,0> }
		object { Catwalk(18*Feet,6*Feet,10*Feet,40) rotate z*0 translate <-36*Feet,-5*Feet,0> }
		object { BigPump scale 1.8 rotate z*180 translate <-31*Feet,-0.6*Feet,0> }
		object { Stairs(16*Feet,40) translate <10*Feet,0,0> rotate z*0 translate <-36*Feet,-5*Feet,0> }
	} // end union

#declare Level6Catwalks = // highest level
	union {
		object { Catwalk(16*Feet,6*Feet,10*Feet,40) rotate z*90 translate <-20*Feet,-27*Feet,0> }
		object { Stairs(16*Feet,40) translate <10*Feet,0,0> rotate z*90 translate <-20*Feet,-27*Feet,0> }
		#declare BPArray = array[8]
		{<0,0,0>,<0,0,40>,<0,48,40>,<0,48,-40*Feet>,
		<60,48,-40*Feet>,<60,-2,-40*Feet>,<60,-2,4>,<0,-2,4>
		}
		object { BigPump scale 1.8 rotate z*-90 translate <-24*Feet,-17.6*Feet,0> }
		object { PipeTrack(BPArray,9,HTankTex) translate <-24*Feet,-17.6*Feet,16> }

		object { Catwalk(12*Feet,9*Feet,5*Feet,40) rotate z*90 translate <-20*Feet,-5*Feet,-24> }
		object { Stairs(16*Feet,40) translate <5*Feet,0,0> rotate z*90 translate <-20*Feet,-5*Feet,-24> }
		object { RoundedHTank(HTankTex) scale 1.6 rotate z*90 translate <-24.5*Feet,-30,-24> }
	} // end union

//---------------- Tanks ----------------------

#declare TankGroup =
	union {

//		#declare BS=seed(20395);
		#declare BS=seed(20673);
		#declare BT=0;
		#while ( BT < 20 )
			#declare MBS=rand(BS);
			#declare MB=.1+MBS*.6;
			object { RoundedVTank(pigment{rgb<MB,MB*1.3,MB*2>})
				scale .5+rand(BS)*2
				translate <-20*Feet,-20*Feet,0*Feet> // start point
				translate <rand(BS)*40*Feet,-18*Feet+rand(BS)*40*Feet,rand(BS)*44*Feet>
			}
			#declare BT = BT + 1;
		#end
		#declare HWS=seed(44434);
		#declare HWT=0;
		#while ( HWT < 5 )
			#declare MGS=rand(HWS);
			#declare MG=.4+MGS*.6;
			object { SquareVTank(pigment{rgb<MG,MG*1.3,MG>})
				scale .5+rand(HWS)*2
				translate <-20*Feet,-30*Feet,30*Feet> // start point
				translate <rand(HWS)*20*Feet,rand(HWS)*20*Feet,rand(HWS)*40*Feet>
			}
			#declare HWT = HWT + 1;
		#end
		#declare CS=seed(95873);
		#declare CT=0;
		#while ( CT < 24 )
			object { ClearTank(30+rand(CS)*80,20+rand(CS)*30,30+rand(CS)*70)
				translate <-20*Feet,-30*Feet,10*Feet> // start point
				translate <rand(CS)*30*Feet,rand(CS)*30*Feet,rand(CS)*40*Feet>
			}
			#declare CT = CT + 1;
		#end

		object { ClearTankDetailed(120,50,88) translate <12*Feet,16*Feet,50*Feet> }
		object { BigPump translate <16*Feet,14*Feet,50*Feet> }
		#declare BigPumpArray = array[6]
		{<0,0,0>,<0,0,40>,<0,20,40>,<0,20,130>,<-50,20,130>,<-50,20,90> }
		object { PipeTrack(BigPumpArray,3.5,pigment{rgb<.45,.30,.28>}) translate <16*Feet,14*Feet,50*Feet+12> }


	} // end union

//---------------- Piles ----------------------
#declare PileGroup =
	union {
		object { Pile(52094,240) translate <0,0,18*Feet> }
		object { Pile(12094,140) translate <10*Feet,0,18*Feet> }
		object { Pile(44094,100) translate <-10*Feet,-8*Feet,18*Feet> }
		object { Pile(44094,100) translate <-5*Feet,-18*Feet,18*Feet> }

		object { Pile(56111,40) translate <-5*Feet,-18*Feet,-4*Feet> }
	} // end union

//---------------- Ground Pipes ----------------------
#declare GroundPipes =
	union {
		// PipeTrack(NodeArray,Nodes,Dia,PipeTexture) // with elbows
		#declare SA1=array[3]{<0,0,0>,<0,100*Feet,0>,<100*Feet,100*Feet,0>}
		#object { PipeTrack(SA1,9,GroundPipeTex) translate <0,0,10> }
		#declare SA2=array[3]{<0,0,0>,<0,160*Feet,0>,<100*Feet,160*Feet,0>}
		#object { PipeTrack(SA2,9,GroundPipeTex) translate <-15,0,10> }
		cylinder { <0,0,0>,<0,300*Feet,0>,6 texture { GroundPipeTex } translate <-30,0,10> }
		cylinder { <0,0,0>,<0,300*Feet,0>,6 texture { GroundPipeTex } translate <-45,0,10> }
		#declare SA3=array[6]{<-60,0,0>,<-60,102*Feet,0>,<-60,102*Feet,30>,<20,102*Feet,30>,<20,102*Feet,0>,<100*Feet,102*Feet,0>}
		#object { PipeTrack(SA3,9,GroundPipeTex) translate <0,0,10> }
	} // end union


//===============================================
//             Object Placement
//===============================================

object { BathroomGroup translate <0,0,100*Feet> }

object { WhitePipeGrid translate <0,0,90*Feet> }

object { PipeGroup }
object { TankGroup translate <0,-12,0> }
object { BigTank scale 0.6 translate <-20*Feet,-20*Feet,20*Feet> }
object { Level1Catwalks translate z*20*Feet }
object { Level2Catwalks translate z*30*Feet }
object { Level3Catwalks translate z*40*Feet }
object { Level4Catwalks translate z*50*Feet }

object { BigTank scale 1.0 translate <0*Feet,0*Feet,16*Feet> }
object { Level5Catwalks translate z*60*Feet }
object { Level6Catwalks translate z*70*Feet }
object { PileGroup }
object { GroundPipes translate <-10*Feet,0*Feet,0> }

object { RoundedVTank(WhitePlastic) scale <2,2,40> translate <12*Feet,-100*Feet,0> }
object { RoundedVTank(WhitePlastic) scale <2,2,40> translate <38*Feet,-100*Feet,0> }
object { RoundedVTank(WhitePlastic) scale <2,2,40> translate <42*Feet,-100*Feet,0> }

object { BlobMan scale 1.6 rotate z*102 translate <-60*Feet,107*Feet,7.9*Feet> }
object { ToolBox scale 1.6 rotate z*107 translate <-56*Feet,107*Feet,0*Feet> } 

#declare BigGroup=
	union {
object { PipeGroup }
object { TankGroup }
object { BigTank scale 0.6 translate <-20*Feet,-20*Feet,20*Feet> }
object { Level2Catwalks translate z*30*Feet }
object { Level3Catwalks translate z*40*Feet }
object { Level4Catwalks translate z*50*Feet }
object { BigTank scale 1.0 translate <0*Feet,0*Feet,16*Feet> }
object { Level5Catwalks translate z*60*Feet }
object { Level6Catwalks translate z*70*Feet }
object { PileGroup }
	} // end union
object { BigGroup scale x*-1 translate <-20*Feet,-45*Feet,10*Feet> }
object { BigGroup scale x*-1 rotate z*90 translate <30*Feet,-7*Feet,-38*Feet> }

