
// POV-Ray Object File - Water Tanks
// created 3-Jun-03
// last update 29-Jun-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "WaterTanks.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// RandomTanks
// RoundedVTank(TankTexture)
// SquareVTank(TankTexture)
// RoundedHTank(BluePaint)
// BlueTank
// HotWaterTank
// ClearTank(Height,Dia,FillHeight)
// ClearTankDetailed(Height,Dia,FillHeight)
// BigTank

//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Tank origin is at the base
// Tank height extends into +Z

#ifndef (ThisIsMaster) // now we know this include file was not called by another
	#declare RenderMe = 0; // supress self-rendering of other includes files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc" // uncomment for testing only
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================




//===============================================
//             Variables
//===============================================

#declare CPR = 0.9/2; // CopperPipeRadius

//===============================================
//             Textures
//===============================================

#declare TankTex = // default
	texture {
		pigment { color rgb<0.575,0.592,0.547>*1.00 }
		finish { metallic specular 0.32 roughness 0.135 }
	}
#declare BluePaint =
	texture {
		pigment { color rgb<.129,.172,.411>*1.00 }
		finish { specular 0.82 roughness 0.035 }
	}
#declare GlossyWhitePaint =
	texture {
		pigment { color rgb<.97,.97,.97>*1.20 }
		finish { ambient 0.7 specular 0.92 roughness 0.035 }
	}
#declare CopperTex =
	texture {
		pigment { color rgb<0.875,0.592,0.247>*1.00 }
		finish { metallic specular 0.92 roughness 0.035 }
	}
#declare DirtyMetalTex =
	texture {
//		pigment { color rgb<0.575,0.592,0.547>*1.00 }
		pigment {
			granite
			color_map {
				[ 0.0 rgb<0.575,0.592,0.547> ]
				[ 0.4 rgb<0.433,0.414,0.437> ]
				[ 0.7 rgb<0.403,0.314,0.306> ]
			}
			scale 2
		}
		finish { metallic specular 0.32 roughness 0.135 }
	}
#declare GlassTex =
	texture {
//		pigment { color rgbf<0.67,0.92,0.85,.98> } // too filtered on green
		pigment { color rgbf<0.81,0.96,0.88,.98> }
		finish { specular 0.99 roughness 0.008 }
	}
#declare GlassInt =
		interior { ior 1.5 }
#declare GlassMat =
	material {
		texture { GlassTex }
		interior { GlassInt }
	}
#declare BubbleTex = material { GlassMat }
#declare WaterTex =
	texture {
		pigment { color rgbf<0.67,0.92,0.95,.98> }
		normal { bumps 0.2 scale 4 }
		finish { specular 0.99 roughness 0.008 }
	}
#declare WaterInt =
		interior { ior 1.33 }
#declare WaterMat =
	material {
		texture { WaterTex }
		interior { WaterInt }
	}
#declare BlueStainless =
	texture {
		pigment { color rgb<0.835,0.847,0.987>*0.65 }
		finish { metallic specular 0.22 roughness 0.135 }
	}
#declare BrightChrome =
	texture {
		pigment { color rgb<0.835,0.892,0.987>*0.26 }
//		pigment { color rgb<.5,.5,1> }
		finish { brilliance 5 reflection 0.4 }
	}



//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

#declare RandomTanks =
	union {
		#local RS=seed(20945);
		#local TQ=0;
		#while ( TQ < 20 )
			cylinder {
				<0,0,0>,<0,0,4*Feet+rand(RS)*8*Feet>,2*Feet+rand(RS)*4*Feet
				texture { TankTex }
				translate <-40*Feet+rand(RS)*80*Feet,-20*Feet+rand(RS)*40*Feet,-30*Feet+rand(RS)*60*Feet>
			}
			#local TQ=TQ+1;
		#end
	} // end union


#macro RoundedVTank(TankTexture)
	union {
		cylinder { // main
			<0,0,8>,<0,0,38>,12
		}
		sphere { // base
			<0,0,0>,12
			scale <1,1,.4>
			translate <0,0,8>
		}
		sphere { // top
			<0,0,0>,12
			scale <1,1,.4>
			translate <0,0,38>
		}
		box { // feet
			<-3,-11,0>,<3,11,8>
		}
		box { // feet
			<-3,-11,0>,<3,11,8>
			rotate z*90
		}
		texture { TankTexture }
	} // end union
#end
#declare BlueTank = object { RoundedVTank(BluePaint) }

#macro SquareVTank(TankTexture)
	union {
		cylinder { // main
			<0,0,6>,<0,0,70>,11.5
		}
		sphere { // base
			<0,0,0>,11.5
			scale <1,1,.25>
			translate <0,0,8>
		}
		sphere { // top
			<0,0,0>,11.5
			scale <1,1,.14>
			translate <0,0,70>
		}
		cylinder { // base
			<0,0,0>,<0,0,8>,9.5
		}
		cylinder { <0,0,50>,<0,0,90>,CPR texture { CopperTex } } // inlet
		cylinder { <0,-4,50>,<0,-4,84>,CPR*4 texture { CopperTex } } // vent
		cylinder { <0,0,74>,<13.5,0,74>,CPR texture { CopperTex } }
		cylinder { <13.5,0,74>,<13.5,0,14>,CPR texture { CopperTex } }
		texture { TankTexture } 
	} // end union
#end
#declare HotWaterTank =	object { SquareVTank(GlossyWhitePaint) } 

#macro RoundedHTank(TankTexture)
	union {
		cylinder { // main
			<0,0,0>,<48,0,0>,12
			translate <0,0,16>
		}
		sphere { // left end
			<0,0,0>,12
			scale <.4,1,1>
			translate <0,0,16>
		}
		sphere { // right end
			<0,0,0>,12
			scale <.4,1,1>
			translate <48,0,16>
		}
		difference { // foot
			box { <-3,-11,0>,<3,11,16> }
			box { <-4,-10.3,1.0>,<-1,10.3,17> }
			translate <8,0,0>
		} // end difference
		difference { // foot
			box { <-3,-11,0>,<3,11,16> }
			box { <-4,-10.3,1.0>,<-1,10.3,17> }
			scale <-1,1,1>
			translate <40,0,0>
		} // end difference
		cylinder { // vent
			<0,0,20>,<0,0,34>,2.2
			translate <12,0,0>
		}
		cylinder { // vent
			<0,0,32>,<0,0,35>,2.8
			translate <12,0,0>
		}
		sphere { // vent
			<0,0,0>,2.8
			scale <1,1,.22>
			translate <12,0,35>
		}
		texture { TankTexture }
	} // end union
#end


#macro ClearTank(Height,Dia,FillHeight)
	union {
		difference {
			cylinder { // main glass outer
				<0,0,6>,<0,0,Height>,Dia/2
			}
			cylinder { // main glass inner
				<0,0,6>,<0,0,Height>,Dia/2-1.0
			}
			material { GlassMat }
		} // end difference
		cylinder { // water inside
			<0,0,6.1>,<0,0,FillHeight>,Dia/2-0.99
			material { WaterMat }
		}
		difference { // tank base
			cylinder {
				<0,0,4>,<0,0,12>,Dia/2+1
			}
			cylinder {
				<0,0,6.1>,<0,0,13>,Dia/2
			}
		} // end difference
		cylinder { // top
			<0,0,Height-7>,<0,0,Height+1>Dia/2+1
		}
		difference {
			cylinder {
				<0,0,Height-3>,<0,0,Height+7>,Dia/2-1
			}
			cylinder {
				<0,0,Height-4>,<0,0,Height+10>,Dia/2-1.6
			}
			cylinder {
				<-Dia/2,0,Height+3>,<Dia/2,0,Height+3>,2.3
			}
			cylinder {
				<-Dia/2,0,Height+3>,<Dia/2,0,Height+3>,2.3
				rotate z*90
			}
		} // end difference
		cylinder {
			<0,0,Height+3>,<0,0,Height+6>,Dia/4
		}
		sphere {
			<0,0,0>,Dia/4
			scale <1,1,.16>
			translate <0,0,Height+6>
		}
		cylinder { // base support
			<0,0,0>,<0,0,4>,Dia/2-2
		}
		#declare N=0;
		#declare NMax = 6;
		#while ( N < NMax )
			box { <-2,-1,6>,<2,0,Height>
				translate <0,-Dia/2,0>
				rotate N*(360/NMax)*z
			}
			#declare N = N + 1;
		#end
		texture { DirtyMetalTex } 
	} // end union
#end

#macro ClearTankDetailed(Height,Dia,FillHeight)
	#declare RS=seed(20950);
	union {
		difference {
			cylinder { // main glass outer
				<0,0,6>,<0,0,Height>,Dia/2
			}
			cylinder { // main glass inner
				<0,0,6>,<0,0,Height>,Dia/2-1.0
			}
			material { GlassMat }
		} // end difference
		cylinder { // water inside
			<0,0,6.1>,<0,0,FillHeight>,Dia/2-0.99
			material { WaterMat }
		}
		#declare B=0;
		#declare BMax = FillHeight*4;
		#while ( B < BMax )
			sphere {
				<0,0,0>,.4+rand(RS)*1
				translate <rand(RS)*(Dia/2-1.5),0,rand(RS)*(FillHeight-1.5)>
				rotate z*rand(RS)*360
				material { BubbleTex }
			}
			#declare B=B+1;
		#end
		difference { // tank base
			cylinder {
				<0,0,4>,<0,0,12>,Dia/2+1
			}
			cylinder {
				<0,0,6.1>,<0,0,13>,Dia/2
			}
		} // end difference
		cylinder { // top
			<0,0,Height-7>,<0,0,Height+1>Dia/2+1
		}
		sphere { // lid
			<0,0,0>,Dia/2-2
			scale <1,1,.26>
			translate <0,0,Height+.1>
		}
		cylinder { <0,0,Height>,<0,0,Height+6>,2 }
		cylinder { // base support
			<0,0,0>,<0,0,4>,Dia/2-2
		}
		#declare N=0;
		#declare NMax = 6;
		#while ( N < NMax )
			box { <-2,-1,6>,<2,0,Height>
				translate <0,-Dia/2,0>
				rotate N*(360/NMax)*z
			}
			#declare N = N + 1;
		#end
		#declare N=0;
		#declare NMax = 6;
		#while ( N < NMax )
			cylinder { <0,0,6>,<0,0,Height>,2
				translate <0,-Dia/2,0>
				rotate N*(360/NMax)*z
			}
			#declare N = N + 1;
		#end
		texture { DirtyMetalTex } 
	} // end union
#end

//---------------- Big Tank ----------------------
#declare BigTank =
	union {
		cylinder { // main body
			<0,0,0>,<0,0,40*Feet>,8*Feet
		}
		cylinder {
			<0,0,5*Feet>,<0,0,9.2*Feet>,8*Feet+.2
			texture { BrightChrome }
		}
		#declare N=0; // fins
		#while (N<360)
			box {
				<0,-4,0>,<8,4,22*Feet>
				translate <8*Feet-1,0,11*Feet>
				rotate z*N
			}
			#declare N=N+30;
		#end
		#declare N=0; // rivets
		#while (N<360)
			sphere {
				<0,0,0>,9
				scale <.3,1,1>
				translate <8*Feet,0,31*Feet>
				rotate z*(N+15)
			}
			sphere {
				<0,0,0>,9
				scale <.3,1,1>
				translate <8*Feet,0,13*Feet>
				rotate z*(N+15)
			}
			#declare N=N+30;
		#end

		sphere { // lid area
			<0,0,0>,7.8*Feet
			scale <1,1,.6>
			translate <0,0,40*Feet>
			texture { BrightChrome }
		}
		torus {
			8*Feet,0.6*Feet
			rotate x*90
			translate <0,0,36*Feet>
			texture { BrightChrome }
		}
		torus {
			8*Feet,0.6*Feet
			rotate x*90
			translate <0,0,38*Feet>
			texture { BrightChrome }
		}
/*
		#declare N=0; // top tubes
		#declare RS=seed(30921);
		#while (N<11)
			#declare SF=rand(RS);
			cylinder {
				<0,0,0>,<0,0,0*Feet+SF*14*Feet>,2+SF*6
				translate <2*Feet+rand(RS)*5.6*Feet,0,40*Feet>
				rotate z*rand(RS)*360
			}
			#declare N=N+1;
		#end
*/
 		sphere { // base area
			<0,0,0>,7.8*Feet
			scale <1,1,.33>
			translate <0,0,0*Feet>
			texture { BrightChrome }
		}
		cylinder {
			<0,0,0>,<0,0,6>,12*Feet
			translate <0,0,27>
		}
		cylinder {
			<0,0,0>,<0,0,6>,11*Feet
			translate <0,0,39>
		}

		texture { BlueStainless }
	} // end union


//===============================================
//             Groups
//===============================================


//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

global_settings{ max_trace_level 10 }
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 40
		location  <4*Feet, -20*Feet, 5*Feet> // overall
		look_at <0*Feet,0,3*Feet>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 2.0
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb .4, rgb .3 } scale 10 }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }


object { RoundedHTank(BluePaint) scale 1 rotate z*0 translate <40,30,0> }
object { RoundedHTank(BluePaint) scale 1 rotate z*60 translate <-40,0,0> }
//object { HotWaterTank scale 1 rotate x*0 translate <0,80,0> }
//object { ClearTankDetailed(80,40,56) scale 1 rotate x*0 translate <0,0,0> }
//object { ClearTankDetailed(50,30,16) scale 1 rotate x*0 translate <-40,0,0> }
//object { BigTank scale .5 rotate x*0 translate <5*Feet,20*Feet,0> }
#end
