#macro rounded_triangle (p0, p1, p2, r_t_thickness)
    union {
        sphere {p0, r_t_thickness/2}
        sphere {p1, r_t_thickness/2}
        sphere {p2, r_t_thickness/2}
        cylinder {p0, p1, r_t_thickness/2}
        cylinder {p1, p2, r_t_thickness/2}
        cylinder {p2, p0, r_t_thickness/2}
        #declare r_t_normal = vnormalize (vcross (p1-p0, p2-p0));
        difference {
            cylinder {p0-r_t_normal*r_t_thickness/2, p0+r_t_normal*r_t_thickness/2, max (vlength (p1-p0), vlength (p2-p0))}
            plane {vcross (r_t_normal, p1-p0), 0  translate p0}
            plane {vcross (r_t_normal, p0-p2), 0  translate p0}
            plane {vcross (r_t_normal, p2-p1), 0  translate p1}
        }
    }
#end

#macro rounded_box (p0, p1, r_b_edge_sharpness)
    union {
        #local p00 = p0+r_b_edge_sharpness;
        #local p01 = <p1.x, p0.y, p0.z>+r_b_edge_sharpness*(-x+y+z);
        #local p02 = <p1.x, p0.y, p1.z>+r_b_edge_sharpness*(-x+y-z);
        #local p03 = <p0.x, p0.y, p1.z>+r_b_edge_sharpness*(x+y-z);
        #local p04 = <p0.x, p1.y, p0.z>+r_b_edge_sharpness*(x-y+z);
        #local p05 = <p1.x, p1.y, p0.z>+r_b_edge_sharpness*(-x-y+z);
        #local p06 = p1-r_b_edge_sharpness;
        #local p07 = <p0.x, p1.y, p1.z>+r_b_edge_sharpness*(x-y-z);
        rounded_triangle (p00, p01, p02, 2*r_b_edge_sharpness)
        rounded_triangle (p02, p03, p00, 2*r_b_edge_sharpness)
        rounded_triangle (p02, p03, p06, 2*r_b_edge_sharpness)
        rounded_triangle (p06, p07, p03, 2*r_b_edge_sharpness)
        rounded_triangle (p01, p02, p06, 2*r_b_edge_sharpness)
        rounded_triangle (p06, p05, p01, 2*r_b_edge_sharpness)
        rounded_triangle (p03, p00, p04, 2*r_b_edge_sharpness)
        rounded_triangle (p04, p07, p03, 2*r_b_edge_sharpness)
        rounded_triangle (p00, p01, p05, 2*r_b_edge_sharpness)
        rounded_triangle (p05, p04, p00, 2*r_b_edge_sharpness)
        rounded_triangle (p04, p05, p06, 2*r_b_edge_sharpness)
        rounded_triangle (p06, p07, p04, 2*r_b_edge_sharpness)
        bounded_by {box {p0-0.0001, p1+0.0001}}
    }
#end

#macro rounded_cylinder (r_c_height, r_c_radius, r_c_edge_sharpness)
    union {
        torus {r_c_radius-r_c_edge_sharpness, r_c_edge_sharpness  translate r_c_edge_sharpness*y}
        torus {r_c_radius-r_c_edge_sharpness, r_c_edge_sharpness  translate (r_c_height-r_c_edge_sharpness)*y}
        cylinder {0, r_c_height*y, r_c_radius-r_c_edge_sharpness}
        cylinder {r_c_edge_sharpness*y, (r_c_height-r_c_edge_sharpness)*y, r_c_radius}
        bounded_by {cylinder {-0.0001*y, (r_c_height+0.0001)*y, r_c_radius+0.0001}}
    }
#end

#declare wooden_part_edge_sharpness = 0.0075;
#declare wooden_part1_height = 1.5;
#declare wooden_part1_width = 0.15;
#declare wooden_part1_dist_to_stones = 0.15;

#declare wooden_part2_width = 3*wooden_part1_width;
#declare wooden_part3_width = 0.25*wooden_part1_width;
#declare wooden_part4_cut_width = 3*wooden_part3_width;

#declare wooden_part1 =
object {rounded_box (-wooden_part1_width/2*(x+y+z), <wooden_part1_width/2, wooden_part1_height, wooden_part1_width/2>, wooden_part_edge_sharpness)}

#declare wooden_part2 =
object {rounded_box (<-wooden_part1_width/2, 0, -wooden_part2_width/2>, <wooden_part1_width/2, wooden_part1_width, wooden_part2_width/2>, wooden_part_edge_sharpness)}

#declare wooden_part3 =
object {
    rounded_box (<-(stones_i_radius+stone_width/2+wooden_part1_width/2+wooden_part1_dist_to_stones+wooden_part1_width/2), 0, -wooden_part3_width/2>,
        <stones_i_radius+stone_width/2+wooden_part1_width/2+wooden_part1_dist_to_stones+wooden_part1_width/2, wooden_part1_width, wooden_part3_width/2>,
        wooden_part_edge_sharpness
    )
}

#declare wooden_part4 =
union {
    #local p000 = <-wooden_part1_width/2, 0, wooden_part2_width/2+wooden_part3_width>+wooden_part_edge_sharpness*(x-y-z);
    #local p001 = <wooden_part1_width/2, 0, wooden_part2_width/2+wooden_part3_width>-wooden_part_edge_sharpness;
    #local p002 = <wooden_part1_width/2, 0, wooden_part2_width/2+wooden_part3_width-wooden_part4_cut_width>+wooden_part_edge_sharpness*(-x-y+z);
    #local p003 = <-wooden_part1_width/2, 0, wooden_part2_width/2+wooden_part3_width-wooden_part4_cut_width>+wooden_part_edge_sharpness*(x-y+z);
    #local p004 = <-wooden_part1_width/2, -wooden_part2_width/2+wooden_part1_width/2-wooden_part3_width, wooden_part1_width/2>+wooden_part_edge_sharpness;
    #local p005 = <wooden_part1_width/2, -wooden_part2_width/2+wooden_part1_width/2-wooden_part3_width, wooden_part1_width/2>+wooden_part_edge_sharpness*(-x+y+z);
    #local p006 = <wooden_part1_width/2, -wooden_part2_width/2+wooden_part1_width/2-wooden_part3_width+wooden_part4_cut_width, wooden_part1_width/2>+wooden_part_edge_sharpness*(-x-y+z);
    #local p007 = <-wooden_part1_width/2, -wooden_part2_width/2+wooden_part1_width/2-wooden_part3_width+wooden_part4_cut_width, wooden_part1_width/2>+wooden_part_edge_sharpness*(x-y+z);
    rounded_triangle (p000, p001, p005, 2*wooden_part_edge_sharpness)
    rounded_triangle (p005, p004, p000, 2*wooden_part_edge_sharpness)
    rounded_triangle (p002, p003, p007, 2*wooden_part_edge_sharpness)
    rounded_triangle (p007, p006, p002, 2*wooden_part_edge_sharpness)
    rounded_triangle (p001, p002, p006, 2*wooden_part_edge_sharpness)
    rounded_triangle (p006, p005, p001, 2*wooden_part_edge_sharpness)
    rounded_triangle (p003, p000, p004, 2*wooden_part_edge_sharpness)
    rounded_triangle (p004, p007, p003, 2*wooden_part_edge_sharpness)
    bounded_by {
        box {
            <-wooden_part1_width/2, -wooden_part2_width/2-wooden_part3_width+wooden_part4_cut_width, wooden_part1_width/2>-0.001,
            <wooden_part1_width/2, 0, wooden_part2_width/2+wooden_part3_width>+0.001
        }
    }
}

#declare wooden_part4b = object {wooden_part4  scale <1, 1, -1>}

#declare wooden_gear_radius = 0.15;
#declare wooden_gear_width = 0.05;
#declare wooden_gear_dist = 0.01;
#declare wooden_gear_teeth = 10;
#declare wooden_gear_sharpness = 0.004;

#declare wooden_gear_tooth_cut = wooden_gear_radius*cos (radians (360/wooden_gear_teeth));
#declare wooden_gear_tooth_width = wooden_gear_radius*sin (radians (360/wooden_gear_teeth));
#declare wooden_gear_part =
union {
    #local p000 = <0, 0, 0>+wooden_gear_sharpness*x;
    #local p001 = <0, wooden_gear_tooth_cut, 0>+wooden_gear_sharpness*(x-y);
    #local p002 = <0, wooden_gear_tooth_cut, -wooden_gear_tooth_width>+wooden_gear_sharpness*(x-y);
    #local p003 = <wooden_gear_width, 0, 0>-wooden_gear_sharpness*x;
    #local p004 = <wooden_gear_width, wooden_gear_tooth_cut, 0>+wooden_gear_sharpness*(-x-y);
    #local p005 = <wooden_gear_width, wooden_gear_tooth_cut, -wooden_gear_tooth_width>+wooden_gear_sharpness*(-x-y);
    rounded_triangle (p000, p001, p002, 2*wooden_gear_sharpness)
    rounded_triangle (p001, p004, p005, 2*wooden_gear_sharpness)
    rounded_triangle (p005, p002, p001, 2*wooden_gear_sharpness)
    rounded_triangle (p000, p002, p005, 2*wooden_gear_sharpness)
    rounded_triangle (p005, p003, p000, 2*wooden_gear_sharpness)
}

#declare wooden_gear =
union {
    #local I = 0;
    #local I_c = wooden_gear_teeth;
    #while (I < I_c)
        object {wooden_gear_part  rotate 360*I/I_c*x}
        #declare I = I+1;
    #end
    bounded_by {cylinder {-0.001*x, (wooden_gear_width+0.001)*x, wooden_gear_radius+0.001}}
}

#declare wooden_part5 =
object {
    rounded_box (
        <-wooden_gear_dist, 0, -wooden_part2_width/2>,
        <wooden_gear_width+wooden_gear_dist, 1.5*(wooden_gear_radius-wooden_gear_tooth_cut), 0>,
        wooden_part_edge_sharpness
    )
}

#declare wooden_wheel_radius = 0.175;
#declare wooden_wheel_width = 0.05;
#declare wooden_wheel_dist = 0.02;

#declare wooden_wheel =
object {
    rounded_cylinder (wooden_wheel_width, wooden_wheel_radius, wooden_part_edge_sharpness)
    rotate -90*z
}

#declare wooden_handle1_length = 0.2775;
#declare wooden_handle1_radius = wooden_wheel_width/2*0.8;
#declare wooden_handles = 8;

#declare wooden_handle1 =
object {
    rounded_cylinder (wooden_handle1_length, wooden_handle1_radius, wooden_part_edge_sharpness)
}

#declare wooden_handle2_length = 0.075;
#declare wooden_handle2_radius = 0.9*wooden_handle1_radius;

#declare wooden_handle2 =
object {
    rounded_cylinder (wooden_handle2_length, wooden_handle2_radius, wooden_part_edge_sharpness)
    rotate 90*z
}

#declare wooden_part6_radius = 0.6*wooden_part1_width/2;
#declare wooden_part6_add_length = 0.45;

#declare wooden_part6 =
object {
    rounded_cylinder (2*(stones_i_radius+stone_width/2+wooden_part1_dist_to_stones)+wooden_part6_add_length, wooden_part6_radius, wooden_part_edge_sharpness)
    rotate -90*z
}

#declare wooden_stick_length = 0.075;
#declare wooden_stick_radius = 0.9*wooden_handle1_radius;

#declare wooden_stick =
union {
    object {rounded_cylinder (wooden_stick_length, wooden_stick_radius, wooden_part_edge_sharpness)}
    object {rounded_cylinder (wooden_stick_length, wooden_stick_radius, wooden_part_edge_sharpness)  rotate 180*x}
}

#local Z1 = seed (61);
#declare dark_wood_pattern0 =
pigment {
    wood
    color_map {
        #local I = 0;
        #local I_c = 30;
        #while (I < I_c)
            #local line_thickness_turb = (-0.15+0.3*rand (Z1))/I_c;
            [I/I_c+line_thickness_turb  color rgb rand (Z1)*(x+y+z)]
            [(I+0.5)/I_c+line_thickness_turb  color rgb rand (Z1)*(x+y+z)]
            #local I = I+1;
        #end
        [1  color rgb 0.5]
    }
    turbulence <0.003, 0.003, 0.15>*1.5
    omega 0.0065
    lambda 3.3
}

#declare dark_wood_pattern =
pigment {
    pigment_pattern {dark_wood_pattern0}
    color_map {
        [0  color rgb 0]
        [1  color rgb 1]
    }
    turbulence 0.85*z
    omega 0.25
    lambda 4
}

#declare dark_wood_brightness = 2.3;
#declare dark_wood_tex =
texture {
    pigment {
        pigment_pattern {dark_wood_pattern}
        color_map {
            [0  color rgb <0.54, 0.36, 0>*0.9*dark_wood_brightness]
            [1  color rgb <0.54, 0.36, 0>*0.45*dark_wood_brightness]
        }
    }
    finish {diffuse 0.9}
    normal {
        average
        normal_map {
            [pigment_pattern {dark_wood_pattern} 1.9]
            [wrinkles 1.85  scale <1, 1, 13.5>*0.05]
        }
    }
    scale 0.035*3
}

#local Z2 = seed (55);
#local Z0 = seed (49);
#declare wooden_parts =
union {
    object {wooden_part1
        texture {dark_wood_tex
            rotate 90*x
            translate 100*rand (Z2)*y
            rotate (-3+6*rand (Z2))*x
            translate 0.15*rand (Z2)*z
            rotate 360*rand (Z2)*y
        }
        translate -(stones_i_radius+stone_width/2+wooden_part1_width/2+wooden_part1_dist_to_stones)*x
    }
    object {wooden_part1
        texture {dark_wood_tex
            rotate 90*x
            translate 100*rand (Z2)*y
            rotate (-3+6*rand (Z2))*x
            translate 0.15*rand (Z2)*z
            rotate 360*rand (Z2)*y
        }
        translate (stones_i_radius+stone_width/2+wooden_part1_width/2+wooden_part1_dist_to_stones)*x
    }
    union {
        difference {
            object {wooden_part2}
            cylinder {<-0.6*wooden_part1_width, wooden_part1_width/2, 0>, <0.6*wooden_part1_width, wooden_part1_width/2, 0>, wooden_part6_radius+wooden_part_edge_sharpness}
        }
        torus {wooden_part6_radius+wooden_part_edge_sharpness, wooden_part_edge_sharpness  rotate 90*z  translate <wooden_part1_width/2-wooden_part_edge_sharpness, wooden_part1_width/2, 0>}
        texture {dark_wood_tex
            translate 100*rand (Z2)*z+wooden_part1_width/2*y
            rotate (-3+6*rand (Z2))*x
            translate 0.15*rand (Z2)*y
            rotate 360*rand (Z2)*z
        }
        translate -(stones_i_radius+stone_width/2+wooden_part1_width/2+wooden_part1_dist_to_stones)*x+wooden_part1_height*y
    }
    union {
        difference {
            object {wooden_part2}
            cylinder {<-0.6*wooden_part1_width, wooden_part1_width/2, 0>, <0.6*wooden_part1_width, wooden_part1_width/2, 0>, wooden_part6_radius+wooden_part_edge_sharpness}
        }
        torus {wooden_part6_radius+wooden_part_edge_sharpness, wooden_part_edge_sharpness  rotate 90*z  translate <-wooden_part1_width/2+wooden_part_edge_sharpness, wooden_part1_width/2, 0>}
        texture {dark_wood_tex
            translate 100*rand (Z2)*z+wooden_part1_width/2*y
            rotate (-3+6*rand (Z2))*x
            translate 0.15*rand (Z2)*y
            rotate 360*rand (Z2)*z
        }
        translate (stones_i_radius+stone_width/2+wooden_part1_width/2+wooden_part1_dist_to_stones)*x+wooden_part1_height*y
    }
    object {wooden_part3
        scale <1+0.01*rand (Z0), 1+0.02*rand (Z0), 1>  translate (-0.005+0.01*rand (Z0))*x
        texture {dark_wood_tex
            rotate 90*y
            translate 100*rand (Z2)*x+wooden_part1_width/2*y
            rotate (-3+6*rand (Z2))*z
            translate 0.15*rand (Z2)*y
            rotate 360*rand (Z2)*x
        }
        translate <0, wooden_part1_height, -(wooden_part2_width/2+wooden_part3_width/2)>
    }
    object {wooden_part3
        scale <1+0.01*rand (Z0), 1+0.02*rand (Z0), 1>  translate (-0.005+0.01*rand (Z0))*x
        texture {dark_wood_tex
            rotate 90*y
            translate 100*rand (Z2)*x+wooden_part1_width/2*y
            rotate (-3+6*rand (Z2))*z
            translate 0.15*rand (Z2)*y
            rotate 360*rand (Z2)*x
        }
        translate <0, wooden_part1_height, (wooden_part2_width/2+wooden_part3_width/2)>
    }
    object {wooden_part4
        texture {dark_wood_tex
            translate 100*rand (Z2)*z+wooden_part1_width/2*y
            rotate (-3+6*rand (Z2))*x
            translate 0.15*rand (Z2)*y
            rotate 360*rand (Z2)*z
            rotate 45*x
            translate (wooden_part2_width/2+wooden_part3_width-wooden_part4_cut_width/2)*z
        }
        translate -(stones_i_radius+stone_width/2+wooden_part1_width/2+wooden_part1_dist_to_stones)*x+wooden_part1_height*y
    }
    object {wooden_part4
        texture {dark_wood_tex
            translate 100*rand (Z2)*z+wooden_part1_width/2*y
            rotate (-3+6*rand (Z2))*x
            translate 0.15*rand (Z2)*y
            rotate 360*rand (Z2)*z
            rotate 45*x
            translate (wooden_part2_width/2+wooden_part3_width-wooden_part4_cut_width/2)*z
        }
        translate (stones_i_radius+stone_width/2+wooden_part1_width/2+wooden_part1_dist_to_stones)*x+wooden_part1_height*y
    }
    object {wooden_part4b
        texture {dark_wood_tex
            translate 100*rand (Z2)*z+wooden_part1_width/2*y
            rotate (-3+6*rand (Z2))*x
            translate 0.15*rand (Z2)*y
            rotate 360*rand (Z2)*z
            rotate -45*x
            translate -(wooden_part2_width/2+wooden_part3_width-wooden_part4_cut_width/2)*z
        }
        translate -(stones_i_radius+stone_width/2+wooden_part1_width/2+wooden_part1_dist_to_stones)*x+wooden_part1_height*y
    }
    object {wooden_part4b
        texture {dark_wood_tex
            translate 100*rand (Z2)*z+wooden_part1_width/2*y
            rotate (-3+6*rand (Z2))*x
            translate 0.15*rand (Z2)*y
            rotate 360*rand (Z2)*z
            rotate -45*x
            translate -(wooden_part2_width/2+wooden_part3_width-wooden_part4_cut_width/2)*z
        }
        translate (stones_i_radius+stone_width/2+wooden_part1_width/2+wooden_part1_dist_to_stones)*x+wooden_part1_height*y
    }
    object {wooden_gear
        texture {dark_wood_tex
            translate 100*rand (Z2)*z+wooden_part1_width/2*y
            rotate (-3+6*rand (Z2))*x
            translate 0.15*rand (Z2)*y
            rotate 360*rand (Z2)*z
            rotate 45*x
        }
        rotate -30*x
        translate <stones_i_radius+stone_width/2+wooden_part1_width+wooden_part1_dist_to_stones+wooden_gear_dist, wooden_part1_height+wooden_part1_width/2, 0>
    }
    object {wooden_part5
        texture {dark_wood_tex
            translate 100*rand (Z2)*z+wooden_part1_width/2*y
            rotate (-3+6*rand (Z2))*x
            translate 0.15*rand (Z2)*y
            rotate 360*rand (Z2)*z
        }
        translate wooden_gear_tooth_cut*y
        rotate -30*x
        translate <stones_i_radius+stone_width/2+wooden_part1_width+wooden_part1_dist_to_stones+wooden_gear_dist, wooden_part1_height+wooden_part1_width/2, 0>
    }
    object {wooden_handle2
        texture {dark_wood_tex
            rotate 90*x
            translate 100*rand (Z2)*y
            rotate (-3+6*rand (Z2))*x
            translate 0.15*rand (Z2)*z
            rotate 360*rand (Z2)*y
            rotate 90*y
        }
        translate <0, wooden_gear_tooth_cut+1.5*(wooden_gear_radius-wooden_gear_tooth_cut)/2, -1.5*(wooden_gear_radius-wooden_gear_tooth_cut)/2>
        rotate -30*x
        translate <stones_i_radius+stone_width/2+wooden_part1_width+wooden_part1_dist_to_stones+wooden_gear_dist, wooden_part1_height+wooden_part1_width/2, 0>
    }
    object {wooden_wheel
        texture {dark_wood_tex
            translate 100*rand (Z2)*z+wooden_part1_width/2*y
            rotate (-3+6*rand (Z2))*x
            translate 0.15*rand (Z2)*y
            rotate 360*rand (Z2)*z
            rotate 360*rand (Z2)*x
        }
        translate <stones_i_radius+stone_width/2+wooden_part1_width+wooden_part1_dist_to_stones+wooden_gear_dist, wooden_part1_height+wooden_part1_width/2, 0>+
            (2*wooden_gear_dist+wooden_gear_width+wooden_wheel_dist)*x
    }
    #local I = 0;
    #local I_c = wooden_handles;
    #while (I < I_c)
        object {wooden_handle1
            scale <1, 1+0.075*rand (Z2), 1>
            texture {dark_wood_tex
                rotate 90*x
                translate 100*rand (Z2)*y
                rotate (-3+6*rand (Z2))*x
                translate 0.15*rand (Z2)*z
                rotate 360*rand (Z2)*y
            }
            rotate I/I_c*360*x
            translate <stones_i_radius+stone_width/2+wooden_part1_width+wooden_part1_dist_to_stones+wooden_gear_dist, wooden_part1_height+wooden_part1_width/2, 0>+
                (2*wooden_gear_dist+wooden_gear_width+wooden_wheel_dist+wooden_wheel_width/2)*x
        }
        #declare I = I+1;
    #end
    object {wooden_part6
        texture {dark_wood_tex
            rotate 90*y
            translate 100*rand (Z2)*x+wooden_part1_width/2*y
            rotate (-3+6*rand (Z2))*z
            translate 0.15*rand (Z2)*y
            rotate 360*rand (Z2)*x
        }
        translate <-(stones_i_radius+stone_width/2+wooden_part1_dist_to_stones+wooden_part6_add_length/2), wooden_part1_height+wooden_part1_width/2, 0>
    }
    object {wooden_stick
        texture {dark_wood_tex
            rotate 90*x
            translate 100*rand (Z2)*y
            rotate (-3+6*rand (Z2))*x
            translate 0.15*rand (Z2)*z
            rotate 360*rand (Z2)*y
        }
        rotate 35*x
        translate <-(stones_i_radius+stone_width/2+wooden_part1_width+wooden_part1_dist_to_stones+1.25*wooden_stick_radius), wooden_part1_height+wooden_part1_width/2, 0>
    }
    translate lawn_alt*y
}