// Date: 23/06/2003
// Auth: Jean-Charles Marteau
#include "transforms.inc"
#include "functions.inc"

#declare Radius=0.8;
#declare StrengthVal = 1.0;
#declare Gris_Base=0.5;
#declare Sombre=0.5;

#declare Text_ET=texture {
  pigment {
    cells
    turbulence 0.1
    color_map {
/*
      [0.0 rgb <0.6, 0.65, 0.9>]
      [0.3 rgb <0.9, 0.6, 0.65>]
      [0.6 rgb <0.65, 0.9, 0.6>]
      [1.0 rgb <0.8, 0.8, 0.8>]
*/
      [0.0 rgb <Gris_Base,Gris_Base,1>*Sombre]
      [0.3 rgb <1,Gris_Base,Gris_Base>*Sombre]
      [0.6 rgb <Gris_Base,1,Gris_Base>*Sombre]
      [1.0 rgb <Gris_Base,Gris_Base,Gris_Base>*Sombre]
    }
    rotate <0.0,45.0,45.0>
    scale 0.01
  }
  finish { phong 0.01 phong_size 200 reflection 0.02 }
  normal { dents bump_size 1.0 }
}

/*
#declare Text_ET=texture {
  pigment { rgb <0.2, 0.3, 0.8> }
}
*/

// ---------------------------------- Oeil
#declare Pig_Iris=pigment {
    radial
    frequency 40
    turbulence 0.08
    color_map {
      [0.00 color rgb <0.0,0.0,0.0>]
      [0.01 color rgb <1.0,0.0,0.0>]
      [0.00 color rgb <1.0,0.0,0.0>]
      [0.50 color rgb <1.0,0.6,0.0>]
      [1.00 color rgb <0.5,0.6,0.0>]
    }
  }

#declare Text_Oeil=texture {
    pigment {
      cylindrical
      pigment_map {
	[0.00 color rgb 1.0 ]
	[0.45 color rgb 1.0 ]
	[0.50 Pig_Iris ]
	[0.65 Pig_Iris ]
	[0.70 color rgb 0.0 ]
	[1.00 color rgb 0.0 ]
      }
      scale Radius/5
    }
    finish { ambient 0.3 }
    rotate 90*x
}

#declare Oeil=sphere {
  0, Radius/5
  texture { Text_Oeil }
}

// ---------------------------------- Pancarte
#declare Pancarte=union {
  cylinder {
    0, 1*y,  Radius/10
    texture {
      pigment { rgb 1.0 }
      finish { ambient 0.5 }     
    }
  }
  box {
    <-0.6, 0.9,-0.01>, <0.6, 1.8, 0.001>
    texture {
      pigment { rgb <1.0,0.6,0.6> }
      finish { ambient 0.6 }     
    }    
  }
  
  isosurface {
    function { f_heart (x, y, z, -1.0) }
    contained_by { box { -13, 13 } }
    accuracy 0.001 // accuracy of calculation [0.001]
    max_gradient 40
    texture {
      pigment { rgb <1.0,0.0,0.0> }
    }
    scale 0.28
    rotate -90*x
    rotate 90*y
    translate <0.0,1.35,-0.2>
  }
}

// ---------------------------------- ETs
// create a smooth blobby shape
#declare Radius=0.8;
#declare StrengthVal = 1.0;

#macro ET1 (look_at_point)
union {
  blob {
    threshold 0.6
    sphere { <-0.5, 2.0, 0.0>, Radius, StrengthVal }
    sphere { < 0.5, 2.0, 0.0>, Radius, StrengthVal }
    sphere { <-0.5, 2.0,-0.5>, Radius/3, -StrengthVal }
    sphere { < 0.5, 2.0,-0.5>, Radius/3, -StrengthVal }
    cylinder { < 0.0, 2.0, 0.0>, < 0.0, 1.0, 0.0>, Radius/4, StrengthVal }

    // Deux pattes sur les cotes
    cylinder { < 0.0, 1.0, 0.0>, <-0.2, 1.0, 0.0>, Radius/4, StrengthVal }
    cylinder { < 0.0, 1.0, 0.0>, < 0.2, 1.0, 0.0>, Radius/4, StrengthVal }

    cylinder { <-0.2, 1.0, 0.0>, <-0.4, 0.5, 0.0>, Radius/4, StrengthVal }
    cylinder { < 0.2, 1.0, 0.0>, < 0.4, 0.5, 0.0>, Radius/4, StrengthVal }

    cylinder { <-0.4, 0.5, 0.0>, <-0.5, 0.0, 0.0>, Radius/4, StrengthVal }
    cylinder { < 0.4, 0.5, 0.0>, < 0.5, 0.0, 0.0>, Radius/4, StrengthVal }

    // Pieds
    sphere { < 0.5, 0.1, 0.0>, Radius/2, StrengthVal }
    sphere { < 0.5,-0.2, 0.0>, Radius/2,-2*StrengthVal }

    sphere { <-0.5, 0.1, 0.0>, Radius/2, StrengthVal }
    sphere { <-0.5,-0.2, 0.0>, Radius/2,-2*StrengthVal }

    texture { Text_ET }
  }

  #local Pos_Oeil1=<-0.5, 2.0,-0.3>;
  object { Oeil transform { Reorient_Trans (-z, look_at_point-Pos_Oeil1) } translate Pos_Oeil1 }
  #local Pos_Oeil2=< 0.5, 2.0,-0.3>;
  object { Oeil transform { Reorient_Trans (-z, look_at_point-Pos_Oeil2) } translate Pos_Oeil2 }
}
#end

#macro ET2 (look_at_point)
union {
  blob {
    threshold 0.6
    
    // Quatre pattes en croix
    cylinder { < 0.0, 2.0, 0.0>, < 0.4, 2.5,-0.2>, Radius/4, StrengthVal }
    cylinder { < 0.0, 2.0, 0.0>, <-0.4, 2.5,-0.2>, Radius/4, StrengthVal }
    cylinder { < 0.0, 2.0, 0.0>, <-0.4, 2.5, 0.2>, Radius/4, StrengthVal }
    cylinder { < 0.0, 2.0, 0.0>, < 0.4, 2.5, 0.2>, Radius/4, StrengthVal }
    
    cylinder { < 0.4, 2.5,-0.2>, < 0.6, 1.5,-0.3>, Radius/4, StrengthVal }
    cylinder { <-0.4, 2.5,-0.2>, <-0.6, 1.5,-0.3>, Radius/4, StrengthVal }
    cylinder { <-0.4, 2.5, 0.2>, <-0.6, 1.5, 0.3>, Radius/4, StrengthVal }
    cylinder { < 0.4, 2.5, 0.2>, < 0.6, 1.5, 0.3>, Radius/4, StrengthVal }

    cylinder { < 0.6, 1.5,-0.3>, < 0.7, 0.0,-0.35>, Radius/4, StrengthVal }
    cylinder { <-0.6, 1.5,-0.3>, <-0.7, 0.0,-0.35>, Radius/4, StrengthVal }
    cylinder { <-0.6, 1.5, 0.3>, <-0.7, 0.0, 0.35>, Radius/4, StrengthVal }
    cylinder { < 0.6, 1.5, 0.3>, < 0.7, 0.0, 0.35>, Radius/4, StrengthVal }

    // Pieds
    sphere { < 0.7, 0.10,-0.35>, Radius/2, 2*StrengthVal }
    sphere { < 0.7,-0.21,-0.35>, Radius/2,-2*StrengthVal }
    cylinder { < 0.7-Radius/2, 0.1,-0.35>, < 0.7+Radius/2, 0.1,-0.35>, Radius/5, -2*StrengthVal }
    cylinder { < 0.7, 0.1,-0.35-Radius/2>, < 0.7, 0.1,-0.35+Radius/2>, Radius/5, -2*StrengthVal }    

    sphere { < 0.7, 0.10, 0.35>, Radius/2, 2*StrengthVal }
    sphere { < 0.7,-0.21, 0.35>, Radius/2,-2*StrengthVal }
    cylinder { < 0.7-Radius/2, 0.1, 0.35>, < 0.7+Radius/2, 0.1, 0.35>, Radius/5, -2*StrengthVal }
    cylinder { < 0.7, 0.1, 0.35-Radius/2>, < 0.7, 0.1, 0.35+Radius/2>, Radius/5, -2*StrengthVal }    

    sphere { <-0.7, 0.10, 0.35>, Radius/2, 2*StrengthVal }
    sphere { <-0.7,-0.21, 0.35>, Radius/2,-2*StrengthVal }
    cylinder { <-0.7-Radius/2, 0.1, 0.35>, <-0.7+Radius/2, 0.1, 0.35>, Radius/5, -2*StrengthVal }
    cylinder { <-0.7, 0.1, 0.35-Radius/2>, <-0.7, 0.1, 0.35+Radius/2>, Radius/5, -2*StrengthVal }    

    sphere { <-0.7, 0.10,-0.35>, Radius/2, 2*StrengthVal }
    sphere { <-0.7,-0.21,-0.35>, Radius/2,-2*StrengthVal }
    cylinder { <-0.7-Radius/2, 0.1,-0.35>, <-0.7+Radius/2, 0.1,-0.35>, Radius/5, -2*StrengthVal }
    cylinder { <-0.7, 0.1,-0.35-Radius/2>, <-0.7, 0.1,-0.35+Radius/2>, Radius/5, -2*StrengthVal }    

    // Cou
    cylinder { < 0.0, 2.0, 0.0>, < 0.0, 1.7, 0.0>, Radius/4, StrengthVal }
    sphere { < 0.0, 1.7, 0.0>, Radius/4, -StrengthVal }
    cylinder { < 0.0, 1.7, 0.0>, < 0.0, 1.5,-0.1>, Radius/4, StrengthVal }
    sphere { < 0.0, 1.5,-0.1>, Radius/4, -StrengthVal }
    cylinder { < 0.0, 1.5,-0.1>, < 0.0, 1.0,-0.5>, Radius/4, StrengthVal }
    sphere { < 0.0, 1.0,-0.5>, Radius/4, -StrengthVal }
    cylinder { < 0.0, 1.0,-0.5>, < 0.0, 0.6,-0.8>, Radius/4, StrengthVal }
    sphere { < 0.0, 0.6,-0.8>, Radius/4, -StrengthVal }
    cylinder { < 0.0, 0.6,-0.8>, < 0.0, 0.6,-1.0>, Radius/4, StrengthVal }
    
    // Tete
    sphere { < 0.0, 0.6,-1.4>, Radius, StrengthVal }
    sphere { < 0.0, 0.6,-1.9>, Radius/2, -2*StrengthVal }
    
    texture { Text_ET }
  }
  #local Pos_Oeil=< 0.0, 0.6,-1.5>;  
  object { Oeil transform { Reorient_Trans (-z, look_at_point-Pos_Oeil) } scale 1.8 translate Pos_Oeil }
}
#end

#macro ET3 (look_at_point)
union {
  blob {
    threshold 0.6
    
    // Tete
    sphere { < 0.0,2.0,0.0>, 2*Radius, 2*StrengthVal }
    sphere { < 0.0,2.0,-1.1>, Radius,-2*StrengthVal }

    cylinder { < 0.0,2.0,0.0>, < 0.0,0.0,0.0>, Radius/2, StrengthVal }

    // Pieds
    sphere { < 0.0, 0.1,-0.2>, Radius*0.8, StrengthVal }
    sphere { < 0.0,-0.1,-0.2>, Radius/2,-2*StrengthVal }

    // Bras
    cylinder { < 0.0,2.0,0.0>, < 0.0,3.7,0.0>, Radius/4, StrengthVal }
    sphere { < 0.0,3.7,0.0>, Radius/4, -StrengthVal } 
    cylinder { < 0.0,3.7,0.0>, <0.5,4.0,0.0>, Radius/4, StrengthVal }
    
    sphere { <0.5,4.0,0.0>, Radius/2, StrengthVal }
    cylinder { <0.5,3.6,0.0>, <0.5,4.4,0.0>, Radius/8, -2*StrengthVal }
    
    texture { Text_ET }
  }                               
  
  #local Pos_Oeil=< 0.0,2.0,-0.5>;
  
  object { Oeil transform { Reorient_Trans (-z, look_at_point-Pos_Oeil) } scale 4.5 translate Pos_Oeil }
  object { Pancarte rotate -35*y translate <0.5,3.7,0.0> }
  scale 0.8
}
#end
