// Date: 23/06/2003
// Auth: Jean-Charles Marteau
#include "math.inc"

#local Max_Brick_Level=0.6;
#local Brick_Scale=0.1;
#local Cover_Scale=0.2;
#local Pattern_Precision=500;
#local Cover_Holes=0.2;
#local Stucco_Size=0.04;

// ----------------------------------------
//  Height field part

// Stries horizontales sur les pierres
#declare Pig_Stones_Irregularities=pigment {
  marble
  turbulence 1.0
  scale <1.0,0.1,1.0>
  pigment_map {
    [0.0 rgb Max_Brick_Level]
    [1.0 rgb Max_Brick_Level*0.75]
  }
}

// Piquete du beton
#declare Pig_Mortar_Irregularities=pigment {
  dents
  pigment_map {
    [0.0 rgb 0.0]
    [1.0 rgb 0.05]
  }
  scale 0.01
}

// Melange Pierre/Beton
#declare Pig_HF_Bricks=pigment {
  crackle
  turbulence 0.05
  pigment_map {
    [0.000 Pig_Mortar_Irregularities]
    [0.015 Pig_Mortar_Irregularities]
    [0.100 Pig_Stones_Irregularities]
    [1.000 Pig_Stones_Irregularities]      
  }
  scale Brick_Scale
}

// ----------------------------------------

// Piquete du crepis
#declare Pig_Cover_Irregularities=pigment {
  dents
  color_map {
    [0.0 rgb (Max_Brick_Level+1.0)/2]
    [1.0 rgb 1.00]
  }
  scale 0.02
}

// Piquete de la transition
#declare Pig_Partial_Irregularities=pigment {
  granite
  color_map {
    [0.0 rgb 0.8*(Max_Brick_Level+1.0)/2]
    [1.0 rgb (Max_Brick_Level+1.0)/2]
  }
  scale 0.05
}

// Crepis avec les trous
#declare Pig_HF_Cover=pigment {
  dents
  turbulence 0.2
  pigment_map {
    [0.000 rgb 0.0]
    [Cover_Holes rgb 0.0]
    [Cover_Holes+Stucco_Size Pig_Partial_Irregularities]
    [Cover_Holes+Stucco_Size Pig_Cover_Irregularities]
    [1.000 Pig_Cover_Irregularities]
  }
  scale Cover_Scale
}

// ----------------------------------------
#declare FHF_Bricks=function { pigment { Pig_HF_Bricks } };
#declare FHF_Cover=function { pigment { Pig_HF_Cover } };
#declare FMaxHF=function { max (FHF_Bricks(x, y, z).grey , FHF_Cover(x, y, z).grey ) }

// ----------------------------------------
//  Color part

// Mousse
#declare Pig_Moss=pigment { rgb <0.08, 0.3, 0.15> }

// Couleur des pierres
#declare Pig_Stone=pigment {
  granite
  turbulence 0.5
  color_map
   {[0.000, 0.153   color rgbt <0.545, 0.380, 0.345, 0.000>
                    color rgbt <0.588, 0.475, 0.333, 0.000>]
    [0.153, 0.398   color rgbt <0.588, 0.475, 0.333, 0.000>
                    color rgbt <0.675, 0.478, 0.404, 0.000>]
    [0.398, 0.559   color rgbt <0.675, 0.478, 0.404, 0.000>
                    color rgbt <0.757, 0.635, 0.522, 0.000>]
    [0.559, 0.729   color rgbt <0.757, 0.635, 0.522, 0.000>
                    color rgbt <0.659, 0.549, 0.443, 0.000>]
    [0.729, 1.001   color rgbt <0.659, 0.549, 0.443, 0.000>
                    color rgbt <0.545, 0.380, 0.345, 0.000>]
   }
}
 
// Couleur du beton
#declare Pig_Mortar=pigment { rgb 0.3 }

SetGradientAccuracy(0.005)

#declare F_Moss=fn_Gradient_Directional (FMaxHF, <0,-1,0>)

// Pierres, melange Mousse/Pierre
#declare Pig_Brick=pigment {
  dents
  //function { max (0, F_Moss (x,y,z))/5 }
  pigment_map {
    [0.00 Pig_Stone]
    [0.90 Pig_Stone]
    [0.95 Pig_Moss]
    [1.00 Pig_Moss]
  }
  scale 0.5
}

// Melange mortier/Pierres
#declare Pig_Bricks=pigment {
  crackle
  turbulence 0.05
  pigment_map {
    [0.000 Pig_Mortar]
    [0.015 Pig_Mortar]
    [0.030 Pig_Brick]
    [1.000 Pig_Brick]
  }
  scale Brick_Scale
}

// Couleur du crepis interne
#declare Pig_Full_Cover=pigment {
  dents
  turbulence 0.1
  color_map {
    [0.0 rgb 1.0]
    [1.0 rgb Max_Brick_Level*1.01]
  }
  scale 0.02
}

// Couleur du crepis abime
#declare Pig_Partial_Cover=pigment { rgb <0.9, 0.9, 0.6> }

// Melange, crepis avec des trous
#declare Pig_Cover=pigment {
  dents
  turbulence 0.2
  pigment_map {
    [0.000 rgb 0]
    [Cover_Holes rgb 0]
    [Cover_Holes Pig_Partial_Cover]
    [Cover_Holes+Stucco_Size Pig_Partial_Cover]
    [Cover_Holes+Stucco_Size Pig_Full_Cover]
    [1.000 Pig_Full_Cover]
  }
  scale Cover_Scale
}

// ----------------------------------------
//  Finish and normal
#declare Txt_Finish_Mortar=texture {
  normal {
    bumps
    scale 0.01
  }
  finish {
    crand 0.01
  }
}    
#declare Txt_Finish_Partial=texture {
  normal {
    granite
    scale 0.01
  }
}    
#declare Txt_Finish_Neutral=texture { }    

// Indice de presence de beton
#declare Pig_Is_Mortar=pigment {
  crackle
  turbulence 0.05
  pigment_map {
    [0.000 rgb 0.5]
    [0.015 rgb 0.5]
    [0.018 rgb 0.0]
    [1.000 rgb 0.0]
  }
  scale Brick_Scale
}

// Indice de presence du crepis partiel
#declare Pig_Is_Partial=pigment {
  dents
  turbulence 0.2
  pigment_map {
    [0.000 rgb 0.0]
    [Cover_Holes rgb 0.0]
    [Cover_Holes rgb 1.0]
    [Cover_Holes+Stucco_Size rgb 1.0]
    [Cover_Holes+Stucco_Size rgb 0.0]
    [1.000 rgb 0.0]
  }
  scale Cover_Scale
}

// Map pour le texture map
#declare Pig_Txt_Map=pigment {
  function { FHF_Bricks(x, y, z).grey < FHF_Cover(x, y, z).grey }
  pigment_map {
    [0.0 Pig_Is_Mortar]
    [1.0 Pig_Is_Partial]
  }
}
