// Persistence of Vision Ray Tracer Scene Description File
// File: whatsthat.pov
// Vers: 3.5
// Desc: Photon Scene Template
// Date: 23/06/2003
// Auth: Jean-Charles Marteau
// IRTC 06/2003 Entry / Theme : Mystery 

#version 3.5;

#declare Photons=off;
#declare Radiosity=on;
#declare Area_Light=6;
#declare Nb_Cailloux=100;
#declare With_Tree=on;
#declare With_Grass=on;
#declare With_Gate=on;
#declare With_Saucer=on;
#declare With_Clouds=on;
#declare With_Photo=on;
#declare With_ET=on;
#declare With_Contrast_Fog=on;

// Standard pre-defined colors
//
#include "colors.inc"
#include "woods.inc"

#include "exe_mat.inc"
#include "objets.inc"
#include "sky_textures.inc"
#include "photo.inc"
#include "extra_terrestres.inc"
#include "terre.inc"

global_settings {
  assumed_gamma 1.0
  max_trace_level 5
  #if (Photons)          // global photon block
    photons {
      spacing 0.02                 // specify the density of photons
      //count 100000               // alternatively use a total number of photons

      //gather min, max            // amount of photons gathered during render [20, 100]
      //media max_steps [,factor]  // media photons
      //jitter 1.0                 // jitter phor photon rays
      //max_trace_level 5          // optional separate max_trace_level
      //adc_bailout 1/255          // see global adc_bailout
      //save_file "filename"       // save photons to file
      //load_file "filename"       // load photons from file
      //autostop 0                 // photon autostop option
      //radius 10                  // manually specified search radius
      // (---Adaptive Search Radius---)
      //steps 1
      //expand_thresholds 0.2, 40
    }

  #end
  #if (Radiosity)
    radiosity {
      pretrace_start 0.08           // start pretrace at this size
      pretrace_end   0.04           // end pretrace at this size
      count 35                      // higher -> higher quality (1..1600) [35]
      nearest_count 5               // higher -> higher quality (1..10) [5]
      error_bound 1.8               // higher -> smoother, less accurate [1.8]
      recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
      low_error_factor .5           // reduce error_bound during last pretrace step
      gray_threshold 0.0            // increase for weakening colors (0..1) [0]
      minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
      brightness 1                  // brightness of radiosity effects (0..1) [1]

      adc_bailout 0.01/2
      //normal on                   // take surface normals into account [off]
      //media on                    // take media into account [off]
      //save_file "file_name"       // save radiosity data
      //load_file "file_name"       // load saved radiosity data
      //always_sample off           // turn sampling in final trace off [on]
      //max_sample 1.0              // maximum brightness of samples
    }
  #end
}

#default {
  texture {
    pigment {rgb 1}
    #if (Radiosity)
      finish {
        ambient 0.0
        diffuse 0.6
        specular 0.3
      }
    #else
      finish {
        ambient 0.1
        diffuse 0.6
        specular 0.3
      }
    #end
  }
}

// ----------------------------------------

camera {
  right x*image_width/image_height
  look_at   <-0.8,0.75,0>
  location  <-4,1.6,-9>
  angle 50
}

light_source {
  <50,40,-15>       // light's position
  color rgb <1.0,1.0,0.9>*2
  photons {           // photon block for a light source
    refraction on
    reflection on
  }
  #if (Area_Light>1)
    area_light
    <0.3, 0, 0> <0, 0, 0.3>
    Area_Light, Area_Light
    adaptive 0          // 0,1,2,3...
    jitter              // adds random softening of light
    circular            // make the shape of the light circular
    orient              // orient light
  #end
}

sky_sphere {
#if (With_Clouds)
  pigment {sky_texture}
  pigment {sky_clouds}
#else
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
#end
}

// ----------------------------------------
#declare Mur_Pierre=height_field {
  png "mur_hf.png"
  smooth
  texture {
    pigment {
      image_map { png "mur_pig.png" map_type 0 interpolate 2 once }
      rotate x*90
    }
  }
  scale <10.0, 0.2, 10.0>
  translate <-5.0, 0.0, 0.0>
  rotate -90*x
}

// ----------------------------------------
plane {
  y, 0.0
  hollow
  pigment { rgb Terre_Col }
}

object { Sol translate <0.0,0.0,-5.0> }
union { Poser_Cailloux(Nb_Cailloux) translate <0.0,0.0,-5.0> }
object { Mur_Pierre }

#if (With_Saucer)
  object {
    Soucoupe ()
    scale 1.0
    translate <0.1,1.0,-2.3>
  }
#end

// ----------------------------------------
#if (With_Tree)
  #include "txttree.inc"

  #local Tree_position=<7.0, 0.0, -5>;

  #declare colBark=rgb <1,0.8,0.51>*0.8; // dirty brown
  #declare txtTree=texture {
    pigment{ crackle turbulence 0.4 lambda 3.2
      color_map{
        [0 color colBark*.3]
        [0.1 color colBark*.4]
        [0.6 color colBark*.8]
        [1 color colBark*1.2]
      }
    }       
    finish{ ambient 0.0 }
    scale <0.2,0.7,0.2>*1
  }

  #declare colLeaf_1=rgb <0.7,1,0.2>*0.8; // greenish 
  #declare colLeaf_2=rgb <1,0.7,0.2>*0.8; // yellow
  #declare txtLeaf=texture{
    pigment{agate
      color_map {
        [0.0 color colLeaf_1]
        [0.3 color colLeaf_2]
        [0.7 color colLeaf_2]
        [1.0 color colLeaf_1]
      }
    }       
    finish{ambient 0.0 specular 0.3 roughness 0.01}
    scale 10
  }                 

  #include "jcleaf.inc"
  #include "jcleaves.inc"
  #include "jctree.inc"

  union {
    object { JCTree }
    object { JCLeaves
      texture { txtLeaf }
    }
    scale 0.28
    translate Tree_position
  }
#end

#if (With_Grass)
  object {
    #include "fgrass1.inc"  
    texture {
      pigment {
        dents
        triangle_wave
        color_map {
          [0.0 rgb <0.0, 0.4, 0.1>]
          [1.0 rgb <0.1, 0.6, 0.2>]
        }
      }
    }
    scale 0.08
    rotate 35*y
    translate <0.5,0.6,-8.0>
  }
  
  object {
    #include "fgrass2.inc"  
    texture {
      pigment {
        dents
        triangle_wave
        color_map {
          [0.0 rgb <0.0, 0.4, 0.1>]
          [1.0 rgb <0.1, 0.6, 0.2>]
        }
      }
    }
    scale 0.08
    rotate 25*y
    translate <-6.0,0.55,-3.0>
  }
  object {
    #include "fgrass2.inc"  
    texture {
      pigment {
        dents
        triangle_wave
        color_map {
          [0.0 rgb <0.0, 0.4, 0.1>]
          [1.0 rgb <0.1, 0.6, 0.2>]
        }
      }
    }
    scale 0.08
    rotate (180+25)*y
    translate <-6.3,0.55,-3.5>
  }
#end

#if (With_Gate)
  union {
    torus { 12.0, 0.02 scale <1.0,5.0,1.0> translate <0.0,2.2,0.0> texture { T_Wood5 } }
    torus { 12.0, 0.02 scale <1.0,5.0,1.0> translate <0.0,1.0,0.0> texture { T_Wood5 } }
    #local i=0;
    #while (i<300)
      #local i=i+1;
      box { <12.0,0.0,-0.09>, <12.05,3.0,0.09> rotate y*(270*i/150-45) texture { T_Wood5 } }
    #end
    translate <3.0,0.0,-2.0>
  }
#end

#if (With_Photo)
  object { photo_bic scale 0.4 rotate <-5,0,2> translate <-3.3,0.565,-5.8> }
#end

#if (With_ET)
  object { ET1(<-1,0,-5>) scale 0.5 translate <-3.0, 0.6, -4.5> }
  object { ET2(<0,0,-4>) scale 0.3 rotate <4,0,-8> rotate 100*y translate <-2.1, 0.48, -5.95> }
  object { ET3(<0,0,-7>) scale 0.4 rotate 45*y  translate <-1.8, 0.6, -4.5> }
#end


#if (With_Contrast_Fog)
fog {
  fog_type 1               // 1=constant, 2=ground_fog
  distance 7
  color 1.2
  // (---turbulence---)
  //turbulence <0.5, 0.5, 1.0>
  //turb_depth 0.5
  //omega 0.5
  //lambda 2.0
  //octaves 6
  // (---ground fog---)
  //fog_offset 0.5         // height of constant fog
  //fog_alt 0.5            // at fog_offset+fog_alt: density=25%
}
#end
