default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

NOTE: please render justclouds.pov first, then, render this. do both these at about
800x600. Then, render test.pov, which is the final scene.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       0.01
    count            1
    distance_maximum 1.0
    error_bound      0.4
    gray_threshold   0.8
    low_error_factor 0.5
    minimum_reuse    0.01
    nearest_count    4
    recursion_limit  1
  }
}

background { color <0.467,0.467,0.467> }

fog {
  fog_type 2    // Ground Fog
  distance     10.0
  color <0.580392,0.623529,0.654902,0.0,0.0>
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      1.5
}

camera {  //  Camera Camera01
  location  <     -0.161,     -12.237,       3.004>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38192,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      40.800
  look_at   <      0.124,      -0.607,       2.258>
}

//
// *******  L I G H T S *******
//

light_source {   // Light002
  <0.0, 0.0, 0.0>
  color rgb <0.971, 0.957, 1.000>
  translate  <-12.761, -8.131, 7.434>
}


//
// ********  MATERIALS  *******
//

#include "outside.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare SimpleCross = union { // SimpleCross
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.04, 0.01, 0.33>
    translate  <2.039, -7.575, 1.309>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.04, 0.01, 0.2>
    rotate <0.0, 90.0, 0.0>
    translate  <2.036, -7.575, 1.436>
  }
  material {
    SimpleCrossPaint
  }
  rotate -2.1*z
  translate  <0.324, 0.128, -0.129>
}


#declare BezPtch001 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
      <-0.073974, 0.000000, -0.600182>, <-0.073974, -0.042391, -0.600182>, <-0.040185, -0.077075, -0.598488>, <0.001113, -0.077075, -0.596417>, 
      <-0.081727, 0.000000, -0.400154>, <-0.081727, -0.042391, -0.400154>, <-0.047938, -0.077075, -0.398460>, <-0.006640, -0.077075, -0.396390>, 
      <-0.072728, 0.000000, 0.380734>, <-0.072728, -0.048637, 0.380734>, <-0.034297, -0.088430, 0.382428>, <0.012674, -0.088430, 0.384499>, 
      <-0.078852, 0.000000, 0.597687>, <-0.078852, -0.048637, 0.597687>, <-0.041634, -0.088430, 0.591765>, <0.003856, -0.088430, 0.584527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
      <0.001113, -0.077075, -0.596417>, <0.042410, -0.077075, -0.594347>, <0.076199, -0.042391, -0.592653>, <0.076199, 0.000000, -0.592653>, 
      <-0.006640, -0.077075, -0.396390>, <0.034658, -0.077075, -0.394319>, <0.068447, -0.042391, -0.392625>, <0.068447, 0.000000, -0.392625>, 
      <0.012674, -0.088430, 0.384499>, <0.059644, -0.088430, 0.386569>, <0.098075, -0.048637, 0.388264>, <0.098075, 0.000000, 0.388264>, 
      <0.003856, -0.088430, 0.584527>, <0.049346, -0.088430, 0.577289>, <0.086565, -0.048637, 0.571367>, <0.086565, 0.000000, 0.571367>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
      <0.076199, 0.000000, -0.592653>, <0.076199, 0.042391, -0.592653>, <0.042410, 0.077075, -0.594347>, <0.001113, 0.077075, -0.596417>, 
      <0.068447, 0.000000, -0.392625>, <0.068447, 0.042391, -0.392625>, <0.034658, 0.077075, -0.394319>, <-0.006640, 0.077075, -0.396390>, 
      <0.098075, 0.000000, 0.388264>, <0.098075, 0.048637, 0.388264>, <0.059644, 0.088430, 0.386569>, <0.012674, 0.088430, 0.384499>, 
      <0.086565, 0.000000, 0.571367>, <0.086565, 0.048637, 0.571367>, <0.049346, 0.088430, 0.577289>, <0.003856, 0.088430, 0.584527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
      <0.001113, 0.077075, -0.596417>, <-0.040185, 0.077075, -0.598488>, <-0.073974, 0.042391, -0.600182>, <-0.073974, 0.000000, -0.600182>, 
      <-0.006640, 0.077075, -0.396390>, <-0.047938, 0.077075, -0.398460>, <-0.081727, 0.042391, -0.400154>, <-0.081727, 0.000000, -0.400154>, 
      <0.012674, 0.088430, 0.384499>, <-0.034297, 0.088430, 0.382428>, <-0.072728, 0.048637, 0.380734>, <-0.072728, 0.000000, 0.380734>, 
      <0.003856, 0.088430, 0.584527>, <-0.041634, 0.088430, 0.591765>, <-0.078852, 0.048637, 0.597687>, <-0.078852, 0.000000, 0.597687>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
      <-0.078852, 0.000000, 0.597687>, <-0.078852, -0.048637, 0.597687>, <-0.041634, -0.088430, 0.591765>, <0.003856, -0.088430, 0.584527>, 
      <-0.084977, 0.000000, 0.814640>, <-0.084977, -0.048637, 0.814640>, <-0.048970, -0.088430, 0.801101>, <-0.004961, -0.088430, 0.784555>, 
      <0.055278, 0.000000, 1.031228>, <0.055278, -0.048637, 1.031228>, <0.077005, -0.088430, 0.999483>, <0.103560, -0.088430, 0.960684>, 
      <0.187258, 0.000000, 1.107925>, <0.187258, -0.048637, 1.107925>, <0.210839, -0.088430, 1.077623>, <0.239660, -0.088430, 1.040587>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
      <0.003856, -0.088430, 0.584527>, <0.049346, -0.088430, 0.577289>, <0.086565, -0.048637, 0.571367>, <0.086565, 0.000000, 0.571367>, 
      <-0.004961, -0.088430, 0.784555>, <0.039047, -0.088430, 0.768008>, <0.075054, -0.048637, 0.754470>, <0.075054, 0.000000, 0.754470>, 
      <0.103560, -0.088430, 0.960684>, <0.130115, -0.088430, 0.921885>, <0.151841, -0.048637, 0.890140>, <0.151841, 0.000000, 0.890140>, 
      <0.239660, -0.088430, 1.040587>, <0.268481, -0.088430, 1.003552>, <0.292062, -0.048637, 0.973250>, <0.292062, 0.000000, 0.973250>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
      <0.086565, 0.000000, 0.571367>, <0.086565, 0.048637, 0.571367>, <0.049346, 0.088430, 0.577289>, <0.003856, 0.088430, 0.584527>, 
      <0.075054, 0.000000, 0.754470>, <0.075054, 0.048637, 0.754470>, <0.039047, 0.088430, 0.768008>, <-0.004961, 0.088430, 0.784555>, 
      <0.151841, 0.000000, 0.890140>, <0.151841, 0.048637, 0.890140>, <0.130115, 0.088430, 0.921885>, <0.103560, 0.088430, 0.960684>, 
      <0.292062, 0.000000, 0.973250>, <0.292062, 0.048637, 0.973250>, <0.268481, 0.088430, 1.003552>, <0.239660, 0.088430, 1.040587>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
      <0.003856, 0.088430, 0.584527>, <-0.041634, 0.088430, 0.591765>, <-0.078852, 0.048637, 0.597687>, <-0.078852, 0.000000, 0.597687>, 
      <-0.004961, 0.088430, 0.784555>, <-0.048970, 0.088430, 0.801101>, <-0.084977, 0.048637, 0.814640>, <-0.084977, 0.000000, 0.814640>, 
      <0.103560, 0.088430, 0.960684>, <0.077005, 0.088430, 0.999483>, <0.055278, 0.048637, 1.031228>, <0.055278, 0.000000, 1.031228>, 
      <0.239660, 0.088430, 1.040587>, <0.210839, 0.088430, 1.077623>, <0.187258, 0.048637, 1.107925>, <0.187258, 0.000000, 1.107925>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
      <0.187258, 0.000000, 1.107925>, <0.187258, -0.048637, 1.107925>, <0.210839, -0.088430, 1.077623>, <0.239660, -0.088430, 1.040587>, 
      <0.319237, 0.000000, 1.184622>, <0.319237, -0.048637, 1.184622>, <0.344672, -0.088430, 1.155763>, <0.375760, -0.088430, 1.120491>, 
      <0.511485, 0.000000, 1.274929>, <0.511485, -0.048637, 1.274929>, <0.530085, -0.088430, 1.241257>, <0.552818, -0.088430, 1.200102>, 
      <3.862643, 0.000000, 1.565323>, <3.862643, -0.043001, 1.565323>, <3.862552, -0.078183, 1.532789>, <3.862441, -0.078183, 1.493025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
      <0.239660, -0.088430, 1.040587>, <0.268481, -0.088430, 1.003552>, <0.292062, -0.048637, 0.973250>, <0.292062, 0.000000, 0.973250>, 
      <0.375760, -0.088430, 1.120491>, <0.406847, -0.088430, 1.085219>, <0.432282, -0.048637, 1.056359>, <0.432282, 0.000000, 1.056359>, 
      <0.552818, -0.088430, 1.200102>, <0.575551, -0.088430, 1.158946>, <0.594150, -0.048637, 1.125274>, <0.594150, 0.000000, 1.125274>, 
      <3.862441, -0.078183, 1.493025>, <3.862329, -0.078183, 1.453261>, <3.862238, -0.043001, 1.420727>, <3.862238, 0.000000, 1.420727>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
      <0.292062, 0.000000, 0.973250>, <0.292062, 0.048637, 0.973250>, <0.268481, 0.088430, 1.003552>, <0.239660, 0.088430, 1.040587>, 
      <0.432282, 0.000000, 1.056359>, <0.432282, 0.048637, 1.056359>, <0.406847, 0.088430, 1.085219>, <0.375760, 0.088430, 1.120491>, 
      <0.594150, 0.000000, 1.125274>, <0.594150, 0.048637, 1.125274>, <0.575551, 0.088430, 1.158946>, <0.552818, 0.088430, 1.200102>, 
      <3.862238, 0.000000, 1.420727>, <3.862238, 0.043001, 1.420727>, <3.862329, 0.078183, 1.453261>, <3.862441, 0.078183, 1.493025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
      <0.239660, 0.088430, 1.040587>, <0.210839, 0.088430, 1.077623>, <0.187258, 0.048637, 1.107925>, <0.187258, 0.000000, 1.107925>, 
      <0.375760, 0.088430, 1.120491>, <0.344672, 0.088430, 1.155763>, <0.319237, 0.048637, 1.184622>, <0.319237, 0.000000, 1.184622>, 
      <0.552818, 0.088430, 1.200102>, <0.530085, 0.088430, 1.241257>, <0.511485, 0.048637, 1.274929>, <0.511485, 0.000000, 1.274929>, 
      <3.862441, 0.078183, 1.493025>, <3.862552, 0.078183, 1.532789>, <3.862643, 0.043001, 1.565323>, <3.862643, 0.000000, 1.565323>
    }
  }
  material {
    WhitePaint
  }
  scale 0.25
  translate  <-0.965, 0.001, 1.359>
}




//
// ********  OBJECTS  *******
//

#declare scale_links                       = true;
#declare rotate_links                  = true;
//link_point1 Object Name             = ChainPoint12
#declare link_point1                  = <-2.003,-2.072,1.480>;
//link_point2 Object Name             = ChainPoint13
#declare link_point2                  = <-1.965,-2.045,1.326>;
#declare camera_sky                   = <0.000,0.000,1.000>;
#declare link_looseness               = 1.000;
#declare link_count                   = 4.000;
#declare link_twist                   = 0.000;
#declare total_link_twist             = 0.000;
#declare link_size_turb               = 0.000;
#declare link_twist_turb              = 0.000;
#declare link_seed                    = 0.000;
#declare link_texture             = material {ChromeLike}
#include "LINKOBJS.inc"
#declare link_object              = Iron_Chain
object {#include "LINK.INC" material {ChromeLike}}


#declare scale_links                       = true;
#declare rotate_links                  = true;
//link_point1 Object Name             = ChainPoint10
#declare link_point1                  = <-2.219,-2.247,1.487>;
//link_point2 Object Name             = ChainPoint11
#declare link_point2                  = <-2.257,-2.285,1.326>;
#declare camera_sky                   = <0.000,0.000,1.000>;
#declare link_looseness               = 1.000;
#declare link_count                   = 3.000;
#declare link_twist                   = 0.000;
#declare total_link_twist             = 0.000;
#declare link_size_turb               = 0.000;
#declare link_twist_turb              = 0.000;
#declare link_seed                    = 0.000;
#declare link_texture             = material {ChromeLike}
#include "LINKOBJS.inc"
#declare link_object              = Iron_Chain
object {#include "LINK.INC" material {ChromeLike}}


sphere { // ChainPoint10
  <0,0,0>,1
  material {
    ChromeLike
  }
  scale 0.01
  translate  <-2.219091, -2.246949, 1.487407>
}


#declare scale_links                       = true;
#declare rotate_links                  = true;
//link_point1 Object Name             = MyChainPoin3
#declare link_point1                  = <-1.924,-2.008,2.345>;
//link_point2 Object Name             = MyChainPoin4
#declare link_point2                  = <-2.001,-2.075,1.516>;
#declare camera_sky                   = <0.000,0.000,1.000>;
#declare link_looseness               = 1.000;
#declare link_count                   = 14.000;
#declare link_twist                   = 0.000;
#declare total_link_twist             = 10.000;
#declare link_size_turb               = 0.000;
#declare link_twist_turb              = 0.200;
#declare link_seed                    = 0.000;
#declare link_texture             = material {ChromeLike}
#include "LINKOBJS.inc"
#declare link_object              = Iron_Chain
object {#include "LINK.INC" material {ChromeLike}}


#declare scale_links                       = true;
#declare rotate_links                  = true;
//link_point1 Object Name             = MyChainPoin1
#declare link_point1                  = <-2.270,-2.298,2.345>;
//link_point2 Object Name             = MyChainPoin2
#declare link_point2                  = <-2.215,-2.245,1.530>;
#declare camera_sky                   = <0.000,0.000,1.000>;
#declare link_looseness               = 1.000;
#declare link_count                   = 16.000;
#declare link_twist                   = 10.000;
#declare total_link_twist             = 0.000;
#declare link_size_turb               = 0.000;
#declare link_twist_turb              = 0.200;
#declare link_seed                    = 0.000;
#declare link_texture             = material {ChromeLike}
#include "LINKOBJS.inc"
#declare link_object              = Iron_Chain
object {#include "LINK.INC" material {ChromeLike}}


#include "lilgrl.inc"

object {
  lilgrl
  scale 1.5
  rotate <90.0, 0.0, 41.700844>
  translate  <-1.98756, -2.242219, 0.803078>
}


#include "colors.inc"
#include "txttree.inc"
#include "maketree.pov" // tree & leaf macro
#declare dofile   = false;
#declare dotexture   = true;
#declare ftname="Ttest.inc" // file name for tree
#declare fvname="Ftest.inc" // file name for foliage
#declare ffname="Ltest.inc" // file name for leaf
#declare txtTree=texture{txtTree_3} // Bark texture
#declare rsd           = 12345.000;
#declare rd=seed(rsd);
#declare rdl=seed(rsd);
#declare level0  = 6.000;
#declare nseg0 = 7.000;
#declare dotop   = true;
#declare nb			= 4.000;
#declare lb0			= 25.000;
#declare rb0        = 1.400;
#declare ab0			= 35.000;
#declare qlb			= 0.670;
#declare qrb			= 0.590;
#declare qab			= 0.880;
#declare stdax		= 10.000;
#declare stday		= 10.000;
#declare branchproba= 1.000;
#declare jb			= 0.700;
#declare fgnarl		= 0.250;
#declare stdlseg		= 0.500;
#declare twigproba  = 0.590;
#declare v0			= <0.000,1.000,0.000>;
#declare pos0			= <0.000,0.000,0.000>;
#declare vpush		= <0.000,-1.000,0.000>;
#declare fpush		= 0.200;
#declare aboveground= 0.000;
#declare belowsky   = 140.000;
#declare rootproba  = 1.000;
#declare nroot		= 1.000;
#declare vroot		= <0.000,0.000,0.000>;
#declare yroot		= <0.000,0.500,0.000>;
#declare leafproba  = 0.000;
#declare leaflevel  = 4.000;
#declare alz0			= 100.000;
#declare alx0			= -10.000;
#declare stdalx		= 40.000;
#declare stdlsize   = 0.100;
#declare txtLeaf		= texture{txtLeaf_0}
#declare lsize		= 0.300;
#declare seg			= 10.000;
#declare ll			= 5.000;
#declare wl			= 1.200;
#declare fl			= 0.500;
#declare lpow			= 1.000;
#declare al			= 100.000;
#declare apow			= 1.000;
#declare ndents		= 0.000;
#declare nlobes		= 3.000;
#declare alobes		= 110.000;
#declare qlobes		= 0.700;
#declare ls			= 3.000;
#declare ws			= 0.120;
#declare as			= 10.000;
		object{
        #if (leafproba>0)
        #declare Leaf=object{MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,
                 ndents,nlobes,alobes,qlobes,ls,ws,as,dofile,ffname)
                 #if (dotexture=false)  // no texture applied to tree segments, so the leaf texture must be used for the individual leaf
                        texture{txtLeaf}
                 #end
        } 
        #end
        MakeTree()
        #if (dotexture = true) // texture is already applied to tree so that we can safely apply the leaf texture to the leaves
                texture {txtLeaf}
        #else
                texture {txtTree} // apply tree texture  regardless of the tree structure
        #end
			scale <0.050,0.050,0.050>
			rotate <90.000,0.000,173.300>
			translate <2.936,-3.591,0.834>
}


#include "colors.inc"
#include "txttree.inc"
#include "maketree.pov" // tree & leaf macro
#declare dofile   = false;
#declare dotexture   = true;
#declare ftname="Ttest.inc" // file name for tree
#declare fvname="Ftest.inc" // file name for foliage
#declare ffname="Ltest.inc" // file name for leaf
#declare txtTree=texture{txtTree_3} // Bark texture
#declare rsd           = 1433.000;
#declare rd=seed(rsd);
#declare rdl=seed(rsd);
#declare level0  = 6.000;
#declare nseg0 = 7.000;
#declare dotop   = true;
#declare nb			= 4.000;
#declare lb0			= 25.000;
#declare rb0        = 1.400;
#declare ab0			= 36.500;
#declare qlb			= 0.670;
#declare qrb			= 0.590;
#declare qab			= 0.880;
#declare stdax		= 10.000;
#declare stday		= 10.000;
#declare branchproba= 1.000;
#declare jb			= 0.700;
#declare fgnarl		= 0.250;
#declare stdlseg		= 0.500;
#declare twigproba  = 1.000;
#declare v0			= <0.000,1.000,0.000>;
#declare pos0			= <0.000,0.000,0.000>;
#declare vpush		= <0.000,-1.000,0.000>;
#declare fpush		= 0.200;
#declare aboveground= 0.000;
#declare belowsky   = 140.000;
#declare rootproba  = 1.000;
#declare nroot		= 1.000;
#declare vroot		= <0.000,0.000,0.000>;
#declare yroot		= <0.000,0.500,0.000>;
#declare leafproba  = 0.000;
#declare leaflevel  = 4.000;
#declare alz0			= 100.000;
#declare alx0			= -10.000;
#declare stdalx		= 36.500;
#declare stdlsize   = 0.100;
#declare txtLeaf		= texture{txtLeaf_0}
#declare lsize		= 0.300;
#declare seg			= 10.000;
#declare ll			= 5.000;
#declare wl			= 1.200;
#declare fl			= 0.500;
#declare lpow			= 1.000;
#declare al			= 100.000;
#declare apow			= 1.000;
#declare ndents		= 0.000;
#declare nlobes		= 3.000;
#declare alobes		= 110.000;
#declare qlobes		= 0.700;
#declare ls			= 3.000;
#declare ws			= 0.120;
#declare as			= 10.000;
		object{
        #if (leafproba>0)
        #declare Leaf=object{MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,
                 ndents,nlobes,alobes,qlobes,ls,ws,as,dofile,ffname)
                 #if (dotexture=false)  // no texture applied to tree segments, so the leaf texture must be used for the individual leaf
                        texture{txtLeaf}
                 #end
        } 
        #end
        MakeTree()
        #if (dotexture = true) // texture is already applied to tree so that we can safely apply the leaf texture to the leaves
                texture {txtLeaf}
        #else
                texture {txtTree} // apply tree texture  regardless of the tree structure
        #end
			scale <0.030,0.030,0.030>
			rotate <90.000,0.000,90.000>
			translate <-2.467,0.361,0.894>
}


object { // SimpleCross6 -> SimpleCross
  SimpleCross
  scale 0.5
  rotate <-0.0, -3.699998, 0.0>
  translate  <-0.052446, 5.514497, 0.318>
}


object { // SimpleCross5 -> SimpleCross
  SimpleCross
  rotate -29.900003*z
  translate  <0.712203, 0.254358, 0.0>
}


object { // SimpleCross4 -> SimpleCross
  SimpleCross
  scale 0.75
  rotate <5.5, -0.0, 0.0>
  translate  <1.185, 5.057, 0.752>
}


object { // SimpleCross3 -> SimpleCross
  SimpleCross
  scale 0.75
  rotate 1.5*y
  translate  <-2.065, 5.796, 0.198>
}


object { // SimpleCross2 -> SimpleCross
  SimpleCross
  rotate <-0.0, 3.2, 5.8>
  translate  <0.512, 3.105, 0.0>
}


object { // SimpleCross1 -> SimpleCross
  SimpleCross
  rotate <-0.0, -2.6, 0.4>
  translate  <-3.341, 1.99, -0.164>
}


object { SimpleCross }


#declare scale_links                       = true;
#declare rotate_links                  = true;
//link_point1 Object Name             = MyChainPoin7
#declare link_point1                  = <-0.961,-1.492,2.339>;
//link_point2 Object Name             = MyChainPoin8
#declare link_point2                  = <-0.978,-1.492,1.353>;
#declare camera_sky                   = <0.000,0.000,1.000>;
#declare link_looseness               = 1.000;
#declare link_count                   = 20.000;
#declare link_twist                   = 10.000;
#declare total_link_twist             = 0.000;
#declare link_size_turb               = 0.000;
#declare link_twist_turb              = 0.200;
#declare link_seed                    = 0.000;
#declare link_texture             = material {ChromeLike}
#include "LINKOBJS.inc"
#declare link_object              = Iron_Chain
object {#include "LINK.INC" material {ChromeLike}}


#declare scale_links                       = true;
#declare rotate_links                  = true;
//link_point1 Object Name             = MyChainPoin5
#declare link_point1                  = <-1.313,-1.492,2.345>;
//link_point2 Object Name             = MyChainPoin6
#declare link_point2                  = <-1.324,-1.492,1.359>;
#declare camera_sky                   = <0.000,0.000,1.000>;
#declare link_looseness               = 1.000;
#declare link_count                   = 20.000;
#declare link_twist                   = 11.000;
#declare total_link_twist             = 0.000;
#declare link_size_turb               = 0.000;
#declare link_twist_turb              = 0.000;
#declare link_seed                    = 0.000;
#declare link_texture             = material {ChromeLike}
#include "LINKOBJS.inc"
#declare link_object              = Iron_Chain
object {#include "LINK.INC" material {ChromeLike}}


sphere { // MyChainPoin1
  <0,0,0>,1
  material {
    ChromeLike
  }
  scale 0.01
  translate  <-2.27, -2.298, 2.345>
}


#declare BentBars = union {
  object { BezPtch001 }
  object { // BezPtch002 -> BezPtch001
    BezPtch001
    rotate -45.0*z
    translate  -0.0*x
  }
  object { // BezPtch003 -> BezPtch001
    BezPtch001
    rotate -90.0*z
    translate  0.0*x
  }
  object { // BezPtch004 -> BezPtch001
    BezPtch001
    rotate -135.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // BezPtch005 -> BezPtch001
    BezPtch001
    rotate -180.0*z
    translate  -0.0*y
  }
  object { // BezPtch006 -> BezPtch001
    BezPtch001
    rotate 135.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // BezPtch007 -> BezPtch001
    BezPtch001
    rotate 90.0*z
    translate  -0.0*x
  }
  object { // BezPtch008 -> BezPtch001
    BezPtch001
    rotate 45.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  translate  <1.417, -5.641, -0.017>
}
union { // MarryGoRound
  object { BentBars }
  superellipsoid { // SuperQ001
    <1.0, 0.1>
    material {
      WhitePaint
    }
    scale <0.035, 0.035, 0.5>
    translate  <1.42, -5.642, 1.243>
  }
  superellipsoid { // SuperQ002
    <1.0, 0.2>
    material {
      TheMessedUpMetal
      scale <1.83, 1.59, 1.0>
      translate <-1.070000, -0.797000, 0.000000>
    }
    scale <1.0, 1.0, 0.02>
    translate  <1.42, -5.642, 1.179>
  }
}


sphere { // Sphere001
  <0,0,0>,1
  material {
    ThaClouds
  }
  hollow
  scale 38.630001
}


#include "swingthing.inc"

#declare swingthing_Ref = object {
  swingthing
  scale 0.25
  rotate <90.0, 0.0, 90.0>
  translate  <-2.897, -2.65, 2.203>
}
#declare CSG001 = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      ScrewedupPaint
    }
    scale <0.06, 0.06, 1.5>
    rotate <-25.0, -0.0, 0.0>
    translate  <-2.898, -3.318, 0.887>
  }
  object { swingthing_Ref }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      ScrewedupPaint
    }
    scale <0.06, 0.06, 1.5>
    rotate <25.0, -0.0, 0.0>
    translate  <-2.898, -1.645, 0.895>
  }
}
#declare swingthing1_Ref = object {
  swingthing
  scale 0.25
  rotate <90.0, 0.0, 90.0>
  translate  <-2.897, -2.65, 2.203>
}
#declare CSG002 = union {
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      ScrewedupPaint
    }
    scale <0.06, 0.06, 1.5>
    rotate <-25.0, -0.0, 0.0>
    translate  <-2.898, -3.318, 0.887>
  }
  object { swingthing1_Ref }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      ScrewedupPaint
    }
    scale <0.06, 0.06, 1.5>
    rotate <25.0, -0.0, 0.0>
    translate  <-2.898, -1.645, 0.895>
  }
  rotate 180.0*z
  translate  <-2.986, -4.888, -0.002>
}
#declare SwingSeat = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.014974, 0.009113, 1.029013>, <0.993903, 0.009116, 1.013628>, <0.914901, 0.004965, 0.955086>, <0.909455, 0.000005, 0.950102>, 
      <1.047838, -1.038944, 0.983962>, <1.026766, -1.039282, 0.968578>, <0.946357, -0.565270, 0.911964>, <0.939264, 0.001131, 0.909235>, 
      <1.342653, -1.037183, 0.580130>, <1.321581, -1.037521, 0.564745>, <1.241172, -0.563524, 0.508132>, <1.234080, 0.002876, 0.505402>, 
      <1.678584, -1.035422, 0.328976>, <1.668542, -1.035760, 0.308249>, <1.629353, -0.561779, 0.230783>, <1.624958, 0.004621, 0.225714>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.909455, 0.000005, 0.950102>, <0.904008, -0.004955, 0.945118>, <0.974113, -0.008920, 0.995483>, <0.995184, -0.008923, 1.010867>, 
      <0.939264, 0.001131, 0.909235>, <0.932172, 0.567531, 0.906505>, <1.000938, 1.020355, 0.958703>, <1.022009, 1.020693, 0.974087>, 
      <1.234080, 0.002876, 0.505402>, <1.226987, 0.569276, 0.502672>, <1.295753, 1.022116, 0.554870>, <1.316824, 1.022454, 0.570255>, 
      <1.624958, 0.004621, 0.225714>, <1.620563, 0.571021, 0.220645>, <1.652508, 1.023877, 0.289842>, <1.662550, 1.024215, 0.310570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.995184, -0.008923, 1.010867>, <1.016255, -0.008926, 1.026252>, <0.980631, -0.004965, 1.001061>, <0.986077, -0.000005, 1.006045>, 
      <1.022009, 1.020693, 0.974087>, <1.043081, 1.021031, 0.989472>, <1.008795, 0.568760, 0.962448>, <1.015887, 0.002360, 0.965178>, 
      <1.316824, 1.022454, 0.570255>, <1.337896, 1.022792, 0.585639>, <1.303610, 0.570505, 0.558615>, <1.310702, 0.004105, 0.561345>, 
      <1.662550, 1.024215, 0.310570>, <1.672592, 1.024553, 0.331297>, <1.657079, 0.572250, 0.296019>, <1.661474, 0.005850, 0.301087>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.986077, -0.000005, 1.006045>, <0.991524, 0.004955, 1.011029>, <1.036045, 0.009110, 1.044397>, <1.014974, 0.009113, 1.029013>, 
      <1.015887, 0.002360, 0.965178>, <1.022979, -0.564040, 0.967908>, <1.068909, -1.038606, 0.999347>, <1.047838, -1.038944, 0.983962>, 
      <1.310702, 0.004105, 0.561345>, <1.317795, -0.562295, 0.564075>, <1.363724, -1.036845, 0.595514>, <1.342653, -1.037183, 0.580130>, 
      <1.661474, 0.005850, 0.301087>, <1.665869, -0.560550, 0.306156>, <1.688626, -1.035084, 0.349704>, <1.678584, -1.035422, 0.328976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.678584, -1.035422, 0.328976>, <1.668542, -1.035760, 0.308249>, <1.629353, -0.561779, 0.230783>, <1.624958, 0.004621, 0.225714>, 
      <2.014516, -1.033661, 0.077823>, <2.015503, -1.033999, 0.051752>, <2.017534, -0.560034, -0.046566>, <2.015836, 0.006366, -0.053974>, 
      <2.517220, -1.031900, 0.015802>, <2.518208, -1.032238, -0.010269>, <2.520239, -0.558289, -0.108588>, <2.518541, 0.008112, -0.115995>, 
      <3.016860, -1.030140, 0.034702>, <3.017847, -1.030478, 0.008631>, <3.019878, -0.556543, -0.089687>, <3.018180, 0.009857, -0.097095>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.624958, 0.004621, 0.225714>, <1.620563, 0.571021, 0.220645>, <1.652508, 1.023877, 0.289842>, <1.662550, 1.024215, 0.310570>, 
      <2.015836, 0.006366, -0.053974>, <2.014138, 0.572767, -0.061381>, <2.009264, 1.025638, 0.024814>, <2.008276, 1.025976, 0.050885>, 
      <2.518541, 0.008112, -0.115995>, <2.516842, 0.574512, -0.123403>, <2.511968, 1.027398, -0.037208>, <2.510981, 1.027736, -0.011137>, 
      <3.018180, 0.009857, -0.097095>, <3.016482, 0.576257, -0.104502>, <3.011608, 1.029159, -0.018308>, <3.010620, 1.029497, 0.007763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.662550, 1.024215, 0.310570>, <1.672592, 1.024553, 0.331297>, <1.657079, 0.572250, 0.296019>, <1.661474, 0.005850, 0.301087>, 
      <2.008276, 1.025976, 0.050885>, <2.007289, 1.026314, 0.076956>, <2.010547, 0.573996, 0.033422>, <2.012246, 0.007595, 0.040830>, 
      <2.510981, 1.027736, -0.011137>, <2.509993, 1.028074, 0.014934>, <2.513252, 0.575741, -0.028599>, <2.514950, 0.009341, -0.021192>, 
      <3.010620, 1.029497, 0.007763>, <3.009633, 1.029835, 0.033834>, <3.012891, 0.577486, -0.009699>, <3.014590, 0.011086, -0.002291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.661474, 0.005850, 0.301087>, <1.665869, -0.560550, 0.306156>, <1.688626, -1.035084, 0.349704>, <1.678584, -1.035422, 0.328976>, 
      <2.012246, 0.007595, 0.040830>, <2.013944, -0.558805, 0.048237>, <2.013529, -1.033323, 0.103894>, <2.014516, -1.033661, 0.077823>, 
      <2.514950, 0.009341, -0.021192>, <2.516648, -0.557060, -0.013784>, <2.516233, -1.031562, 0.041873>, <2.517220, -1.031900, 0.015802>, 
      <3.014590, 0.011086, -0.002291>, <3.016288, -0.555314, 0.005116>, <3.015872, -1.029802, 0.060773>, <3.016860, -1.030140, 0.034702>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.016860, -1.030140, 0.034702>, <3.017847, -1.030478, 0.008631>, <3.019878, -0.556543, -0.089687>, <3.018180, 0.009857, -0.097095>, 
      <3.516499, -1.028379, 0.053602>, <3.517487, -1.028717, 0.027531>, <3.519518, -0.554798, -0.070787>, <3.517820, 0.011602, -0.078194>, 
      <3.910773, -1.026618, 0.111060>, <3.918059, -1.026956, 0.086008>, <3.943896, -0.553053, -0.008876>, <3.944046, 0.013347, -0.016474>, 
      <4.214395, -1.024857, 0.355333>, <4.269862, -1.025195, 0.336350>, <4.325079, -0.551308, 0.263839>, <4.287363, 0.015093, 0.257364>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.018180, 0.009857, -0.097095>, <3.016482, 0.576257, -0.104502>, <3.011608, 1.029159, -0.018308>, <3.010620, 1.029497, 0.007763>, 
      <3.517820, 0.011602, -0.078194>, <3.516122, 0.578002, -0.085602>, <3.511247, 1.030920, 0.000593>, <3.510260, 1.031258, 0.026664>, 
      <3.944046, 0.013347, -0.016474>, <3.944197, 0.579748, -0.024072>, <3.918545, 1.032681, 0.058361>, <3.911259, 1.033019, 0.083412>, 
      <4.287363, 0.015093, 0.257364>, <4.330627, 0.581493, 0.250890>, <4.279902, 1.034442, 0.312771>, <4.224435, 1.034780, 0.331753>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.010620, 1.029497, 0.007763>, <3.009633, 1.029835, 0.033834>, <3.012891, 0.577486, -0.009699>, <3.014590, 0.011086, -0.002291>, 
      <3.510260, 1.031258, 0.026664>, <3.509272, 1.031596, 0.052735>, <3.512531, 0.579231, 0.009202>, <3.514229, 0.012831, 0.016609>, 
      <3.911259, 1.033019, 0.083412>, <3.903972, 1.033357, 0.108464>, <3.917701, 0.580977, 0.067024>, <3.917550, 0.014576, 0.074622>, 
      <4.224435, 1.034780, 0.331753>, <4.249947, 1.035118, 0.350736>, <4.276162, 0.582722, 0.319919>, <4.232898, 0.016322, 0.326393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.014590, 0.011086, -0.002291>, <3.016288, -0.555314, 0.005116>, <3.015872, -1.029802, 0.060773>, <3.016860, -1.030140, 0.034702>, 
      <3.514229, 0.012831, 0.016609>, <3.515927, -0.553569, 0.024017>, <3.515512, -1.028041, 0.079673>, <3.516499, -1.028379, 0.053602>, 
      <3.917550, 0.014576, 0.074622>, <3.917400, -0.551824, 0.082221>, <3.903486, -1.026280, 0.136111>, <3.910773, -1.026618, 0.111060>, 
      <4.232898, 0.016322, 0.326393>, <4.270614, -0.550079, 0.332867>, <4.239907, -1.024519, 0.374315>, <4.214395, -1.024857, 0.355333>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.214395, -1.024857, 0.355333>, <4.269862, -1.025195, 0.336350>, <4.325079, -0.551308, 0.263839>, <4.287363, 0.015093, 0.257364>, 
      <4.598996, -1.023096, 0.599606>, <4.621666, -1.023434, 0.586692>, <4.706262, -0.549562, 0.536553>, <4.711659, 0.016838, 0.531203>, 
      <4.846508, -1.021335, 1.034042>, <4.869177, -1.021673, 1.021128>, <4.953773, -0.547817, 0.970990>, <4.959171, 0.018583, 0.965640>, 
      <4.826769, 0.073012, 0.999347>, <4.849438, 0.073013, 0.986433>, <4.934096, 0.070784, 0.936402>, <4.939564, 0.068120, 0.931177>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.287363, 0.015093, 0.257364>, <4.330627, 0.581493, 0.250890>, <4.279902, 1.034442, 0.312771>, <4.224435, 1.034780, 0.331753>, 
      <4.711659, 0.016838, 0.531203>, <4.717056, 0.583238, 0.525853>, <4.641259, 1.036203, 0.567180>, <4.618590, 1.036541, 0.580094>, 
      <4.959171, 0.018583, 0.965640>, <4.964568, 0.584983, 0.960289>, <4.888771, 1.037964, 1.001617>, <4.866101, 1.038302, 1.014531>, 
      <4.939564, 0.068120, 0.931177>, <4.945032, 0.065455, 0.925952>, <4.869294, 0.063325, 0.967381>, <4.846625, 0.063323, 0.980295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.224435, 1.034780, 0.331753>, <4.249947, 1.035118, 0.350736>, <4.276162, 0.582722, 0.319919>, <4.232898, 0.016322, 0.326393>, 
      <4.618590, 1.036541, 0.580094>, <4.595921, 1.036879, 0.593008>, <4.634622, 0.584467, 0.572813>, <4.629225, 0.018067, 0.578163>, 
      <4.866101, 1.038302, 1.014531>, <4.843432, 1.038640, 1.027445>, <4.882134, 0.586212, 1.007250>, <4.876736, 0.019812, 1.012600>, 
      <4.846625, 0.063323, 0.980295>, <4.823955, 0.063321, 0.993209>, <4.862598, 0.065450, 0.972912>, <4.857130, 0.068114, 0.978137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.232898, 0.016322, 0.326393>, <4.270614, -0.550079, 0.332867>, <4.239907, -1.024519, 0.374315>, <4.214395, -1.024857, 0.355333>, 
      <4.629225, 0.018067, 0.578163>, <4.623828, -0.548333, 0.583514>, <4.576327, -1.022758, 0.612520>, <4.598996, -1.023096, 0.599606>, 
      <4.876736, 0.019812, 1.012600>, <4.871339, -0.546588, 1.017950>, <4.823838, -1.020997, 1.046956>, <4.846508, -1.021335, 1.034042>, 
      <4.857130, 0.068114, 0.978137>, <4.851662, 0.070779, 0.983362>, <4.804100, 0.073010, 1.012261>, <4.826769, 0.073012, 0.999347>
    }
  }
  material {
    BluePlastic
  }
  scale <0.1, 0.06, 0.1>
  translate  <-2.445, -2.445, 1.331>
}
#declare SwingSeat1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.014974, 0.009113, 1.029013>, <0.993903, 0.009116, 1.013628>, <0.914901, 0.004965, 0.955086>, <0.909455, 0.000005, 0.950102>, 
      <1.047838, -1.038944, 0.983962>, <1.026766, -1.039282, 0.968578>, <0.946357, -0.565270, 0.911964>, <0.939264, 0.001131, 0.909235>, 
      <1.342653, -1.037183, 0.580130>, <1.321581, -1.037521, 0.564745>, <1.241172, -0.563524, 0.508132>, <1.234080, 0.002876, 0.505402>, 
      <1.678584, -1.035422, 0.328976>, <1.668542, -1.035760, 0.308249>, <1.629353, -0.561779, 0.230783>, <1.624958, 0.004621, 0.225714>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.909455, 0.000005, 0.950102>, <0.904008, -0.004955, 0.945118>, <0.974113, -0.008920, 0.995483>, <0.995184, -0.008923, 1.010867>, 
      <0.939264, 0.001131, 0.909235>, <0.932172, 0.567531, 0.906505>, <1.000938, 1.020355, 0.958703>, <1.022009, 1.020693, 0.974087>, 
      <1.234080, 0.002876, 0.505402>, <1.226987, 0.569276, 0.502672>, <1.295753, 1.022116, 0.554870>, <1.316824, 1.022454, 0.570255>, 
      <1.624958, 0.004621, 0.225714>, <1.620563, 0.571021, 0.220645>, <1.652508, 1.023877, 0.289842>, <1.662550, 1.024215, 0.310570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.995184, -0.008923, 1.010867>, <1.016255, -0.008926, 1.026252>, <0.980631, -0.004965, 1.001061>, <0.986077, -0.000005, 1.006045>, 
      <1.022009, 1.020693, 0.974087>, <1.043081, 1.021031, 0.989472>, <1.008795, 0.568760, 0.962448>, <1.015887, 0.002360, 0.965178>, 
      <1.316824, 1.022454, 0.570255>, <1.337896, 1.022792, 0.585639>, <1.303610, 0.570505, 0.558615>, <1.310702, 0.004105, 0.561345>, 
      <1.662550, 1.024215, 0.310570>, <1.672592, 1.024553, 0.331297>, <1.657079, 0.572250, 0.296019>, <1.661474, 0.005850, 0.301087>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.986077, -0.000005, 1.006045>, <0.991524, 0.004955, 1.011029>, <1.036045, 0.009110, 1.044397>, <1.014974, 0.009113, 1.029013>, 
      <1.015887, 0.002360, 0.965178>, <1.022979, -0.564040, 0.967908>, <1.068909, -1.038606, 0.999347>, <1.047838, -1.038944, 0.983962>, 
      <1.310702, 0.004105, 0.561345>, <1.317795, -0.562295, 0.564075>, <1.363724, -1.036845, 0.595514>, <1.342653, -1.037183, 0.580130>, 
      <1.661474, 0.005850, 0.301087>, <1.665869, -0.560550, 0.306156>, <1.688626, -1.035084, 0.349704>, <1.678584, -1.035422, 0.328976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.678584, -1.035422, 0.328976>, <1.668542, -1.035760, 0.308249>, <1.629353, -0.561779, 0.230783>, <1.624958, 0.004621, 0.225714>, 
      <2.014516, -1.033661, 0.077823>, <2.015503, -1.033999, 0.051752>, <2.017534, -0.560034, -0.046566>, <2.015836, 0.006366, -0.053974>, 
      <2.517220, -1.031900, 0.015802>, <2.518208, -1.032238, -0.010269>, <2.520239, -0.558289, -0.108588>, <2.518541, 0.008112, -0.115995>, 
      <3.016860, -1.030140, 0.034702>, <3.017847, -1.030478, 0.008631>, <3.019878, -0.556543, -0.089687>, <3.018180, 0.009857, -0.097095>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.624958, 0.004621, 0.225714>, <1.620563, 0.571021, 0.220645>, <1.652508, 1.023877, 0.289842>, <1.662550, 1.024215, 0.310570>, 
      <2.015836, 0.006366, -0.053974>, <2.014138, 0.572767, -0.061381>, <2.009264, 1.025638, 0.024814>, <2.008276, 1.025976, 0.050885>, 
      <2.518541, 0.008112, -0.115995>, <2.516842, 0.574512, -0.123403>, <2.511968, 1.027398, -0.037208>, <2.510981, 1.027736, -0.011137>, 
      <3.018180, 0.009857, -0.097095>, <3.016482, 0.576257, -0.104502>, <3.011608, 1.029159, -0.018308>, <3.010620, 1.029497, 0.007763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.662550, 1.024215, 0.310570>, <1.672592, 1.024553, 0.331297>, <1.657079, 0.572250, 0.296019>, <1.661474, 0.005850, 0.301087>, 
      <2.008276, 1.025976, 0.050885>, <2.007289, 1.026314, 0.076956>, <2.010547, 0.573996, 0.033422>, <2.012246, 0.007595, 0.040830>, 
      <2.510981, 1.027736, -0.011137>, <2.509993, 1.028074, 0.014934>, <2.513252, 0.575741, -0.028599>, <2.514950, 0.009341, -0.021192>, 
      <3.010620, 1.029497, 0.007763>, <3.009633, 1.029835, 0.033834>, <3.012891, 0.577486, -0.009699>, <3.014590, 0.011086, -0.002291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.661474, 0.005850, 0.301087>, <1.665869, -0.560550, 0.306156>, <1.688626, -1.035084, 0.349704>, <1.678584, -1.035422, 0.328976>, 
      <2.012246, 0.007595, 0.040830>, <2.013944, -0.558805, 0.048237>, <2.013529, -1.033323, 0.103894>, <2.014516, -1.033661, 0.077823>, 
      <2.514950, 0.009341, -0.021192>, <2.516648, -0.557060, -0.013784>, <2.516233, -1.031562, 0.041873>, <2.517220, -1.031900, 0.015802>, 
      <3.014590, 0.011086, -0.002291>, <3.016288, -0.555314, 0.005116>, <3.015872, -1.029802, 0.060773>, <3.016860, -1.030140, 0.034702>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.016860, -1.030140, 0.034702>, <3.017847, -1.030478, 0.008631>, <3.019878, -0.556543, -0.089687>, <3.018180, 0.009857, -0.097095>, 
      <3.516499, -1.028379, 0.053602>, <3.517487, -1.028717, 0.027531>, <3.519518, -0.554798, -0.070787>, <3.517820, 0.011602, -0.078194>, 
      <3.910773, -1.026618, 0.111060>, <3.918059, -1.026956, 0.086008>, <3.943896, -0.553053, -0.008876>, <3.944046, 0.013347, -0.016474>, 
      <4.214395, -1.024857, 0.355333>, <4.269862, -1.025195, 0.336350>, <4.325079, -0.551308, 0.263839>, <4.287363, 0.015093, 0.257364>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.018180, 0.009857, -0.097095>, <3.016482, 0.576257, -0.104502>, <3.011608, 1.029159, -0.018308>, <3.010620, 1.029497, 0.007763>, 
      <3.517820, 0.011602, -0.078194>, <3.516122, 0.578002, -0.085602>, <3.511247, 1.030920, 0.000593>, <3.510260, 1.031258, 0.026664>, 
      <3.944046, 0.013347, -0.016474>, <3.944197, 0.579748, -0.024072>, <3.918545, 1.032681, 0.058361>, <3.911259, 1.033019, 0.083412>, 
      <4.287363, 0.015093, 0.257364>, <4.330627, 0.581493, 0.250890>, <4.279902, 1.034442, 0.312771>, <4.224435, 1.034780, 0.331753>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.010620, 1.029497, 0.007763>, <3.009633, 1.029835, 0.033834>, <3.012891, 0.577486, -0.009699>, <3.014590, 0.011086, -0.002291>, 
      <3.510260, 1.031258, 0.026664>, <3.509272, 1.031596, 0.052735>, <3.512531, 0.579231, 0.009202>, <3.514229, 0.012831, 0.016609>, 
      <3.911259, 1.033019, 0.083412>, <3.903972, 1.033357, 0.108464>, <3.917701, 0.580977, 0.067024>, <3.917550, 0.014576, 0.074622>, 
      <4.224435, 1.034780, 0.331753>, <4.249947, 1.035118, 0.350736>, <4.276162, 0.582722, 0.319919>, <4.232898, 0.016322, 0.326393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.014590, 0.011086, -0.002291>, <3.016288, -0.555314, 0.005116>, <3.015872, -1.029802, 0.060773>, <3.016860, -1.030140, 0.034702>, 
      <3.514229, 0.012831, 0.016609>, <3.515927, -0.553569, 0.024017>, <3.515512, -1.028041, 0.079673>, <3.516499, -1.028379, 0.053602>, 
      <3.917550, 0.014576, 0.074622>, <3.917400, -0.551824, 0.082221>, <3.903486, -1.026280, 0.136111>, <3.910773, -1.026618, 0.111060>, 
      <4.232898, 0.016322, 0.326393>, <4.270614, -0.550079, 0.332867>, <4.239907, -1.024519, 0.374315>, <4.214395, -1.024857, 0.355333>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.214395, -1.024857, 0.355333>, <4.269862, -1.025195, 0.336350>, <4.325079, -0.551308, 0.263839>, <4.287363, 0.015093, 0.257364>, 
      <4.598996, -1.023096, 0.599606>, <4.621666, -1.023434, 0.586692>, <4.706262, -0.549562, 0.536553>, <4.711659, 0.016838, 0.531203>, 
      <4.846508, -1.021335, 1.034042>, <4.869177, -1.021673, 1.021128>, <4.953773, -0.547817, 0.970990>, <4.959171, 0.018583, 0.965640>, 
      <4.826769, 0.073012, 0.999347>, <4.849438, 0.073013, 0.986433>, <4.934096, 0.070784, 0.936402>, <4.939564, 0.068120, 0.931177>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.287363, 0.015093, 0.257364>, <4.330627, 0.581493, 0.250890>, <4.279902, 1.034442, 0.312771>, <4.224435, 1.034780, 0.331753>, 
      <4.711659, 0.016838, 0.531203>, <4.717056, 0.583238, 0.525853>, <4.641259, 1.036203, 0.567180>, <4.618590, 1.036541, 0.580094>, 
      <4.959171, 0.018583, 0.965640>, <4.964568, 0.584983, 0.960289>, <4.888771, 1.037964, 1.001617>, <4.866101, 1.038302, 1.014531>, 
      <4.939564, 0.068120, 0.931177>, <4.945032, 0.065455, 0.925952>, <4.869294, 0.063325, 0.967381>, <4.846625, 0.063323, 0.980295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.224435, 1.034780, 0.331753>, <4.249947, 1.035118, 0.350736>, <4.276162, 0.582722, 0.319919>, <4.232898, 0.016322, 0.326393>, 
      <4.618590, 1.036541, 0.580094>, <4.595921, 1.036879, 0.593008>, <4.634622, 0.584467, 0.572813>, <4.629225, 0.018067, 0.578163>, 
      <4.866101, 1.038302, 1.014531>, <4.843432, 1.038640, 1.027445>, <4.882134, 0.586212, 1.007250>, <4.876736, 0.019812, 1.012600>, 
      <4.846625, 0.063323, 0.980295>, <4.823955, 0.063321, 0.993209>, <4.862598, 0.065450, 0.972912>, <4.857130, 0.068114, 0.978137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.232898, 0.016322, 0.326393>, <4.270614, -0.550079, 0.332867>, <4.239907, -1.024519, 0.374315>, <4.214395, -1.024857, 0.355333>, 
      <4.629225, 0.018067, 0.578163>, <4.623828, -0.548333, 0.583514>, <4.576327, -1.022758, 0.612520>, <4.598996, -1.023096, 0.599606>, 
      <4.876736, 0.019812, 1.012600>, <4.871339, -0.546588, 1.017950>, <4.823838, -1.020997, 1.046956>, <4.846508, -1.021335, 1.034042>, 
      <4.857130, 0.068114, 0.978137>, <4.851662, 0.070779, 0.983362>, <4.804100, 0.073010, 1.012261>, <4.826769, 0.073012, 0.999347>
    }
  }
  material {
    BluePlastic
  }
  scale <0.12, 0.06, 0.06>
  rotate <0.0, 0.0, -0.0>
  translate  <-1.238, -2.447, 1.404>
}
union { // SwingSet
  object { CSG001 }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      ScrewedupPaint
    }
    scale <0.035, 0.035, 2.5>
    rotate 90.0*y
    translate  <-2.731, -2.443, 2.486>
  }
  object { CSG002 }
  object { SwingSeat }
  object { SwingSeat1 }
  rotate 40.0*z
  translate  <-2.034, 1.095, -0.11>
}


box { // Cube001
  <-1, -1, -1>, <1, 1, 1>
  material {
    ThaClouds
  }
  scale <15.403518, 9.406223, -0.35>
  rotate 90.0*x
  translate  <1.625621, 19.137, 2.148863>
}




object {   // ThaGround
  height_field {
    jpeg "mount1.jpg"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <9.87, 6.54, 0.04>
  rotate -180.0*z
  translate  <-0.282, -1.215, 0.833>
  material {
    GreyishGrass
    // Transform to world space
  }
}


object {   // ThaGround1
  height_field {
    jpeg "mount1.jpg"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <17.780001, 6.38, 1.17>
  rotate -180.0*z
  translate  <-5.532, 11.701, 0.833>
  material {
    GreyishGrass_1
    // Transform to world space
  }
}


sphere { // MyChainPoin2
  <0,0,0>,1
  material {
    ChromeLike
  }
  scale 0.01
  translate  <-2.215329, -2.244835, 1.529941>
}


sphere { // MyChainPoin3
  <0,0,0>,1
  material {
    ChromeLike
  }
  scale 0.01
  translate  <-1.924, -2.008, 2.345>
}


sphere { // MyChainPoin4
  <0,0,0>,1
  material {
    ChromeLike
  }
  scale 0.01
  translate  <-2.001499, -2.07489, 1.51588>
}


sphere { // MyChainPoin5
  <0,0,0>,1
  material {
    ChromeLike
  }
  scale 0.01
  translate  <-1.313, -1.492, 2.345>
}


sphere { // MyChainPoin6
  <0,0,0>,1
  material {
    ChromeLike
  }
  scale 0.01
  translate  <-1.324, -1.492, 1.359>
}


sphere { // MyChainPoin7
  <0,0,0>,1
  material {
    ChromeLike
  }
  scale 0.01
  translate  <-0.961, -1.492, 2.339>
}


sphere { // MyChainPoin8
  <0,0,0>,1
  material {
    ChromeLike
  }
  scale 0.01
  translate  <-0.978, -1.492, 1.353>
}


#declare HgtFld002 = object { 
  height_field {
    tga "crossbody.tga"
    water_level 0.1071
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <1.0, 1.0, 0.1>
  rotate <90.0, -0.0, -180.0>
  translate  <-0.098, 0.171, 0.002>
}
#declare HgtFld001 = object { 
  height_field {
    tga "cross.tga"
    water_level 0.0238
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <1.0, 1.0, 0.05>
  rotate 90.0*x
  translate  <0.0, 0.046, 0.004>
}
union { // Celtic_Cross
  object { HgtFld002 }
  object { HgtFld001 }
  material {
    stonegrave
  }
  scale 0.5
  rotate <1.088982, -2.98906, -20.028412>
  translate  <-0.152, -6.704, 1.296>
}


#declare TaperSweep001 = prism {
  conic_sweep
  cubic_spline
  0.75,1.0
  15  // control points
  <-0.980332, 0.72704>,
  <-0.983147, -0.773551>,
  <-0.968126, -1.016009>,
  <-0.736193, -1.061739>,
  <0.762624, -1.041552>,
  <0.981243, -1.00402>,
  <1.000755, -0.694688>,
  <1.022683, 0.77944>,
  <0.960157, 1.042171>,
  <0.703952, 1.055797>,
  <-0.678085, 1.054335>,
  <-0.938508, 1.017137>,
  <-0.980332, 0.72704>,
  <-0.983147, -0.773551>,
  <-0.968126, -1.016009>
  rotate <90,0,90>
  scale <0.5, 0.5, 1.5>
  rotate <180.0, 0.0, -0.0>
  translate  <0.0, 0.04, 1.505>
}
#declare TaperSweep002 = prism {
  conic_sweep
  cubic_spline
  0.9,1.0
  16  // control points
  <-1.046123, 0.820852>,
  <-1.064201, -0.677692>,
  <-1.028118, -0.950793>,
  <-0.698818, -0.984756>,
  <0.72551, -0.96944>,
  <0.978911, -0.915646>,
  <1.016215, -0.621123>,
  <1.00703, 0.746937>,
  <0.944215, 1.127735>,
  <0.674981, 1.187409>,
  <0.00703, 1.186734>,
  <-0.761227, 1.195156>,
  <-1.028118, 1.14762>,
  <-1.046123, 0.820852>,
  <-1.064201, -0.677692>,
  <-1.028118, -0.950793>
  rotate <90,0,90>
  scale <0.3, 0.3, 7.5>
  rotate <180.0, 0.0, -0.0>
  translate  <-0.036, 0.026, 7.866>
}
#declare TaperSweep003 = prism {
  conic_sweep
  cubic_spline
  0.9,1.0
  16  // control points
  <-1.046123, 0.820852>,
  <-1.064201, -0.677692>,
  <-1.028118, -0.950793>,
  <-0.698818, -0.984756>,
  <0.72551, -0.96944>,
  <0.978911, -0.915646>,
  <1.016215, -0.621123>,
  <1.00703, 0.746937>,
  <0.944215, 1.127735>,
  <0.674981, 1.187409>,
  <0.00703, 1.186734>,
  <-0.761227, 1.195156>,
  <-1.028118, 1.14762>,
  <-1.046123, 0.820852>,
  <-1.064201, -0.677692>,
  <-1.028118, -0.950793>
  rotate <90,0,90>
  scale <0.32, 0.32, 0.28>
  rotate <-180.0, 0.0, -0.0>
  translate  <-0.04, 0.025, 1.391>
}
#declare TaperSweep004 = prism {
  conic_sweep
  cubic_spline
  0.3,1.0
  16  // control points
  <-1.046123, 0.820852>,
  <-1.064201, -0.677692>,
  <-1.028118, -0.950793>,
  <-0.698818, -0.984756>,
  <0.72551, -0.96944>,
  <0.978911, -0.915646>,
  <1.016215, -0.621123>,
  <1.00703, 0.746937>,
  <0.944215, 1.127735>,
  <0.674981, 1.187409>,
  <0.00703, 1.186734>,
  <-0.761227, 1.195156>,
  <-1.028118, 1.14762>,
  <-1.046123, 0.820852>,
  <-1.064201, -0.677692>,
  <-1.028118, -0.950793>
  rotate <90,0,90>
  scale <0.25, 0.24, 1.0>
  rotate <-180.0, 0.0, -0.0>
  translate  <-0.03, 0.027, 2.115>
}
union { // HeadStone2
  object { TaperSweep001 }
  object { TaperSweep002 }
  object { TaperSweep003 }
  object { TaperSweep004 }
  superellipsoid { // SuperQ003
    <0.1, 0.1>
    scale <0.05, 0.03, 0.33>
    translate  <-0.021, 0.027, 2.118>
  }
  superellipsoid { // SuperQ004
    <0.1, 0.1>
    scale <0.05, 0.03, 0.25>
    rotate 90.0*y
    translate  <-0.021, 0.027, 2.225>
  }
  material {
    stonegrave_1
  }
  scale 0.7
  rotate 5.0*z
  translate  <1.786358, -1.473196, 0.804>
}


union { // SimpleCross7
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.04, 0.01, 0.33>
    translate  <2.039, -7.575, 1.309>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.04, 0.01, 0.2>
    rotate <0.0, 90.0, 0.0>
    translate  <2.036, -7.575, 1.436>
  }
  material {
    SimpleCrossPaint
  }
  rotate <-0.203358, 5.528644, -2.109819>
  translate  <-0.726692, 0.096129, 0.085639>
}


sphere { // ChainPoint11
  <0,0,0>,1
  material {
    ChromeLike
  }
  scale 0.01
  translate  <-2.256645, -2.284845, 1.32614>
}


sphere { // ChainPoint12
  <0,0,0>,1
  material {
    ChromeLike
  }
  scale 0.01
  translate  <-2.002564, -2.071682, 1.479964>
}


sphere { // ChainPoint13
  <0,0,0>,1
  material {
    ChromeLike
  }
  scale 0.01
  translate  <-1.965349, -2.04484, 1.32614>
}


