// Persistence Of Vision raytracer version 3.5  - antiq.pov
//============================================
// Inspired from a 30s picture taken by a surrealist artist - July 2003
// Thomas Lieven 2003 
// http://www.webkenya.com  
//--------------------------------------------                         
// Required Head.inc and Buste.inc (mesh head object done using Spatch) - included in the zip
// Thanks to Matkovitch for his Spatch tutorial                                              
// Thanks also to Tor Olav Kristensen, and Slime for their "hollow sphere around a camera" script which can be found at http://news.povray.org/povray.advanced-users/30298/
// Thanks to allthe members of the POV newsgroup for their comments/help and inspiration (http://news.povray.org)
//---------------
//CONFIGURATION
//--------------
// Scene 1 and 2 create two differents images and scene 3 layer the two images to make one
// Required antiq.ini - 3 frames clock - Command line : +w800 +h600 +a0.3 +q10 +j
// The third scene has three different type of camera effect, the one submitted to IRTC is : #declare scene2=1;
// ----------------------------------------------------------
// For the scene 3 - Choose between three effects (1, 2 or 3)
// ----------------------------------------------------------
#declare scene3=1;  //The one submitted to IRTC is effect No 1 
//************************************************************

#version 3.5;

#include "functions.inc"   
#include "finish.inc" 
#include "head.inc"  
#include "buste.inc"    

// ----------
// Texture
// ---------- 
#declare texs_01 =material {texture {pigment {color rgb 1 } finish {diffuse 0.75 ambient 0.45 specular 0.3 reflection { 0, 0.35} conserve_energy crand 0.05 } }  }

//BALL+WALL  
#declare texs_02 =material {texture {pigment {color rgb 1 } finish {diffuse 0.8 ambient 0.3 specular 0.2 reflection { 0, 0.55} conserve_energy crand 0.05 } } }  

//HEAD  
#declare texs_04 =material {texture {pigment {granite  rotate <0, 0, 90> scale 0.22 turbulence .85 frequency 1 
  color_map {[0 color rgb 1.1] [0.05 color rgb 0.21][0.08 color rgb 1] [1.0 color rgb 1] } }
  finish {diffuse 0.7 ambient 0.4 specular 0.15 roughness .005 crand 0.05} } }              

//HAIR
#declare texs_05 =material {texture {pigment {color rgb 1*2.25 } finish {diffuse 0.2 ambient 0.18} } }   

//BUSTE
#declare texs_06 =material {texture {pigment {color rgb 1} finish {diffuse 0.2 ambient 0.48 brilliance 0.25 reflection 0.251 phong 0.2 phong_size 0.2 crand 0.1} } }   
      
#declare texs_06b= material { texture {pigment {gradient y turbulence 0.75 pigment_map {
  [0 crackle  metric 3.5 turbulence 0.095 frequency 0.95 color_map {
  [ 0.0000 color rgb 1*0 ][ 0.00120 color rgb 1*0.5 ][ 0.0680 color rgb 1*1]
  [ 0.7000 color rgb 1*1] [ 1.0000 color rgb 1*1.72] }] 
  [0.75 color rgb 1][0.79 color rgb 1.2][1 color rgb 1.2] } scale 3.5 }
  finish {ambient 0.41 diffuse 0.85 brilliance 0 reflection 0 phong 0 crand 0.15}
  normal {bumps scale <0.005,0.005,0.008>*400 turbulence 1 frequency 0.55}}} 



// ********************
// BEGINNING OF SCENE 1
// ********************  
// All objects should be on  -  Camera_focal should be on
// ------------------------------------------------------
#switch(clock)

#case(1)

// -------
// Objects
// ------- 
#declare Camera_focal=on;
#declare Spotlight=on; 
#declare Front_ball=on;
#declare Front_box=on;
#declare wall=on;  
#declare antiq_head=on;   
#declare Buste=on;   
#declare Pilier=on;
 
// ----------
// Background
// ----------
background { color rgb <0, 0, 0> } 
sky_sphere {pigment {bozo turbulence 0.75 frequency 0.65 color_map {[0 rgb <0.990,0.981,0.98>*0.75] [0.35 rgb 0.25] [1 rgb 1] }scale 20}}

// --------
// SETTINGS
// --------
global_settings {max_trace_level 15}

// ------
// Camera
// ------ 
#if (Camera_focal)
camera {location  <0.0, -0.75, -6.25> look_at <0.0,-0.62,0.0>  
  right x*image_width/image_height
  aperture 0.48  blur_samples 200 focal_point <0,0,-0.85> 
  confidence 0.995 variance 1/1000 }
#else 
 camera {location  <0.0, -0.75, -6.25> look_at <0.0,-0.62,0.0>  
  right x*image_width/image_height} 
#end

//-----
//Light
//-----	
light_source { 0*x  color rgb <1,1,1> spotlight translate <35, 42, -40> point_at <0,0.5,-0.25> radius 0.85 tightness 15 falloff 2.94622 }
    // create small hightlights
light_source { 0*x color rgb <1,1,1>*1 translate <1.50,-0.8,-4.2> fade_distance 0.8 fade_power 3 }
light_source { 0*x color rgb <1,1,1>*1 translate <-3,-10,-4.2> fade_distance .8 fade_power 3 }
  
//-------
//Objects
//-------
//MAKE THE WALL	
#if (wall)
difference {
box {<-10,-10,-0.5>,<10,10,14> material {texs_01 rotate y*0}}                          
sphere {<0,0.5,-0.5>,1.75} material {texs_02} }                                       
#else
#end

//MAKE THE BALL
#if (Front_ball)
sphere {<0,-1.5,-1.5>,  0.88 material {texs_02}}
#else
#end

//MAKE A TABLE UNDER THE BALL
#if (Front_box)
box {<-5,-5,-2.5>,<1.5,-2.33,0.5> material {texs_02} }
#else
#end

//MAKE THE HEAD AND THE HAIR
#if (antiq_head) 
union {difference {
isosurface {function{ 
  sqrt(  0.75*x*x + 1*y*y + 1.5*z*z - 1)- f_noise3d( x*9, y*10, z*2 )  }
  contained_by { box { -2.5, 2.5 }} accuracy 0.002 max_gradient 25.646}
sphere {<0,-1.83,-.75>,2 scale <0.8,1,1>}
  scale <0.75,0.75,1> translate <0,0.65,0> material {texs_05}} 
                                                           
object {Head scale <0.7,0.68,1>*1.25 material {texs_04}}   
scale 0.89 translate <0,0,0.2>}
#else
#end 

//MAKE THE WOMAN BODY
#if(Buste)
object {buste material {texs_06b} scale <0.85,1.12,0.85> rotate <0,115,0> 
translate <-1.49,0.89,-1.86>}  
#else
#end

//MAKE THE COLONNE
//This required my first "ugly" macro colonne1G.inc (december 2001) 
//Included in the zip 
#if (Pilier)     
#include "Colonne1G.inc"  
#include "textures.inc" 
#declare typeColon = 4; #declare nColon = 14; #declare Prof = 56;
#declare CPA = 4; #declare HPA = 2; #declare HCA = HPA*4; 
#declare alp = 0.5; #declare nSOR = 8; #declare xSOR = 2.5;  
#declare Rcol = 1.25; #declare Hcol = 23; #declare THcol = HCA+HPA+23;  // hauteur du haut de la colonne par rapport a y=0
#declare CSOR = 1.40; #declare htWall = 10;  
#declare tWM = texture {pigment {color rgb 1} finish {diffuse 0.75 ambient 0.45 specular 0.2 reflection { 0, 0.25} conserve_energy crand 0.05 }}
#declare tBA = texture {pigment {color rgb 1} finish {diffuse 0.75 ambient 0.45 specular 0.2 reflection { 0, 0.25} conserve_energy crand 0.05 }}
#declare spd1 = 0.5; #declare spd2 = 0.1; #declare pWM = pigment {color rgb 1}  
#declare fWM = finish {diffuse 0.7 ambient 0.45 phong 0.25 phong_size 2} 
#local def = 0.0001;   

object {mColon(typeColon,nColon,Prof,CPA,HPA,HCA,alp,nSOR,xSOR,Rcol,Hcol,CSOR,tWM,tBA) 
scale <0.135,0.125,0.095> translate <-5.39,-3.888,-3.34>} 
 #else
 #end   

// ********************************************
// End of scene 1 - output=antiq-head_final1.png
// ********************************************
#break                                         
       
 
#case(2)

// -------
// Objects
// ------- 
#declare Camera_focal=on;
#declare Spotlight=on; 
#declare Front_ball=on;
#declare Front_box=on;
#declare wall=off;  
#declare antiq_head=off;   
#declare Buste=on;   
#declare Pilier=off;
 
// ----------
// Background
// ----------
background { color rgb <0, 0, 0> } 
sky_sphere {pigment {bozo turbulence 0.75 frequency 0.65 color_map {[0 rgb <0.990,0.981,0.98>*0.75] [0.35 rgb 0.25] [1 rgb 1] }scale 20}}

// --------
// SETTINGS
// --------
global_settings {max_trace_level 15}

// ------
// Camera
// ------ 
#if (Camera_focal)
camera {location  <0.0, -0.75, -6.25> look_at <0.0,-0.62,0.0>  
  right x*image_width/image_height
  aperture 0.48  blur_samples 200 focal_point <0,0,-0.85> 
  confidence 0.995 variance 1/1000 }
#else 
 camera {location  <0.0, -0.75, -6.25> look_at <0.0,-0.62,0.0>  
  right x*image_width/image_height} 
#end

//-----
//Light
//-----	
light_source { 0*x  color rgb <1,1,1> spotlight translate <35, 42, -40> point_at <0,0.5,-0.25> radius 0.85 tightness 15 falloff 2.94622 }
    
//-------
//Objects
//-------
//MAKE THE WALL	
#if (wall)
difference {
box {<-10,-10,-0.5>,<10,10,14> material {texs_01 rotate y*0}}                          
sphere {<0,0.5,-0.5>,1.75} material {texs_02} }                                       
#else 
box {<-10,-10,-0.5>,<10,10,14> material {texs_01 rotate y*0}}    
#end

//MAKE THE BALL
#if (Front_ball)
sphere {<1,-1.5,-1.5>,  0.88 material {texs_02}}
#else
#end

//MAKE A TABLE UNDER THE BALL
#if (Front_box)
box {<-5,-5,-2.5>,<1.5,-2.33,0.5> material {texs_02} }
#else
#end

//MAKE THE HEAD AND THE HAIR
#if (antiq_head) 
union {difference {
isosurface {function{ 
  sqrt(  0.75*x*x + 1*y*y + 1.5*z*z - 1)- f_noise3d( x*9, y*10, z*2 )  }
  contained_by { box { -2.5, 2.5 }} accuracy 0.002 max_gradient 25.646}
sphere {<0,-1.83,-.75>,2 scale <0.8,1,1>}
  scale <0.75,0.75,1> translate <0,0.65,0> material {texs_05}} 
                                                           
object {Head scale <0.7,0.68,1>*1.25 material {texs_04}}   
scale 0.89 translate <0,0,0.2>}
#else
#end 

//MAKE THE WOMAN BODY
#if(Buste)
object {buste material {texs_06b} scale <0.85,1.12,0.85> rotate <0,115,0> 
translate <-1.49,0.89,-1.86>}  
#else
#end

//MAKE THE COLONNE
//This required my first "ugly" macro colonne1G.inc (december 2001) 
//Included in the zip 
#if (Pilier)     
#include "Colonne1G.inc"  
#include "textures.inc" 
#declare typeColon = 4; #declare nColon = 14; #declare Prof = 56;
#declare CPA = 4; #declare HPA = 2; #declare HCA = HPA*4; 
#declare alp = 0.5; #declare nSOR = 8; #declare xSOR = 2.5;  
#declare Rcol = 1.25; #declare Hcol = 23; #declare THcol = HCA+HPA+23;  // hauteur du haut de la colonne par rapport a y=0
#declare CSOR = 1.40; #declare htWall = 10;  
#declare tWM = texture {pigment {color rgb 1} finish {diffuse 0.75 ambient 0.45 specular 0.2 reflection { 0, 0.25} conserve_energy crand 0.05 }}
#declare tBA = texture {pigment {color rgb 1} finish {diffuse 0.75 ambient 0.45 specular 0.2 reflection { 0, 0.25} conserve_energy crand 0.05 }}
#declare spd1 = 0.5; #declare spd2 = 0.1; #declare pWM = pigment {color rgb 1}  
#declare fWM = finish {diffuse 0.7 ambient 0.45 phong 0.25 phong_size 2} 
#local def = 0.0001;   

object {mColon(typeColon,nColon,Prof,CPA,HPA,HCA,alp,nSOR,xSOR,Rcol,Hcol,CSOR,tWM,tBA) 
scale <0.135,0.125,0.095> translate <-5.39,-3.888,-3.34>} 
 #else
 #end   

// ********************************************
// End of scene 2 - output=antiq-head_final2.png
// ********************************************
#break 


// ********************
// BEGINNING OF SCENE 3
// ******************** 
// FOR THE CAMERA SEPIA PICTURE EFFECT
// I like to thanks Tor Olav Kristensen, and Slime        
// Script can be found at http://news.povray.org/povray.advanced-users/30298/
// cos 4th power law of lens light falloff.   
// **************************************************************************    

#case(3) 
#version 3.5; 

#switch(scene3) 
//------------
//First effect
//------------  
#case(1) 

#version 3.5;

light_source {0*x color rgb 1.0 area_light <8, 0, 0> <0, 0, 8> 4, 4 adaptive 0 jitter circular  orient translate <40, 80, -40>}

global_settings {assumed_gamma 1.0  max_trace_level 250}

sky_sphere {pigment {color rgb 1 }}       

camera {orthographic location <0.5,0.499,6> look_at  <0.5,0.499,0> right 1*x  up 1*y 
angle 9.56 }


// ----------------------------------------
#declare p=0.75;

plane {-z,0 pigment {image_map { png "antiq2.png" once 
            filter all 0.3821 transmit all 0.28    } scale <1,1,1>}                                                                                      
            finish {diffuse 0.26 ambient 0.32} rotate y*180 scale <1.3,1.3,1.73>*1 translate <1.1552,-0.28250,-0.95>}  
                                                                                              
plane {-z,3.93 pigment {image_map { png "antiq1.png" once filter all 0.02}    }  
        finish {diffuse 0.812 ambient 0.62} scale 1}     
  
plane {-z,0 texture {pigment {wood turbulence 0.135 scale <0.022,0.022,0.022>*10 color_map {
   [0 color rgbft <0,0,0.1,0.08,0.0> ]
   [0.25 color rgbft <0.951,1.05,0.5,0.5,3.62> ]
   [0.65 color rgbft <0.8,0.51,0.1964,0.96,0.82> ]
   [1 color rgbft <0.8,0.51,0.19,0.66,0.22> ]} frequency 0.21 rotate 90*x translate <-0.10051,-0.20,0>}
   finish{ambient 0.3 diffuse 0.2}}}
  
plane {-z,0 pigment {image_map { png "antiq1.png" once 
      filter all 0.022951  transmit all 0.58  }    }
      finish {diffuse 0.16 ambient 0.29} rotate y*210 scale <1.15,1,1>*2.42 
      translate <1.972,-1.31,-3>}    
 
 
#declare R=<10,0,0>; // orientation
#declare L=<0.5, 0.5, 0>; // location
#declare V=67; 

sphere {0, 1
  texture {pigment {agate turbulence 0.15 scale 1.2 color_map {
   [0 color rgb 0 transmit 1.02 ]
   [pow(cos(radians(V/2)),4) color rgb 0 transmit pow(cos(radians(V/2)),1) ]
   [1 color rgb 0 transmit 2] } frequency -1 rotate 90*x }
   finish{ambient 0 diffuse 0}}
  scale 0.0001 // make small invisible
  rotate R translate L hollow} 

sphere {0, 0.9 
  texture {pigment {agate turbulence 0.15 scale 1.55 color_map {
  [0 color rgbf <0.8,0.5498,0.1964,1.91>]
  [pow(cos(radians(V/2)),4) color rgbf <0.921,0.9,0.51,1.8>] 
  [0.85 color rgbf  <0.6,0.6,0.6,1.81>]
  [1 color rgbf <0.96,0.96,0.96,1>]} frequency 1 rotate 90*x}
  finish{ambient 0 diffuse 1}}  
  rotate R translate L hollow}  
#debug concat("\n cos 4th law: value for ",str(V,0,0)," degrees is
",str(pow(cos(radians(V/2)),4),-1,9),"\n")
 

#break 
//-------------
//Second effect
//-------------
       
#case(2)     

light_source {0*x color rgb 1*0.75  area_light  <8, 0, 0> <0, 0, 8> 
  4, 4 adaptive 0 jitter circular orient  translate <40, 80, -40>}   
  
global_settings {assumed_gamma 1.0 }

sky_sphere {pigment {color rgb 1 }} 
  
camera {location <0.5,0.5,0> look_at  <0.5,0.5,-6> right 1*x up 1*y angle 18.50 }

#declare p=0.75;
plane {-z,-2.93 pigment {image_map { png "antiq1.png" once }}  finish {diffuse 0.6 ambient 1.133} scale 1 translate <0,0,-6>}     

#declare R=<10,0,0>; #declare L=<0.5, 0.5, 0>; #declare V=57; 

sphere {0, 1
  texture {pigment {agate turbulence 0.55 scale 0.91 color_map {
   [0 color rgb 0 transmit 0.52 ]
   [pow(cos(radians(V/2)),4) color rgb 0 transmit pow(cos(radians(V/2)),1.21) ] 
   [0.95 color rgb 0 transmit 3]
   [1 color rgb 0 transmit 3] } frequency -1 rotate 90*x translate <0,-1,0>}
   finish{ambient 0 diffuse 0}}
   scale 0.0001 // make small invisible
   rotate R translate L hollow} 


 sphere {0, 1.2 
  texture {pigment {agate turbulence 0.15 scale 1.05 color_map {
  [0 color rgbf <0.8,0.5498,0.1964,0.91>]
  [pow(cos(radians(V/2)),4) color rgbf <0.921,0.9,0.51,1.15>] 
  [0.85 color rgbf  <0.6,0.6,0.6,1.21>]
  [1 color rgbf <0.96,0.96,0.96,1.05>]} frequency 1 rotate 90*x translate <1,-0.21,0>}
  finish{ambient 0 diffuse 0}}  
  rotate R translate L hollow}  
  
   
#debug concat("\n cos 4th law: value for ",str(V,0,0)," degrees is ",str(pow(cos(radians(V/2)),4),-1,9),"\n")


#break 

//-------------
//Third effect
//-------------
       
#case(3)         

light_source {0*x color rgb 1.0  area_light <8, 0, 0> <0, 0, 8>  4, 4    
              adaptive 0 jitter circular orient translate <40, 80, -40>}

#version 3.5;

global_settings {assumed_gamma 1.0 max_trace_level 250}

sky_sphere {pigment {  color rgb 1 }}

camera {orthographic location <0.5,0.5,6> look_at  <0.5,0.5,0> right 1*x up 1*y angle 9.58 }

#declare p=0.75;

plane {-z,-2.93 
       pigment {image_map { png "antiq1.png" once 
       filter all 0.812 transmit all 0.058}}  finish {diffuse 0.2 ambient 0.133} scale 1}     
  

plane {-z,0 pigment {image_map { png "antiq2.png" once 
       filter all 0.0083 transmit all 1.20051 } } finish {diffuse 0.6 ambient 0.9} rotate y*180 scale <1.3,1.3,1.73>*1.25 
       translate <1,-0.62250,-2>}    

plane {-z,0 texture {pigment {wood turbulence 0.135 scale <0.022,0.022,0.022>*10 color_map {
   [0 color rgbft <0,0,0.1,0.08,0.9> ]
   [0.25 color rgbft <0.951,1.05,0.95,0.5,3.62> ]
   [0.65 color rgbft <0.8,0.51,0.1964,0.96,1.82> ]
   [1 color rgbft <0.8,0.51,0.19,0.96,10.22> ]} frequency -0.21 rotate 90*x translate <-0.10051,-0.20,0>}
   finish{ambient 0.3 diffuse 0.2}}}   
 
 

#declare R=<10,0,0>; // orientation
#declare L=<0.5, 0.5, 0>; // location
#declare V=67; 

sphere {0, 1
  texture {pigment {agate turbulence 0.15 scale 1 color_map {
   [0 color rgb 0 transmit 1.02 ]
   [pow(cos(radians(V/2)),4) color rgb 0 transmit pow(cos(radians(V/2)),1) ]
   [1 color rgb 0 transmit 1] } frequency -1 rotate 90*x }
   finish{ambient 0 diffuse 0}}
  scale 0.0001 // make small invisible
  rotate R translate L hollow} 

sphere {0, 0.9 
  texture {pigment {agate turbulence 0.15 scale 1.05 color_map {
  [0 color rgbf <0.8,0.5498,0.1964,0.91>]
  [pow(cos(radians(V/2)),4) color rgbf <0.921,0.9,0.51,1>] 
  [0.85 color rgbf  <0.6,0.6,0.6,0.81>]
  [1 color rgbf <0.96,0.96,0.96,1>]} frequency 1 rotate 90*x}
  finish{ambient 0 diffuse 0}}  
  rotate R translate L hollow}  
  
  



#debug concat("\n cos 4th law: value for ",str(V,0,0)," degrees is
",str(pow(cos(radians(V/2)),4),-1,9),"\n")
             
#end            #end


// **************
// End of script
// **************




 