// Persistence Of Vision raytracer version 3.5 
// Airship include file
// Ron Gow 2003

#version 3.5;

#macro Blimp(R_Seed)
#local T_Win_Glass = texture {
    pigment { rgbf <.98 , .97, .98, 1> } 
    finish { ambient 0 diffuse 0.15 specular 0.5 roughness 0.001 brilliance 2
        reflection { 0.5, 1.0 fresnel on }
        conserve_energy
    }
}

#local S = 6;
#local E = 3;
#local C = seed(R_Seed);
#local R = 2;
#local P = <.75,.65,.5>;

#local Bag = union {
    #local A = 180/S;
    #local cnt=0;
    #while(cnt<S)
        #local cc = <rand(C),rand(C),rand(C)> ;
        sphere { 0 R scale <.7,1,E> rotate -z*cnt*A pigment { rgb cc } }
        #local cnt=cnt+1;
    #end 
    sphere { 0 R*.25 scale <1,1,.16*E> translate -z*R*E*.960 pigment { rgb P } }
    sphere { 0 R*.25 scale <1,1,.16*E> translate z*R*E*.960 pigment { rgb P } }
}

#local Gondola = union {
    difference {
        superellipsoid { <.3,.3> scale .75 }
        union { 
            #local W = -.65;
            #local cnt = 0;
            #while (cnt<6)
                box { <-.8,0,-.095> <.8,.6,.095> translate z*(W+.21*cnt) }
                #local cnt = cnt+1;
            #end
            box { <-.65,0,-.8> <.65,.6,.8> }
            box { <-.8,0,-.8> <-.67,.6,.6> }
            box { <.67,0,-.8> <.85,.6,.6> }
        }
        pigment { rgb P }
    }
    superellipsoid { <.3,.3> scale .748 texture { T_Win_Glass } }
    scale <.65,.5,1> 
}

#local Rudder = difference {
union {
        #local T = R*.05;
        #local RR = R/6;
        #local O = R/4;
        
        cylinder { <-T*.8,0,0> <T*.8,0,0> R }
        cylinder { <0,0,-R> <0,0,R> T }
        torus { R T rotate z*90 }
        torus { R T rotate z*90 scale <1,.75,1> }
        torus { R T rotate z*90 scale <1,.5,1> }
        torus { R T rotate z*90 scale <1,.25,1> }
    }
    cylinder { <-T,0,0> <T,0,0> R/2 scale <1,1.1,.8> translate -z*R }
    #local cnt = -3.5;
    #while(cnt<4)
        cylinder { <-T,0,0> <T,0,0> RR scale <1,1.1,.8> translate <0,cnt*O,RR> }
        #local cnt = cnt+1;
    #end
    box { <-T*1.1,-R*1.1,.15> <T*1.1,R*1.1,R*1.1> }
    pigment { rgb P }
}

union {        
    object { Bag pigment { rgb .9 } } 
    object { Gondola scale .45*R translate <0,-(R*1.25),0> }
    object { Rudder translate z*R*E*1.25 }
    object { Rudder rotate z*90 translate z*R*E*1.25 }
}

#end // end Blimp