// Persistence Of Vision raytracer version 3.5 
// test file
// Ron Gow

#version 3.5;

#ifndef(Ft)
    #local Ft=1;
    #local In=Ft/12;
#end 

// ****************************************
#local T_Silver = texture {
    pigment { rgb <.900,.925,.975> }
    finish { ambient 0 diffuse .4 phong .4 phong_size 75 reflection { .3 .9 fresnel on } }
}

#local T_RedWax = texture {
    pigment { rgbf <.950,.350,.100,.25> }
    finish { ambient 0 diffuse .75 phong .35 phong_size 20 }
}

#local T_WhiteWax = texture {
    pigment { rgbt <.950,.950,.950,.850> }
    finish { ambient 0 diffuse .6 phong .15 phong_size 10 }
}
// ****************************************
 
#local AC = 1.5*In;
#local CR = .5*In;
#local CH = 8*In;
#local BR = 4*In;
#local BH = .75*In;
#local HT = 10*In;
#local AW = HT*.3;
#local AR = .25*In;
#local AH = HT*.65;

#local elbow = intersection {
    torus { AC AR }
    box { <0,-AR*1.05,-(AC+AR*1.05)> <AC+AR*1.05,AR*1.05,0> }
    rotate -x*90
}

#local arm =  union {
    cylinder { 0 <AW,0,0> AR } 
    cylinder { 0 <0,AC,0> AR translate <AW+AC,AC,0> }
    object { elbow translate <AW,AC,0> }
}

#local Arm = union {
    object { arm }
    object { arm rotate y*180 }
    sphere { 0 AR*2.5 }
}

#local Base = intersection {
    union {
        cylinder { 0 <0,BH/2,0> BR }
        torus { BR BH/2 }
        sphere { 0 BR*.8 scale <1,BH/BR,1> translate y*BH/2 }
    }
    cylinder { 0 <0,BH+1.25,0> BR+BH*.55 }
}

#local Holder = union {
    sphere { 0 AR*2 scale <1,.5,1> }
    sphere { 0 AR*2 scale <1,.5,1> translate y*AR*7 }
    sphere { 0 AR*3 scale <1,1.25,1> translate y*AR*3.5 }
    difference {
        sphere { 0 AR*5 scale <1,.2,1> } 
        sphere { 0 AR*5 scale <1,.2,1> translate y*AR*.25 }
        translate y*AR*8.15
    }
}


#local shaft = union {
    cylinder { 0 <0,HT,0> AR }
    sphere { 0 AR*3 scale <1,.5,1> translate y*BH*1.25 }
    sphere { 0 AR*2 scale <1,.5,1> translate y*BH*2 }
}

#local cstick = merge {
    #local TR = CR*.75;
    cone { 0 CR <0,CH,0> TR }
    sphere { 0 CR }
    sphere { <0,CH,0> TR }
    texture { T_RedWax }
}

#declare Candle =  union {
    object { cstick scale <.970,.990,.970> 
        texture { T_RedWax } 
    }
    object { cstick scale 1 
        interior_texture { T_WhiteWax }
        texture { T_WhiteWax } 
    }
    cylinder { 0 <0,In,0> .07*In 
        pigment { rgb .85 }
        translate y*CH
    }
}

#declare CandleHolder = union {
    object { Base }
    object { shaft }
    object { Arm translate y*AH }
    object { Holder translate <0,HT,0> }
    object { Holder translate <AW+AC,AH+AC*2,0> }
    object { Holder translate <-(AW+AC),AH+AC*2,0> }
    texture { T_Silver }
}

#declare Candles = union {
    #local HH = AR*8;
    object { CandleHolder }
    object { Candle translate <0,HH+HT,0> }
    object { Candle translate <AW+AC,HH+AH+AC*2,0> }
    object { Candle translate <-(AW+AC),HH+AH+AC*2,0> }
}


