// Persistence Of Vision raytracer version 3.5 
// Gazebo include file
// Ron Gow

#version 3.5;

#ifndef(Ft)
    #local Ft=1;
    #local In=Ft/12; 
#end

// ************** Textures *****************
#local P_Concrete = pigment { rgb .85 };

#local T_WhiteWood = texture {
    pigment { rgb <1,.95,.75> }
    normal { wrinkles .005 scale .025 }
    finish { ambient 0 diffuse .75 phong .35 phong_size 30 }
}

#local T_DarkBrass = texture {
    pigment { rgb <.72,.45,.11> }
    finish { ambient 0 phong .5 phong_size 55 diffuse .8 reflection { .1 .7 fresnel on } }
}

#local T_LiteBrass = texture {
    pigment { rgb <.90,.75,.35> }
    finish { ambient 0 phong .45 phong_size 40 diffuse .8 reflection { 0 .5 fresnel on } }
}
// *****************************************

#local GR = 4*Ft;
#local GH = 8*Ft;
#local BR = GR+In;
#local BH = Ft;
#local IH = GH-BH;
#local OS = BR*.3955;

#local tbase = intersection {
    box { <-BR,0,-BR> <BR,BH,BR> scale y*1.05 }
    box { <-BR,0,-BR> <BR,BH,BR> rotate y*45 }
}

#local bb = union {
    #local BS = 3*In;
    #local BW = 2.80*In;
    #local cnt = -OS;
    #while (cnt<OS)
        box { <cnt,0,-BR-In/2> <cnt+BW,BH-.1*In,BR+In/2> }
        #local cnt = cnt+BS;
    #end
}

#local bbase = union {
    object { bb }
    object { bb rotate y*45 }
    object { bb rotate -y*45 }
    object { bb rotate y*90 }
}

#local Base = union {
    object { tbase pigment { P_Concrete } }
    object { bbase scale y*.95}
    object { tbase scale <1.025,.1,1.025> texture { T_LiteBrass } }
    object { tbase scale <1.025,.1,1.025> translate y*(BH-1.25*In) texture { T_LiteBrass } }
}

#local RB = difference {
    union {
        #local cnt=0;
        #local inc=3.75;
        #while (cnt<180)
            object { 
                box {
                    <-GR,-1.5*In,-.5*In> <GR,1.5*In,.5*In>
                    translate -z*GR rotate x*cnt 
                    texture { T_WhiteWood rotate -z*89 }
                }
            }
            #local cnt=cnt+inc;
        #end
        cylinder { <-GR,0,0> <GR,0,0> GR }
    }
    box { <-BR,-GR,-BR> <BR,In,BR> }
}

#local Rbase = intersection {
    object { RB } 
    object { RB rotate y*90 }
    object { RB rotate y*45 }
    object { RB rotate -y*45 }
    bounded_by { box { <-BR,In*.95,-BR> <BR,GR+In*.15,BR> } }
}

#local RT = intersection {
    difference {
        cylinder { <-GR,0,0> <GR,0,0> GR+In*.25 }
        cylinder { <-GR,0,0> <GR,0,0> GR-In }
    }
    difference {
        cylinder { <-GR,0,0> <GR,0,0> GR+In*.25 }
        cylinder { <-GR,0,0> <GR,0,0> GR-In }
        rotate y*90
    }
    box { <-BR,In*.75,-BR> <BR,GR+In*.75,BR> }
}

#local Rtrim = union {
    object { RT } 
    object { RT rotate y*45 }
    scale <.775,.715,.775>
    rotate y*45/2
    texture { T_DarkBrass } 
}

#local Roof = difference {
    union {
        object { tbase scale <1.025,.25,1.025> texture { T_LiteBrass } }
        object { Rtrim translate y*BH*.20 }
        object { Rbase scale <1,.7,1> translate y*BH*.20 }
    }
    object { Rbase scale <.96,.725,.96> translate -y*In }
}

#local Rail = union {
    #local RL = GR*2/3;
    #local cnt = -5;
    #while (cnt<6)
        #local PP = cnt*RL/11;
        cylinder { <PP,0,-GR> <PP,2,-GR> In/3 texture { T_LiteBrass } } 
        #local cnt = cnt+1;
    #end
    box { 
        <-OS,0,-.5*In>  <OS,In,.5*In> 
        translate <0,0,-GR> 
    }
    box { 
        <-OS,0,-.5*In>  <OS,In,.5*In> 
        translate <0,2,-GR> 
    }
    texture { T_DarkBrass }
}

#local Srail = union {
    #local SL = GR/2;
    #local cnt = 2;
    #while (cnt<7)
        #local PP = cnt*RL/11;
        cylinder { <0,0,PP> <0,2+0,PP> In/3 texture { T_LiteBrass } } 
        #local cnt = cnt+1;
    #end
    box { 
        <-.5*In,0,0>  <.5*In,In,SL> 
        translate <0,0,0> 
    }
    box { 
        <-.5*In,0,0>  <.5*In,In,SL> 
        translate <0,2,0> 
    }
    cylinder { <0,-3*In,0> <0,2.2*Ft,0> In/2 }
    matrix 
     < 0, 0, 0,
       0, 1, 0,
       0, .25, 0,
       0, 0, 0 >
    translate y*9*In
    texture { T_DarkBrass }   
}
    
#local Steps = union {
    #local SH = BH-In;
    #local SS = OS+In; 
    box { <-OS,0,0> <OS,BH/2,SL> }
    box { <-OS,BH/2,SL/2> <OS,BH,SL> }
    box { <-SS,SH/2,-.5*In> <SS,BH/2,SL/2> pigment { P_Concrete } }
    box { <-SS,SH,SL/2.1> <SS,BH,SL> pigment { P_Concrete } }
    object { Srail translate -x*OS }
    object { Srail translate x*OS }
}


#local North = text {
    ttf  "SYMBOL.ttf", "h", .1, 0 
}

#local South = text {
    ttf  "SYMBOL.ttf", "?", .1, 0 
} 

#local East = text {
    ttf  "SYMBOL.ttf", "p", .1, 0  
}
    
#local West = text {
    ttf  "WINGDING.ttf", "e", .1, 0 
} 

#local VH = 2.75*Ft;
#local AL = Ft;
#local AR = .25*In;
#local AI = VH*.75;
#local VW = AL/3;
#local CW = VW*.85;
#local NS_Bar = union {
    cylinder { <-AL,0,0> <AL,0,0> AR }
    object { North scale <1,1,1> translate <1.05,-.17,0> }
    object { South translate <-1.5,-.375,0> }
}

#local EW_Bar = union {
    cylinder { <-AL,0,0> <AL,0,0> AR }
    object { East scale <1.25,1.4,1> translate <1.10,-.3,0> }
    object { West scale <.9,.8,1> translate <-1.67,-.275,0> }
}

#local Bars = union {
    object { NS_Bar }
    object { EW_Bar rotate y*90 }
}

#local vb = difference {
    box { <-VW,0,-VW> <VW,VW*1.2,VW> }
    cylinder { <-VW,VW,-VW> <VW,VW,-VW> CW }
    cylinder { <-VW,VW,VW> <VW,VW,VW> CW }
    cylinder { <-VW,VW,-VW> <-VW,VW,VW> CW }
    cylinder { <VW,VW,-VW> <VW,VW,VW> CW }
}

#local V_Base = intersection {
    object { vb }
    object { vb rotate y*45 }
}

#declare Vane = union {
    object { V_Base scale <2,3,2>}
    union {
        object { Bars translate y*AI }
        sphere { 0 .9*In translate y*AI }
        sphere { 0 .9*In translate y*VH }
        sphere { 0 1.75*In scale <1,.35,1> translate y*VH*.255 }
        cylinder { 0 <0,VH,0> AR*1.25 }
        rotate -y*30
        translate y*VW*1.5
    }
    texture { T_DarkBrass }
}


#declare Gazebo = union {
    #local cnt=1;
    #while (cnt<8)
        object { Rail translate y*(BH+3*In) rotate y*cnt*45 }
        cylinder { <RL/OS,0,-GR> <RL/OS,8,-GR> In*1.5 
            rotate y*cnt*45 
            texture { T_LiteBrass } 
        }
        #local cnt=cnt+1;
        cylinder { <RL/OS,0,-GR> <RL/OS,8,-GR> In*1.5 
            rotate y*cnt*45 
            texture { T_LiteBrass } 
        }
    #end
    object { Vane scale .9 translate y*(GH+GR*.75) }
    object { Roof translate y*GH }
    object { Base }
    object { Steps translate -z*(GR+SL) }
    texture { T_WhiteWood }  
}

