// Persistence Of Vision raytracer version 3.5 
// Tableware include file
// Ron Gow 2003

#version 3.5;

#ifndef(Ft)
    #local Ft=1;
    #local In=Ft/12;
#end

//  *************************************

#local T_Ceramic = texture {
    pigment { rgb <.9,.85,.65> }
    finish { ambient 0 diffuse .6 phong .35 phong_size 50 reflection { 0 .35 fresnel on } }
}

#local T_Silverware = texture {
    pigment { rgb <.85,.90,.95> }
    finish { ambient 0 diffuse .5 phong .4 phong_size 85 reflection .65 }
}

#local S_Shape = sphere_sweep {
    cubic_spline 6
    <-.25,0,0> .01, <0,0,0> .25, <.375,.095,0> .065, 
    <.65,.155,0> .085, <1.15,.125,0> .1, <1.25,.095,0> .05
    scale <1,.25,1>
}

#local F_Shape = difference {
    object { S_Shape }
    cylinder { <0,0,-.26> <0,0,.26> .3 scale <1.35,.25,1> rotate z*1.85 translate <0,.05,0> }
}

#local F_Cut = cylinder { <0,-.075,0> <0,.015,0> .225 scale <2.50,1,.19> }

#declare Plate = lathe {
    cubic_spline 9
    <-In,.015> <0,.008> <3.5*In,0> <4.5*In,.25*In> <5.5*In,.45*In>
    <4.75*In,.40*In> <2.5*In,.1*In>  <0,.09*In> <-2.5*In,.1*In>
    texture { T_Ceramic }
}

#declare Spoon = difference {
    object { S_Shape }
    object { S_Shape rotate z*1.85 translate y*.02 }
    scale <.5,.5,.4> 
    rotate -z*3 
    translate y*.025
    texture { T_Silverware }
}

#declare Fork = difference {
    object { F_Shape }
    object { F_Cut translate <-.280,0,0>}
    object { F_Cut translate <-.325,0,.125>}
    object { F_Cut translate <-.325,0,-.125>}
    scale <.5,.5,.35> 
    rotate -z*3 
    translate y*.025
    texture { T_Silverware }
}

#declare Setting = union {
    object { Plate }
    object { Spoon translate <-3.5*In,0,7*In> }
    object { Fork translate <-3.5*In,0,-7*In> }
}