// Chain.inc
/////////////////////////////////////////
// Defines some basic numbers for a chain
// Units in mm (deal with it)

#include "Shapes.inc"
#include "colors.inc"

#declare Chain_Size_428a = 4281;
#declare Chain_Size_520a = 5201;
#declare Chain_Size_525a = 5251;
#declare Chain_Size_530a = 5301;
#declare Chain_Size_520s = 5202;
#declare Chain_Size_525s = 5252;
#declare Chain_Size_530s = 5302;
#declare Chain_Size_630o = 6303;


#declare Chain_Size = Chain_Size_530s;

// P = Pitch (Pin to Pin - center to center)
// R = Roller diameter 
// W = Inner Link Inner Width
// D = Pin Diameter
// T1 = Pin Link Plate Thickness
// T2 = Inner Link Plate Thickness
// L = pin Length
// kgf = Avg. Tensile Strength  (not used)
// kgm = Weight (kg/m)

#switch(Chain_Size)
#case(Chain_Size_428a)
    #declare P = 12.70;
    #declare R = 8.50;
    #declare W = 7.94;
    #declare D = 4.44;
    #declare T1 = 1.80;
    #declare T2 = 1.80;
    #declare L = 20.10;
    #declare kgf = 2400;
    #declare kgm = 0.83;
#case(Chain_Size_520a)
    #declare P = 15.875;
    #declare R = 10.22;
    #declare W = 6.35;
    #declare D = 5.23;
    #declare T1 = 2.00;
    #declare T2 = 2.00;
    #declare L = 21.25;
    #declare kgf = 3600;
    #declare kgm = 0.98;
#case(Chain_Size_525a)
    #declare P = 15.875;
    #declare R = 10.22;
    #declare W = 7.94;
    #declare D = 5.23;
    #declare T1 = 2.20;
    #declare T2 = 2.20;
    #declare L = 22.55;
    #declare kgf = 3600;
    #declare kgm = 1.11;
#case(Chain_Size_530a)
    #declare P = 15.875;
    #declare R = 10.22;
    #declare W = 9.53;
    #declare D = 5.23;
    #declare T1 = 2.40;
    #declare T2 = 2.40;
    #declare L = 24.90;
    #declare kgf = 4300;
    #declare kgm = 1.30;
#case(Chain_Size_520s)
    #declare P = 15.875;
    #declare R = 10.22;
    #declare W = 6.35;
    #declare D = 5.40;
    #declare T1 = 2.40;
    #declare T2 = 2.40;
    #declare L = 21.95;
    #declare kgf = 4000;
    #declare kgm = 1.31;
#case(Chain_Size_525s)
    #declare P = 15.875;
    #declare R = 10.22;
    #declare W = 7.94;
    #declare D = 5.40;
    #declare T1 = 2.40;
    #declare T2 = 2.40;
    #declare L = 23.25;
    #declare kgf = 4300;
    #declare kgm = 1.36;
#case(Chain_Size_530s)		////////
    #declare P = 15.875;
    #declare R = 10.22;
    #declare W = 9.53;
    #declare D = 5.40;
    #declare T1 = 2.40;
    #declare T2 = 2.40;
    #declare L = 24.80;
    #declare kgf = 4600;
    #declare kgm = 1.44;
#case(Chain_Size_630o)
    #declare P = 19.05;
    #declare R = 11.91;
    #declare W = 9.53;
    #declare D = 5.96;
    #declare T1 = 2.40;
    #declare T2 = 2.40;
    #declare L = 26.30;
    #declare kgf = 4550;
    #declare kgm = 1.50;
#end

#declare Number_Links = 110;

#declare Pin = 
intersection {
    plane { y, L/2 }    
    object { Cylinder_Y scale <R/2,1,R/2> }
    plane { -y, L/2 }
}

#declare Pin = 
cylinder { <0,0,0> <0,1,0> 1 
         scale <D/2, L, D/2> 
         translate <0, -(L/2), 0>
}

#declare LD = D*1.35;

#declare LinkShape =
union {
    cylinder { <0,-0.5,0> <0,0.5,0> 1
             scale <LD, 1, LD>	// Scale it to Fit the shape
    }
    intersection {
        box { -1, 1
            scale <1, 0.5, 1>
            scale <D*1.4, 1, D*1.2>
            translate (P/2)*x
        }
        cylinder { <0, -1, 0> <0, 1, 0> 1
            scale <LD, 1, LD>
            translate <(P/2),0,-LD*1.55>
            inverse
        }
	cylinder { <0, -1, 0> <0, 1, 0> 1
	    scale <LD, 1, LD>
	    translate <(P/2),0,LD*1.55>
	    inverse
	}
    }
    cylinder { <0,-0.5,0> <0,0.5,0> 1
             scale <LD, 1, LD>
             translate P*x
    }
}


#declare InnerLink =
union {
    object { LinkShape 
           scale <1, T2, 1>
    }
//    pigment { color Red }
}

#declare OutterLink =
union {
    object { LinkShape 
	   scale <1, T1, 1>         
           translate <-P,0,0>
    }
}

#declare Roller =
cylinder { <0,0,0> <0,1,0> 1 
         scale <R/2, W, R/2> 
         translate <0, -(W/2), 0> 
}

#declare ORing =
torus { (R/2)-(T2/2), T2/2
      pigment { color Black }
}

#declare PinRoller =
union {
      object { Pin }
      object { Roller }
      object { ORing translate <0,(W/2)+T2+0.5,0> }
      object { ORing translate <0,-((W/2)+T2+0.5),0> }  
}

#declare InnerLinks =
union {
      object { InnerLink translate <0,(W/2)+0.5,0> }
      object { InnerLink translate <0,-((W/2)+0.5), 0> }
}

#declare OutterLinks =
union {
      object { OutterLink translate <0,(W/2)+(T2*2)+0.5, 0> }
      object { OutterLink translate <0,-((W/2)+(T2*2)+0.5), 0> }
}

#declare Link =
union {
    object { PinRoller }
    object { PinRoller translate P*x }    
    
    object { InnerLinks }
    object { OutterLinks 
    //       rotate -y*45
    }
}

#declare Chain = 
union {
/*    
    object { Link translate -(14*P)*x }
    object { Link translate -(12*P)*x }
    object { Link translate -(10*P)*x }
    object { Link translate -(8*P)*x }
    object { Link translate -(6*P)*x }
    object { Link translate -(4*P)*x }
    object { Link translate -(2*P)*x }  
*/    
    object { Link }
    object { Link translate (2*P)*x }
    object { Link translate (4*P)*x }
    object { Link translate (6*P)*x }
    object { Link translate (8*P)*x }
    object { Link translate (10*P)*x }
    object { Link translate (12*P)*x }
    object { Link translate (14*P)*x }
}


#macro CurveChain (T, Cp)		// curve a chain around an imaginary sproket
// P - Chain pitch
// T - number of teeth in the sproket.
// Cp - Coverage percentage
#local Rot=0;
#local Links=1;
#local C = P * T;
#declare Sr = C / (pi*2);
#local theta = 360/T;
#debug "\nCurve Chain Macro\n"
#debug concat("Sr=",str(Sr,1,1),"mm\n")
#debug concat("theta=", str(theta,1,1),"mm\n")
#debug concat("C=", str(C,1,1),"mm\n")
#debug concat("P=", str(P,1,1),"mm\n")
#debug concat("P/Sr=", str(P/Sr,1,-1),"\n")
//#debug concat("Sw=", str(Sw,1,1),"mm\n")

    union {
        #while (Rot < 360*Cp)
            //#debug str(Rot,1,1)
            object { PinRoller 
                     translate -Sr*z
                     rotate Rot*y
            }
            //#local Links = 0;
            #if (Links)
            object { InnerLinks
                     rotate (theta*(P/Sr))*-y
                     translate -Sr*z
                     rotate Rot*y
            }
            object { OutterLinks
                     rotate (theta*(P/Sr))*y
                     translate -Sr*z
                     rotate Rot*y
            }                     
            #local Links = 0;
            #else
            #local Links = 1; 
            #end // if
            #local Rot = Rot + theta;
            //#debug " \n"
        #end // while (Rot < 360*Cp)
        object { PinRoller
                 translate -Sr*z
                 rotate -theta*y
        }
        rotate (clock*(P/12))*(360/C)*y*-1    
    } // union

#end // macro CurveChain


