// Gears.inc
/////////////////////////////////////////
// A macro to make a gear
// V1 is the final translation

#declare BrushedAlum = pigment { color < 0.9, 0.9, 0.9> }
//#declare PI = 3.1415927;
/*
#macro Gear(V1,Sprockets) 
#local Rot=0;
#local r2 = pi/Sprockets;               // PI * R1 / Sprockets
#local theta = 360/Sprockets;  
        difference {
                cylinder {-0.025*x, 0.025*x, 1 }
                #while (Rot<360)
                        cylinder {-0.03*x, 0.03*x, r2
                                translate -y
                                rotate Rot*x
                        }
                        #local Rot = Rot + theta;
                #end // While
        }
#end // Macro

*/

#macro Sproket(P, R, W, T)
// P = chain pitch
// R = Roller Diameter
// W = Width of inner area of chain
// T = Teeth of the Sprocket
#local Rot=0;
#local C = P * T;
//C = 2*pi*r
//r = C / pi *2
#declare Sr = C / (pi*2);
#local theta = 360/T;
#local Sw = W*1.25;
      
#debug "Sproket Macro\n"
#debug concat("Sr=",str(Sr,1,1),"mm\n")
#debug concat("theta=", str(theta,1,1),"mm\n")
#debug concat("C=", str(C,1,1),"mm\n")
#debug concat("Sw=", str(Sw,1,1),"mm\n")

#declare bevelCutObject = cylinder { <0,-1,0>, <0,1,0>, 1
                                     scale <Sw*0.30, Sw, Sw>	// X makes it a deep bevel
                                     rotate z*90
                                   }
#declare bevelCutCSG = union {
                           object { bevelCutObject translate <0, Sw/2, -Sr> }
                           object { bevelCutObject translate <0, -Sw/2, -Sr> }
		       }    	

    intersection {
    //union {
        cylinder { <0,-0.5,0>, <0,0.5,0>, 1 
            scale <Sr, Sw, Sr>
        }
        #while (Rot<360)
            cylinder { <0,-1,0>, <0,1,0>, 1	// Create divits
                scale <R/1.5, W, R/1.5>
                translate -z*(Sr)
                rotate Rot*y
                inverse
            }
            object { bevelCutCSG 
                rotate Rot*y
                inverse
            }
            object { bevelCutCSG 
                rotate (Rot+(theta/2))*y
                inverse
            }
            #local Rot = Rot + theta;
            
        #end // While (Rot<360)
    }
    rotate (clock*(P/12))*(360/C)*y*-1
#end // Macro Sproket