/* This file contains macros created by Toby Anderson

Track
Ribbon
Chip
Scatter2D

*/

#include "shapes.inc"
#include "arrays.inc"

#ifdef(View_POV_Include_Stack)
    #debug "including my_macros.inc\n"
#end

#macro Track (points, tWidth, vup)
    #local nup = vnormalize(vup);
    #local i = 0;
    mesh {
    #while (i < dimension_size(points, 1)-1 )
        #if (i=0)
            #local current = vnormalize(points[1] - points[0]);
        #else
            #local current = next;
        #end
        #local i = i+1;
        #if (i = dimension_size(points, 1)-1)
            #local next = vnormalize(points[i] - points[i-1]);
        #else
            #local temp1 = vnormalize(points[i] - points[i-1]);
            #local temp2 = vnormalize(points[i+1] - points[i]);
            #local next = vnormalize(temp1 + temp2);
        #end
        #local currentP = vnormalize(vcross(current, nup))*tWidth/2;
        #local nextP = vnormalize(vcross(next, nup))*tWidth/2;
        #local A = points[i-1]+currentP;
        #local B = points[i-1]-currentP;
        #local C = points[i]-nextP;
        #local D = points[i]+nextP;
        triangle {A B C}
        triangle {A D C}
    #end
    }
#end

// Ribbon needs more work
// should use a slpine rather than an array
#macro Ribbon (points, rWidth, startN, finishN)
    #local startN = vnormalize(startN);
    #local finishN = vnormalize(finishN);
    #local i = 0;
    mesh {
    #while (i < dimension_size(points, 1)-1 )
        #if (i=0)
            #local currentP = vnormalize(vcross(points[1]-points[0], startN))*rWidth/2;
            #local currentNormal = startN;
        #else
            #local currentP = nextP;
            #local currentNormal = nextNormal;
        #end
        #local i = i+1;
        #if (i = dimension_size(points, 1)-1)
            #local nextNormal = finishN;
            #local nextP = vnormalize(vcross(points[i]-points[i-1], nextNormal))*rWidth/2;
        #else
            #local temp1 = vnormalize(points[i-1] - points[i]);
            #local temp2 = vnormalize(points[i+1] - points[i]);
            #local nextNormal = vnormalize(temp1 + temp2);
            #local nextP = vnormalize(vcross(temp2, nextNormal))*rWidth/2;
            #if (vdot(nextNormal, currentNormal) < 0)
                #local nextNormal = nextNormal*-1;
                #local nextP = nextP*-1;
            #end
            #local nextNormal = vnormalize(nextNormal + 3*currentNormal);
        #end
        #local A = points[i-1] + currentP;
        #local B = points[i-1] - currentP;
        #local C = points[i] - nextP;
        #local D = points[i] + nextP;
        smooth_triangle {A currentNormal B currentNormal C nextNormal}
        smooth_triangle {A currentNormal D nextNormal C nextNormal}
    #end
    }
#end

#declare bit =
mesh {
    smooth_triangle {
        <0,0,0>, y,
        <0,0,1>, y,
        <0.6,0,0>, <-0.4,1,0>
    }
    smooth_triangle {
        <0,0,1>, y,
        <0.6,0,0>, <-0.4,1,0>,
        <0.6,0,1>, <-0.3,1,0>
    }
    smooth_triangle {
        <0.6,0,0>, <-0.4,1,0>,
        <0.6,0,1>, <-0.4,1,0>,
        <1,0.1,0>, <-1,1,0>
    }
    smooth_triangle {
        <0.6,0,1>, <-0.4,1,0>,
        <1,0.1,0>, <-1,1,0>,
        <1,0.1,1>, <-1,1,0>
    }
}
#declare pin =
union {
    object {
        bit
    }
    object {
        bit
        rotate <180, 0, -90>
        translate <1.1,1.1,1>
    }
    object {
        bit
        rotate <0, 180, -90>
        translate <1.1,1.1,1>
    }
    object {
        bit
        rotate <0, 0, 180>
        translate <2.2,2.2,0>
    }
    scale <0.45, 0.47, 0.55>
}
#macro Chip(bodyTex, pinTex)
union {
    difference {    
        box {
            <-1.8,0,-3.2> <1.8,1,3.2>
        }
        sphere {
            <0,1,-3.3> 0.5
        }
        texture {bodyTex}
    }
    object {
        pin
        translate <-2.4,0,-2.8>
    }
    object {
        pin
        translate <-2.4,0,-1.12>
    }
    object {
        pin
        translate <-2.4,0,0.56>
    }
    object {
        pin
        translate <-2.4,0,2.25>
    }
    object {
        pin
        rotate y*180
        translate <2.4,0,2.8>
    }
    object {
        pin
        rotate y*180
        translate <2.4,0,1.12>
    }
    object {
        pin
        rotate y*180
        translate <2.4,0,-0.56>
    }
    object {
        pin
        rotate y*180
        translate <2.4,0,-2.25>
    }
    texture {pinTex}
}
#end

#macro Scatter2D (obj, minArea, maxArea, maxAmount, margin, rs)
    // first ensure min is min and max is max
    #local temp = minArea;
    #local minArea = <min(minArea.u,maxArea.u),min(minArea.v,maxArea.v)>;
    #local maxArea = <max(temp.u,maxArea.u),max(temp.v,maxArea.v)>;
    #local areaRange = <maxArea.u-minArea.u,maxArea.v-minArea.v>;
    // get the extents of the object
    #local minObj = <0,0,0>;
    #local maxObj = <0,0,0>;
    Extents (obj, minObj, maxObj)
    // if we can't find a space for the object after this many tries give up
    #local cutOff = 30;
    // array of all the already placed objects
    // first item in array is a dummy because I'm not allowed an array of length 0
    #local placed = array[1] {box {0 0}}
    // setup loop
    union {
    #local i = 0;
    #while (i < maxAmount)
        // #debug concat("i is: ",str(i,3,0),"\n")
        #local tobj = object {
            obj
            // go to origin
            translate <(minObj.x+maxObj.x)/-2,0,(minObj.z+maxObj.z)/-2>
            // slightly change the size
            scale 0.85+rand(rs)*0.3
            // random rotation on y axis
            rotate y*rand(rs)*360
        }// object
        // having transformed the object reasses the extents
        Extents (tobj, minObj, maxObj)
        #local objRange = <maxObj.x-minObj.x,maxObj.y-minObj.y,maxObj.z-minObj.z>;
        #local j = 0;
        #while (j < cutOff)
            // #debug concat("j is: ",str(j,3,0),"\n")
            // create a random position
            #local xPos = rand(rs)*(areaRange.u-objRange.x)+minArea.u;
            #local zPos = rand(rs)*(areaRange.v-objRange.z)+minArea.v;
            // does the object have a valid position?
            #local valid = true;
            // check position against already placed objects
            #local minA = <0,0,0>;
            #local maxA = <0,0,0>;
            #local k = 1;
            #while (k < dimension_size(placed,1) & valid)
                // #debug concat("k is: ",str(k,0,0),"\n")
                Extents (placed[k], minA, maxA)
                #if (xPos+objRange.x > minA.x-margin & xPos < maxA.x+margin)
                    #if (zPos+objRange.z > minA.z-margin & zPos < maxA.z+margin)
                        #local valid = false;
                    #end // if statement
                #end // if statement
                #local k = k+1;
            #end // while loop
            #if (valid)
                #local j = cutOff; // break
            #end // if statement
            #local j = j+1;
        #end // while loop
        #if (valid)
            // put the object in the assigned position
            object {
                tobj
                translate <xPos+objRange.u/2,0,zPos+objRange.v/2>
            }// object
            // put object extents into array as a box
            Resize_Array (placed, dimension_size(placed,1)+1)
            #local placed[dimension_size(placed,1)-1] = 
            box {<xPos,0,zPos> <xPos+objRange.u,0,zPos+objRange.v>}
        #end // if statement
        #local i = i+1;
    #end // while loop
    }// end union
#end // Scatter2D macro