import java.util.*;

public class KiteDart implements Comparable {
  public long[] abump=new long[10];
  public long[] vstrc=new long[2];
  public int vrot;
  public int type;
  public final static int KITE = 0;
  public final static int DART = 1;

  public KiteDart(String s) {
    StringTokenizer st = new StringTokenizer(s,",");
    type = Integer.parseInt(st.nextToken());
    for (int i=0; i<10; i++) {
      abump[i] = Long.parseLong(st.nextToken());
    }
    for (int i=0; i<2; i++) {
      vstrc[i] = Long.parseLong(st.nextToken());
    }
    vrot = Integer.parseInt(st.nextToken());
  }

  public String toString() {
    String rtn = type+",";
    for (int i=0; i<10; i++) {
      rtn += abump[i]+",";
    }
    for (int i=0; i<2; i++) {
      rtn += vstrc[i]+",";
    }
    rtn += vrot;
    return rtn;
  }

  public KiteDart() {
    this(KITE);
  }

  public KiteDart(KiteDart kd) {
    this.type = kd.type;
    for (int i=0; i<10; i++) {
      this.abump[i] = kd.abump[i];
    }
    for (int i=0; i<2; i++) {
      this.vstrc[i] = kd.vstrc[i];
    }
    this.vrot = kd.vrot;
  }

  private void rot() {
    rot(1);
  }

  private void rot(int i) {
    vrot = (vrot + i)%10;
    if (vrot < 0) vrot = vrot + 10;
    if (vrot >= 5) {
      vrot = vrot - 5;
      vstrc[0] = -vstrc[0];
      vstrc[1] = -vstrc[1];
    }
  }

  private void stretch() {
    long tmp = vstrc[0]+vstrc[1];
    vstrc[0] = vstrc[1];
    vstrc[1] = tmp;
  }

  private void shrink() {
    long tmp = vstrc[1]-vstrc[0];
    vstrc[1] = vstrc[0];
    vstrc[0] = tmp;
  }

  private void moveFwd() {
    abump[2*vrot] += vstrc[0];
    abump[2*vrot+1] += vstrc[1];
  }

  private void moveBwd() {
    abump[2*vrot] -= vstrc[0];
    abump[2*vrot+1] -= vstrc[1];
  }

  private void changeType() {
    changeType(1-type);
  }

  private void changeType(int t) {
    this.type = t;
  }
    

  public KiteDart(int t) {
    type = t;
    for (int i=0; i<10; i++) {
      abump[i] = 0;
    }
    vstrc[0] = 1;
    vstrc[1] = 0;
    vrot = 0;
  }  

  public Collection nextLevel() {
System.out.println("**"+type);
    if (type == KITE) {
      return nextKiteLevel();
    } else if (type == DART) {
      return nextDartLevel();
    } else return null;
  }

  private Collection nextKiteLevel() {
    Set s = new HashSet();
    KiteDart kd;
    kd = new KiteDart(this);
    kd.rot(1);
    kd.moveFwd();
    kd.rot(-4);
    kd.shrink();
    s.add(kd);
    kd = new KiteDart(this);
    kd.rot(-1);
    kd.moveFwd();
    kd.rot(4);
    s.add(kd);
    kd.shrink();
    kd = new KiteDart(this);
    kd.changeType();
    kd.rot(1);
    kd.shrink();
    kd.shrink();
    s.add(kd);
    kd = new KiteDart(this);
    kd.changeType();
    kd.rot(-1);
    kd.shrink();
    kd.shrink();
    s.add(kd);
    return s;
  }

  private Collection nextDartLevel() {
    Set s = new HashSet();
    KiteDart kd = new KiteDart(this);
    kd.rot(4);
    kd.stretch();
    kd.moveBwd();
    kd.shrink();
    kd.shrink();
    s.add(kd);
    kd = new KiteDart(this);
    kd.rot(-4);
    kd.stretch();
    kd.moveBwd();
    kd.shrink();
    kd.shrink();
    s.add(kd);
    kd = new KiteDart(this);
    kd.changeType();
    s.add(kd);
    return s;
  }

  public int compareTo(Object o) {
    KiteDart kd = (KiteDart)(o);
    if (this.type != kd.type) return this.type - kd.type;
    for (int i=0; i<10; i++) {
      if (this.abump[i] != kd.abump[i]) return (int)(this.abump[i]-kd.abump[i]);
    }
    for (int i=0; i<2; i++) {
      if (this.vstrc[i] != kd.vstrc[i]) return (int)(this.vstrc[i]-kd.vstrc[i]);
    }
    if (this.vrot != kd.vrot) return (int)(this.vrot - kd.vrot);
    return 0;
  }

  public boolean equals(Object o) {
    return this.compareTo(o)==0;
  }

}


