import java.io.*;

public class PovWriter {
  PrintWriter pw;

  public PovWriter(Writer w) {
    pw = new PrintWriter(w);
  }

  public void close() throws IOException {
    pw.close();
    pw = null;
  }

  public void print(KiteDart kd) throws IOException {
    double bxx = 0.0;
    double bxy = 0.0;
    double byx = 0.0;
    double byy = 0.0;
    double phi = (Math.sqrt(5)+1)/2;
    for (int i=0; i<5; i++) {
      bxx += Math.cos(i*Math.PI/5)*(kd.abump[2*i]+kd.abump[2*i+1]*phi);
      bxy += Math.sin(i*Math.PI/5)*(kd.abump[2*i]+kd.abump[2*i+1]*phi);
    }
    byy = bxx;
    byx = -bxy;
    pw.println("#declare ax = aax + ("+bxx+")*vvx + ("+bxy+")*vvy;");
    pw.println("#declare ay = aay + ("+byx+")*vvx + ("+byy+")*vvy;");
    bxx = 0;
    bxy = 0;
    byx = 0;
    byy = 0;
    int i = kd.vrot;
    bxx += Math.cos(i*Math.PI/5)*(kd.vstrc[0]+kd.vstrc[1]*phi);
    bxy += Math.sin(i*Math.PI/5)*(kd.vstrc[0]+kd.vstrc[1]*phi);
    byy = bxx;
    byx = -bxy;
    pw.println("#declare vx = ("+bxx+")*vvx + ("+bxy+")*vvy;");
    pw.println("#declare vy = ("+byx+")*vvx + ("+byy+")*vvy;");
    if (kd.type == KiteDart.KITE) {
      pw.println("#include \"kite.inc\"");
    } else if (kd.type == KiteDart.DART) {
      pw.println("#include \"dart.inc\"");
    }
    pw.println();
  }
}    
