// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//  +ft +KI0 +KF1.1 +KFI0 +KFF275

#version 3.5;

#include "colors.inc"
#include "textures.inc"
    
    
#declare rad=on    ;

// radiosity (global illumination) settings
global_settings {
#if (rad)
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 35                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 2                 // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    //normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }  
#end
}


global_settings {
  assumed_gamma 1.0   
  max_trace_level 20
}

// ----------------------------------------

#declare click = 1-clock  ;

#default {
  finish {
    specular 0.5       // amount [0.0]
    roughness 0.001     // (~1.0..0.0005) (dull->highly polished) [0.05]  
    reflection 0.2 
    ambient 0
  } // finish
}


camera {
  location <-8,4,8>
  angle 18
  look_at   <0.0, 0.0,  -0.5>   
  sky z
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.7,1.0,0.6>/2]
      [0.7 rgb <0.1,0.8,0.0>/2]
    }
    turbulence 0.3
  }
}


//plane { z,-0.01 pigment {color rgb <1,2,3>/3}
//    finish {reflection 0.2}
//    }

/*light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <30, 30, 30>
}
*/
// ----------------------------------------


/*#declare vvx = 6*cos(clock*15)-8*sin(clock*15);
#declare vvy = 6*sin(clock*15)+8*cos(clock*15);
#declare aax = -vvx/2-4+8*clock;
#declare aay = -vvy/2-3+6*clock;
*/

#declare aax = -4;
#declare aay = 0;
#declare vvx = 8;
#declare vvy = 0;
#include "trans.inc"
#include "kitedef.inc"
#include "dartdef.inc"

//#include "K.inc"

#declare depth = 2;
//#include "K.inc"
#include "kd7.inc"

//cylinder { 0,x*1.5,0.01 pigment{color Red}}
//cylinder { 0,y*1.5,0.01 pigment{color Green}}
//cylinder { 0,z*1.5,0.01 pigment{color Blue}}

sphere {0.5*y,0.5 pigment { // texture pigment {} attribute
image_map {  
//  png "yalecyl1.png" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
//  png "not30b.png" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
  png "moonmap2.png" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
  map_type 2        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
  interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
  once           // for no repetitive tiling
} // image_map
}            
translate -0.5*y
 scale 1.2   
 rotate 90*x
 rotate -90*z 
 rotate 90*z
 rotate y*40
finish {reflection 0.3 specular 0 ambient 0.3}
}


/*sphere {0.5*y,0.5 pigment { // texture pigment {} attribute
  onion 
    color_map {[0 rgb 0.2*x] [1 rgb 0.4*x]}
    turbulence 0.1
  
}            
translate -0.5*y
 scale 1.2
 rotate -z*90
 rotate -y*40
finish {reflection 0.3 specular 0 ambient 1}
}
*/

         
sphere {0.5*y,0.5 pigment { // texture pigment {} attribute
// create a texture that lays an image's colors onto a surface
// image maps into X-Y plane from <0,0,0> to <1,1,0>
image_map {
  png "earthlights.png" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
  map_type 2        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
  interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
  once           // for no repetitive tiling
  // [filter N V]   // N=all or color index # (0...N), V= value (0.0...1.0)
  // [transmit N V] // N=all or color index # (0...N), V= value (0.0...1.0)
  // [use_color | use_index]
} // image_map
}            
translate -0.5*y
//scale -1
finish {reflection 0 specular 0 ambient 5}
scale 1000
rotate x*90
inverse
}
           
           
                
                
           
#declare IOR = 1.1;
#declare Fade_Distance = 2;
#declare Fade_Power = 3;

#declare Tex1 = 
   texture {
   pigment {
     color rgbf <1,1,1,0.8>
   }
   finish {
      diffuse 0.000001
      metallic on
      ambient 0.1
      specular 1
      roughness 0.001
      irid {
         0.25             // contribution to overall color
         thickness 0.8    // affects frequency, or "busy-ness"
         turbulence 0.1   // Variance in film thickness
      }  
      reflection {0.1,0.9}
   }        
   }


#declare Tex2 = 
   texture {
   pigment {
     color rgb <0,0,0>
   }
   finish {
      reflection 0.8
      specular 1
      roughness 0.001
   }        
   }         
   
   
#declare Tex3 = 
   texture { 
   pigment {
     image_map {
//  png "jupitercyl2.png" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
  png "jupitercyl4.png" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
//  png "moonmap.png" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
  map_type 2        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
  interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
  once           // for no repetitive tiling
    }

   }      
   finish { ambient 0.5  reflection 0}
   
  }



#declare Int1 =
   interior {
      fade_color rgb <0.4,0.9,0.6>
      fade_distance Fade_Distance
      fade_power Fade_Power
      ior IOR
      caustics 1.0
   }
   


#declare cont = object{cylinder {-z,z,10}}   
#declare myobj = intersection { 
  object{cont}
  isosurface {
  function { -z-exp(-pow((x*x/2+y*y/2),p)) }          // function (can also contain declared functions
  contained_by { box { <-10,-10,-1> <10,10,0>} }  // container shape
  //threshold 0.0                     // optional threshold value for isosurface [0.0]
  accuracy 0.001                      // accuracy of calculation [0.001]
  max_gradient 2                      // maximum gradient the function can have [1.1]
  //evaluate 5, 1.2, 0.95             // evaluate the maximum gradient
  //max_trace 1                       // maybe increase for use in CSG [1]
  //all_intersections                 // alternative to 'max_trace'
  //open                              // remove visible container surface
}
}

//object {myobj texture {pigment {color Red}}}


            
            #declare smlrad = 0.08;         
            
            
#declare rstr = seed(1729);            
#include "rand.inc"
merge {  
#declare strm = seed(40033);
#declare num = 12;
#while (num >= 0)
  #declare pt = VRand_In_Obj(myobj,strm);
  sphere {
    pt, smlrad
    texture{Tex1}
    interior{Int1}
  }
  #declare pt = VRand_In_Obj(myobj,strm);
  sphere {
    pt, smlrad
    texture{Tex2}
    }
  #declare pt = VRand_In_Obj(myobj,strm);
  sphere {
    0.5*y,0.5
    texture{Tex3}
    translate -0.5*y
    //rotate <rand(strm)*360,rand(strm)*360,rand(strm)*360>-40
    //rotate 20*x
    rotate 90*x 
    rotate -90*z
    //rotate rand(strm)*360*z
    rotate (rand(rstr)*60-30)*z
    rotate 40*y 
    scale 2*smlrad
    translate pt
  }
  #declare num = num-1;
#end
}

 
 
// general media statement
// put in interior or in scene file for atmospheric media
       
                         
       #declare dens = 20;
object {myobj
texture {pigment{rgbf 1} finish {ambient 0 reflection 0 specular 0}}
interior{
media {
  // (---general values---)
  intervals 10           // number of intervals used for sampling [10]
  samples 1,3            // minimum and maximum number of samples taken per interval [1,1]
  confidence 0.9         // statistic parameter higher->better quality [0.9]
  variance 1.0/128       // statistic parameter lower->better quality [1.0/128]
  ratio 0.9              // distribution between lit and unlit areas [0.9]
  // (---media types---)
//  absorption rgb<1,1,1>  // absorbing media, block light of specified color
  emission rgb<1,1,1>*dens  // emitting media, emit light of specified color
//  scattering {           // scattering media
//    3,                   // scattering type 1=isotropic; 2=Mie haze; 3=Mie murky
//                         // 4=Rayleigh; 5=Henyey-Greenstein
//    rgb<1,1,1>           // color
    //eccentricity 0.25  // eccentricity for type 5 [0.0]
//    extinction 1.0     // for balancing amount of absorption [1.0]
//  }
  // (---method---)
  //method 1             // old Povray 3.1 method
  //method 2             // new method with even distribution
  method 3               // adaptive sampling
  //aa_threshold 0.1     // accuracy threshold for method 3 [0.1]
  //aa_level 4           // maximum recursion depth for method 3 [4]
  jitter 0.5           // randomness for method 2&3
  // (---density---)
  density {
    
    onion            // any pattern
    turbulence 2
    density_map {
      [0 rgb <0.5,0.5,0.5>*dens]
      [1 rgb <3,3,3>*dens]
    }
    scale 0.2
  } 

  // translate etc.
}

}
}

                           
// create a regular point light source
/*light_source {
  0*x                  // light's position (translated below)
  color rgb <0.5,0.5,0>*2    // light's color
  translate 500*z
  shadowless
}

light_source {
  0*x                  // light's position (translated below)
  color rgb <0.5,0.5,0>    // light's color
  translate 500*z
} */
 
 /*
                
text {
  ttf             // font type (only TrueType format for now)
  "c:\\windows\\fonts\\comicbd.ttf",  // Microsoft Windows-format TrueType font file name
  "I'm",      // the string to create
  0.2,              // the extrusion depth
  0 
  rotate 90*x+90*z 
  rotate 40*y   
  scale 0.3
  translate -1.25*x-y
//  texture {Texture01}
//  pigment{color rgb x}
//  interior {Interior01}
  texture {
    pigment {rgb <1,1,1>}
   // finish {Tex1}
  }
//  interior {Int1}
//  photons {target on}
}

text {
  ttf             // font type (only TrueType format for now)
  "c:\\windows\\fonts\\comicbd.ttf",  // Microsoft Windows-format TrueType font file name
  "29.90",      // the string to create
  0.2,              // the extrusion depth
  0 
  rotate 90*x+90*z 
  rotate 40*y   
  scale 0.35
  translate -1.25*x-0.25*y
//  texture {Texture01}
//  pigment{color rgb x}
//  interior {Interior01}
  texture {
  pigment {rgb <1,0,0>}
  
  }
}

text {
  ttf             // font type (only TrueType format for now)
  "c:\\windows\\fonts\\comicbd.ttf",  // Microsoft Windows-format TrueType font file name
  "(+GST)",      // the string to create
  0.2,              // the extrusion depth
  0 
  rotate 90*x+90*z 
  rotate 40*y   
  scale 0.2
  translate -1.25*x+y
//  texture {Texture01}
//  pigment{color rgb x}
//  interior {Interior01}
  texture {
  pigment {rgb <0.2,0.2,0.2>*2.5}
   }
}





           
// create a regular point light source
// create a point "spotlight" (conical directed) light source
light_source {
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <-80, 80, 80> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 5                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
}
             */
/*box {
  0,1
  scale <0.1,3,0.5>
  rotate 40*y
  translate -1.1*x-1.5*y-0.5*z
  pigment {color White} 
} */
           