/*
#macro en(a,b) exp(-(a*a+b*b)/2) #end
#macro sn(a,b) (1+sin(4*a)/4) #end
#macro fn(a,b) en(a,b)*sn(a,b) #end
#macro fa(a,b) cos(4*a)*en(a,b)-a*fn(a,b) #end
#macro fb(a,b) -b*fn(a,b) #end
#macro th(a,b) asin(fb(a,b)/sqrt(1+pow(fb(a,b),2)+pow(fa(a,b),2)))*180/pi #end
#macro ph(a,b) -asin(fa(a,b)/sqrt(1+pow(fa(a,b),2)))*180/pi #end

#macro trans(a,b) translate <-a,-b,0> rotate <th(a,b),ph(a,b),0> translate <a,b,fn(a,b)>
#end
*/

#declare p=1.5;
#macro en(a,b) exp(-pow((a*a/2+b*b/2),p)) #end
#macro fn(a,b) -en(a,b) #end
#macro fa(a,b) -p*a*pow((a*a+b*b),p-1)*fn(a,b) #end
#macro fb(a,b) -p*b*pow((a*a+b*b),p-1)*fn(a,b) #end
#macro th(a,b) asin(fb(a,b)/sqrt(1+pow(fb(a,b),2)+pow(fa(a,b),2)))*180/pi #end
#macro ph(a,b) -asin(fa(a,b)/sqrt(1+pow(fa(a,b),2)))*180/pi #end

#macro trans(a,b) translate <-a,-b,0> rotate <th(a,b),ph(a,b),0> translate <a,b,fn(a,b)>
#end

/*

#macro trans(a,b) translate 0
#end

*/