//The Cross
#declare Corner_Rad=.03;
#declare Cross_Depth=.25; // is used as +/- value
#declare C_Curve_Radius=.25;

#declare C_h_Corner_b_f_l=<-1,2,-Cross_Depth>;
#declare C_h_Corner_b_r_l=<-1,2,Cross_Depth>;
#declare C_h_Corner_t_f_l=<-1,2.5,-Cross_Depth>;
#declare C_h_Corner_t_r_l=<-1,2.5,Cross_Depth>;
#declare C_h_Corner_b_f_r=<1,2,-Cross_Depth>;
#declare C_h_Corner_b_r_r=<1,2,Cross_Depth>;
#declare C_h_Corner_t_f_r=<1,2.5,-Cross_Depth>;
#declare C_h_Corner_t_r_r=<1,2.5,Cross_Depth>;

#declare C_v_Bottom_Length=0;
#declare C_v_Top_Length=3.3;
#declare C_v_Corner_b_f_l=<-.25,C_v_Bottom_Length,-Cross_Depth>;
#declare C_v_Corner_b_r_l=<-.25,C_v_Bottom_Length,Cross_Depth>;
#declare C_v_Corner_t_f_l=<-.25,C_v_Top_Length,-Cross_Depth>;
#declare C_v_Corner_t_r_l=<-.25,C_v_Top_Length,Cross_Depth>;
#declare C_v_Corner_b_f_r=<.25,C_v_Bottom_Length,-Cross_Depth>;
#declare C_v_Corner_b_r_r=<.25,C_v_Bottom_Length,Cross_Depth>;
#declare C_v_Corner_t_f_r=<.25,C_v_Top_Length,-Cross_Depth>;
#declare C_v_Corner_t_r_r=<.25,C_v_Top_Length,Cross_Depth>;

#declare Cross_h=
 union{
  sphere{C_h_Corner_b_f_l,Corner_Rad}
  sphere{C_h_Corner_b_r_l,Corner_Rad}
  sphere{C_h_Corner_t_f_l,Corner_Rad}
  sphere{C_h_Corner_t_r_l,Corner_Rad}
  sphere{C_h_Corner_b_f_r,Corner_Rad}
  sphere{C_h_Corner_b_r_r,Corner_Rad}
  sphere{C_h_Corner_t_f_r,Corner_Rad}
  sphere{C_h_Corner_t_r_r,Corner_Rad}
  cylinder{C_h_Corner_b_f_l,C_h_Corner_b_f_r,Corner_Rad}
  cylinder{C_h_Corner_b_r_l,C_h_Corner_b_r_r,Corner_Rad}
  cylinder{C_h_Corner_t_f_l,C_h_Corner_t_f_r,Corner_Rad}
  cylinder{C_h_Corner_t_r_l,C_h_Corner_t_r_r,Corner_Rad}
  cylinder{C_h_Corner_b_f_l,C_h_Corner_t_f_l,Corner_Rad}
  cylinder{C_h_Corner_b_r_l,C_h_Corner_t_r_l,Corner_Rad}
  cylinder{C_h_Corner_b_f_r,C_h_Corner_t_f_r,Corner_Rad}
  cylinder{C_h_Corner_b_r_r,C_h_Corner_t_r_r,Corner_Rad}
  cylinder{C_h_Corner_b_f_l,C_h_Corner_b_r_l,Corner_Rad}
  cylinder{C_h_Corner_t_f_l,C_h_Corner_t_r_l,Corner_Rad}
  cylinder{C_h_Corner_b_f_r,C_h_Corner_b_r_r,Corner_Rad}
  cylinder{C_h_Corner_t_f_r,C_h_Corner_t_r_r,Corner_Rad}
  box{<-1-Corner_Rad,2,-.25><1+Corner_Rad,2.5,.25>}
  box{<-1,2-Corner_Rad,-.25><1,2.5+Corner_Rad,.25>}
  box{<-1,2,-.25-Corner_Rad><1,2.5,.25+Corner_Rad>}
 }

#declare Cross_v=
 union{
  sphere{C_v_Corner_b_f_l,Corner_Rad}
  sphere{C_v_Corner_b_r_l,Corner_Rad}
  sphere{C_v_Corner_t_f_l,Corner_Rad}
  sphere{C_v_Corner_t_r_l,Corner_Rad}
  sphere{C_v_Corner_b_f_r,Corner_Rad}
  sphere{C_v_Corner_b_r_r,Corner_Rad}
  sphere{C_v_Corner_t_f_r,Corner_Rad}
  sphere{C_v_Corner_t_r_r,Corner_Rad}
  cylinder{C_v_Corner_b_f_l,C_v_Corner_b_f_r,Corner_Rad}
  cylinder{C_v_Corner_b_r_l,C_v_Corner_b_r_r,Corner_Rad}
  cylinder{C_v_Corner_t_f_l,C_v_Corner_t_f_r,Corner_Rad}
  cylinder{C_v_Corner_t_r_l,C_v_Corner_t_r_r,Corner_Rad}
  cylinder{C_v_Corner_b_f_l,C_v_Corner_t_f_l,Corner_Rad}
  cylinder{C_v_Corner_b_r_l,C_v_Corner_t_r_l,Corner_Rad}
  cylinder{C_v_Corner_b_f_r,C_v_Corner_t_f_r,Corner_Rad}
  cylinder{C_v_Corner_b_r_r,C_v_Corner_t_r_r,Corner_Rad}
  cylinder{C_v_Corner_b_f_l,C_v_Corner_b_r_l,Corner_Rad}
  cylinder{C_v_Corner_t_f_l,C_v_Corner_t_r_l,Corner_Rad}
  cylinder{C_v_Corner_b_f_r,C_v_Corner_b_r_r,Corner_Rad}
  cylinder{C_v_Corner_t_f_r,C_v_Corner_t_r_r,Corner_Rad}
  box{<-.25-Corner_Rad,C_v_Bottom_Length,-.25><.25+Corner_Rad,C_v_Top_Length,.25>}
  box{<-.25,C_v_Bottom_Length-Corner_Rad,-.25><.25,C_v_Top_Length+Corner_Rad,.25>}
  box{<-.25,C_v_Bottom_Length,-.25-Corner_Rad><.25,C_v_Top_Length,.25+Corner_Rad>}
 }

#declare Cross_Curve=
intersection{
 union{
  torus{C_Curve_Radius,Corner_Rad translate y*Cross_Depth}
  torus{C_Curve_Radius,Corner_Rad translate y*-Cross_Depth}
  intersection{
   box{<0,-Corner_Rad-Cross_Depth,0>,<C_Curve_Radius+Corner_Rad*2,Corner_Rad+Cross_Depth,C_Curve_Radius+Corner_Rad*2>}
   cylinder{y*-(Corner_Rad*2+Cross_Depth*2),y*(Corner_Rad*2+Cross_Depth*2),C_Curve_Radius inverse}
   }
  intersection{
   box{<0,-Cross_Depth,0>,<C_Curve_Radius+Corner_Rad*2,Cross_Depth,C_Curve_Radius+Corner_Rad*2>}
   cylinder{y*-(Corner_Rad*2+Cross_Depth*2),y*(Corner_Rad*2+Cross_Depth*2),C_Curve_Radius-Corner_Rad inverse}
   }

  }  
 box{<0,-(Corner_Rad*2+Cross_Depth*2),0>,<C_Curve_Radius+Corner_Rad*2,(Corner_Rad*2+Cross_Depth*2),C_Curve_Radius+Corner_Rad*2>} 
 }

#declare Cross=
union{
 object {Cross_h}
 object {Cross_v
         matrix < 1   ,0,0, //x
                 -0.03,1,0, //y
                  0   ,0,1, //z
                  0   ,0,0>
         translate x*.06
        }
 object {Cross_v
         matrix < 1   ,0,0, //x
                  0.03,1,0, //y
                  0   ,0,1, //z
                  0   ,0,0>
         translate x*-.06                
        }
 object{Cross_Curve rotate x*-90 translate <-.25,2,0>-C_Curve_Radius*<1,1,0>}
 object{Cross_Curve rotate x*-90 translate <-.25,2,0>-C_Curve_Radius*<1,1,0> scale <-1,1,1>}
 object{Cross_Curve rotate x*90 translate <-.25,2.5,0>-C_Curve_Radius*<1,-1,0>}
 object{Cross_Curve rotate x*90 translate <-.25,2.5,0>-C_Curve_Radius*<1,-1,0> scale <-1,1,1>}
}