//+w800 +h400 +AM2 +A0.3 +R2

//Florian Kastell
//DigitalTwilight
//http://www.digitaltwilight.de
//kingofmycastle@gmx.net

//Death of Mind

/*----------------------------------------------- settings -----------------------------------------------*/
#version 3.5;

#default {finish{ambient 0}}

#declare Arealight=off;
#declare Media=off;

global_settings{
        assumed_gamma 1
        ambient_light 1
        max_trace_level 256
}

/*---------------------------------------------camera & light----------------------------------------------*/

camera{
       location <2.4,.2,.6>
       look_at <-2,3,7>
       up y*1
       right x*2
}

light_source{<-65,40,-100> rgb 1
             #if (Arealight) area_light x*15, z*15, 16, 16 orient circular adaptive 2 jitter #end
             fade_distance 100 fade_power 2 media_interaction off
}

light_source{<-25,18,30> rgb 1 parallel point_at <-40,18,10>}

/*----------------------------------------------- textures ------------------------------------------------*/

#declare Sky_Material=
 pigment{gradient y color_map{[0 rgb 1][0.05 rgb 0][1 rgb 0]}}

#declare HF_Material=
 material{
  texture{
   pigment{rgb .25}
   normal{granite scale <.5,1.1,.5>}
   finish{roughness .01 specular .1}
  }
 }

#declare Cross_Material=
 material{
  texture{
   pigment{rgb <1.15,1.15,1.15>}
   normal{granite scale .7}
   finish{
          diffuse .9
          ambient .05
          brilliance 1.5
          metallic .5
          roughness .5
          specular .08
   }
  }
 }

#declare Big_Head_Material=
 material{
  texture{
   pigment{rgb 2}
   finish{
          ambient .03
          reflection <.006,.006,.006>
          brilliance 1
          specular .5
   }
  }
 }

#declare Dead_Body_Material=
 material{
  texture{
   pigment{rgb 0}
   finish{
          reflection <.005,.008,.008>
          brilliance 1
          metallic .5
          specular .6
          diffuse 1.9
          ambient .8
   }
  }
 }

#declare Final_Death_Obj_Material=
 material{
  texture{
   pigment{rgbt <0,1,1.5,.85>}
   finish{
          specular .06
          brilliance .25
          diffuse .05
          ambient .05               
   }
  }
 }

#declare Myst_Water_Material=
 material{
  texture{
   pigment{
           bozo
           color_map{
                     [0.0 rgbt <.01, .01, .01, .1>]
                     [1.0 rgbt <.05, .05, .05, .1>]
           }
   }
   normal{
          average
          normal_map{
                     [0.0 bumps .9]
                     [1.0 wrinkles .5]
          }
   }
   finish{
          phong .2
          specular .5
          ambient .2
          metallic .15
          brilliance .9
          reflection 1.5
   }
  }
 }

/*----------------------------------------------- includes ------------------------------------------------*/

#include "head_sm.inc"
#include "cross.inc"
#include "dead_body.inc"
#include "final_death.inc"

/*---------------------------------------------- the scene ------------------------------------------------*/

//the sky
sky_sphere{pigment{Sky_Material} scale 2 translate -1}
fog {color rgb 1 distance 30 fog_type 2 fog_offset .4 fog_alt .3}

//the mystic water background
#declare Mystic_Water_Bg=
 plane{z, 70 hollow rotate y*-20}

//the ground
#declare HF_Height=15;

#declare Plain_Hills= pigment{bozo color_map{[0 rgb 0][1 rgb 1/HF_Height]} scale .03}
#declare Higher_Hills=pigment{bozo color_map{[0 rgb 1/HF_Height][1 rgb 1]} scale .15}

#declare Soft_Hills = pigment{gradient y poly_wave 2 pigment_map{[0 Plain_Hills][1 Higher_Hills]}}
#declare HF = function{pigment{Soft_Hills}}

#declare HF_Detail=500;
#declare HF_Size = <90,HF_Height,90>;

#declare HF_Object =
 height_field{
  function HF_Detail,HF_Detail{HF(x,y,z).x}
  smooth
  scale <1,1,-1>
  translate <-.5,0,1>
  scale HF_Size
  translate <0,-.5,0>
  material{HF_Material}
 }

//head
#declare Head=
 union{
  object{Head_Source scale 15 rotate y*180 translate <0,-7.4,.15>}
   box{<-.2,0,-.2><.2,.4,.2> translate <0,2.7,.55>}
   box{<-.175,0,-.175><.175,.35,.175> translate <-.25,2.6,.45>}
   box{<-.175,0,-.175><.175,.35,.175> translate <.25,2.6,.45>}
   box{<-.15,0,-.15><.15,.3,.15> translate <-.33,2.5,.32>}
   box{<-.15,0,-.15><.15,.3,.15> translate <.33,2.5,.32>}
   box{<-.125,0,-.125><.125,.25,.125> translate <-.37,2.4,.2>}
   box{<-.125,0,-.125><.125,.25,.125> translate <.37,2.4,.2>}
   box{<-.1,0,-.1><.1,.2,.1> translate <-.395,2.3,.06>}
   box{<-.1,0,-.1><.1,.2,.1> translate <.395,2.3,.06>}
   box{<-.075,0,-.075><.075,.15,.075> translate <-.375,2.25,-.08>}
   box{<-.075,0,-.075><.075,.15,.075> translate <.375,2.25,-.08>}
   box{<-.05,0,-.05><.05,.1,.05> translate <-.37,2.26,-.18>}
   box{<-.05,0,-.05><.05,.1,.05> translate <.37,2.26,-.18>}
   box{<-.025,0,-.025><.025,.075,.025> translate <-.37,2.26,-.28>}
   box{<-.025,0,-.025><.025,.075,.025> translate <.37,2.26,-.28>}
   box{<-.0125,0,-.0125><.0125,.05,.0125> translate <-.362,2.263,-.32>}
   box{<-.0125,0,-.0125><.0125,.05,.0125> translate <.362,2.263,-.32>}
   translate z*-.2
  }

//the crosses
#declare Cross_Array=
 union{
  #declare A=0;
   #while (A<=25)
   #declare B=0;
    #while (B<=20)
     #declare Rand1= seed(10);
     #declare Normal=<0,0,0>;
     #declare Pos=trace(HF_Object, <-1.5+-2*B,0,4+2*A> + y*20, <0,-1,0>, Normal);
     #if (vlength(Normal))
      object {Cross material{Cross_Material} rotate y*10*rand(Rand1) scale .21 translate Pos}
     #end
     #declare Rand2= seed(10);
     #declare Normal=<0,0,0>;
     #declare Pos=trace(HF_Object, < 1.5+ 2*B,0,4+2*A> + y*20, <0,-1,0>, Normal);
     #if (vlength(Normal))
      object {Cross material{Cross_Material} rotate y*10*rand(Rand2) scale .21 translate Pos}
     #end

     #declare B=B+1;
    #end
    #declare A=A+1;
   #end
 }

//red head
#declare Big_Head=
 union{
  object{Head_Source scale 15 rotate y*180 translate <0,-7.4,.15>}
  union{
   box{<-.2,0,-.2><.2,.4,.2> translate <0,2.7,.55>}
   box{<-.175,0,-.175><.175,.35,.175> translate <-.25,2.6,.45>}
   box{<-.175,0,-.175><.175,.35,.175> translate <.25,2.6,.45>}
   box{<-.15,0,-.15><.15,.3,.15> translate <-.33,2.5,.32>}
   box{<-.15,0,-.15><.15,.3,.15> translate <.33,2.5,.32>}
   box{<-.125,0,-.125><.125,.25,.125> translate <-.365,2.4,.2>}
   box{<-.125,0,-.125><.125,.25,.125> translate <.365,2.4,.2>}
   box{<-.1,0,-.1><.1,.2,.1> translate <-.39,2.3,.06>}
   box{<-.1,0,-.1><.1,.2,.1> translate <.39,2.3,.06>}
   box{<-.075,0,-.075><.075,.15,.075> translate <-.375,2.25,-.08>}
   box{<-.075,0,-.075><.075,.15,.075> translate <.375,2.25,-.08>}
   box{<-.05,0,-.05><.05,.1,.05> translate <-.37,2.26,-.18>}
   box{<-.05,0,-.05><.05,.1,.05> translate <.37,2.26,-.18>}
   box{<-.025,0,-.025><.025,.075,.025> translate <-.38,2.26,-.255>}
   box{<-.025,0,-.025><.025,.075,.025> translate <.38,2.26,-.255>}
   box{<-.0125,0,-.0125><.0125,.05,.0125> translate <-.38,2.263,-.295>}
   box{<-.0125,0,-.0125><.0125,.05,.0125> translate <.38,2.263,-.295>}
   pigment{rgb .4}
   finish{
          diffuse 1.5
          ambient .5
          roughness .005
          specular .2
          metallic .5
   }
  }
  translate z*-.2
 }

//hovering ghost
#declare Final_Death_Obj=
union{
  object{Cross scale .08 translate <.013,.185,-.038>}
  object{Final_Death
       #if (Media)
       interior{
          media{
            emission <2,0,0>
            scattering {1, 0.9}
            density { 
              spherical scale 12
              color_map {
                [0.0 rgb 0]
                [0.1 rgb 0]
                [1.0 rgb <.95,0,0>]
              }
            }
          }
       }
       #end
  }
}

/*-------------------------------------------position of things--------------------------------------------*/

object{
       Dead_Body
       material{Dead_Body_Material}
       scale 2
       rotate y*160
       translate <2.1,.1,2.55>
}

object{
       Final_Death_Obj
       material{Final_Death_Obj_Material}
       double_illuminate
       hollow
       no_shadow
       scale 2
       rotate <20,145,0>
       translate <1.545,.5,1.9>
}

object{HF_Object}

object{Mystic_Water_Bg material{Myst_Water_Material scale 5}}

object{Cross_Array}

object{
        Big_Head
        material{Big_Head_Material}
        rotate y*-145
        scale 27
        translate <-50,-43,14>
        no_shadow
        no_reflection
      }