// PoVRay 3.5 Scene File "clock01.pov"
// created by   Paolo Gibellini  
// Date:   21/08/2003
//------------------------------------------------------------------------

//Lancette /////////////////////////
#macro Hand(h_len,h_tex,h_rot) 
    union{
        cylinder { <0,0,0>,<0,h_len,0>,0.05
                    texture{h_tex }
        }
        cone{<0,h_len,0>,0.2,<0,h_len+0.7,0>,0
                texture{h_tex}
        }
     rotate< 0,0,h_rot>
     translate<0,0,-0.5>                   
     }
#end 

// Perno
#declare Perno=union {
    cylinder { <0,0,0>,<0,0,-0.5>,0.1
    	texture{ pigment{Bronze}
                 finish {ambient 0.15 diffuse 0.85 phong 1 phong_size 50 reflection .35}
        }
    }
    sphere {<0,0,0>, .2
    	texture{ pigment{Bronze}
                 finish {ambient 0.15 diffuse 0.85 phong 1 phong_size 50 reflection .35}
        }
        translate<0,0,-0.5>                   
    }
}

// Disco
#declare Disk=
disc {<0, 0, 0>   z,  2.5,  0.2
	texture{ pigment{White_Marble}
             finish {ambient 0.15 diffuse 0.85 phong 1 phong_size 50 reflection .35}
    }
}

// Disegna i segnalini
// Segnalino
#declare Tick=
box {<-1, -1, -1> < 1,  1,  1> scale <0.1,0.1,0.6> rotate<0,0,0> translate<0,0,0>
	texture{ pigment{color Orange}
             finish {ambient 0.15 diffuse 0.85 phong 1 phong_size 50 reflection .35}
    }
}
#declare Ticks=union{
    #local Nr=0;            // start
    #local N_per_Rev=12;   // number of elements per revolutions
    #while (Nr < N_per_Rev) 
        object{Tick     translate<0.25/N_per_Rev,-0.05,2>
                        rotate<0,Nr * 360/N_per_Rev,0>
        } 
        #local Nr=Nr+1;    // next Nr
    #end // ---------------  end of loop 
    rotate<-90,0,0>
    translate<0,0,0>
} // end of union


// Orologio
#declare clock01=union {
    object {Ticks}
    object {Disk}
    Hand(1.8, pigment{color Bronze},40)
    Hand(1, pigment{color Bronze},-50)
    object {Perno}
}

