#!/usr/bin/python

#**************************************************************************
#
#    Stem.py  - classes Segment, Leaf and Stem - here is all the logic of 
#               the tree generating algorithm
#
#    Copyright (C) 2003  Wolfram Diestel
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    Send comments and bug fixes to diestel@steloj.de
#
#**************************************************************************/


from random import *
import sys
import Stem
from Vector import *

class Tree:
      "A class for creation of threedimensional tree objects"

      # debugging
      debug = 0
      verbose = 1
      # testing = 0
      ignoreVParams = 0

      bend = 0 # (0..1) how much rotate leafs toward light
      quality = 1
      # the seed
      Seed = 13

      # global params
      Levels = 2
      Ratio = 0.05
      RatioPower = 1.2
      Shape = 1
      BaseSize = 0.3
      Flare = 0.5
      
      Leaves = 5
      LeafShape = 0
      LeafScale = 0.5
      LeafScaleX = 0.5

      Scale = 13.0
      ScaleV = 0.0

      nBaseSplits = [1,None,None,None] # only 0BaseSplits used
      nScale = [1.0,None,None,None] # only 0SCale used
      nScaleV = [0.0,None,None,None] # only 0ScaleV used
      
      nTaper = [0.9,1.0,1.0,1.0] # taper to a point (cone)
      nCurveRes = [5,3,2,1]
      nCurve = [0,0,0,0]
      nCurveV = [0,0,0,0]
      nCurveBack = [0,0,0,0]
      nLength = [1.0,0.3,0.5,0.5]
      nLengthV = [0,0,0,0]
      nSegSplits = [0,0,0,0]
      nSplitAngle = [0,0,0,0]
      nSplitAngleV = [0,0,0,0]
      nBranches = [None,5,5,5]
      #nDownAngle = [90,90,45,45]
      nDownAngle = [90,90,90,90]
      nDownAngleV = [0,0,0,0]	
      #nRotate = [None,90,45,45]
      nRotate = [None,90,90,90]
      nRotateV = [None,0,0,0]
      
      AttractionUp = 0
      
      # other settings
      splitErrorValue = [0,0,0,0]
      substemErrorValue = [0,0,0,0]
      leavesErrorValue = [0,0,0,0]

      def __init__(self,pos=Location(0,0,0),dir=Direction(0,0,1)):
	  self.position = pos
	  self.direction = dir
	  self.debug = 0

      def make(self):
          if self.ignoreVParams:
	  	self.ScaleV=0
	  	self.nCurveV=self.nScaleV=self.nLengthV=self.nSplitAngleV=\
			self.nRotateV=[0,0,0,0]
		for i in range (1,4):
			if self.nDownAngle[i]>0: self.nDownAngle[i]=0
			#else: self.nDownAngleV[i]=-0.00000001
      
	  self.random = Random(self.Seed)
          if self.verbose: sys.stderr.write("making tree, seed: %d" % self.Seed)
	  self.trunk = Stem.Stem(self,self,0,self.position,self.direction)
	  self.trunk.make()
	  if self.verbose: sys.stderr.write(".\n")

      def shape_ratio(self,ratio,shape=-1):
          if shape == -1: shape = self.Shape
	  if   shape == 0: return 0.2+0.8*ratio
	  elif shape == 1: return 0.2+0.8*sin(pi*ratio)
	  elif shape == 2: return 0.2+0.8*sin(0.5*pi*ratio)
	  elif shape == 3: return 1.0
	  elif shape == 4: return 0.5+0.5*ratio
	  elif shape == 5:
	       if ratio<=0.7: return ratio/0.7
	       else: return (1-ratio)/0.3
	  elif shape == 6: return 1-0.8*ratio
	  elif shape == 7:
	       if ratio<=0.7: return 0.5+0.5*ratio/0.7 
	       else: return 0.5+0.5*(1-ratio)/0.3 
	  else: 
	       raise Stem.ErrorNotYetImplemented,"Shape>7 not implemented yet\n";

      def povray(self):
          if self.verbose: sys.stderr.write("writing povray code...\n")
	  print "#declare Tree = union { \n"
	  self.trunk.povray()
	  print "}"
	  
      def dump(self):
	  print "TREE:"
	  self.trunk.dump()
	  
def test():
    tree = Tree()
    tree.make()
    tree.povray()














