#!/usr/bin/python

#**************************************************************************
#
#    Stem.py  - classes Segment, Leaf and Stem - here is all the logic of 
#               the tree generating algorithm
#
#    Copyright (C) 2003  Wolfram Diestel
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    Send comments and bug fixes to diestel@steloj.de
#
#**************************************************************************/


import Tree

def quaking_aspen():
	tree = Tree.Tree()
	
	tree.Seed=13
	
	# global params
	tree.Shape = 7
	tree.BaseSize = 0.4
      
	tree.Scale = 13
	tree.ScaleV = 3
	#tree.ZScale = 1
	#tree.ZScaleV = 0

	tree.Levels = 3
	
	tree.Ratio = 0.015
	tree.RatioPower = 1.2
	
	#tree.Lobes = 5
	#tree.LobeDepth = 0.07
	
	tree.Flare = 0.6

	tree.nScale = [1.0] # only 0SCale used
	tree.nScaleV = [0.0] # only 0ScaleV used
	tree.nBaseSplits = [0]
	
	tree.nDownAngle = [None,60,45,45]
	tree.nDownAngleV = [None,-50,10,10]	
	tree.nRotate = [None,140,140,77]
	tree.nRotateV = [None,0,0,0]
	tree.nBranches = [None,50,30,10]
	
	tree.nLength = [1.0,0.3,0.6,0]
	tree.nLengthV = [0,0,0,0]
	tree.nTaper = [1.0,1.0,1.0,1.0]
	
	tree.nSegSplits = [0,0,0,0]
	tree.nSplitAngle = [0,0,0,0]
	tree.nSplitAngleV = [0,0,0,0]
	
	tree.nCurveRes = [3,5,3,1]
	tree.nCurve = [0,-40,-40,0]
	#tree.nCurveBack = [0,0,0]
	tree.nCurveV = [20,50,75,0]
	
	tree.Leaves=25 
	tree.bend=0.5
	tree.quality=0.8
	tree.LeafShape=0
	tree.LeafScale=0.17 # 0.17
	tree.LeafScaleX=1
	tree.AttractionUp=0.5
	#tree.PruneRatio=0
	#tree.PruneWidth=0.5
	#tree.PruneWidthPeak=0.5
	#tree.PrunePower=0.5
	#tree.PrunePowerHigh=0.5

	tree.debug=0
	tree.make()
	tree.povray()

def weeping_willow():
	tree = Tree.Tree()
	
	tree.Seed=13
	
	# global params
	tree.Shape = 3
	tree.BaseSize = 0.05
      
	tree.Scale = 15
	tree.ScaleV = 5
	#tree.ZScale = 1
	#tree.ZScaleV = 0

	tree.Levels = 4
	
	tree.Ratio = 0.03
	tree.RatioPower = 2
	
	#tree.Lobes = 9
	#tree.LobeDepth = 0.03
	
	tree.Flare = 0.75

	tree.nScale = [1.0] # only 0SCale used
	tree.nScaleV = [0.0] # only 0ScaleV used
	tree.nBaseSplits = [2]
	
	tree.nDownAngle = [None,20,30,20]
	tree.nDownAngleV = [None,10,10,10]	
	tree.nRotate = [None,-120,-120,140]
	tree.nRotateV = [None,30,30,0]
	tree.nBranches = [None,15,8,40] #[None,25,10,300]
	
	tree.nLength = [0.8,0.5,1.5,0.1]
	tree.nLengthV = [0,0.1,0,0]
	tree.nTaper = [1.0,1.0,1.0,1.0]
	
	tree.nSegSplits = [0.1,0.2,0.2,0]
	tree.nSplitAngle = [3,30,45,0]
	tree.nSplitAngleV = [0,10,20,0]
	
	tree.nCurveRes = [8,16,12,1]
	tree.nCurve = [0,40,0,0]
	tree.nCurveBack = [20,80,0,0]
	tree.nCurveV = [120,90,0,0]
	
	tree.Leaves=15 
	tree.bend=0.5
	tree.quality=0.8
	tree.LeafShape=02
	tree.LeafScale=0.12 # 0.17
	tree.LeafScaleX=0.2
	tree.AttractionUp=-3
	#tree.PruneRatio=1
	#tree.PruneWidth=0.4
	#tree.PruneWidthPeak=0.6
	#tree.PrunePower=0.001
	#tree.PrunePowerHigh=0.5

	tree.debug=0
	tree.make()
	tree.povray()
	
	
def black_tupelo():
	tree = Tree.Tree()
	
	tree.Seed=13
	
	# global params
	tree.Shape = 4
	tree.BaseSize = 0.2
      
	tree.Scale = 23
	tree.ScaleV = 5
	#tree.ZScale = 1
	#tree.ZScaleV = 0

	tree.Levels = 4
	
	tree.Ratio = 0.015
	tree.RatioPower = 1.3
	
	#tree.Lobes = 5
	#tree.LobeDepth = 0.07
	
	tree.Flare = 1

	tree.nScale = [1.0] # only 0SCale used
	tree.nScaleV = [0.0] # only 0ScaleV used
	tree.nBaseSplits = [0]
	
	tree.nDownAngle = [None,60,30,45]
	tree.nDownAngleV = [None,-40,10,10]	
	tree.nRotate = [None,140,140,140]
	tree.nRotateV = [None,0,0,0]
	tree.nBranches = [None,50,25,12]
	
	tree.nLength = [1.0,0.3,0.6,0.4]
	tree.nLengthV = [0,0.05,0.1,0]
	tree.nTaper = [1.0,1.0,1.0,1.0] #1.1
	
	tree.nSegSplits = [0,0,0,0]
	tree.nSplitAngle = [0,0,0,0]
	tree.nSplitAngleV = [0,0,0,0]
	
	tree.nCurveRes = [10,10,10,1]
	tree.nCurve =    [0,  0,-10,0]
	tree.nCurveBack =[0,  0,0,0]
	tree.nCurveV =   [40, 90,150,0]
	
	tree.Leaves=6 
	tree.bend=0.5
	tree.quality=0.8
	tree.LeafShape=0
	tree.LeafScale=0.3
	tree.LeafScaleX=0.5
	tree.AttractionUp=0.5
	#tree.PruneRatio=0
	#tree.PruneWidth=0.5
	#tree.PruneWidthPeak=0.5
	#tree.PrunePower=0.5
	#tree.PrunePowerHigh=0.5

	tree.debug=0
	tree.make()
	tree.povray()
	
		
def ca_black_oak():
	tree = Tree.Tree()
	
	tree.Seed=17
	
	# global params
	tree.Shape = 2
	tree.BaseSize = 0.05
      
	tree.Scale = 10
	tree.ScaleV = 10
	#tree.ZScale = 1
	#tree.ZScaleV = 0

	tree.Levels = 3
	
	tree.Ratio = 0.018
	tree.RatioPower = 1.3
	
	#tree.Lobes = 5
	#tree.LobeDepth = 0.07
	
	tree.Flare = 1.2

	tree.nScale = [1.0] # only 0SCale used
	tree.nScaleV = [0.0] # only 0ScaleV used
	tree.nBaseSplits = [2] #2 # only 0BaseSplits used
	
	tree.nDownAngle = [None,30,45,45]
	tree.nDownAngleV = [None,-30,10,10]	
	tree.nRotate = [None,80,140,140]
	tree.nRotateV = [None,0,0,0]
	tree.nBranches = [None,30,70,0] #40,120
	
	tree.nLength = [1.0,0.8,0.2,0.4]
	tree.nLengthV = [0,0.1,0.05,0]
	tree.nTaper = [0.95,1.0,0.05,1.0]
	
	tree.nSegSplits = [0.4,0.2,0.1,0]
	tree.nSplitAngle = [10,10,10,0]
	tree.nSplitAngleV = [0,10,10,0]
	
	tree.nCurveRes = [8,10,3,1]
	tree.nCurve = [0,40,-40,0]
	tree.nCurveBack = [0,-70,0,0]
	tree.nCurveV = [90,150,-30,0]
	
	tree.Leaves=20 
	tree.bend=0.5
	tree.quality=0.8
	tree.LeafShape=0
	tree.LeafScale=0.12 # 0.17
	tree.LeafScaleX=0.66
	tree.AttractionUp=0.8
	#tree.PruneRatio=0
	#tree.PruneWidth=0.5
	#tree.PruneWidthPeak=0.5
	#tree.PrunePower=0.5
	#tree.PrunePowerHigh=0.5

	tree.debug=0
	tree.ignoreVParams=0
	
	tree.make()
#	print "/*"
#	tree.dump()
#	print "*/"
	tree.povray()

def surrealistic():
	tree = Tree.Tree()
	
	tree.Seed=13
	
	# global params
	tree.Shape = 2
	tree.BaseSize = 0.2
      
	tree.Scale = 13
	tree.ScaleV = 0
	#tree.ZScale = 1
	#tree.ZScaleV = 0

	tree.Levels = 2 #3
	
	tree.Ratio = 0.05
	tree.RatioPower = 1.8
	
	#tree.Lobes = 9
	#tree.LobeDepth = 0.03
	
	tree.Flare = 0.2

	tree.nScale = [1.0] # only 0SCale used
	tree.nScaleV = [0.0] # only 0ScaleV used
	tree.nBaseSplits = [1]
	
	tree.nDownAngle = [None,80,110,20]
	tree.nDownAngleV = [None,10,50,10]	
	tree.nRotate = [None,70,140,140]
	tree.nRotateV = [None,10,30,30]
	tree.nBranches = [None,10,15,40] #[None,25,10,300]
	
	tree.nLength = [1.0,0.6,0.9,0.1]
	tree.nLengthV = [0,0.1,0.3,0]
	tree.nTaper = [1.0,1.0,1.0,1.0]
	
	tree.nSegSplits = [0,0.1,0.05,0]
	tree.nSplitAngle = [170,30,45,0]
	tree.nSplitAngleV = [0,10,20,0]
	
	tree.nCurveRes = [3,16,20,1]
	tree.nCurve =    [0,-100,20,0]
	tree.nCurveBack =[120,10,0,0]
	tree.nCurveV =   [0,10,50,0]
	
	tree.Leaves=0
	tree.bend=0.5
	tree.quality=0.8
	tree.LeafShape=0
	tree.LeafScale=0.12 # 0.17
	tree.LeafScaleX=0.2
	tree.AttractionUp=2
	#tree.PruneRatio=1
	#tree.PruneWidth=0.4
	#tree.PruneWidthPeak=0.6
	#tree.PrunePower=0.001
	#tree.PrunePowerHigh=0.5

	tree.debug=0
	tree.make()
#	print "/*"
#	tree.dump()
#	print "*/"
	tree.povray()

	
		
def generic():	
	tree = Tree.Tree()
	tree.debug=1
	tree.make()
	print "/*"
	tree.dump()
	print "*/"
	tree.povray()

def splitting():	
	tree = Tree.Tree()
	tree.debug=1
	
	tree.nCurveRes[0]=10
	tree.nCurve[0] = 10
	tree.Levels = 1
	tree.Leaves = 0
	tree.nSegSplits = [0.8,0.2,0.1,0]
	tree.nSplitAngle = [90,10,10,0]
	tree.nSplitAngleV = [0,0,0,0]
	
	tree.make()
	print "/*"
	tree.dump()
	print "*/"
	tree.povray()
	
		
def povraytest():
#	generic()
#	quaking_aspen()
#	ca_black_oak()
#        black_tupelo()
#	splitting()
#	weeping_willow()
	surrealistic()
	print '''global_settings {
   adc_bailout 0.00392157
   assumed_gamma 1.5
}

sky_sphere {
   pigment {
      color rgb <0.623529, 1, 0.976471>
   }
}

light_source {
   <40, 500, -500>, rgb <1, 1, 1>
}

camera {
   perspective
   location <0, 7, -25>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.33333, 0, 0>
   up <0, 1, 0>
   look_at <0, 7, 0>
   angle 45
}

object {
   Tree

   pigment {
      color rgb <0.980392, 0.980392, 0.980392>
   }
   scale 1
   rotate y*60
   translate <0, 0, 0>
}'''

								
#generic()
#quaking_aspen()
#ca_black_oak()
#splitting()
surrealistic()

#povraytest()


