#!/usr/bin/perl -w

# Erzeugt zufllig verteilte Tropfen.
# Winkelabweichung von der Geraden entspr.
# Normalverteilung. Streubreite kann durch
# $n beeinflusst werden

my @tropfen = ();

# Randomseed (festlegen wg. Wiederholbarkeit)
srand(13);

# Anzahl Tropfen
$cnt=3000;

# Maximale Entfernung vom Ursprung
$dist=1;

# Maximaler Abweichwinkel
$angle = 120;

# Tropfengre und Abweichung von Kugel in %
$rad = 0.001;
$deform = 0.2;
$scale = 4; # Verlngerung in Flugrichtung

# Streuung der Verteilung
$n = 10; # kleine Zahl = breite Streuung, groe Zahl = kleine Streuung

# Tropfen zufllig generieren
for ($j=0; $j<$cnt; $j++) {

    # Zufallszahl zw. 0 und 1 aus Summanden erzeugen
    # Hufigkeitsmaximum bei 0.5
    my $sum1=0;
    for ($i=0; $i<$n; $i++) {
       $sum1 += rand(1/$n);
    }
    my $sum2=0;
    for ($i=0; $i<$n; $i++) {
       $sum2 += rand(1/$n);
    }

    # Tropfen erzeugen
    my $tropfen = [
	rand($dist), # Entfernung vom Austritt 0..1
        ($sum1-0.5)*$angle, # Abweichwinkel y von Gerade
        ($sum2-0.5)*$angle, # Abweichwinkel z von Gerade
	$scale-rand($deform), # Abweichung von Kugel in
	1-rand($deform), # Richtungen x,y,z
        1-rand($deform)];

    push @tropfen,$tropfen;
}

# Povray-Ausgabe

print "#declare Tropfen = union {\n";

foreach $t (@tropfen) {
    print " " x 5;
    print "sphere { 0,$rad scale ".pp([$t->[3],$t->[4],$t->[5]]);
    print " translate ".ps($t->[0])."*x rotate ".pp([0,$t->[1],$t->[2]])."}\n";
}

print " " x 5 . "}\n";


# Punkt id der Form <x,y,z> ausgeben
sub pp {
    my $point = shift;

    return "<".join(',',map{sprintf("%.03f",$_)} @$point).">";
}

# Zahl gerundet ausgeben
sub ps {
    my $n = shift;

    return sprintf("%.3f",$n);
}




