/*
   ----------------       Surrealism - IRTC Competition         ------------------------ 
   ----------------               discovery.pov                 ------------------------
   ----------------               31.August 2003                ------------------------
   ----------------       copyright by Norbert W. Kern          ------------------------
   ----------------      norbert-werner.kern@t-online.de        ------------------------ 
*/

#version 3.5;

#declare Save_Rad  = 1;  // 1=save rad; 2=load rad data; 0=no rad storing
#declare RAD       = 4;  // radiosity quality settings 0=out; 1=acceptable; 5=good
                
global_settings {
        #declare a_g = 1.4;
        assumed_gamma a_g
        max_trace_level 15
        noise_generator 2  
        #if(RAD > 0)
                radiosity {
                        #if (Save_Rad  = 1)
                                pretrace_start 0.08
                                pretrace_end   0.04/RAD
                                error_bound 2/RAD
                                low_error_factor 0.5
                        #else
                                pretrace_start 1
                                pretrace_end   1
                                error_bound 2/RAD
                                low_error_factor 0.5
                        #end 
                        count 30*RAD                                   
                        recursion_limit 1
                        nearest_count RAD      
                        gray_threshold 0  
                        minimum_reuse 0.015 
                        brightness 1      
                        adc_bailout 2/255
                        normal on
                        media on
                        #if (Save_Rad = 1)
                                save_file "pov.rad"
                        #else
                                #if (Save_Rad = 2)
                                        load_file "pov.rad" 
                                        always_sample off
                                #end
                        #end                           
                }
        #end
}        

#declare diff = 1;

#if (RAD > 0)
        #default {finish {ambient 0 diffuse diff*0.7}}
#end

#include "functions.inc"

//__________________________________________________________________________

camera {  
        location  <  13.098,  0.111,  1.969>
        direction <     0.0,    0.0, 1.6095> 
        sky       <-0.00673,0.34135,0.93991> 
        up        <     0.0,    0.0,    1.0> 
        right     < 1.33333,    0.0,    0.0> 
        look_at   <  -4.039, -0.409,  0.936>
}

light_source {
        <10000,-20000,15000> 
        color rgb 5   
} 
   
//__________________________________________________________________________

#declare moonHF   = 1;
#declare mars     = 1;
#declare stars    = 1;
#declare martians = 1;
#declare moon     = 1;
#declare venus    = 1;   
//__________________________________________________________________________

#if (moonHF = 1)

#declare moon_tex =
texture {  
        pigment {rgb 0.7}
        normal {
                average
                normal_map {
                        [       
                                bumps 0.7
                                warp {turbulence 1}
                                scale 0.001
                        ]
                        [
                                bumps 0.5
                                warp {turbulence 0.5}
                                scale 0.000005
                        ]
                }
        }
        finish {ambient 0 diffuse 0.24}
        scale 0.05
} 

object {  
        height_field {
                tga "moon"
                water_level 0.0
                smooth
        }
        rotate <-90,0,0> 
        scale <2,2,-2> 
        translate <-1,-1,-1> 
        scale <10,10,2>
        rotate -3*y
        translate <0.511301,-0.965913,-1.532159>
        texture {moon_tex}
}

#declare RX=1;
#declare RY=0.5;
#declare hfscalx = 1;
#declare hfscaly = 0.2;
#declare hfscalz = 1;

#declare stone1 = 
isosurface{
        function{
                f_sphere (x,y,z,RY)
                +f_granite (x*0.3,y*0.3,z*0.3)*0.4*0.5
                -f_granite (x*0.05,y*0.05,z*0.05+RX)*0.5
        }
        contained_by {sphere{0,RY*2}}
        max_gradient 3
        accuracy 0.0001     
        scale 0.004
}

#declare stone2 = 
isosurface{
        function{
                f_sphere (x,y,z,RY)
                +f_granite (x*0.3,y*0.3,z*0.3)*0.4*0.5
                -f_granite (x*0.05,y*0.05,z*0.05+RX+1)*0.5
        }
        contained_by {sphere{0,RY*2}}
        max_gradient 3
        accuracy 0.0001     
        scale 0.001
}

#declare st = seed(0);
union {
        #include "stone3l.inc"
        #include "stone4.inc"
        scale <1/hfscalx,1/hfscaly,1/hfscalz>
        rotate <-90,0,0> 
        scale <2,2,-2> 
        translate <-1,-1,-1>
        scale <10,10,2>
        rotate -3.0*y
        translate <0.511301,-0.965913,-1.532159>
        texture {moon_tex}
}
#end

//__________________________________________________________________________

#if (mars = 1)                   
#declare topo = 
function {
        pigment {
                image_map {
                        png "MarsTopogross2" map_type 1 interpolate 2 
                }
        }
} 

#declare fac = 1.6; 
isosurface { 
        function {f_sphere (x,y,z,1)-topo (x,y,z).gray*0.0141}
        contained_by {sphere{0,1.1}}
        accuracy 0.00001
        max_gradient 6
        texture {     
                pigment {
                        image_map {png "mars_tex3" map_type 1 interpolate 2}
                } 
                finish {diffuse 0.35 ambient 0}
        }
        rotate y*180
        rotate <-70,-70,40>
        rotate <0,-3.7,3.7> 
        scale 101
        translate <-195.682019,31.503718,43.286052>
} 

#declare athmosphere = 
material {   
        texture  {      
                pigment  {color rgbt 1}
        }   
        interior { 
                media {
                        emission rgb <0.5,0.23,0.06>*0.9
                        density {
                                spherical 
                                color_map {
                                        [0      rgb 0.00]
                                        [0.9859 rgb 0.15]
                                }
                        }
                }
        }
}

sphere {  
        <0,0,0>,1
        material {athmosphere}
        hollow
        rotate <90,40,20> 
        scale 105
        translate <-195.682019,31.503718,43.286052>
}
#end

//__________________________________________________________________________

#if (stars = 1) 
#declare star_count = 100000; 
#declare star_scale = 0.15; 
#include "GALAXY.SF"   

#include "colors.inc" 
#include "skies.inc" 

#declare camera_location   = < 13.098,   0.111,    1.969>; 
#declare camera_sky        = <-0.00673,  0.34135,  0.93991>; 
#declare camera_look_at    = <-4.039,   -0.409,    0.936>;
#end            

//__________________________________________________________________________

#if (martians = 1)            
#include "tripod.inc"   
   
object {Marsian scale 0.005 rotate <0.8,-0.5,-79> translate <4.21,1.24,1.72>}                
object {Marsian scale 0.005 rotate <16,-16,-119> translate <8.1,0.63,3>}
#end

//__________________________________________________________________________

#if (moon = 1)
#include "bac2048.inc"

#declare phobos_tex =    
texture {
        pigment {image_map {tga "phobosgross" map_type 1 interpolate 2}}  
        normal {bump_map {tga "phobosgross"  map_type 1 interpolate 2 bump_size 9}}
        finish {diffuse 0.3 ambient 0 specular 0.02 roughness 0.15} 
}

   
object { 
        _default           
        scale <0.5,1,1>*40
        texture {phobos_tex}   
        rotate <27+13,23+14,-48-13>
        translate <-564,-200,-17>    
}
#end                                             

//__________________________________________________________________________

#if (venus = 1)
#macro G(Color,g)
        rgb <pow(Color.x,g),pow(Color.y,g),pow(Color.z,g)>
#end 

#declare Gamma = 1.1/a_g;
        
#declare metal =
texture{
        pigment {color G(<0.2,0.1,0.05>,Gamma)} 
        finish {
                ambient 0
                brilliance 2
                diffuse 0.3
                metallic
                specular 0.80
                roughness 0.05
        }
        normal {
                average
                normal_map{
                        [dents 3 scale 0.015]
                        [granite 0.5 scale 0.03]
                }
        }
        scale 0.3
}

#declare patina =
texture {
        pigment {color G(<0.1,0.5,0.35>,Gamma)} 
        finish {diffuse 0.22 ambient 0}
        normal {granite 1 scale 0.01}
        normal{
                average
                normal_map{
                        [dents 3 scale 0.015]
                        [granite 0.5 scale 0.03]
                }
        }
}

#declare Tex=
texture {
        image_pattern {png "venus_map_" interpolate 2}
        translate -0.5 scale 20
        texture_map{
                [0.6 patina]
                [1   metal]
        }
  
}

#declare RX=1;
#declare RY=0.5;

#declare stoneVenus = 
isosurface{
        function{
                f_sphere (x,y,z, RY)
                +f_granite (x*0.3,y*0.3,z*0.3)*0.4
                -f_granite (x*0.05,y*0.05,z*0.05+RX)
        }
        contained_by{sphere{0,RY*2}}
        max_gradient 3     
        scale 0.015
}

#include "venus_mesh.inc"
#include "transforms.inc"

#declare venus =
union {
        object {venusMesh rotate -30*y texture{Tex}}
        union {
                #include "stoneVenus3.inc"
                texture {  
                        pigment {rgb 0.7}
                        normal {
                                average
                                normal_map {
                                        [       
                                                bumps 0.7
                                                warp {turbulence 1}
                                                scale 0.001
                                        ]
                                        [
                                                bumps 0.5
                                                warp {turbulence 0.5}
                                                scale 0.000005
                                        ]
                                }
                        }
                        finish {ambient 0 diffuse 0.3}
                        scale 2.8
                }
        }
}

object {
        venus
        scale <-1,1,1>*0.37
        Reorient_Trans (<0,5,-35>,<13.098+4.039,0.111+0.409,1.969-0.936>)
        rotate x*60
        rotate y*-15
        rotate x*10
        translate <-5.6,-1.9,-2.3>        
}
#end


