// ========================================
// Example 1 for the MadPipe macro
// by Gilles Tran (c) 2000
// ----------------------------------------
// Run the example with -h512 -w384 (vertical format)
// and -UV -UL (if the light buffers make the disk swap like crazy)
// ----------------------------------------
#version 3.1;
#include "colors.inc"
// ----------------------------------------
#declare PdV=<0,100,-400>;
#declare PdA=<-5,0,10>;
camera{location  PdV  direction 2.*z  right 0.75*x up y sky <0,1,0> look_at   PdA}

//-----------------------------------------
// Lamps
//-----------------------------------------
#declare colLum1=rgb<0.5,0.95,1.3>;
#declare colLum2=rgb<1,0.5,0.2>;
light_source{PdV color colLum1*0.5}
#declare LumLampCage=light_source{PdV color colLum1*2 fade_distance 100 fade_power 2}

//-----------------------------------------
// Texture
//-----------------------------------------
#declare colPipe=rgb<1,0.8,0.7>;
#declare txtPipe=texture{pigment{colPipe*0.8} finish{metallic brilliance 7 ambient 0.01 specular 1 roughness 0.005}}

//-----------------------------------------
// Decorations (must be declared before)
//-----------------------------------------
#declare nDeco=7;
#declare Deco=array[nDeco]
#include "pipedeco.inc"
//#include "pipedeco0.inc" // (test decorations = spheres)

//-----------------------------------------
// Pipes
//-----------------------------------------
#declare yCage=80;  // all pipes are contained in a box of same height

#include "madpipe.inc"
#declare nPipe=200; // all pipes have the sampe number of elements
#declare dPipe=0; // 3D pipes (dPipe=1 = 2D pipes on the x-y plane)

#declare rPipe=1.5;
#declare lPipe=14; 
#declare box_container=<21,yCage,30>;  
#declare box_hole=<0,0,0>;//box_container*0.3;  
#declare Pipe_1=object{MadPipe(rPipe,lPipe,nPipe,dPipe,box_container,box_hole,3,13,true,"pipe_1.inc") }


#declare rPipe=1.2;
#declare lPipe=15;
#declare box_container=<25,yCage,8>;  
#declare box_hole=box_container*0.3;  
#declare Pipe_2=object{MadPipe(rPipe,lPipe,nPipe,dPipe,box_container,box_hole,2,20,true,"pipe_2.inc") }           

#declare rPipe=1;
#declare lPipe=13;        
#declare box_container=<27,yCage,6>;  
#declare box_hole=box_container*0.3;  
#declare Pipe_3=object{MadPipe(rPipe,lPipe,nPipe,dPipe,box_container,box_hole,2,30,true,"pipe_3.inc") }           

#declare rPipe=0.6;
#declare lPipe=6;
#declare box_container=<30,yCage,8>;  
#declare box_hole=box_container*0.3;  
#declare Pipe_4=object{MadPipe(rPipe,lPipe,nPipe,dPipe,box_container,box_hole,1,53,true,"pipe_4.inc") }           

#declare rPipe=0.5;
#declare lPipe=7;
#declare box_container=<29,yCage,10>;  
#declare box_hole=box_container*0.3;  
#declare Pipe_5=object{MadPipe(rPipe,lPipe,nPipe,dPipe,box_container,box_hole,1,54,true,"pipe_5.inc") }           


//-----------------------------------------
// Pipe placement
// once the pipes are created, just include the files (no need to call the macro)
//-----------------------------------------

#declare Cage=union{
        #include "Pipe_1.inc"
        /*#include "Pipe_2.inc"
        #include "Pipe_4.inc"
        #include "Pipe_5.inc"*/
        texture{txtPipe}
        }
        
union{           
//        cylinder{-yCage*2*y,y*yCage,25 pigment{colWall}}
        object{LumLampCage translate <-10,yCage*0.5,-35>}
        object{LumLampCage translate <-10,-yCage*0.4,-35>}
        
        object{Cage}
        //object{Cage scale -0.9 rotate y*-90}
        rotate y*-45                                  
}



light_source{<-1400,300,-2000> color colLum2*2}
light_source{<-540,100,-100> color colLum1*3}

