global_settings {assumed_gamma 1}

#include "metals.inc"

#declare Finish =
finish {diffuse 0.6 ambient 0}

#declare Clear =
texture{
        pigment {color rgb <0.2,0.1,0.05>} 
        finish {
                ambient 0
                brilliance 2
                diffuse 0.3
                metallic
                specular 0.80
                roughness 1/20
                //reflection 0.1
        }
        normal {
                average
                normal_map{
                        [dents 3 scale 0.015]
                        [granite 1 scale 0.03]
                }
        }
}

#declare Grime =
texture {
        pigment {color rgb <0.1,0.5,0.35>} 
        finish {diffuse 0.22 ambient 0}
        normal {granite 1 scale 0.01}
        normal{
                average
                normal_map{
                        [dents 6 scale 0.015]
                        [granite 1 scale 0.03]
                }
        }
}

#declare Tex=
texture {
        image_pattern {png "venus_map_.png" interpolate 2}
        translate -0.5 scale 20
        texture_map{
                [0.6 Grime]
                [1 Clear]
        }
  
}

#include "venus_mesh.inc"

#declare X=
object {venusMesh rotate -30*y texture{Tex}}

object{X}

light_source{
        <0,0,-30>
        rgb<1,0.8,0.4>*4
        spotlight radius 1 falloff 15 tightness 5 point_at 0
        //fade_power 2 fade_distance 5
        area_light 5*x,5*y,8,8 jitter adaptive 0
        rotate 75*x
        rotate 40*y
  
}

light_source{
        <0,0,-100>
        rgb<0.6,0.9,1>*0.6
        spotlight radius 1 falloff 15 tightness 1 point_at 0
        area_light 5*x,5*y,8,8 jitter adaptive 0
        rotate 30*y
}

light_source{
        <0,0,-30>
        rgb<1,1,0.95>*2
        spotlight radius 1 falloff 30 tightness 5 point_at 0
        area_light 5*x,5*y,8,8 jitter adaptive 0
        rotate 30*x
        rotate -30*y
}

camera{
        location  <0, 5,-35>
        direction <0, 0, 1.5>
        up        <0, 1, 0>
        right     <1, 0, 0>
        look_at 0
} 



