global_settings {assumed_gamma 1}

light_source {
        <10000, -20000, 15000> 
        color rgb 5//4   
}

camera {  
        location  <  13.098,  0.111,  1.969>
        direction <     0.0,    0.0, 1.6095> 
        sky       <-0.00673,0.34135,0.93991> 
        up        <     0.0,    0.0,    1.0> 
        right     < 1.33333,    0.0,    0.0> 
        look_at   <  -4.039, -0.409,  0.936>
}

//__________________________________________________________________________

#declare Clear =
texture{
        pigment {color rgb <0.2,0.1,0.05>} 
        finish {
                ambient 0
                brilliance 2
                diffuse 0.3
                metallic
                specular 0.80
                roughness 1/20
                //reflection 0.1
        }
        normal {
                average
                normal_map{
                        [dents 3 scale 0.015]
                        [granite 1 scale 0.03]
                }
        }
        scale 0.1
}

#declare Grime =
texture {
        pigment {color rgb <0.1,0.5,0.35>} 
        finish {diffuse 0.22 ambient 0}
        normal {granite 1 scale 0.01}
        normal{
                average
                normal_map{
                        [dents 6 scale 0.015]
                        [granite 1 scale 0.03]
                }
        }
}

#declare Tex=
texture {
        image_pattern {png "venus_map_.png" interpolate 2}
        translate -0.5 scale 20
        texture_map{
                [0.6 Grime]
                [1   Clear]
        }
  
}

#include "venus_mesh.inc"
#include "transforms.inc"

#declare venus=
object {venusMesh rotate -30*y texture{Tex}}

object {
        venus
        scale <-1,1,1>*0.4
        Reorient_Trans(<0,5,-35>,<13.098+4.039,0.111+0.409,1.969-0.936>)
        rotate x*60
        rotate y*-15
        rotate x*0        
}



