#include "fgrass1.inc"
#include "fgrass2.inc"

#declare Water = material {
           texture {
             pigment { color rgbf <.8,.8,.8,.6>}    
             finish {
               ambient 0.0
               diffuse 0.0
               reflection {
                            0.1, 1.0
                            fresnel on
                           }
               specular 0.4
               roughness 0.003
             }
           }
           interior {
             ior 1.3
           }
         }


#declare T_Ground=
texture {
  pigment {
    crackle metric 1 form<0.8,0,0> 
    color_map {
      [0.0 color Gray90 * .8  ] //DarkTan
      [0.5 color DarkGreen * .5  ] 
      [1.0 color DarkBrown   ]
    }
    scale 50   //200
    warp { turbulence 1.2 }
  }
  finish {ambient <0.8, 0.9, 1.4>*0.65  //35
         }

  normal {
          granite .5
          scale 5000
  }
} 

#declare T_Ground1=
texture {
  pigment {
    crackle metric 1 form<0.8,0,0> 
    color_map {
      [0.0 color Black  ] //DarkTan
      [0.5 color DarkGreen * .5  ] 
      [1.0 color DarkBrown   ]
    }
    scale 100   //200
    warp { turbulence 0.5 }
  }
  finish {ambient <0.8, 0.9, 1.4>*0.65  //35
         }

  normal {
          granite .5
          scale 50000 
  }
}
 


#declare T_Rock=
texture {
  pigment {
    agate
    color_map {
      [0.2 color rgb <0.55, 0.50, 0.40> ]  
      [0.6 color rgb <0.75, 0.50, 0.50> ]  
      [1.0 color rgb <0.70, 0.60, 0.50> ]  
    }
    scale 10
    warp { turbulence 0.5 }
  }
  finish {ambient <0.8, 0.9, 1.4>*0.65  //35
          diffuse 1
          specular .01 roughness 1
          diffuse 0.2
         }

  normal {
          granite 0.6
          scale 10 //0.1
  }
  scale 1/40
} 

  
#declare Terrain=
            height_field {
            tga "Land1.tga" 
            smooth
            rotate y*10
            scale <2000 * Feet,190 * Feet,4000 * Feet> * 1   
            translate<-1200 * Feet,20 * Feet,0 * Feet>  
          }                                       

   
object {
  Terrain  
   texture {  
             slope {<0,-1,0>,0,0.5}   
             texture_map {
                          [0.00  T_Ground]
                          [0.12  T_Ground]
                          [0.12  T_Ground1]
                          //[0.25  T_Ground1]
                          [0.22  T_Rock scale 1000]  //500
                          [0.30  T_Stone10 scale 500 ]
                          [1.0  T_Stone10 scale 500 ]    
                         } 
   }
}

//Lake
sphere{<0,0,0>,1
  material{Water}
  normal{ bozo scale 100}
  scale <200 * Feet, 80 * Feet, 250 * Feet>
  translate <20 * Feet,50 * Feet,500 * Feet>
}

#declare Pagoda1 = 
              
  difference{
       sphere{<0,0,0>,50 }    
       #local Theta = 0;
       #while(Theta<359)
          sphere{<45 * cos(Theta*pi/180),20,45 * sin(Theta*pi/180)>,50} 
          #local Theta = Theta + 60;    
       #end
       box {  <-1, -1, -1>, <1, 1, 1>
              scale <55, 50, 55>          
              translate<0,40,0>
           }
       box {  <-1, -1, -1>, <1, 1, 1>
              scale <55, 10, 55>
              translate<0,-50,0>
           }
       cutaway_textures
       scale<1,1.5,1>
  }

#declare Posts=
   union{
       #local Theta = 30;
       #while(Theta<389)
          cylinder{0*y,30*y,2
                   translate<35 * cos(Theta*pi/180),-70,35 * sin(Theta*pi/180)>
                   material{BuildingTex}
          } 
          #local Theta = Theta + 60;    
       #end
   }
  
#declare Pagoda2=    
   difference{                  
      #object{Pagoda1}
      #object{Pagoda1 translate<0,-2,0>}
      pigment{ gradient y 
               pigment_map{
                           [0 Red]
                           [.6 Gray40]
                           [1 Gray40]
                          } scale 35 translate<0,22,0>
              } 
    finish {
      ambient .2
      diffuse .6
      phong .4
      phong_size 100
    }

      
   }                          

#declare Pagoda3 =
union{ #object {Pagoda2 scale <1,.5,1> }
       #object{Posts translate<0,18,0>}
       translate<0,-50,0>
}

#declare Pagoda4=
union{ #object{Pagoda2}
       #object{Posts}                                            
       #object{Pagoda3}

        #object{Isosfc2 
                material{BuildingTex}
                scale <40,2 ,40>
                translate <0 , -100, 0 >
        }
       
       scale <.2,.26,.2>  * Feet  //.2 * Feet
       translate<90 * Feet,134.3 * Feet,300 * Feet>  //best
}

#object{Pagoda4}
  
     
object {#declare web_type = 2;
        #declare web_radius =          8;    //Sets the overall radius of the web
        #declare web_spokes_count=      20;    //Sets the number of spokes in the web
        #declare web_circles_count=     15;    //Sets the number of circles in the web
        #declare web_circles_radius=    8;    //Sets the overall radius of the web circles
        #declare thread_thickness=      0.04; //Sets the thickness of the web thread
        #declare thread_tightness=      0.5;  //Sets the tightness of the web circles
        #declare web_seed=              0;    //Sets the random seed used to create the web
        #declare web_spokes_turb=       0.3;  //Sets the randomness of the web spokes
        #declare web_circles_turb=      0.5;  //Sets the randomness of the web circles
        #include "SPWeb.inc"
        scale .55 * Feet 
        rotate<50,90,0>
        texture {pigment {rgbt <1, 1, 1, .5>}}
        finish{ambient .3 diffuse .5}
        translate <-15 * Feet, 216.5 * Feet, -10 * Feet>
} 
 

#macro Trace_It (Start, Object, Offset)  
    #local Norm = <0, 0, 0>;
    #local Pos = trace (
                  Terrain,     // object to test
                  Start,           // starting point
                  y,              // direction
                  Norm );          // normal
    #if (vlength(Norm)!=0)   // if intersection is found, normal differs from 0
        object {
          Object
          translate Pos + <0,Offset,0>
        }
    #end 
#end
  
#if(TREES) 
#declare N = 1;       
#while (N < 1500)
                   
            #if (rand(R1) > 0.4)
            Trace_It(<(-300 + (400 * rand(R1))) * Feet,
               0 * Feet,
               (500 - (440 * rand(R1))) * Feet>,    //300 - 240
               #object{Grass 
                       rotate<0,rand(R1) * 180,0> 
                       scale <(.15 + (.05 * rand(R1))) * Feet,
                             (.2 - (.08 * rand(R1))) * Feet,
                             (.15 + (.05 * rand(R1))) * Feet>
                       finish{ambient .8 diffuse .4}},
                       0
               ) 
               
            #else
            Trace_It(<(-300 + (400 * rand(R1))) * Feet,
               0 * Feet,
               (300 - (240 * rand(R1))) * Feet>, 
               #object{Grass1 
                       rotate<0,rand(R1) * 180,0> 
                       //scale <.1,.2,.1> * Feet 
                       scale <(.07 + (.05 * rand(R1))) * Feet,
                             (.2 - (.05 * rand(R1))) * Feet,
                             (.07 + (.05 * rand(R1))) * Feet>
                       finish{ambient .4 diffuse .4}},
                       0
               ) 
            #end
  #declare N = N + 1;
          
#end 
 
 
#include"DOHMaplem.inc" 
  
#declare R1 = seed(5674);

Trace_It(<110 * Feet,
           0 * Feet,
           300 * Feet>, 
           #object{MAPLE 
                   scale 30 * Feet 
                   rotate<0,45,0> 
                   finish{ambient .8 diffuse .4}}, 
           0
        ) 

#local N = 1;
#while (N<1000)
     #local TreeScale = (250+(rand(R1) * 800));
     Trace_It(<(200+(rand(R1) * 400)) * Feet,     
               0 * Feet,
               TreeScale * Feet>, 
               #object{MAPLE
                       rotate<0,rand(R1) * 180,0>
                       scale (30 - (TreeScale * .03)) * Feet    //5
                       finish{ambient .8 diffuse .4}}, 
               0             
             ) 
     #local N = N + 1;
#end

#include"DOHWillowm.inc" 

//around right Lake 
Trace_It(<150 * Feet,
           0 * Feet,
           550 * Feet>, 
           #object{WILLOW 
                   scale 20 * Feet 
                   rotate<0,45,0> 
                   finish{ambient .8 diffuse .4}}, 
           0
        ) 
Trace_It(<155 * Feet,
           0 * Feet,
          500 * Feet>, 
           #object{WILLOW 
                   scale 20 * Feet 
                   rotate<0,45,0> 
                   finish{ambient .8 diffuse .4}}, 
           0
        ) 
Trace_It(<160 * Feet,
           0 * Feet,
           450 * Feet>, 
           #object{WILLOW 
                   scale 20 * Feet 
                   rotate<0,45,0> 
                   finish{ambient .8 diffuse .4}}, 
           0
        )
Trace_It(<160 * Feet,
           0 * Feet,
           410 * Feet>, 
           #object{WILLOW 
                   scale 20 * Feet 
                   rotate<0,45,0> 
                   finish{ambient .8 diffuse .4}}, 
           0
        )      

//around right lake

Trace_It(<30 * Feet,
           0 * Feet,
           410 * Feet>, 
           #object{WILLOW 
                   scale 20 * Feet 
                   rotate<0,45,0> 
                   finish{ambient .8 diffuse .4}}, 
           3 * Feet
        ) 

Trace_It(<50 * Feet,
           0 * Feet,
           380 * Feet>, 
           #object{WILLOW 
                   scale 20 * Feet 
                   rotate<0,9,0> 
                   finish{ambient .8 diffuse .4}}, 
           3 * Feet
        )  



#include"DOHLindenm.inc" 
        
//Fire tree

#declare R1 = seed(44956);

#local N = 1;
#while(N<15)   
     Trace_It(<(-140+(rand(R1)*150)) * Feet,
                0 * Feet,
                (300+(rand(R1)*200)) * Feet>, 
                #object{LINDEN 
                        scale <(40 - (20 * rand(R1))) * Feet,  //<40 * Feet, 30 * Feet, 40 * Feet> 
                               (30 - (15 * rand(R1))) * Feet,
                               (40 - (20 * rand(R1))) * Feet>
                        rotate<0, 180 * rand(R1),0>}, 
                        0
             ) 
     #local N=N+1;
#end
#end //if 

        
  