//////////////////////////////////////////////////////////////////////////
// Hinge.inc  Copyright(c) 2003, K.E. Ayers Designs                     //
//////////////////////////////////////////////////////////////////////////
// Defines one of the door's hinges.                                    //
//////////////////////////////////////////////////////////////////////////

// This file should only be included once!
#ifndef (_Hinge_Inc_)
#declare _Hinge_Inc = true;

#include "SceneConstants.inc"
#include "Textures.inc"


// Define the hinges ... keep it simple, for now;
// we'll add more detail later.

#declare HingePlateHgt          = 4;
#declare HingePlateWid          = DoorThick - 0.25;
#declare HingePlateThick        = 1/8;
#declare HingePinBarrelRad      = 3/16;
#declare HingePinBarrelSections = 5;
#declare HingePinSectionSep     = HingePlateHgt / HingePinBarrelSections;
#declare HingePinSectionHgt     = HingePinSectionSep - 1/16;
#declare HingePinCapThick       = 1/8;

#declare ScrewHeadRad           = 3/16;
#declare ScrewBodyRad           = 1/16;
#declare ScrewHeadThick         = HingePlateThick;
#declare ScrewHeadYOfs          = HingePlateHgt / 3;
#declare ScrewHeadZOfs          = HingePlateWid / 3;

#declare ScrewHeadShape =
cone {
    < 0, 0, 0 >, ScrewHeadRad,
    < ScrewHeadThick, 0, 0 >, ScrewBodyRad
}

#declare ScrewHolePunch =
object {
    ScrewHeadShape
    scale 1.3
    translate < -1/64, 0, 0 >
}

#declare PhillipsHeadPunch =
union {
    box {
        < -0.1, -1/32, -ScrewHeadRad * 0.75 >,
        <  ScrewHeadThick / 2, 1/32, ScrewHeadRad * 0.75 >
    }
    box {
        < -0.1, -ScrewHeadRad * 0.75, -1/32 >,
        <  ScrewHeadThick / 2, ScrewHeadRad * 0.75, 1/32 >
    }
}

#declare ScrewHead =
difference {
    object { ScrewHeadShape }
    object { PhillipsHeadPunch }
    texture { PolishedBrass }
}

#declare ScrewHeads =
union {
    object { ScrewHead translate < 0,  ScrewHeadYOfs, -ScrewHeadZOfs > }
    object { ScrewHead translate < 0,              0, -2 * ScrewHeadZOfs > }
    object { ScrewHead translate < 0, -ScrewHeadYOfs, -ScrewHeadZOfs > }
    translate < -1/32, 0, 0 >
}

#declare ScrewHolePunches =
union {
    object { ScrewHolePunch translate < 0,  ScrewHeadYOfs, -ScrewHeadZOfs > }
    object { ScrewHolePunch translate < 0,              0, -2 * ScrewHeadZOfs > }
    object { ScrewHolePunch translate < 0, -ScrewHeadYOfs, -ScrewHeadZOfs > }
}

#declare HingePlateShape =
box {
    < 0, -HingePlateHgt / 2, 0 >,
    <  HingePlateThick,  HingePlateHgt / 2,  -HingePlateWid >
}

#declare HingePlate =
union {
    difference {
        object { HingePlateShape }
        object { ScrewHolePunches }
    }
    object { ScrewHeads }
}

#declare HingePinBarrelSection =
cylinder {
    < 0, -HingePinSectionHgt / 2, 0 >,
    < 0,  HingePinSectionHgt / 2, 0 >,
    HingePinBarrelRad
}

#declare HingePinCap =
cylinder {
    < 0, 0, 0 >,
    < 0, HingePinCapThick, 0 >,
    HingePinBarrelRad + 1/128
}

#local Sec = 0;
#local Pos = 0;

#declare HingePin =
union {
    #while (Sec < HingePinBarrelSections)
        #if (Sec = 0)
            object { HingePinBarrelSection }
            #local Pos = HingePinSectionSep;
        #else
            object { HingePinBarrelSection translate < 0,  Pos, 0 > }
            object { HingePinBarrelSection translate < 0, -Pos, 0 > }
            #local Pos = Pos + HingePinSectionSep;
        #end

        #local Sec = Sec + 2;
    #end
    object {
        HingePinCap
        translate < 0, HingePlateHgt / 2, 0 >
    }
    object {
        HingePinCap
        scale < 1, -1, 1 >
        translate < 0, -HingePlateHgt / 2, 0 >
    }
}

#declare Hinge =
union {
    object {
        HingePlate
        translate < 1/64, 0, 0 >
    }
    object {
        HingePlate
        scale < -1, 1, 1 >
        translate < -1/64, 0, 0 >
        rotate < 0, -DoorOpenAngle, 0 >
    }
    object { HingePin }
    texture { PolishedBrass }
}

#declare Hinges =
union {
    object { Hinge }
    object { Hinge translate < 0, -DoorHgt * 3/8, 0 > }
    object { Hinge translate < 0,  DoorHgt * 3/8, 0 > }
    translate < -1/16, 0, HingePinBarrelRad >
}

#end    // _Hinge_Inc_

