//////////////////////////////////////////////////////////////////////////
// Mountains.inc  Copyright(c) 2003, K.E. Ayers Designs                 //
//////////////////////////////////////////////////////////////////////////
// This file creates the distance mountain range used in the scene.     //
//////////////////////////////////////////////////////////////////////////

// This file should only be included once!
#ifndef (_Mountains_Inc_)
#declare _Mountains_Inc_ = true;

#include "SceneConstants.inc"
#include "Textures.inc"


#local MountainTexture =
texture {
    pigment {
        gradient y turbulence 0.3
        color_map {
            [ 0.0   color rgb < 0.3, 0.5, 0.1 > ]
            [ 0.01  color rgb < 0.3, 0.5, 0.1 > ]
            [ 0.05  color rgb < 0.5, 0.5, 0.5 > ]
            [ 0.2   color rgb < 0.5, 0.5, 0.5 > ]
            [ 0.4   color rgb < 0.4, 0.4, 0.5 > ]
            [ 0.7   color rgb < 1.0, 1.0, 1.0 > ]
            [ 1.5   color rgb < 1.0, 1.0, 1.0 > ]
        }
    }
    //finish { ambient 1 diffuse 0 }
    finish { ambient Ambient diffuse Diffuse }
}


#declare MountainShape =
height_field { gif "Mountain.gif" translate < -0.5, 0.0, -0.5 > }

#declare Rnd = seed(30011);

#declare XOFS = 0;
#declare ZOFS = 0;

#macro MoveMountain(XDir)
    #local   Scl  = 1.2 - rand(Rnd) * 0.8;
    #local   Ang  = 360 * rand(Rnd);
    #declare XOFS = 0.5 + XOFS;
    
    #if (ZOFS > 0)
        #local ZOfs = 0;
    #else
        #local ZOfs = 0.75;
    #end
    
    object {
        MountainShape
        rotate Ang * y
        scale < 1, Scl, 1 >
        translate < XOFS * XDir, 0, ZOFS >
        texture { MountainTexture }
    }
#end    // #macro MakeMountain


#declare MountainRange =
union {
    object { MountainShape texture { MountainTexture } }

    #local   Num    = 8;

    #declare XOFS   = 0;
    #declare ZOFS   = 0;
    #local   N      = 1;

    #while (N <= Num)
        object { MoveMountain(1)  }
        #local N = N + 1;
    #end

    #declare XOFS   = 0;
    #declare ZOFS   = 0;
    #local   N      = 1;

    #while (N <= Num)
        object { MoveMountain(-1)  }
        #local N = N + 1;
    #end
}

#end    // #ifndef (_Mountains_Inc_)

