//////////////////////////////////////////////////////////////////////////
// PorchLight.inc  Copyright(c) 2003, K.E. Ayers Designs                //
//////////////////////////////////////////////////////////////////////////
// This file constructs the lights at the side of the front door.       //
//////////////////////////////////////////////////////////////////////////

// This file should only be included once!
#ifndef (_PorchLight_Inc_)
#declare _PorchLight_Inc_ = true;

#include "Textures.inc"
#include "SceneConstants.inc"

#declare PorchLampRad       = 2.0;
#declare PorchLampLen       = 8.0;
#declare PorchLampThick     = 1/16;
#declare PorchLampBaseRad   = PorchLampRad;
#declare PorchLampBaseThick = 1/2;
#declare LightBulbRad       = PorchLampRad - 1/2;

#declare PorchLampTexture =
texture {
    pigment { BrassColor * 0.9 }
    finish {
        ambient     Ambient * 0.8
        diffuse     Diffuse
        specular    1.0
        roughness   0.1
        brilliance  2.0
        metallic
    }
    normal { ripples scale < 0.01, 0.01, 1.0 > }
}


#declare PorchLightColor    = color rgb < 0.3, 0.2, 0.1 >;


#declare PorchLampBase =
cylinder {
    < 0, 0, -PorchLampBaseThick >,
    < 0, 0, 0 >, PorchLampBaseRad
    texture { PorchLampTexture }
}

#declare PorchLampShadeShape =
cylinder {
    < 0, -PorchLampLen / 2, 0 >,
    < 0,  PorchLampLen / 2, 0 >,
    PorchLampRad }

#local RadScale = 1 / (1 + PorchLampThick);
#local BulbYOfs = -(PorchLampLen / 2) + (LightBulbRad * 1.5);
#local ZOfs     = -PorchLampRad - (PorchLampBaseThick * 2);
#local PointAtZ = ZOfs;

#declare PorchLampShade =
union {
    difference {
        object { PorchLampShadeShape }
        object {
            PorchLampShadeShape
            scale < RadScale, 1, RadScale >
            translate -PorchLampThick * y
        }
        
        #local A = 0;
        
        #while (A < 180)
            cylinder {
                    < 0, 0, -(PorchLampRad + .1) >,
                    < 0, 0,  (PorchLampRad + .1) >,
                    3/16
                    rotate A *y
                    translate BulbYOfs * y
            }
            #local A = A + 45;
        #end
        
        texture { PorchLampTexture }
    }
    light_source {
        < 0, BulbYOfs, 0 >
        color PorchLightColor
        looks_like {
            sphere { < 0, 0, 0 >, LightBulbRad }
            pigment { White }
            finish { ambient 1 diffuse 0 }
        }
    }
}


#declare PorchLight =
union {
    object { PorchLampBase }
    object {
        PorchLampShade
        translate < 0, (-PorchLampLen / 2) + (PorchLampBaseRad * 1.5), ZOfs >
    }
}


#end    // _PorchLight_Inc_