//////////////////////////////////////////////////////////////////////////
// SceneConstants.inc  Copyright(c) 2003, K.E. Ayers Designs            //
//////////////////////////////////////////////////////////////////////////
// This file defines the common constants used throughout the scene.    //
//////////////////////////////////////////////////////////////////////////

// This file should only be included once!
#ifndef (_SceneConstants_Inc_)
#declare _SceneConstants_Inc_ = true;


// These are the dimensions for the door.
#declare DoorWid                = 42;
#declare DoorHgt                = 80;
#declare DoorThick              = 2;


// The offsets to move the door into its proper position.
#declare DoorXOfs               = DoorWid / 2;
#declare DoorYOfs               = 0.0;
#declare DoorZOfs               = -DoorThick / 2;


#declare WallHgtAboveDoor       = 12;   // The extension above the door
#declare WallExt                = 52;   // The left/right wall extension
#declare SidingThick            = 1/2;

// The radius of our "sky dome".
#declare SceneSkyRad            = 60000;


#end    // _SceneConstants_Inc_

