//////////////////////////////////////////////////////////////////////////
// Shrubbery.inc  Copyright(c) 2003, K.E. Ayers Designs                 //
//////////////////////////////////////////////////////////////////////////
// This creates a flowering bush for around the steps, and a bushy      //
// shrub for beside the porch.                                          //
//////////////////////////////////////////////////////////////////////////

// This file should only be included once!
#ifndef (_Shrubbery_Inc_)
#declare _Shrubbery_Inc_ = true;

#include "Plants.inc"


//////////////////////////////////////////////////////////////////////////
// A flowering Impatien-like bush.                                      //
//////////////////////////////////////////////////////////////////////////

#declare FloweringBushHgt       = 5;
#declare FloweringBushStemLen   = 3;

#local LeafShapes =
array[4] { GreenLeaf, LightGreenLeaf, DyingLeaf, DeadLeaf }

#local FlowerShapes =
array[1] { object { RedImpatienFlower scale 0.4 } }

#declare FloweringBush =
object {
    LeafyBush
    (
        // StalkHeight
        FloweringBushHgt,
        // StalkBaseRad
        1/8,
        // StalkEndRad
        1/32,
        // StemHeight
        2,
        // StemLength
        FloweringBushStemLen,
        // StemLengthScale
        0.9,
        // StemRad
        1/16,
        // StemSpacing
        20,
        // StemAngle
        80,
        // StemAngleScale
        0.8,
        // LeafAngle
        70,
        // LeafAngleScale
        1.1,
        // Rings
        6,
        // RingStagger
        10,
        // TheLeaf
        LeafShapes,
        // TheFlower
        FlowerShapes,
        // FlowerFrequency
        0.25,
        // Slop
        0.30,
        // StalkTexture
        texture { pigment { color rgb < 0.2, 0.6, 0.3 > } }
    )
}


//////////////////////////////////////////////////////////////////////////
// A bushy shrub ... no flowers.                                        //
//////////////////////////////////////////////////////////////////////////

#declare BushyShrubHgt     = 15;
#declare BushyShrubStemLen = 5;

#local LeafShapes =
array[4]
{
    object { GreenLeaf      scale < 2,   1,   1 > },
    object { LightGreenLeaf scale < 2,   1,   1 > },
    object { DyingLeaf      scale < 1.7, 1,   1 > },
    object { DeadLeaf       scale < 1.7, 1,   1 > }
}

#local FlowerShapes = array[1] { GreenLeaf }

#declare BushyShrub =
object {
    LeafyBush
    (
        // StalkHeight
        BushyShrubHgt,
        // StalkBaseRad
        3/16,
        // StalkEndRad
        1/16,
        // StemHeight
        2,
        // StemLength
        BushyShrubStemLen,
        // StemLengthScale
        0.875,
        // StemRad
        3/32,
        // StemSpacing
        10,
        // StemAngle
        80,
        // StemAngleScale
        0.95,
        // LeafAngle
        70,
        // LeafAngleScale
        1.05,
        // Rings
        12,
        // RingStagger
        5,
        // TheLeaf
        LeafShapes,
        // TheFlower
        FlowerShapes,
        // FlowerFrequency
        0.0,
        // Slop
        0.40,
        // StalkTexture
        texture { pigment { color rgb < 0.2, 0.6, 0.3 > } }
    )
}


#end    // _Shrubbery_Inc_

