//////////////////////////////////////////////////////////////////////////
// Textures.inc  Copyright(c) 2003, K.E. Ayers Designs                  //
//////////////////////////////////////////////////////////////////////////
// This file defines the common textures and colors used in the scene.  //
//////////////////////////////////////////////////////////////////////////

// This file should only be included once!
#ifndef (_Textures_Inc_)
#declare _Textures_Inc_ = true;

#include "SceneConstants.inc"


// Since this is a dark scene, let's increase the ambient light.
#declare Ambient = 0.4;
#declare Diffuse = 0.7;


// Declare some common basic colors.
#declare Clear  = color rgbf < 1.0,  1.0,  1.0,  1.0  >;
#declare White  = color rgb  < 1.0,  1.0,  1.0  >;
#declare Black  = color rgb  < 0.0,  0.0,  0.0  >;
#declare Red    = color rgb  < 1.0,  0.0,  0.0  >;
#declare Green  = color rgb  < 0.0,  1.0,  0.0  >;
#declare Blue   = color rgb  < 0.0,  0.0,  1.0  >;
#declare Yellow = color rgb  < 1.0,  1.0,  0.0  >;


// The door will be white with a very light gray wood-grained texture.

#declare DoorColor      = color rgb< 1.0, 1.0, 1.0 >;
#declare DoorGrainColor = color rgb< 0.9, 0.9, 0.9 >;

#declare DoorTexture =
texture {
    pigment {
        wood
        turbulence 0.1
        color_map {
            [ 0.0   DoorColor ]
            [ 0.4   DoorColor ]
            [ 0.5   DoorGrainColor ]
            [ 0.6   DoorColor ]
        }
        rotate < 93,  0,   0 >
        translate < DoorWid / 2, DoorHgt / 2, 0 >
        scale DoorWid / 18
    }
    finish {
        ambient     Ambient
        diffuse     Diffuse
        specular    1.0
        roughness   0.001
    }
}


// The foundation is concrete block.

#declare MortarColor            = color rgb < 0.8, 0.8, 0.8 >;
#declare FoundationColor        = color rgb < 0.7, 0.7, 0.7 >;
#declare FoundationGrainColor   = color rgb < 0.5, 0.5, 0.5 >;

#declare BlockPigment =
pigment {
    granite
    turbulence 0.15
    color_map {
        [ 0.0   FoundationColor ]
        [ 0.4   FoundationColor ]
        [ 0.5   FoundationGrainColor ]
        [ 0.6   FoundationColor ]
    }
}

#declare FoundationTexture =
texture {
    pigment {
        brick pigment { MortarColor } pigment { BlockPigment }
        brick_size < 10, 6, 6 >
    }
    finish {
        ambient     Ambient
        diffuse     Diffuse
    }
}


// The wall has white siding.
#declare SidingTexture = texture { DoorTexture rotate < 0, 0, 90 > }

// The door's threshold strip will be brushed aluminum.

#declare AluminumColor = color rgb < 0.7, 0.7, 0.8 >;

#declare BrushedAluminum =
texture {
    pigment { AluminumColor }
    finish {
        ambient     Ambient
        diffuse     Diffuse
        specular    1.0
        roughness   0.1
        brilliance  4.0
        reflection  0.3
        metallic
    }
}


// The entry hallway will have an oak wood floor.

#declare LightOakColor   = color rgb < 0.9, 0.675, 0.45 >;
#declare OakColor        = color rgb < 0.8, 0.6,   0.4 >;
#declare OakGrainColor   = color rgb < 0.4, 0.3,   0.1 >;
#declare DarkOakColor    = color rgb < 0.3, 0.1,   0.05 >;
#declare DarkGrainColor  = color rgb < 0.7, 0.3,   0.1  >;


#declare FinishedLightOak =
texture {
    pigment {
        wood
        turbulence 0.15
        color_map {
            [ 0.0 LightOakColor ]
            [ 0.4 LightOakColor ]
            [ 0.5 OakGrainColor ]
            [ 0.6 LightOakColor ]
        }
    }
    finish {
        ambient     Ambient
        diffuse     Diffuse
        specular    1.0
        roughness   0.01
        reflection  0.1
    }
}

#declare FinishedOak =
texture {
    pigment {
        wood
        turbulence 0.15
        color_map {
            [ 0.0 OakColor ]
            [ 0.4 OakColor ]
            [ 0.5 OakGrainColor ]
            [ 0.6 OakColor ]
        }
    }
    finish {
        ambient     Ambient
        diffuse     Diffuse
        specular    1.0
        roughness   0.01
        reflection  0.1
    }
}


#declare FinishedDarkOak =
texture {
    pigment {
        wood
        turbulence 0.15
        color_map {
            [ 0.0 DarkOakColor ]
            [ 0.4 DarkOakColor ]
            [ 0.5 DarkGrainColor ]
            [ 0.6 DarkOakColor ]
        }
    }
    finish {
        ambient     Ambient
        diffuse     Diffuse
        specular    1.0
        roughness   0.01
        reflection  0.1
    }
}

#declare DoorFrameTexture = texture { FinishedDarkOak scale 1.25}


// All of the hardware will be shiny brass.

#declare BrassColor = color rgb < 1.0, 0.95, 0.6 >;

#declare PolishedBrass =
texture {
    pigment { BrassColor }
    finish {
        ambient     Ambient
        diffuse     Diffuse
        specular    1.0
        roughness   0.0001
        brilliance  4.0
        reflection  0.3
        metallic
    }
}

#declare SatinBrass =
texture {
    pigment { BrassColor }
    finish {
        ambient     Ambient
        diffuse     Diffuse
        specular    1.0
        roughness   0.01
        brilliance  2.0
        reflection  0.1
        metallic
    }
}

#declare BrushedBrass =
texture {
    pigment { BrassColor }
    finish {
        ambient     Ambient
        diffuse     Diffuse
        specular    1.0
        roughness   0.1
        brilliance  2.0
        metallic
    }
    normal { ripples scale < 0.01, 0.01, 1.0 > }
}



// The porch slab is concrete -- we'll try a faint granite
// pattern in similar shades of gray.

#declare PorchColor      = color rgb < 0.7, 0.7, 0.7 >;
#declare PorchGrainColor = color rgb < 0.8, 0.8, 0.8 >;

#declare PorchTexture =
texture {
    pigment {
        granite
        turbulence 0.15
        color_map {
            [ 0.0   PorchColor ]
            [ 0.4   PorchColor ]
            [ 0.5   PorchGrainColor ]
            [ 0.6   PorchColor ]
        }
    }
    finish {
        ambient     Ambient
        diffuse     Diffuse
        specular    1.0
        roughness   0.5
    }
    normal { dents 1.0 scale < 0.05, 0.05, 1.5 > }
}


#end    // _Textures_Inc_


