//////////////////////////////////////////////////////////////////////////
// Unicycle.inc  Copyright(c) 2003, K.E. Ayers Designs                  //
//////////////////////////////////////////////////////////////////////////
// This file creates a unicycle that is lying on its side in the yard.  //
//////////////////////////////////////////////////////////////////////////

// This file should only be included once!
#ifndef (_Unicycle_Inc_)
#declare _Unicycle_Inc_ = true;

#debug "\nParsing: Unicycle.inc\n"

#include "SceneConstants.inc"
#include "Textures.inc"


#declare WheelRad           = 8;

#local WheelWid             = 2;
#local WheelThick           = 1;
#local HubRad               = WheelRad * 0.25;
#local HubWid               = WheelWid * 1.5;

#local ForkBotThick         = 1/2;
#local ForkTopThick         = ForkBotThick * 2;
#local ForkBotWid           = 3/4;
#local ForkTopWid           = ForkTopThick * 2;
#local ForkLen              = WheelRad + WheelThick * 2;
#local ForkConnectorThick   = 1;

#local PedalLen             = 4;
#local PedalWid             = 2.5;
#local PedalThick           = 1;
#local PedalCrankLen        = WheelRad * 0.5;
#local PedalCrankWid        = 1;
#local PedalCrankThick      = 1/2;

#local SeatShaftRad         = 3/8;
#local SeatShaftLen         = WheelRad;
#local SeatLen              = 8;
#local SeatFrontWid         = 2;
#local SeatBackWid          = 6;


#local FrameTexture =
texture {
    pigment { Blue }
    finish {
        ambient     Ambient
        diffuse     Diffuse
        specular    1
        roughness   0.01
        metallic
        brilliance  2
        reflection  0.2
    }
}

#local TireTexture =
texture {
    pigment { Black }
    finish {
        ambient     Ambient
        diffuse     Diffuse
        specular    0.5
        roughness   0.1
    }
}


#local PedalBlock =
box {
    < 0,        -PedalThick / 2, -PedalWid / 2 >,
    < PedalLen,  PedalThick / 2,  PedalWid / 2 >
    texture { TireTexture }
}

#local PedalCrank =
union {
    cylinder {
        < 0, 0, 0 >,
        < ForkBotThick + PedalCrankThick + 1/32, 0, 0 >
        PedalCrankWid / 4
    }
    union {
        cylinder {
            < 0, 0, 0 >,
            < PedalCrankThick, 0, 0 >
            PedalCrankWid / 2
        }
        box {
            < 0, -PedalCrankLen, -PedalCrankWid / 2 >,
            < PedalCrankThick, 0, PedalCrankWid / 2 >
        }
        cylinder {
            < 0, -PedalCrankLen, 0 >,
            < PedalCrankThick, -PedalCrankLen, 0 >
            PedalCrankWid / 2
        }
        cylinder {
            < 0, -PedalCrankLen, 0 >,
            < PedalCrankThick + PedalLen + 5/8, -PedalCrankLen, 0 >
            PedalThick / 4
        }
        translate ForkBotThick * x
    }
    texture { BrushedAluminum }
}

#local Pedal =
union {
    object { PedalCrank }
    object {
        PedalBlock
        translate < ForkBotThick + PedalCrankThick + 1/2, -PedalCrankLen, 0 > }
}
    
#local RimRad = WheelRad - WheelThick * 0.4;

#local Wheel =
union {
    // Where the rubber meets the road!
    torus {
        WheelRad, WheelThick / 2
        scale < 1, WheelWid / WheelThick, 1 >
        rotate -90 * z
        texture { TireTexture }
    }
    // Chrome rims, Man!
    difference {
        cylinder {
            < -WheelWid * 0.3, 0, 0 >, 
            <  WheelWid * 0.3, 0, 0 >,
            RimRad
        }
        cylinder {
            < -WheelWid, 0, 0 >, 
            <  WheelWid, 0, 0 >,
            RimRad - WheelThick
        }
        texture { BrushedAluminum }
    }
    // The hub.
    cylinder {
        < -HubWid / 2, 0, 0 >,
        <  HubWid / 2, 0, 0 >,
        HubRad
        texture { BrushedAluminum }
    }
    // Cool spokes!
    #local Rot = 0;
    
    #while (Rot < 360)
        cylinder {
            < 0, 0, 0 >, < 0, WheelRad, 0 >, HubWid * 0.25
            scale < 0.5, 1, 1 >
            texture { BrushedAluminum }
            rotate Rot * x
        }
        #local Rot = Rot + 45;
    #end
    
    // Two pedals.
    object { Pedal translate (HubWid / 2) * x }
    object {
        Pedal
        scale < -1, 1, 1 >
        rotate 180 * x
        translate -(HubWid / 2) * x
    }
}


#local ForkBranch =
intersection {
    union {
        cone {
            < 0, 0, 0 >, ForkBotWid / 2,
            < 0, ForkLen, 0 >, ForkTopWid / 2
        }
        sphere { < 0, 0, 0 >, ForkBotWid / 2 }
    }
    plane { < -1, 0, 0 >, 0 }
    texture { FrameTexture }
}

#local HalfConnector =
union {
    box {
        < 0, 0, -(ForkTopWid / 2) - 1/4 >,
        < HubWid / 2, ForkConnectorThick, (ForkTopWid / 2) + 1/4 >
    }
    cylinder {
        < HubWid / 2, 0, 0 >,
        < HubWid / 2, ForkConnectorThick, 0 >,
        (ForkTopWid / 2) + 1/4
    }
    texture { BrushedAluminum }
}

#local HalfFork =
union {
    object {
        ForkBranch
        translate (HubWid / 2) * x
    }
    object {
        HalfConnector
        translate ForkLen * y
    }
}

#local Seat =
union {
    cylinder {
        < 0, 0, 0 >, < 0, SeatShaftLen, 0 >, SeatShaftRad
        texture { BrushedAluminum }
    } 
    intersection {
        union {
            cone {
                < 0, 0, -SeatLen / 2 >, SeatBackWid / 2
                < 0, 0,  SeatLen / 2 >, SeatFrontWid / 2
            }
            sphere {
                < 0, 0, 0 >, SeatBackWid / 2
                scale < 1, 1, 0.5 >
                translate -(SeatLen / 2) * z
            }
            sphere {
                < 0, 0, 0 >, SeatFrontWid / 2
                scale < 1, 1, 0.5 >
                translate (SeatLen / 2) * z
            }
        }
        plane { < 0, -1, 0 >, 0 }
        scale < 1, 0.5, 1 >
        texture { TireTexture }
        translate < 0, SeatShaftLen, SeatLen * 0.33 >
    }
    translate (ForkLen + ForkConnectorThick) * y
}        
    
#declare Unicycle =
union {
    object { Wheel }
    object { HalfFork }
    object { HalfFork scale < -1, 1, 1 > }
    object { Seat }
    translate (WheelRad + WheelThick / 2) * y
}

#end    // #ifndef (_Unicycle_Inc_)
