//////////////////////////////////////////////////////////////////////////
// Wall.inc  Copyright(c) 2003, K.E. Ayers Designs                      //
//////////////////////////////////////////////////////////////////////////
// This file constructs the wall and foundation sourrounding the entry. //
//////////////////////////////////////////////////////////////////////////

// This file should only be included once!
#ifndef (_Wall_Inc_)
#declare _Wall_Inc = true;

#debug "\nParsing: Wall.inc\n"

#include "SceneConstants.inc"
#include "Textures.inc"
#include "Window.inc"


#declare EntryOverhang          = 1;
#declare FoundationHgt          = 12;

#declare WallLeft               = FrameLeft  - WallExt;
#declare WallRight              = FrameRight + WallExt;
#declare WallBottom             = FrameBottom;
#declare WallTop                = FrameTop + WallHgtAboveDoor;
#declare WallFront              = FrameFront - SidingThick;
#declare WallBack               = WallFront + 3/4;

#declare WallWid                = WallRight - WallLeft;
#declare WallHgt                = WallTop - WallBottom;

#declare FoundationTop          = WallBottom;
#declare FoundationBottom       = FoundationTop - FoundationHgt;
#declare FoundationFront        = WallFront + EntryOverhang;
#declare FoundationBack         = FoundationFront + 6;


// The foundation is a simple concrete block wall.
#declare Foundation =
box {
    < WallLeft,  FoundationBottom, FoundationFront >,
    < WallRight, FoundationTop,    FoundationBack >
    texture {
        gradient x
        texture_map {
            [ 0.0   FoundationTexture scale < 2 / WallWid, 1, 1 > ]
            [ 0.6   FoundationTexture scale < 2 / WallWid, 1, 1 > ]
            [ 1.0   pigment { Clear } ]
            [ 1.1   pigment { Clear } ]
        }
        scale < WallWid * 0.51, 1, 1 >
        translate ((WallLeft + WallRight) / 2) * x
    }
}


// This is what we'll use to cut out the opening, in our siding,
// for the entry way.
#declare EntryCutout =
box {
    < FrameLeft,  FrameBottom, WallFront - 2 >,
    < FrameRight, FrameTop,    WallBack  + 2 >
}


// Our wall has horzontal siding.

#local SidingWid   = 6;
#local SidingThick = 3/4;
#local YOfs        = WallBottom;

#declare Siding =
difference {
    union {
        #while (YOfs < WallTop)
            box {
                < WallLeft,  0,         0 >,
                < WallRight, SidingWid, -SidingThick >
                rotate < 7.5, 0, 0 >
                translate < 0, YOfs - 1/2, WallFront >
            }

            #local YOfs = YOfs + SidingWid;
        #end
    }
    object { EntryCutout }
    object {
        WindowCutout
        translate < FrameRight + WindowXOfs, FrameBottom + WindowYOfs, 0 >
    }
    object {
        WindowCutout scale < -1, 1, 1 >
        translate < FrameLeft - WindowXOfs, FrameBottom + WindowYOfs, 0 >
    }
    texture {
        gradient x
        texture_map {
            [ 0.0   SidingTexture scale < 2 / WallWid, 1, 1 > ]
            [ 0.6   SidingTexture scale < 2 / WallWid, 1, 1 > ]
            [ 1.0   pigment { Clear } ]
            [ 1.1   pigment { Clear } ]
        }
        scale < WallWid * 0.51, 1, 1 >
        translate ((WallLeft + WallRight) / 2) * x
    }
}

#declare Wall =
union {
    object { Foundation }
    object { Siding }
    object {
        Window
        translate < FrameRight + WindowXOfs,
                    FrameBottom + WindowYOfs,
                    FrameFront - SidingThick * 1.25 >
    }
    object {
        Window scale < -1, 1, 1 >
        translate < FrameLeft - WindowXOfs,
                    FrameBottom + WindowYOfs,
                    FrameFront - SidingThick * 1.25 >
    }
}

#end    // _Wall_Inc_

