/*The Strange Fountain
 by Florian Dietachmayr
16.8.2003-24.8.2003
for the IRTC, topic Surrealism*/

#include "colors.inc"

global_settings {
  ambient_light White
}

camera {
  location <0,15,-15>
  look_at  <0,12,0>
  angle 60
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 0.9 color DarkSlateBlue
               color SkyBlue]
    }
    rotate 180*x
  }
  pigment {
    bozo
    turbulence 0.75
    omega 0.5
    octaves 7
    lambda 3
    color_map {
      [0.0 0.1 color rgb <0.85, 0.85, 0.85>
               color rgb <0.75, 0.75, 0.75>]
      [0.1 0.5 color rgb <0.75, 0.75, 0.75>
               color rgbt <1, 1, 1, 1>]
      [0.5 1.0 color rgbt <1, 1, 1, 1>
               color rgbt <1, 1, 1, 1>]
    }
    scale <.2,.2,.2>
  } 
}

light_source { <50,50,-10> White area_light <5,0,0>,<0,0,5>,5,5 fade_distance 70 fade_power 5 }


/******************************************textures***********************************/
#declare stone = 
  texture {
    pigment {
      granite
      color_map {
        [0 0.1 color DimGrey
               color Grey]
        [0.1 .2 color Grey
                color LightGrey]
        [0.2 0.3 color LightGrey
                 color VLightGrey]
        [0.3 0.4 color VLightGrey
                 color White]
      }
      scale 2
    }  
    normal {
      granite
      scale 5
    }
  }
  
#declare metal = 
  texture {
    pigment { color DimGrey }
    finish {
      reflection .5
      specular 1
      metallic
    }
  }
  
#declare ground =
  texture {
    pigment {
      bozo
      turbulence .3
      color_map {
        //[0 0.3 color Gray
          //     color Brown]
        [0.0 0.6 color Brown
                 color Black]
        [0.6 0.9 color Black
                 color rgbf <1,1,1,1>]
      }                              
      scale .2
    }
  }
  
#declare grasstex =
  texture {
    pigment {
      bozo
      turbulence .3
      color_map {
        [0 0.3 color Yellow
               color rgb <.6,.6,0>]
        [0.3 0.6 color rgb <.6,.6,0>
                 color Green]
      }
      scale .1
    }
  }
  
#declare watertex =
  texture { 
    pigment { rgbf<1.0, 1.0, 1.0, 0.5> }
    finish  { 
      specular .5
      ambient 0
      diffuse 0.2
      reflection .2
    }
    normal {
      ripples
      turbulence 1
      scale .1
    }
  }                         

#declare woodtex =
  texture {
    pigment { color Brown }
    normal {
      gradient y
      scale .5
    }
  }
  
#declare seatex =
  texture {
    pigment {SeaGreen}
    finish {
      reflection .3
      specular 1
    }
    normal {
      ripples
      turbulence .5
      scale 1
    }
  }
  

/******************************************fountain***********************************/
#declare fountain = union { 
  difference {
    cylinder {
      <0,0,0><0,2,0>,4.5
    }   
    difference {
      cylinder {
        <0,1.1,0><0,2.1,0>,4.3
      }
      cylinder {
        <0,1.0,0><0,2.2,0>,2.5
      }    
    }
  }   
  
  cylinder {
    <0,0,0><0,4,0>,2.5
  }
  
  cone {
    <0,4,0>,2.5,<0,5,0>,1
  }
}
 

/********************************dragonhead***********************************/
#declare dragon = union {
  difference {
    blob {
      threshold .65
      sphere {
        <0,2,0>,3,1
      }            
      cylinder {
        <0,2,0><2.8,2.5,0>,1.2,.8
      }
      cylinder {
        <0,2,0><2.8,1.5,0>,1.2,.8
      }
      
      #declare i=0;//*******************************************horns
      #while (i<=20)
        #if (i>10)
          sphere {
            <-1+10/20+(i-10)/50,4-i/20,.7>,0.05+10/50,1
          } 
          sphere {
            <-1+10/20+(i-10)/50,4-i/20,-.7>,0.05+10/50,1
          } 
        #else
          sphere {
            <-1+i/20,4-i/20,.7>,0.05+i/50,1
          }  
          sphere {
            <-1+i/20,4-i/20,-.7>,0.05+i/50,1
          }
        #end 
        #declare i=i+1;
      #end
      sphere {//************************************************counteracting spheres
        <0,3,-6>,6,-1
      }
      sphere {
        <0,3,6>,6,-1
      }
      sphere {
        <1,-3,0>,5,-4
      }
      sphere {
        <.5,0,0>,2,-1
      }
      sphere {
        <1.5,2.5,0>1,-.2
      }
    }         
    
    union {//***************************************************eyes,mouth,noseholes
      intersection {
        sphere {
          <0,0,0>,1
        }
        sphere {
          <1.6,0,0>,1
        }
        rotate 70*z
        translate <.3,2.2,-1.2>      
      } 
      intersection {
        sphere {
          <0,0,0>,1
        }
        sphere {
          <1.6,0,0>,1
        }
        rotate 70*z
        translate <.3,2.2,1.2>      
      } 
      lathe {
        linear_spline
        3,
        <0,0>,
        <1,.3>,
        <0,.6>
        scale 3
        translate <4,1.1,0>
      }
      sphere {
        <2.8,2.9,-.3>,.15
      }
      sphere {
        <2.8,2.9,.3>,.15
      }
    }
  }
  
  #declare i = 0;//*********************************************teeth
  #while (i<=1.2) 
    cone {
      <2.05-i,2.28,-0.3-i/3>,0.1,
      <2.05-i,2.68-i/5,-0.3-i/3>,0
      rotate -18*z
    }  
    cone {
      <2.05-i,2.28,+0.3+i/3>,0.1,
      <2.05-i,2.68-i/5,+0.3+i/3>,0
      rotate -18*z
    }  
    cone {
      <3.6-i,1.55,-0.225-i/3>,0.1,
      <3.6-i,1.15+i/5,-0.225-i/3>,0
      rotate 18*z
    }  
    cone {
      <3.6-i,1.55,+0.225+i/3>,0.1,
      <3.6-i,1.15+i/5,+0.225+i/3>,0
      rotate 18*z
    }
    #declare i = i+0.3;
  #end
  
  intersection {//***************************************************eyes
    sphere {
      <0,0,0>,1
    }
    sphere {
      <1.6,0,0>,1
    }
    rotate 70*z
    translate <.35,2.15,-0.1>      
  } 
  
  intersection {
    sphere {
      <0,0,0>,1
    }
    sphere {
      <1.6,0,0>,1
    }
    rotate 70*z
    translate <.35,2.15,0.1>      
  }
                                                                    
  blob {//******************************************************don't really know how to name it
    threshold .65
    cylinder {
      <0,2,0><2,2.5,0>,.1,1
    }
    cylinder {
      <0,1.5,0><2.1,1.5,0>,.1,1
    }
    cylinder {
      <0,1,0><2.2,0.5,0>,.1,1
    }
    #declare i=0;
    #while (i<=10)
      cylinder {
        <0,2-i/10,0><2+(i/5)/10,2.5-(2*i)/10,0>,.03,1  
      }
      #declare i=i+.1;
    #end
    scale .8
    scale .6*x
    rotate 90*y
    rotate 30*y
    translate <0,1,-.8>
  } 
  
  blob {
    threshold .65
    cylinder {
      <0,2,0><2,2.5,0>,.1,1
    }
    cylinder {
      <0,1.5,0><2.1,1.5,0>,.1,1
    }
    cylinder {
      <0,1,0><2.2,0.5,0>,.1,1
    }
    #declare i=0;
    #while (i<=10)
      cylinder {
        <0,2-i/10,0><2+(i/5)/10,2.5-(2*i)/10,0>,.03,1  
      }
      #declare i=i+.1;
    #end
    scale .8
    scale .6*x
    rotate -90*y
    rotate -30*y
    translate <0,1,.8>
  }
}


/******************************************pitcher*************************************/
#declare pitcher = union {
  difference {//***********************************the basic structure 
    union {
      lathe {
        cubic_spline
        5,
        <2.5,1>,
        <0,0>,
        <1.5,0>, 
        <1.5,2>,
        <.5,3>
      }
      
      lathe {
        cubic_spline
        4,
        <2.5,1>,
        <1.5,2>,
        <1,4>,
        <2,5>
      }
      
      torus {
        1,.15
        rotate 90*x
        translate <-1.2,2,0>
      }
    
    } 
    
    union {//*******************************************cutting out the spouthole (hope that that's the correct word)
      #declare i=0;
      #while (i<=1)
        difference {
          difference {
            difference {
              sphere {
                <0,2,0>,1
              }
              sphere {
                <0,2,0>,.9
              }   
            }  
            box {
              <-2,4,0><2,0,-3>
            }
          }
          box {
            <-2,5,-3><2,1.6,3>
            rotate 20*x
          }
          scale .5
          rotate 90*y
          translate <.9,3.15+i,0>
        } 
        #declare i=i+.05;
      #end  
    }  
  }
  
  difference {//***************************************adding the spout
    difference {
      difference {
        sphere {
          <0,2,0>,1
        }
        sphere {
          <0,2,0>,.9
        }   
      }  
      box {
        <-2,4,0><2,0,-3>
      }
    }
    box {
      <-2,5,-3><2,1.6,3>
      rotate 20*x
    }
    scale .5
    rotate 90*y
    translate <.9,3.15,0>
  }
}    


/*************************************water*****************************************/
declare water = difference {
  cylinder {
    <0,1.0,0><0,1.8,0>,4.31
  }
  cylinder {
    <0,0.9,0><0,1.9,0>,2.49
  }   
  texture {watertex}                         
} 

declare water2 = bicubic_patch {
  type 1
  u_steps 3
  v_steps 3
  flatness 0.001
  <.125,2.825,-.2>,<.50,2.80,-.2>,<.375,2.175,-.2>,<.5,1.9,-.2>,
  <.125,2.825,-.1>,<.50,2.80,-.1>,<.375,2.175,-.1>,<.5,1.9,-.1>,
  <.125,2.825,.1>,<.50,2.80,.1>,<.375,2.175,.1>,<.5,1.9,.1>,
  <.125,2.825,.2>,<.50,2.80,.2>,<.375,2.175,.2>,<.5,1.9,.2>
  texture {watertex}
  scale .5*z
}                                                                                    


/*************************************grass*****************************************/
#declare grass = object {
  #include "grass.inc"
}

#declare circle_of_grass = difference{
  intersection {
    union {
      object {grass}
      object {grass translate <-10,0,0>}
      object {grass translate <-20,0,0>}
      object {grass translate <10,0,0>}
      object {grass translate <20,0,0>}
      object {grass translate <0,0,10>}
      object {grass translate <-10,0,10>}
      object {grass translate <-20,0,10>}
      object {grass translate <10,0,10>}
      object {grass translate <20,0,10>}
      object {grass translate <0,0,-10>}
      object {grass translate <-10,0,-10>}
      object {grass translate <-20,0,-10>}
      object {grass translate <10,0,-10>}
      object {grass translate <20,0,-10>}
    }
    cylinder {
      <0,-5,0><0,5,0>,10
    }
  }          
  cylinder {
    <0,-5,0><0,5,0>,4.5
  }
  texture {grasstex}
}
                                                                                      
                                                                                      
/**************************************ground****************************************/
#declare hill_with_sea = union {
  cone {
    <0,0,0>,20,<0,10,0>,10
    texture {stone}
    texture {ground}
  } 
  
  plane {
    y,0
    texture {seatex}
  } 
}


/**************************************sign****************************************/
#declare sign = difference {
  union {
    cylinder {
      <0,0,0><0,3,0>,0.2
    }
    box {
      <-1,2.9,-0.39><1,1.5,-0.5>
    }
    texture {woodtex}    
  }
  text {
    ttf "timrom.ttf" "The Strange Fountain" 0.15, 0
    scale <.2,.3,0>
    translate <-.9,2.5,-0.55>
  }
  text {
    ttf "timrom.ttf" "made by" 0.15, 0
    scale <.2,.3,0>
    translate <-.3,2.1,-0.55>
  }                        
  text {
    ttf "timrom.ttf" "Florian Dietachmayr" 0.15, 0
    scale <.2,.3,0>
    translate <-.8,1.7,-0.55>
  }                        
  translate <-5,10,-5.5>
  rotate -20*y
}


/**************************************scene****************************************/
union {
  object {dragon scale .3 rotate 90*y rotate -30*x translate <0,2.8,-2.4>}
  object {dragon scale .3 rotate -30*z translate <2.4,2.8,0>}
  object {dragon scale .3 rotate -90*y rotate 30*x translate <0,2.8,2.4>}
  object {dragon scale .3 rotate 180*y rotate 30*z translate <-2.4,2.8,0>}
  object {pitcher scale .5 rotate 180*y rotate -90*z translate <-0.9,5.8,.1>}
  object {water2 rotate 90*y translate <0,0,-3.15>}
  object {water2 translate <3.15,0,0>}
  object {water2 rotate 180*y translate <-3.15,0,0>}
  object {water2 rotate -90*y translate <0,0,3.15>}
  object {water2 rotate 180*x rotate 10*z scale 20*y translate <.4,61.45,.1>}
  object {water}
  object {fountain}
  texture {metal}
  rotate 45*y
  translate 10*y
} 

union {
  object {hill_with_sea}
  object {circle_of_grass translate 10*y}
}

object {sign}