#include "colors.inc"
#include "metals.inc"
#include "shapes.inc"
#include "woods.inc"

camera {location <0,40,-100>
        look_at  <0,10,0>
        rotate y*30}

light_source {<20,40,-60>
              color White}

background {color White}

#declare schakel = 
union {
difference {
torus {2.5,0.4
       rotate x*90
       translate y*2}
box {<-5,2,-5>
     <5,-10,5>}}
cylinder {<-2.5,2,0>
          <-2.5,-2,0>0.4}
cylinder {<2.5,2,0>
          <2.5,-2,0>0.4}
difference {
torus {2.5,0.4
       rotate x*90
       translate y*-2}
box {<-5,-2,-5>
     <5,10,5>}}
translate y*4.8};


//KOOI
#declare tralie = union {
cylinder {<-15,0,0>
          <-15,23,0>,0.25}
cylinder {<15,0,0>
          <15,23,0>,0.25}
difference {torus {15,0.25
                   rotate x*90
                   translate y*23}
            box {<-90,23,-90>
                 <90,-100,90>}}}

#declare kooi = union {
#declare teller = 0;
#while (teller < 8)
object {tralie
        rotate y*teller*22.5}
#declare teller = teller + 1;
#end}

object {kooi
        texture {T_Chrome_4C}}

//BODEM
#declare bodem = union {
cylinder {<0,0,0>
          <0,-0.5,0>,17}
difference {Round_Cylinder_Union (<0,-0.4,0>
                                  <0,0.3,0>,17,0.1)
            cylinder {<0,-1,0>
                      <0,1,0>,16.5}}}
object {bodem
        pigment {color Grey}
        finish {phong 1
                phong_size 2000
                reflection 0.3}}


//ZITJE
#declare buiging1 = intersection {torus {0.5,0.25
                                         rotate x*90
                                         translate <2.75,17.5,0>}
                                  box {<2.75,17.5,-2>
                                       <4,16,2>}}
#declare buiging2 = intersection {torus {0.5,0.25
                                         rotate x*90
                                         translate <-2.75,17.5,0>}
                                  box {<-2.75,17.5,-2>
                                       <-4,16,2>}}
#declare boog = difference {torus {3.25,0.25
                                   rotate x*90
                                   translate y*23}
                            box {<-4,23,-4>
                                 <4,15,4>}}
#declare frame = union {object {buiging1}
                        object {buiging2}
                        object {boog}
                        cylinder {<3.25,17.5,0>
                                  <3.25,23,0>,0.25}
                        cylinder {<-3.25,17.5,0>
                                  <-3.25,23,0>,0.25}
                        cylinder {<-2.75,17,0>
                                  <2.75,17,0>,0.25}}

#declare zitje = union {object {frame
                                texture {T_Chrome_3C}}
                        cylinder {<-2.5,17,0>
                                  <2.5,17,0>,0.75
                                  texture {T_Wood31 scale 10}}}

object {zitje}


//KETTING
#declare ketting = union {
#declare teller=0;
#while (teller < 12)
object {schakel
        translate y*8.2*teller
        rotate y*90*teller}
#declare teller = teller+1;
#end}

difference {
object {ketting
        texture {T_Chrome_3C}
        scale 0.125
        translate y*25.80
        rotate y*90}
box {<-5,38,-5>
     <5,40,5>}}


//BAL
sphere {<0,17,-10>,2
        pigment {image_map {jpeg "d:/pieter/source files/povray/wtf/eightball texture.jpg"}     
                            scale 3.5 translate x*-50}
        rotate <30,0,0>
        finish {phong 1
                phong_size 3000
                reflection 0.2}}


//TAFEL
#declare tafel = union {
box {<-30,-1.5,-20>
     <-27,-40,-17>}
box {<-30,-1.5,20>
     <-27,-40,17>}
box {<30,-1.5,-20>
     <27,-40,-17>}
box {<30,-1.5,20>
     <27,-40,17>}
Round_Box_Union (<-33,-1,-23>
                 <33,-1.5,23>,1)}

object {tafel
        texture {T_Wood34 scale 40}
        finish {phong 0.7
                reflection 0.1}}


//VLOER
box {<-300,-40,-250>
     <300,-41,250>
     pigment {checker color Black, color White
              scale 20}
     finish {phong 1
             reflection 0.1}}

//MUUR
box {<-300,-100,250>
     <300,200,270>
     pigment {color Quartz}
     normal {wrinkles scale <2,2,0.3>}}

box {<-300,-100,-500>
     <-310,200,270>
     pigment {color Quartz}
     normal {wrinkles scale <0.3,2,2>}}

box {<300,-100,-500>
     <310,200,270>
     pigment {color Quartz}
     normal {wrinkles scale <0.3,2,2>}}

box {<-300,200,-500>
     <310,210,270>
     pigment {color Quartz}
     normal {wrinkles scale <0.3,2,2>}}