// Persistence of Vision Ray Tracer Scene Description File
// File: its_time.pov
// Vers: 3.5
// Desc: IRTC entry
// Date: July / August 2003
// Auth: Steely
//

#version 3.5;
#include "extree1.inc"
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "metals.inc"
#include "stones1.inc"
#include "stones2.inc"
#include "stars.inc"
#include "its_time.inc"
#include "rustyeasy.inc"
#include "zeitung.inc"
#include "brokenlogo.inc"
#declare Radiosity=on;

global_settings {
  charset  utf8
  assumed_gamma 1.0
  max_trace_level 5

  #if (Radiosity)
    radiosity {
      pretrace_start 0.08           // start pretrace at this size
      pretrace_end   0.04           // end pretrace at this size
      count 35                      // higher -> higher quality (1..1600) [35]
      nearest_count 5               // higher -> higher quality (1..10) [5]
      error_bound 1.8               // higher -> smoother, less accurate [1.8]
      recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
      low_error_factor .5           // reduce error_bound during last pretrace step
      gray_threshold 0.0            // increase for weakening colors (0..1) [0]
      minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
      brightness 1                  // brightness of radiosity effects (0..1) [1]

      adc_bailout 0.01/2
      //normal on                   // take surface normals into account [off]
      //media on                    // take media into account [off]
      //save_file "file_name"       // save radiosity data
      //load_file "file_name"       // load saved radiosity data
      //always_sample off           // turn sampling in final trace off [on]
      //max_sample 1.0              // maximum brightness of samples
    }
  #end
}

#default {
  texture {
    pigment {rgb 1}
    #if (Radiosity)
      finish {
        ambient 0.0
        diffuse 0.6
        specular 0.3
      }
    #else
      finish {
        ambient 0.1
        diffuse 0.6
        specular 0.3
      }
    #end
  }
}


// ----------------------------------------

camera {
  location  <0.0, 1.8, -10.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 1.50,  0.0>
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color VeryDarkBrown*3  // light's color
  translate <-300, 30, 1000>
}
light_source {
  <0, 0, 0>            // light's position (translated below)
  color VeryDarkBrown  // light's color
  translate <300, 30, 300>
}
light_source {
  <0, 0, 0>            // light's position (translated below)
  color Gray10  // light's color
  translate <-300, 30, -30>
} 
light_source {
  <0, 0, 0>            // light's position (translated below)
  color White  // light's color
  translate <2, 0.1, 35>
} 

// ----------------------------------------

plane {       // checkered floor 
  y, -0.01  
  texture {
      checker
      texture { T_Copper_1A }
      texture { T_Stone25 scale 0.05} 
      turbulence 0.05 scale 0.5
   }  
  
}
// zum beschleunigen
plane {       // bumps
  y, 0.0  
  texture
  {
      T_Glass1 }
     normal {bumps 3 scale 0.5} 
}  
// ----------------------------------------------- declarations
#declare ziegel = color DimGrey;
#declare zement = color BakersChoc;
#declare regenrinne =
union{ 
cylinder { 0.5*y,  19.81*y,  0.06  }
cylinder { <0, 0.5, 0>,  <0, 0.2, -0.2>,  0.06 open rotate 30*x translate -0.2*z }
pigment { color Gray25}
finish {specular 0.5 roughness 0.15}
}
// ----------------------------------------------- 
// ----------------------------------------------- left building
union{
object {regenrinne translate <24.95, 0, -1.03>}
object {regenrinne translate <-24.95, 0, -1.03>}
box {
  <-25.2, 19.8,  -1.2>  // one corner position <X1 Y1 Z1>
  < 25.2, 20.4,  30.2>  // other corner position <X2 Y2 Z2>
pigment {color Wheat} finish {specular 0.5 roughness 0.15}  }
box {
  <-25, -1, -1>  
  < 25,  20, 30> 
pigment { brick ziegel , zement            
          brick_size <0.48,0.24,0.16>  mortar 0.02   
          turbulence 0.03     }
finish {specular 0.5 roughness 0.15}
}
box {
  <-25, -1,  -1.01>  // one corner position <X1 Y1 Z1>
  < 25,  20, -1.02>  // other corner position <X2 Y2 Z2>
pigment {color Clear} pigment {image_map {gif "screw.gif" once filter 5, 1.0 }
/*rotate 5*z */scale <11,11,1> translate <-20,3,0> }
            normal {brick -1 turbulence 0.01 scale 0.25}  }
rotate -89*y translate <-15,0,47>} // end of union  

// ----------------------------------------------- right building
union{
object {regenrinne translate <24.95, 0, -1.03>}
object {regenrinne translate <-24.95, 0, -1.03>}
box {
  <-25.2, 19.8,  -1.2>  // one corner position <X1 Y1 Z1>
  < 25.2, 20.4,  30.2>  // other corner position <X2 Y2 Z2>
pigment {color Wheat} finish {specular 0.5 roughness 0.15}  }
box {
  <-25, -1, -1>  
  < 25,  20, 30> 
pigment { brick ziegel , zement            
          brick_size <0.48,0.24,0.16>  mortar 0.02   
          turbulence 0.03     }
finish {specular 0.5 roughness 0.15}
}
box {
  <-25, -1,  -1.01>  // one corner position <X1 Y1 Z1>
  < 25,  20, -1.02>  // other corner position <X2 Y2 Z2>
pigment {color Clear} pigment {image_map {gif "fuckoff.gif" once filter 5, 1.0 }
scale <11,11,1> translate <-13,-4,0> }
            normal {brick -1 turbulence 0.01 scale 0.25}  }
rotate 89*y translate <15,0,15>} // end of union  

// ----------------------------------------------- left background building
union{
object {regenrinne translate <24.95, 0, -1.03>}
object {regenrinne translate <-24.95, 0, -1.03>}
box {
  <-25.2, 19.8,  -1.2>  // one corner position <X1 Y1 Z1>
  < 25.2, 20.4,  30.2>  // other corner position <X2 Y2 Z2>
pigment {color Wheat} finish {specular 0.5 roughness 0.15}  }
box {
  <-25, -1, -1>  
  < 25,  20, 30> 
pigment { brick ziegel , zement            
          brick_size <0.48,0.24,0.16>  mortar 0.02   
          turbulence 0.03     }
finish {specular 0.5 roughness 0.15}
}
box {
  <-25, -1,  -1.01>  // one corner position <X1 Y1 Z1>
  < 25,  20, -1.02>  // other corner position <X2 Y2 Z2>
pigment {color Clear} pigment {image_map {gif "burn.gif" once filter 5, 1.0  }
/*rotate 5*z */scale <11,11,1> translate <3,-3,0> }
            normal {brick -1 turbulence 0.01 scale 0.25}  }
rotate -15*y translate <-15,0,190>} // end of union  

// ----------------------------------------------- right background building
union{
object {regenrinne translate <24.95, 0, -1.03>}
object {regenrinne translate <-24.95, 0, -1.03>}
box {
  <-25.2, 19.8,  -1.2>  // one corner position <X1 Y1 Z1>
  < 25.2, 20.4,  30.2>  // other corner position <X2 Y2 Z2>
pigment {color Wheat} finish {specular 0.5 roughness 0.15}  }
box {
  <-25, -1, -1>  
  < 25,  20, 30> 
pigment { brick ziegel , zement            
          brick_size <0.48,0.24,0.16>  mortar 0.02   
          turbulence 0.03     }

}
box {
  <-25, -1,  -1.01>  // one corner position <X1 Y1 Z1>
  < 25,  20, -1.02>  // other corner position <X2 Y2 Z2>
pigment {color Clear}  
normal {brick -1 turbulence 0.01 scale 0.25} finish {specular -3 roughness 0.015}  }
text {
  ttf             // font type (only TrueType format for now)
  "povlogo.ttf",  // Microsoft Windows-format TrueType font file name
  "P",      // the string to create
  0.1,              // the extrusion depth
  0               // inter-character spacing
scale 3 translate <-19,2,-1.1>}
rotate 8*y translate <75,0,290>} // end of union  

// ----------------------------------------------- middle background building
union{
object {regenrinne translate <24.95, 0, -1.03>}
object {regenrinne translate <-24.95, 0, -1.03>}
box {
          <-25.2, 19.8,  -1.2>  // one corner position <X1 Y1 Z1>
          < 25.2, 20.4,  30.2>  // other corner position <X2 Y2 Z2>
        pigment {color Wheat} finish {specular 0.5 roughness 0.15}
  }

box {
          <-25, -1, -1>  
          < 25,  20, 30> 
        pigment { brick ziegel , zement            
          brick_size <0.48,0.24,0.16>  mortar 0.02   
          turbulence 0.03     }
        finish {specular 0.5 roughness 0.15}
}

box {
  <-25, -1,  -1.01>  // one corner position <X1 Y1 Z1>
  < 25,  20, -1.02>  // other corner position <X2 Y2 Z2>
pigment {color Clear} 
normal {brick -1 turbulence 0.01 scale 0.25} 
finish {specular 0.5 roughness 0.15}
}
// end of light group            
             
rotate 5*y translate <45,0,420>} // end of union  






// ----------------------------------------------


sphere {  // ---------------------------------- "this dimension" sky   no_reflection
  0.0, 10000
  texture { Starfield1 } finish {ambient 0.2} scale 1500
hollow}
light_group {
        light_source { <0, 9900, 0>            // light's position (translated below)
        color Red  // light's color
        rotate -60*x rotate 60*y
        }
        light_source { <0, 9900, 0>            // light's position (translated below)
        color Black*5  // light's color
        rotate -60*x //rotate -15*y
        }
sphere { 0, 9800
        texture { 
        pigment { FBM_Clouds scale 300 scale 1.5*x }
        finish { ambient 0.09 }
        } 
hollow}
} // end of light group
// ----------------------------------------------


// ----------------------------------------------------------------------------
// scene -------------------------------------------------- scene -------------
// ----------------------------------------------------------------------------

text { ttf "acidrefl.ttf", "Come on, now!",      
  0.2,              // the extrusion depth
  <0.05, -0.1, -1.75>  scale 0.8
pigment { color Red } finish { ambient 0.6}
rotate 5*y translate <-2.7,2.2,0.5> no_shadow no_reflection}  

light_group {
light_source { <5, 0.2, -4>  color SeaGreen }
light_source { <-1, 0.3, -8>  color White }
object {rustyeasy scale 1.9 translate <01.2, 0.0, -4.7>}
global_lights on} // eof light group

union {
object {brokenlogo1 translate 1.3*x rotate 5*z rotate -89*y translate <-9, 0.7, 11>}
object {brokenlogo2 translate -7.8*x rotate 5.75*z rotate -10*y translate <-4.15, 0.82, 16.5>}
object {schleife pigment {color Green} scale 0.3 translate <-9, 0.25, 15>}
object {schleife pigment {color Green} scale 0.3 translate <-9.5, 0.25, 13>}
rotate 90*y translate <-6,0,17>} // end of logo union
light_group {
light_source { <-1.85, 1.95, -5.99>  color Wheat*0.25 }
light_source { <-0.2, 1.5, -6.1>  color Wheat*0.25 }
object {zeitung  rotate -37*y rotate -92*x translate <-1.65, 1.05, -5.80>}
}// end of light group
union{
cylinder { 0*z,  0.005*z,  0.01}
cylinder { 0.005*z,  0.15*z,  0.003}
rotate -60*y translate <-1.65, 1.3, -5.82>
pigment {color Silver}
}//end of union
object {baum scale 0.2 translate <-1.9,0,-5.6> no_shadow}

// ------------------------------------------------
// the death --------------------------------------
//-------------------------------------------------
#include "death1_pov.inc" //the geometry is in this file
//-------------------------------------------------
#include "death2_pov.inc" //the geometry is in this file
//light_group{
light_source { <-2.3,2.5,0.5>  color Black }
object{ Death1 scale 5 rotate 150*y translate <-3,0,0.5> no_shadow}
object{ Death2 scale 5 rotate 150*y translate <-3,0,0.5> no_shadow}
//} // eof light group
//-------------------------------------------------
#include "death3_pov.inc" //the geometry is in this file
object{ Death3 scale 5 rotate 150*y translate <-3,0,0.5> no_shadow}
//-------------------------------------------------
#include "door.inc"
object {tuer scale 2 translate <-0.35,0,2.4>}

// create a regular point light source
/*light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <-20, 40, -20>
}*/
