/* 
 * + + + + + + + + + + + + + + + + + +
 * S O M E T H I N G  S U R R E A L +
 * + + + + + + + + + + + + + + + + + +
 * 
 * Surreal art in futuristic, kindof surreal world. Pretty surreal idea, or
 * what? :) Ok, maybe not. But let's hope it makes sense.
 *
 * Submission to IRTC July - August 2003 round. Topic: Surreal.
 *
 * Tools used
 * ----------
 *
 *  VIM 6.1
 *  GNU Make
 *  POV-Ray 3.5 for Unix
 *
 *  Running on Debian GNU/Linux 3.0r0 Woody
 *  Linux kernel 2.4.18-586tsc, Debian prepackaged
 *
 * 
 * CONTACT
 * ~~~~~~~
 * jaan@surnuaed.ee
 * http://www.surnuaed.ee/ud
 *
 * 
 * LICENCE
 * ~~~~~~~
 * Copyright  2003  Jaan Pullerits
 *
 * You may take any code from this source file and use it in any of your
 * scenes if you:
 *
 *   a) ...release the source of that scene you used my code in.
 *   b) ...put a message in your source header that you borrowed some code
 *      from this file. My contact address and URL where to get the
 *      original sources or image would be nice aswell.
 *   c) ...send me a message, letting me know you liked something in my
 *      code. I would love to see work based on my work.
 *   d) ...release some of your scenes under similar licence. OpenSource
 *      really rocks!
 *
 * None of them are really hard rules. You can ignore any or all of them,
 * but it is not nice. I would be really thankful if you wouldn't do that.
 * 
 */   


#include "colors.inc"
#include "debug.inc"

/* Different random seeds change many things in scene. Lights around the
 * blue thing, lights on houses... And the blue thing itself. For example
 * RS of 151 looks like Elvis. ;) No really.
 */
#declare RS = seed(152);

/* Whether to use arealights or not. With some RS values this is not
 * neccesary, and works fine with no arealights, but on some cases very
 * sharp shadows may appear without it.
 */
#declare AREALIGHTS = false;

camera{
	location <20, 10, -80>
	look_at <0, 20, 0>
}


// ======================================================================
// ATMO SPHERE ;)
// ======================================================================
sphere {
	0, 1
	hollow
	texture{
		pigment{
			gradient y
			color_map{
				[-1, rgb<0.2, 0.2, 0.6>]
				[0,  rgb<0.2, 0.2, 0.6>]
				[2,  rgb<0.01, 0.01, 0.1>]
			}
			turbulence .1
		}
		finish {
			ambient .6
		}
	}

	texture {
		pigment{
			#local P1 =
			pigment{
				granite
				color_map{
					[-1, rgbt<1,1,1,1>]
					[0, rgb<1,1,1>]
					[1.4, rgbt<1,1,1,1>]
				}
				scale <1, 0.1, 1>
				turbulence .1
			}
			#local P2 = 
			pigment{
				granite
				color_map{
					[-1, rgbt<1.02,1,1,1>]
					[0, rgbt<1.01,1,1,0.9>]
					[1.4, rgbt<1.02,1,1,1>]
				}
				scale <1, 0.1, 1>
				turbulence .1
			}
			gradient y
			pigment_map{
				[0, P1]
				[0.7, P2]
			}
		}
		finish {
			ambient .4
		}
	}

	normal {
		granite .3
		scale .1
	}
	scale <20000, 10000, 20000>
}

// ======================================================================
// THE BLOB THING
// ======================================================================
// Some sick experiment with blobs
#declare WeirdBlob =
blob{
	#local I = 0;
	#while (I < 100)
		sphere{
			0, 7, 8 - rand(RS) * 10
			translate <rand(RS), rand(RS), rand(RS)> * 20 - 10
		}
		#local I = I + 1;
	#end
	translate y * 15
}

// ======================================================================
// THE BLOB HOLDER
// ======================================================================
#declare BlobHolder = 
difference {
	cone {
		<0, 0, 0>, 20
		<0, 4, 0>, 18
	}
	sphere {
		<0, 0, 0>, 15
		scale <1, .3, 1>
		translate y * 5
	}
}

// ======================================================================
// WEIRD BUILDING #1
// ======================================================================
#declare Building1 =
union {
	#local N = 0;
	#while (N < 20)
		#local I = 20 - N;
		union{
			difference{
				cylinder {
					<0, 2, 0>,
					<0, 0, 0>,
					I
				}
				torus {
					I, 0.5
					translate y*0.5
				}
			}
			torus{
				I, 0.5
				translate y * 1.5
			}
			#local J = 0;
			#while (J < 32)
				sphere{
					0, 0.3
					
					// Some lights are on, some off.
					#local Random = rand(RS);
					pigment {
						#if (Random > 0.5)
							White
						#else
							Black
						#end
					}
					finish {
						diffuse 0
						ambient 1
					}

					translate (I + 0.5) * x
					rotate 360 / 32 * J * y
					translate y * 1.5
				}
				#local J = J + 1;
			#end
			
			translate N * 2 * y
		}
		#local N = N + 1;
	#end
	pigment { 
		agate
		color_map{
			[0, rgb <0.2, 0.2, 0.6>]
			[1, rgb <0  , 0  , 0.1>]
		}
	}
	scale <3, 6, 3>
}

// ======================================================================
// WEIRD BRIDGE
// ======================================================================
#declare Piece_of_bridge =
difference{
	box {
		<-2, 0,-2>,
		< 2, 4, 2>
	}
	cylinder{
		< 2, 4,-2.1>,
		< 2, 4, 2.1>,
		2
	}
	cylinder{
		<-2, 4,-2.1>,
		<-2, 4, 2.1>,
		2
	}
	box {
		<-2.1, 1,-1.9>,
		< 2.1, 4.1, 1.9>
	}
	pigment {
		granite
		color_map{
			[0, Gray20]
			[1, Gray50]
		}
	}
	normal{
		granite .6
		scale .1
	}
}

#declare Column = 
union {
	// Lower part
	difference{
		cylinder{
			0,
			2 * y,
			2
		}
		torus{
			1.5,
			5
			translate 1.5
		}
	}
	// Body
	cylinder{
		2 * y,
		5 * y,
		1
	}
	// Top part
	difference{
		cylinder{
			5 * y,
			7 * y,
			2
		}
		torus{
			1.5,
			5
			translate 5.5
		}
	}
	pigment {
		granite
		color_map{
			[0, Gray20]
			[1, Gray50]
		}
	}
	normal{
		granite .6
		scale .1
	}
}

#declare Bridge_Light =
union {
	cone{
		0, 0.5
		<0, 1, 0>, 0
		pigment { Black }
	}
	sphere{
		0, 0.1
		pigment { White }
		finish {
			ambient 1
			diffuse 0
		}
	}
}

#declare Bridge =
union{
	#local I = 0;
	#while (I < 20)
		#if (mod(I, 4) = 0)
			object{
				Column
				translate I * 4 * x
			}
			object {
				Bridge_Light
				scale 2
				translate 9 * y + -2 * z
				translate I * 4 * x
			}
		#end
		object {
			Piece_of_bridge
			translate 7 * y + I * 4 * x
		}
		#local I = I + 1;
	#end
}


// ======================================================================
// WEIRD LIGHTS
// ======================================================================

#macro Weird_Light()
	union{
	union{
		// Stand
		sphere{
			0, 5
			scale <1, 0.3, 1>
		}
		// First segment
		#local S1 = <rand(RS) * 10, 5 + rand(RS) * 10, rand(RS) * 10>;
		sphere{
			<0, 2, 0>,
			2
		}
		cylinder{
			<0, 2, 0>,
			S1,
			1
		}
		// Second segment
		#local S2 = <rand(RS) * 10,  10 + rand(RS) * 10, rand(RS) * 10>;
		sphere{
			S1,
			2
		}
		cylinder{
			S1,
			S2,
			1
		}
		// Third segment
		#local S3 = <rand(RS) * 10, 15 + rand(RS) * 10, rand(RS) * 10>;
		sphere{
			S2,
			2
		}
		cone {
			S2, 1
			S3, 0
			no_shadow
		}
		pigment { rgb <0, 0.3, 0> }
		finish {
			reflection .7
			metallic
			phong .3
		}
	}
	sphere {
		0,
		1

		hollow 
		no_shadow

		pigment {
			transmit 1
		}
	
		interior{
			media {
				emission 1
				density{
					spherical
					color_map{
						[0, rgb<0, 0, 0>]
						[1, rgb<1, 1, 1>]
					}
				}
			}
		}
		scale 4
		translate S3

	}
	light_source {
		S3
		color 0.5
		#if (AREALIGHTS)
			area_light <-1, 0, -1>, <1, 0, 1>, 3, 3
			adaptive 1
			jitter
		#end
		fade_distance 30
		fade_power 2
	}
}
#end

// ======================================================================
// ARCHWAYS
//======================================================================
#declare Archway = 
union {
	union{
		difference{
			box {	
				<-3, 9, 0>,
				< 3, 0, 5>
			}
			box {	
				<-2, 6, -1>,
				< 2,-1, 6>
			}
			cylinder{
				<0, 6, -1>,
				<0, 6,  6>,
				2
			}
			sphere {
				0, 1
				scale <1, .3, .3>
				scale 0.99
				translate y * 8.5
			}
		}
		
		cylinder {
			<-3, 9, 0>
			< 3, 9, 0>,
			0.3
		}
		pigment { rgb <1, 0.78, 0> }
		normal  { granite .4 }
		finish  {
			phong 0.1
		}
	}

	sphere {
		0, 0.5
		scale <1, .3, .3>
		scale 0.99
		translate y * 8.5

		pigment { rgbf <0, 0.7, 0, 0.9> }
		finish  { 
			ambient 1
			reflection .1	
		}
	}
	
	scale 5
	
}


// ======================================================================
// BUILDING #2
// ======================================================================
#macro Small_building(Width, Height)
	union{
		box{
			<0 - (Width / 2), Height, 0>,
			< Width / 2, 0,  20>
			pigment{ Black }
		}
		#local I = 0;
		#while (I < Width)
			#local J = 0;
			#while (J < Height)
				sphere{
					<0 - (Width / 2) + I + 0.5, J + 0.5, 0>,
					0.3
					pigment {White}
					finish {
						#if (rand(RS) > 0.8)
							diffuse 0
							ambient 1
						#else
							diffuse 0
							ambient 0
						#end
					}
				}
				#local J = J + 1;
			#end
			#local I = I + 1;
		#end	
	}
#end
// ======================================================================
// SOME SORT OF PLANTLIFE
// ======================================================================
#macro Plant()
	sphere_sweep{
		cubic_spline,
		22
		<0, -1, 0>, 2
		
		#local I = 0;
		
		#local X = 0;
		#local Y = 0;
		#local Z = 0;
		
		#while (I < 20)
			#local X = X + (2.5 - rand(RS) * 5);
			#local Z = Z + (2.5 - rand(RS) * 5);
			<X, Y, Z>, (2 / 20) * (20 - I),
			#local Y = Y + rand(RS) * 5;
			#local I = I + 1;
		#end
		<X, Y + 1, Z>, 0
		tolerance .1
	}
#end

#declare Block_of_plants =
union{
	#local I = 0;
	#while (I < 100)
	object{
		Plant()
		translate <int(I / 10), 0, 0> * 10
		rotate y * mod(I, 10) * 10
		scale 3
	}
	#local I = I + 1;
	#end	
	pigment { Green }
}

// ======================================================================
// THE SCENE
// ======================================================================

// Holder for the statue
object {
	BlobHolder
	texture { 
		pigment{
			granite
			color_map{
				[0, Gray40]
				[1, Gray20]
			}
		}
		normal{
			crackle .1
			turbulence .4
		}
	}
}

// Some strange statue, a organic fluid looking shape
object{
	WeirdBlob
	pigment { 
		rgb <.5, .5, .8>
	}
	normal {
		granite .7
	}
	finish {
		reflection .06
		phong .5
	}
}
// Floor
plane {
	y, 0
	texture {
		pigment { 
			granite
			color_map{
				[0, rgb <0.9, 0.9, 1>]
				[1, rgb <0.6, 0.6, 0.6>]
			}
		}
	}

	texture {
		pigment {
			checker 
			pigment{image_map{ png "map/square1.png" }},
			pigment{image_map{ png "map/square2.png" }}
			rotate x * 90
			scale 10
		}
	}

	finish {
		reflection .5
	}
	normal {
		bumps .1
		scale 20
	}
}

#local I = 0;
#while (I < 12)
	object{
		Weird_Light()	
		translate x * 80
		rotate (360 / 12 * I) * y
		scale .5
	}
	#local I = I + 1;
#end 

#local I = 0;
#while (I < 20)
	object{
		Archway
		rotate y * -90
		translate x * -150
		translate I * 30 * z
	}
	#local I = I + 1;
#end 

#local I = 0;
#while (I < 20)
	object{
		Archway
		rotate y * 90
		translate x * 150
		translate I * 30 * z
	}
	#local I = I + 1;
#end 


// Some sort of buildings, no they are not christmastrees. :P
object{
	Building1
	translate <-300, 0, 350>
}

object{
	Building1
	rotate y * 180
	translate <-340, 0, 450>
}

object{
	Building1
	rotate y * 90
	translate <-320, 0, 200>
}


// A bridge of some sort
object {
	Bridge
	scale 5
	translate <-200, 0, 700>
}

// A foresty kind of object. Or big bush. ;)
object{
	Block_of_plants
	translate <100, 0, 900>
}

// Cube buildings. Oldschool skyscrapers
object{
	Small_building(100, 20)
	scale 5
	translate <0, 0, 1500>
}

object{
	Small_building(10, 30)
	scale 5
	translate <-100, 0, 1300>
}

object{
	Small_building(20, 50)
	scale 5
	translate <-150, 0, 1600>
}

object{
	Small_building(20, 10)
	scale 5
	translate <-50, 0, 900>
}

object{
	Small_building(20, 40)
	scale 5
	translate <100, 0, 1000>
}

object{
	Small_building(10, 35)
	scale 5
	translate <300, 0, 1200>
}

object{
	Small_building(10, 40)
	scale 5
	translate <200, 0, 900>
}

object{
	Small_building(10, 60)
	scale 5
	translate <-20, 0, 900>
}

