//jumbucks.POV                                IRTC July/Aug 2003 " Surrealism "                       Ian MacKay

#include "colors.inc" 
#include "Woods.inc"

global_settings { max_trace_level 7 
                  radiosity { always_sample off 
                              brightness 1.1
                              count 200
                              error_bound 1.7
                              gray_threshold 0.6
                              normal on 
                             } 
                } 
                
background { color rgb < 0.6, 0.6, 0.8 > }

camera {
        location  < 1.5, -0.4, -46 >
        look_at < -1, 2, 0 > 
        angle 48                                         
       }
       
light_source { < 1000, 1200, -1000 > color Gray20 }  // main

light_source { < 100, 120, -100 > color Gray50    // on snake
                spotlight
                point_at < 1.5, -0.5, -45 >
                falloff   10
                radius    5
                tightness  80
             }                                         
light_source { < 50, 50, -50 > color rgb < 0.6, 0.3, 0.1 >       // on sheep
                spotlight
                point_at < 1.5, -0.5, -39 >
                falloff   2
                radius    1
                tightness  80
             }
light_source { < 100, 120, -50 > color White   // on far hills
                spotlight
                point_at < 10, -2, 22 >
                falloff   20
                radius    15
                tightness  50
             }                                
light_source { < 4, 2.5, -35 > color Gray55 }      // back room    
light_source { < 2.3, 2, -36.5 > color Gray85 }     // window
 




// CUMULOUS CLOUD  ***********************************************  


#declare Cumul =
height_field {                                       // white cloud
               tga "Gran2.tga" smooth
               translate < -0.5, -0.5, -0.5 >
               scale < 100, 11, 15 >               
               rotate x*-25
               clipped_by {
                            box { < -100, 0, 0 >,< 100, 40, 140 > }
                          }  
               pigment { 
                        gradient y
                        color_map {
                                    [ 0 color Gray75 ]
                                    [ 1 color White ] 
                                   
                                  }
                              scale 10 
                              translate y*-4.5                                                            
                        }           
                          
               finish { ambient 0.2 }
              
               }                                                                                      
#declare Cbase =
height_field {                                       // cloud base
               tga "Gran2.tga" smooth
               translate < -0.5, -0.5, -0.5 >
               scale < 100, 11, 15 >               
               rotate < 10, 0, 180 >
               clipped_by {
                            box { < -100, -200, 0 >,< 100, 140, 140 > }
                          }  
               pigment { color White }                         
                          
               finish { ambient 0 }
              
               }
               
#declare Puff =
                union {                               
                        object { Cumul  translate < 6, 5, 20 > }
                        object { Cbase scale < 1, 0.45, 1 >  translate < 0, 5.3, 20 > } 
                                      clipped_by {
                                                   cylinder { < 0, 3, 15 >,< 0, 3, 75 >,15 }
                                                 }
                      }
object { Puff translate < 7.5, -1.4, 25 > }    
object { Puff translate < 11, -2, 22 > }                                                                 


                                                                                     
              
// LANDSCAPE **************************************************************************               
                                                                                    
height_field {                                        // far hills
               gif "Fract009.gif" smooth
               translate < -0.5, -0.5, -0.5 > 
               rotate y*190
               scale < 30, 2, 5 >                             
               rotate < -30, 30, 0 >
              
               pigment { 
                         bozo
                         color_map {
                                                                        
                                     [ 0  color rgb < 0.9, 0.875, 0.82 >  ]
                                     [ 0.2 color rgb < 0.8, 0.92, 0.47 >  ]
                                     [ 0.25 color rgb < 0.9, 0.82, 0.37 > ]    
                                     [ 0.45 color rgb < 0.7, 0.7, 0.82 > ]
                                     [ 0.5 color rgb < 0.82, 0.92, 0.7 > ]      
                                     [ 0.6 color rgb < 0.8, 0.82, 0.7 > ]
                                     [ 1 color rgb < 0.6, 0.92, 0.6 > ]
                                    }
                               scale 0.04
                               turbulence 0.85
                         }                                            
                            
                          
               finish { ambient 0 }
               translate < -4, 0.2,-19.5 >
               } 


//plane { y, -0.595 pigment { color Gray80 } normal { bumps scale 0.01 } finish { ambient 0 } }                

union {               
        box { < -3, -0.52, -41 >,< 6.5, -0.7, -30 > }
        cylinder { < -3, -0.595, 0 >,< 6.5, -0.595, 0 >,0.075
                     scale < 1, 1, 3 >
                     translate z*-41
                 }
              pigment { 
                        granite
                        color_map {
                                   [ 0 color rgb < 0.3, 0.8, 0.1 > ]
                                   [ 0.25 color rgb < 0.4, 0.7, 0.2 > ]
                                   [ 0.5 color rgb < 0.2, 0.7, 0.4 > ]
                                   [ 0.75 color rgb < 0.3, 0.8, 0.1 > ]
                                   [ 1.0 color rgb < 0.6, 0.5, 0.3 > ]
                                   }
                        scale 0.1
                      }             
              finish { ambient 0 }
    }          
// Tussocks *********************************
                                               
#declare Straw =
               torus { 0.2, 0.005  rotate x*90
                            scale < 1, 4, 1 >
                            translate y*8
                            clipped_by {
                                        box { < 0, 0, -1 >,< 2.5, 8.1, 1 > }
                                       }
                            pigment { color rgb < 1, 0.9, 0.5 > }
                            finish { ambient 0.2 } 
                            translate < -0.15, -7.2, 0 >
                     } 
                     
#declare Number_of_Cycles = 10 ;
#declare Count_per_Cycle = 15 ;
#declare Coefficient = 0.01 ;
#declare Starting_Angle = 0 ; 
#declare Angle = 360 / Count_per_Cycle ;
#declare Count = Number_of_Cycles * Count_per_Cycle -1 ;

#declare SD1 = seed(1) ;
#declare SD2 = seed(2) ;

#declare Tussok =
                union {
                       #while ( Count >= 0 )
                       object { Straw
                                scale < 1, 1.5*rand(SD1), 1 > 
                                translate < 0.5*rand(SD2), 0.2*rand(SD1), 0 >
                                rotate < 5*rand(SD1), Starting_Angle*rand(SD2), 2*rand(SD1) >
                               }
                       #declare Starting_Angle = Starting_Angle + Angle ;
                       #declare Count = Count - 1 ;
                       #end
                       }
                       
object { Tussok   scale 0.25 translate < 0.77, -0.53, -39.05 > }   
object { Tussok  scale 0.25 rotate y*90 translate < 3.05, -0.53, -38.7 > }  
    
                      

// SHEEP **********************************

#declare Wool =
               texture {
                          pigment { color rgb < 0.95, 0.78, 0.7 > }
                          normal { bumps 0.5 scale < 0.04, 0.08, 0.04 > }
                          finish { ambient 0 }
                       }   
                          

#declare Middle =
                 superellipsoid { < 1, 0.5 > 
                                    rotate y*-90
                                    scale < 1.45, 0.9, 0.75 > 
                                    texture { Wool }                                    
                                } 
#declare Dew = 
                superellipsoid { < 1, 0.5 > 
                                    rotate y*-90
                                    scale < 0.465, 0.825, 0.48 > 
                                    rotate z*-15
                                    translate < 1.5, -0.25, 0 >
                                    texture { Wool }
                                } 
#declare Neck =
                cone { < 1.7, -0.42, 0 >,0.7,< 2.5, -0.9, 0 >,0.2
                              scale < 1, 1, 0.65 >
                              texture { Wool }
                      } 
                      
#declare Ear =
              sphere { < 0, 0, 0 >,0.36
                         scale < 0.1, 0.25, 1 > 
                         pigment { color White }
                         finish { ambient 0 }
                     } 
#declare Eye =
               union {
                      sphere { < 0, 0, 0 >,0.2
                                 scale < 1.5, 1, 0.5 > 
                                 pigment { color White }
                                 finish { ambient 0 }
                             }
                      sphere { < 0, 0, 0 >,0.07 
                                 scale < 1, 0.8, 0.5 >
                                 translate < 0, 0, -0.08 >
                                 pigment { color Black } 
                             }
                     } 
#declare Nose =
               cylinder { < 0.44, 0.03, -0.1 >,< 0.44, 0.03, 0.1 >,0.07
                                pigment { color Gray60 }
                                finish { ambient 0 }
                        }                                                                            
                                                                                     
#declare Head = union {
                        sphere {  < 0, 0, 0 >,0.5
                              scale < 1, 0.4, 0.4 >
                              pigment { color White }
                              finish { ambient 0 }
                               } 
                        object { Nose }       
                        object { Ear rotate < -20, 30, 0 > translate < -0.4, -0.05, -0.35 > }
                        object { Ear translate < -0.3, -0.05, 0.35 > }
                        object { Eye translate < -0.1, 0, -0.12 > }
                        object { Eye rotate x*180 translate < -0.1, 0, 0.12 > }                                      
                        sphere {  < 0, 0, 0 >,0.5      //jaw
                              scale < 0.5, 0.35, 0.45 >
                              translate < -0.147, -0.2, 0 >
                              pigment { color White }
                              finish { ambient 0 }
                               }       
                        sphere { < 0, 0, 0 >,0.35     //poll
                                  scale < 1, 0.5, 0.8 >
                                  translate < -0.3, 0.2, 0 >    
                               }
                        difference {       
                                     sphere { < 0, 0, 0 >,0.3 }
                                     cylinder { < 0.3, 0, -0.3 >,< 0.3, 0, 0.3 >,0.3 scale < 1, 0.6, 1 > }
                                               scale < 0.8, 0.9, 0.25 >
                                               translate < -0.3, 0, -0.25 > 
                                   }                                                           
                        difference {       
                                     sphere { < 0, 0, 0 >,0.3 }
                                     cylinder { < 0.3, 0, -0.3 >,< 0.3, 0, 0.3 >,0.3 scale < 1, 0.6, 1 > }
                                               scale < 0.8, 0.9, 0.25 >
                                               translate < -0.3, 0, 0.25 > 
                                   }                   
                        
                                  texture { Wool }
                      }
#declare Foot =
                union {
                       cylinder { < 0, -0.15, 0 >,< 0, 0.025, 0 >,0.09
                                      rotate z*2
                                      pigment { color Gray60 }
                                      finish { ambient 0 }
                                }
                       sphere { < 0, 0, 0 >,0.1
                                      scale < 1.5, 1, 1 >
                                      rotate z*-30
                                      translate < -0.05, 0.05, 0 >
                                      pigment { color Gray90 }
                                      finish { ambient 0 } 
                              }
                     }                                                                                                               
#declare Fleg =
                union { 
                       superellipsoid { < 1, 0.5 >                                   
                                            scale < 0.4, 0.6, 0.33 >
                                            translate y*0.5 
                                            texture { Wool }
                                      }
                       cylinder { < 0, 0, 0 >,< 0, -1, 0 >,0.08
                                        pigment { color Gray90 }
                                        finish { ambient 0 }
                                } 
                        object { Foot translate < 0.08, -1, 0 > }
                                                                                               
                                       
                      }                                              
#declare Bleg =
                union { 
                       superellipsoid { < 1, 0.5 >                                   
                                            scale < 0.42, 0.6, 0.33 >
                                            translate y*0.5 
                                      }                              
                       superellipsoid { < 1, 0.5 >                                   
                                            scale < 0.3, 0.25, 0.3 >
                                            translate < -0.3, 0.1, 0 > 
                                      }               
                       cylinder { < -0.35, 0, 0 >,< -0.35, -1, 0 >,0.08
                                         pigment { color Gray90 }
                                         finish { ambient 0 }       
                                }
                       object { Foot translate < -0.26, -1.05, 0 > }                                                                         
                                         texture { Wool }
                      }                                 
                                                       
#declare Sheep =
               union {
                       object { Middle translate y*-0.15 }
                       object { Dew translate y*-0.15 }
                       object { Head rotate z*-75 translate < 2.35, -1.2, 0 > } 
                       object { Fleg rotate z*25 translate < 0.85, -1, -0.35 > } 
                       object { Fleg rotate z*-25 translate < 0.8, -1.1, 0.35 > } 
                       object { Bleg rotate z*-15 translate < -1, -1, -0.35 > }     
                       object { Bleg rotate z*30 translate < -0.7, -0.9, 0.35 > } 
                       object { Neck }
                       translate y*2
                       scale 0.125
                      }
object { Sheep scale 0.8 rotate y*25 translate < 3.25, -0.52, -40 >  }                        
               
// SECOND SHEEP ************************************ 

#declare Ahead = union {
                        sphere {  < 0, 0, 0 >,0.5
                              scale < 1, 0.4, 0.4 >
                              pigment { color White }
                              finish { ambient 0 }
                               } 
                        object { Nose }       
                        object { Ear rotate < -20, 30, 0 > translate < -0.4, -0.05, -0.35 > }
                        object { Ear translate < -0.3, -0.05, 0.35 > }
                        object { Eye translate < -0.1, 0, -0.12 > }
                        object { Eye rotate x*180 translate < -0.1, 0, 0.12 > }                                      
                        sphere {  < 0, 0, 0 >,0.5      //jaw
                              scale < 0.5, 0.35, 0.45 >
                              translate < -0.147, -0.2, 0 >
                              pigment { color White }
                              finish { ambient 0 }
                               }       
                        sphere { < 0, 0, 0 >,0.35     //poll
                                  scale < 0.6, 0.5, 0.8 >
                                  translate < -0.13, 0.2, 0 >    
                               }
                        difference {       
                                     sphere { < 0, 0, 0 >,0.3 }
                                     cylinder { < 0.3, 0, -0.3 >,< 0.3, 0, 0.3 >,0.3 scale < 1, 0.6, 1 > }
                                               scale < 0.8, 0.9, 0.25 >
                                               translate < -0.3, 0, -0.25 > 
                                   }                                                           
                        difference {       
                                     sphere { < 0, 0, 0 >,0.3 }
                                     cylinder { < 0.3, 0, -0.3 >,< 0.3, 0, 0.3 >,0.3 scale < 1, 0.6, 1 > }
                                               scale < 0.8, 0.9, 0.25 >
                                               translate < -0.3, 0, 0.25 > 
                                   }                   
                        
                                  texture { Wool }
                      }


#declare Aneck =
                union { 
                        torus { 0.5, 0.16
                                  scale < 1, 1.3, 0.65 >
                                  rotate z*-60                                  
                                  translate < 1.67, 0.175, 0 > 
                              }                                      
                        torus { 0.45, 0.14 
                                  scale < 1, 1.3, 0.65 >
                                  rotate z*-56                                  
                                  translate < 1.8, 0.4, 0 > 
                              }                             
                        torus { 0.38, 0.1 
                                  scale < 1, 1.3, 0.65 >
                                  rotate z*-50                                  
                                  translate < 2, 0.6, 0 > 
                              }                
                        cone { < 1.2, 0, 0 >,0.7,< 2.25, 1.15, 0 >,0.2
                                 scale < 1, 1, 0.65 >
                             }         
                                  texture { Wool }
                      } 
#declare Ableg =
                union { 
                       superellipsoid { < 1, 0.5 >                                   
                                            scale < 0.42, 0.6, 0.33 >
                                            translate y*0.5 
                                      }                              
                       superellipsoid { < 1, 0.5 >                                   
                                            scale < 0.3, 0.25, 0.3 >
                                            translate < -0.3, 0.1, 0 > 
                                      }               
                       cylinder { < -0.5, 0, 0 >,< -0.35, -0.99, 0 >,0.08
                                         pigment { color Gray90 }
                                         finish { ambient 0 }       
                                }
                       object { Foot translate < -0.26, -1.05, 0 > }                                                                         
                                         texture { Wool }
                      }                                 
                                                       
#declare Asheep =
               union {
                       object { Middle translate y*-0.15 }
                       object { Dew translate y*0.15 }
                       object { Ahead rotate z*-40 translate < 2.25, 0.75, 0 > } 
                       object { Fleg  translate < 0.85, -1, -0.35 > } 
                       object { Fleg  translate < 0.85, -1, 0.35 > } 
                       object { Ableg rotate z*1 translate < -0.75, -0.95, -0.35 > }     
                       object { Ableg rotate z*-15 translate < -0.75, -0.9, 0.35 > } 
                       object { Aneck }
                       translate y*2
                       scale 0.125
                      }
object { Asheep rotate y*-15 translate < 1.6, -0.52, -39 > }                                          
                                     
      
                                                    

// SKY ******************************************************************************

cylinder { < -100, 0, 0 >,< 100, 0, 0 >,1        // background sky
             texture {
                       pigment { 
                                 gradient y
                                 color_map {
                                            [ 0 color rgb < 0.7, 0.8, 0.9 > ]                                             
                                            [ 0.4 color rgb < 0.5, 0.6, 1 > ]       
                                            [ 1.0 color rgb < 0.7, 0.8, 0.9 > ]
                                           }                                  
                                 
                                            
                               }
                       finish { ambient 1 diffuse 0 }
                       }
             scale < 5000, 5000, 7000 >
           }                                      


// DOG ************************************************* 

#declare Dark =
               texture {
                          pigment { color rgb < 0.5, 0.5, 0.56 > }
                          normal { dents scale < 0.005, 0.045, 0.005 > }
                          finish { ambient 0 }
                        }
#declare Light =
                texture {
                          pigment { color rgb < 0.9, 0.9, 0.95 > }
                          normal { bumps 0.25 scale < 0.005, 0.05, 0.005 > }
                          finish { ambient 0 }
                         }                          

#declare Bod =
               sphere { < 0, 0, 0 >,0.12
                          scale < 0.5, 1, 0.5 >
                          rotate z*-25
                          translate y*0.15 
                          texture { Dark }                           
                      } 
#declare Chest =
                sphere { < 0, 0, 0 >,0.1
                          scale < 0.25, 0.8, 0.5 >
                          rotate z*-15
                          translate < 0.046, 0.17, 0 > 
                          texture { Light }
                       }
#declare Neck =
                   torus { 0.025, 0.015
                           scale < 1, 2, 1 >
                           rotate z*-28 
                           translate < 0.044, 0.245, 0 >
                               texture { Light }
                         } 
#declare Dogear =
                   difference {
                                sphere { < 0, 0, 0 >,0.038
                                           scale < 0.45, 1, 0.1 >
                                       }
                                box { < -0.1, 0, -0.1 >,< 0.1, 0.1, 0.1 > }
                                        texture { Dark }                                          
                               } 
#declare Dogeye =
                  union {
                           sphere { < 0, 0, 0 >,0.015
                                     scale < 1, 1, 0.2 >
                                     texture { Dark }                                     
                               } 
                            sphere { < 0, 0, 0 >,0.006 
                                     scale < 1, 1, 0.2 >
                                     translate z*-0.003
                                     pigment { color White }
                                     finish { ambient 0 } 
                                   }                                    
                            sphere { < 0, 0, 0 >,0.004
                                     translate z*-0.0036
                                     pigment { color Black }
                                     finish { ambient 0 } 
                                   }                                 
                         }                 
#declare Cold = sphere { < 0, 0, 0 >,0.006 scale < 1.25, 1, 2.5 > pigment { color Gray60 } } 
#declare Tongue = sphere { < 0, 0, 0 >,0.02 
                                scale < 1, 0.1, 0.5 >
                                rotate < 15, -30, 0 >
                                pigment { color Red }
                                finish { ambient 0 }
                          }                                                                                                                                                                                               
#declare Head =
               union { 
                       object { Dogear 
                                  rotate < 16, 0, 30 >
                                  translate < -0.016, 0.028, -0.031 >
                              }                                                
                       object { Dogear 
                                  rotate < -16, 0, 30 >
                                  translate < -0.016, 0.028, 0.031 >
                              }     
                       sphere { < 0, 0, 0 >,0.04                   // slull 
                                   texture { Dark }                                
                              } 
                       object { Dogeye 
                                       rotate < 20, -30, 0 >
                                       translate < 0.022, 0.013, -0.027 > }         
                       object { Dogeye 
                                       rotate < 160, 30, 0 >
                                       translate < 0.022, 0.013, 0.027 > }                       
                        sphere { < 0, 0, 0 >,0.038                           // jaw
                                scale < 1, 0.33, 0.75 > 
                                clipped_by {
                                             box { < -0.1, 0, -0.1 >,< 0.1, -0.1, 0.1 > 
                                                         rotate  z*-10
                                                 }
                                           } 
                                rotate z*-5            
                                translate < 0.04, -0.01, 0 >
                                texture { Light rotate z*90 }
                              } 
                       object { Tongue rotate z*-10 translate < 0.06, -0.01, 0.01 > }             
                       sphere { < 0, 0, 0 >,0.038                              // muzzle
                                scale < 1, 0.55, 0.75 > 
                                clipped_by {
                                             box { < -0.1, -0.007, -0.1 >,< 0.1, 0.1, 0.1 > 
                                                         rotate  z*10
                                                 }
                                           }  
                                translate < 0.04, 0, 0 >
                                 texture { Light rotate z*90 }
                              } 
                        object { Cold translate < 0.072, 0.004, 0 > }      
                           rotate z*-18     
                           translate < 0.065, 0.265, 0 >                          
                      } 
#declare Dlegs =
                union {
                       sphere { < 0, 0, 0 >,0.02
                                   scale < 1.5, 2.5, 1 >
                                   rotate x*5
                                   translate < 0.04, 0.175, -0.038 > 
                                     texture { Dark }                                   
                              }
                       sphere { < 0, 0, 0 >,0.02
                                   scale < 1.5, 2.5, 1 >
                                   rotate x*-5
                                   translate < 0.04, 0.175, 0.038 >
                                   texture { Dark }                                   
                              }
                       cylinder { < 0.035, 0.07, -0.04 >,< 0.045, 0.15, -0.04 >,0.011 
                                          texture { Dark }                                      
                                } 
                       cylinder { < 0.035, 0.085, 0.04 >,< 0.045, 0.15, 0.04 >,0.011  
                                          texture { Dark }  
                                }       
                       cylinder { < 0.045, 0, -0.04 >,< 0.035, 0.085, -0.04 >,0.01 } 
                       cylinder { < 0.045, 0, 0.04 >,< 0.035, 0.085, 0.04 >,0.01  } 
                       sphere { < 0, 0, 0 >,0.015
                                        scale < 1, 0.75, 1 >
                                        translate < 0.055, 0.003, -0.04 >
                               }                                                 
                       sphere { < 0, 0, 0 >,0.015
                                        scale < 1, 0.75, 1 >
                                        translate < 0.055, 0.003, 0.04 >
                               }         
                                         texture { Light }
                      } 
#declare Bfeet =
                 union { 
                        sphere { < 0, 0, 0 >,0.01
                                        scale < 4, 1, 1.1 >
                                        translate < -0.04, 0.005, -0.05 > 
                                         texture { Light }
                               }                     
                        sphere { < 0, 0, 0 >,0.01
                                        scale < 4, 1, 1.1 >
                                        translate < -0.04, 0.005, 0.05 > 
                                         texture { Light }
                               }
                       }                                     
#declare Thighs = 
                 union {
                        sphere { < 0, 0, 0 >,0.05
                                   scale < 1, 1, 0.45 >
                                   rotate x*10
                                   translate < -0.05, 0.05, -0.05 >
                               }                                
                        sphere { < 0, 0, 0 >,0.05
                                   scale < 1, 1, 0.45 > 
                                   rotate x*-10
                                  translate < -0.05, 0.05, 0.05 >
                               }
                                     texture { Dark }  
                      } 
#declare Lumbar =
                  sphere { < 0, 0, 0 >,0.06
                              scale < 0.8, 1.2, 0.7 >
                              translate < -0.065, 0.06, 0 >
                                texture { Dark }  
                         }                                          
#declare Waist =
                   torus { 0.04, 0.015
                           scale < 1, 3, 1 >
                           rotate z*-15 
                           translate < -0.03, 0.1, 0 >
                                texture { Dark }  
                         }
#declare Tail =
               union {
                      sphere { < 0, 0, 0 >,0.02
                                 scale < 2.3, 1, 1 >
                                 translate < -0.02, 0.01, 0.08 >
                                  texture { Light rotate z*90 }
                              }
                      difference {
                                   torus { 0.04, 0.02
                                           translate < 0, 0.01, 0.04 > 
                                         }
                                   box { < 0.04, -0.1, -1.1 >,< 1, 0.1, 1.1 > } 
                                              translate x*-0.06 
                                                texture { Dark }  
                                 } 
                      }                                                                                                                 
                                                         
#declare Dog =
              union {
                      object { Head }
                      object { Neck }                      
                      object { Bod }
                      object { Chest }
                      object { Dlegs }
                      object { Thighs }
                      object { Bfeet }
                      object { Lumbar }
                      object { Waist } 
                      object { Tail }  
                    }
                    
object { Dog rotate y*140 translate < 2.5, -0.52, -39 > } 

// LAMB  **********************************************************                                                                    

#declare Pelt =
                texture {
                         pigment { color rgb < 1, 1, 0.8 > }
                         normal { bumps 0.65 scale 0.034 }
                         finish { ambient 0 }
                        }
 

#declare Orb =                                              // eye 
              union {
                     sphere { < 0, 0, 0 >,0.1
                                 pigment { color Black}
                                 finish { phong 1 }
                            }
                     difference {       
                                  sphere { < 0, 0, 0 >,0.175 }
                                  box { < -0.2, 0.04, -0.2 >,< 0.2, -0.2, 0.2 > rotate z*25 }
                                          texture { Pelt }
                                }
                    }                                 

#declare Searr =                                            // right ear
                 cylinder { < -0.75, 0, 0 >,< 0, 0, 0 >,0.25
                               clipped_by {
                                             box { < -1, -0.25, -1 >,< 1, 1, 1 >
                                                         rotate < 40, 0, -60 >
                                                         translate y*0.15
                                                 }
                                          } 
                               scale < 2, 1, 1 >           
                               texture { Pelt }
                          }                                                                         
#declare Searl =                                            // left ear
                 cylinder { < 0.75, 0, 0 >,< 0, 0, 0 >,0.25
                               clipped_by {
                                             box { < -1, -0.25, -1 >,< 1, 1, 1 >
                                                         rotate < 40, 0, 60 >
                                                         translate y*0.15
                                                 }
                                          } 
                               scale < 2, 1, 1 >           
                               texture { Pelt }
                          }
#declare Nost =                                               // nostrils
               union {
                       sphere { < 0, 0, 0 >,0.12 
                                   scale < 2, 0.7, 0.9 >
                                   translate < 0, 0.1, -0.1 >
                              }                         
                       sphere { < 0, 0, 0 >,0.12 
                                   scale < 2, 0.7, 0.9 >
                                   translate < 0, 0.1, 0.1 >
                              }             
                                   pigment { color Gray50 } 
                     }                                                                                      
#declare Lmhed =                                           // head
                union {
                       difference { 
                                   sphere_sweep {
                                                 cubic_spline
                                                 5
                                                 < -0.5, 0, 0 >,0.75
                                                 < 0, 0, 0 >,0.7
                                                 < 0.5, -0.3, 0 >,0.5
                                                 < 0.95, -0.5, 0 > 0.25
                                                 < 1.2, -0.7, 0 >,0.2
                                                } 
                                   object { Nost rotate z*-30 translate < 0.95, -0.5, 0 > }
                                   }            
                        object { Orb translate < 0.4, 0, -0.6 > }     
                        object { Orb translate < 0.4, 0, 0.6 > } 
                        object { Searr rotate y*-90 translate < -0.1, 0.25, -0.5 > }    
                        object { Searl rotate y*-90 translate < -0.1, 0.25, 0.5 > }            
                                       texture { Pelt }
                     }
#declare Rfleg =                                                          // right front leg
                union { 
                        union {
                               sphere { < 0, 0, 0 >,0.5 
                                            scale < 0.8, 1, 0.4 >
                                            rotate x*15
                                            translate < 1.8, 0.8, 0 >
                                      }                               
                               cone { < 0, -0.09, 0 >,0.5,< -0.4, -0.7, -0.65 >,0.2 
                                          scale < 0.8, 1, 0.3 >
                                          translate < 1.8, 0.8, -0.05 > 
                                    }      
                               }                        
                        cylinder { < 2, 1, 0.05 >,< 1.4, 0.1, -0.05 >,0.2 }
                        sphere { < 1.4, 0.1, -0.05 >,0.2 }
                        cylinder { < 1.4, 0.1, -0.05 >,< 2.6, 0.2, 0 >,0.2 }
                        sphere { < 2.56, 0.19, 0 >,0.25 }      
                        cylinder { < 2.6, 0.2, 0 >,< 2.1, -0.8, 0 >,0.18 } 
                        sphere { < 2.1, -0.75, 0 >,0.22 }
                        cone { < 2.1, -0.8, 0 >,0.14,< 1.6, -0.8, 0 >,0.22 }
                                    translate z*-0.9 
                                    texture { Pelt }
                      }                                                                                   
#declare Lfleg =                                                            // left front leg
                union { 
                        union {
                               sphere { < 0, 0, 0 >,0.5 
                                          scale < 0.8, 1, 0.4 >
                                          rotate x*-15
                                          translate < 1.8, 0.8, 0 >
                                      }                                   
                               cone { < 0, -0.09, 0 >,0.5,< -0.4, -0.7, 0.65 >,0.2 
                                          scale < 0.8, 1, 0.3 >
                                          translate < 1.8, 0.8, 0.05 >
                                    }      
                               }                        
                        cylinder { < 2, 1, -0.05 >,< 1.4, 0.1, 0.05 >,0.2 }
                        sphere { < 1.4, 0.1, 0.05 >,0.2 }
                        cylinder { < 1.4, 0.1, 0.05 >,< 2.6, 0.2, 0 >,0.2 }
                        sphere { < 2.56, 0.19, 0 >,0.25 }      
                        cylinder { < 2.6, 0.2, 0 >,< 2.1, -0.8, 0 >,0.18 } 
                        sphere { < 2.1, -0.75, 0 >,0.22 }
                        cone { < 2.1, -0.8, 0 >,0.14,< 1.6, -0.8, 0 >,0.22 }
                                    translate z*0.9 
                                    texture { Pelt }
                      } 
#declare Rbakleg =                                                        // right back leg
                  union { 
                          sphere { < -0.05, 0, 0 >,0.7
                                      scale < 1, 1, 0.6 >
                                      translate z*0.2
                                 }     
                          cone { < 0, 0, 0.2 >,0.7,< -0.4, -1.4, -0.15 >,0.4 
                                      scale < 1, 1, 0.3 >
                               } 
                          sphere { < -0.05, -1.3, 0 >,0.2 }           
                          
                          cylinder { < 0, -1.3, 0 >,< -1.4, -1.5, 0 >,0.2 }  
                          cylinder { < 0, -1.1, 0 >,< -1.4, -1.4, 0 >,0.16 }
                          sphere { < -1.4, -1.45, 0 >,0.2 }
                          cylinder { < -1.4, -1.5, 0 >,< -1.6, -2.5, 0 >,0.2 }
                          sphere { < -1.6, -2.5, 0 >,0.22 }
                          cone { < -1.6, -2.5, 0 >,0.15,< -2.1, -2.75, 0 >,0.22 }
                                      translate z*-0.7
                                      texture { Pelt }
                         }                                                                    
#declare Lbakleg =                                                        // left back leg
                  union {
                           sphere { < -0.05, 0, 0 >,0.7
                                      scale < 1, 1, 0.6 >
                                      translate z*-0.2
                                 }     
                          cone { < 0, 0, 0 >,0.7,< -0.4, -1.4, -0.4 >,0.4 
                                      scale < 1, 1, 0.3 >
                               } 
                          sphere { < -0.05, -1.3, 0 >,0.2 }           
                          
                          cylinder { < 0, -1.3, 0 >,< -1.4, -1.5, 0 >,0.2 }  
                          cylinder { < 0, -1.1, 0 >,< -1.4, -1.4, 0 >,0.16 }
                          sphere { < -1.4, -1.45, 0 >,0.2 }
                          cylinder { < -1.4, -1.5, 0 >,< -1.6, -2.5, 0 >,0.2 }
                          sphere { < -1.6, -2.5, 0 >,0.22 }
                          cone { < -1.6, -2.5, 0 >,0.18,< -2.1, -2.75, 0 >,0.22 }
                                      translate z*0.7
                                      texture { Pelt }
                         }                                                                                                                     
#declare Lamb =                                                       
               union {                                                     // body               
                       sphere_sweep {
                                     cubic_spline
                                     8
                                     < -1.8, 0.3, 0 >,0.7
                                     < -1.5, 0.2, 0 >,0.8
                                     < 0, 0, 0 >,1
                                     < 1.5, 0.4, 0 >,1.1
                                     < 2, 0.6, 0 >,0.8                   
                     
                                     < 3, 1.5, 0 >,0.5
                                     < 3.3, 1.8, 0 >,0.4
                                     < 3.65, 1.8, 0 >,0.4
                                     texture { Pelt }
                                     } 
               object { Lmhed rotate z*-20translate < 3.4, 1.7, 0 > }          // head 
               object { Rfleg }
               object { Lfleg }
               object { Rbakleg translate < -1.5, 0.2, 0 > }    
               object { Lbakleg translate < -1.5, 0.2, 0 > }
                     } 
#declare Escap =
                  union {                     
object { Lamb scale 0.04  translate < 1.6, 0, 0 > }                
object { Lamb scale 0.042  translate < 2.3, 0.17, 0 > } 
object { Lamb scale 0.045  translate < 2.9, 0.16, 0 > } 
                         rotate y*40
                         translate z*-39.3 
                        }
object { Escap }  

// SECOND LAMB ************************************************

#declare Brfleg =                                                          // right front leg
                union { 
                        union {
                               sphere { < 0, 0, 0 >,0.5 
                                            scale < 0.8, 1, 0.4 >
                                            rotate x*15
                                            translate < 1.8, 0.8, 0 >
                                      }                               
                               cone { < 0, -0.09, 0 >,0.5,< -0.4, -0.7, -0.65 >,0.2 
                                          scale < 0.8, 1, 0.3 >
                                          translate < 1.8, 0.8, -0.05 > 
                                    }      
                               }                        
                        cylinder { < 2, 1, 0.05 >,< 1.4, 0.1, -0.05 >,0.2 }
                        sphere { < 1.4, 0.1, -0.05 >,0.2 }                    
                        cylinder { < 0, 0, -0.05 >,< 1.2, 0.1, 0 >,0.2 
                                      rotate z*-45
                                      translate < 1.4, 0.1, 0 >
                                 } 
                        sphere { < 2.31, -0.75, 0 >,0.25 }                    
                        cylinder { < 2.35, -0.6, 0 >,< 2.1, -1.4, 0 >,0.18 }   
                        sphere { < 2.05, -1.51, 0 >,0.22 }                    
                        cone { < 2.05, -1.51, 0 >,0.14,< 1.6, -1.8, 0 >,0.22 } 
                                    translate z*-0.9 
                                    texture { Pelt }
                      }                                                                                   
#declare Blfleg =                                                            // left front leg
                union { 
                        union {
                               sphere { < 0, 0, 0 >,0.5 
                                          scale < 0.8, 1, 0.4 >
                                          rotate x*-15
                                          translate < 1.8, 0.8, 0 >
                                      }                                   
                               cone { < 0, -0.09, 0 >,0.5,< -0.4, -0.7, 0.65 >,0.2 
                                          scale < 0.8, 1, 0.3 >
                                          translate < 1.8, 0.8, 0.05 >
                                    }      
                               }                        
                        cylinder { < 2, 1, -0.05 >,< 1.4, 0.1, 0.05 >,0.2 }
                        sphere { < 1.4, 0.1, 0.05 >,0.2 }
                        cylinder { < 0, 0, 0.05 >,< 1.2, 0.1, 0 >,0.2 
                                      rotate z*-45
                                      translate < 1.4, 0.1, 0 >
                                 }                         
                        sphere { < 2.31, -0.75, 0 >,0.25 }      
                        cylinder { < 2.35, -0.6, 0 >,< 2.1, -1.4, 0 >,0.18 } 
                        sphere { < 2.05, -1.51, 0 >,0.22 }
                        cone { < 2.05, -1.51, 0 >,0.14,< 1.6, -1.8, 0 >,0.22 } 
                                    translate < -1.8, -0.8, 0 >
                                    rotate z*35
                                    translate < 1.8, 0.8, 0.9 >
                                    texture { Pelt }
                      }  

#declare Blamb =
                 union {                                                     // body               
                       sphere_sweep {
                                     cubic_spline
                                     8
                                     < -1.8, 0.3, 0 >,0.7
                                     < -1.5, 0.2, 0 >,0.8
                                     < 0, 0, 0 >,1
                                     < 1.5, 0.4, 0 >,1.1
                                     < 2, 0.6, 0 >,0.8                   
                     
                                     < 3, 1.5, 0 >,0.5
                                     < 3.3, 1.8, 0 >,0.4
                                     < 3.65, 1.8, 0 >,0.4
                                     texture { Pelt }
                                     } 
               object { Lmhed rotate z*10 translate < 3.4, 1.7, 0 > }          // head 
               object { Brfleg }
               object { Blfleg }
               object { Rbakleg translate < -1.5, 0.2, 0 > }    
               object { Lbakleg translate < -1.5, 0.2, 0 > } 
                       }
                                         
                     
object { Blamb scale 0.054  rotate < 0, 45, -15 >  translate < 2.75, 0.05, -40.5 > }  
                                                                                
// FRAME *******************************************

#declare Fin =
               union {
                      box { < 0, -0.6, 0 >,< 0.02, 1, 0.1 > }             // -1.4
                      cylinder { < 0.01, -0.6, 0 >,< 0.01, 1, 0 >,0.01 }  
                      cylinder { < 0.01, -0.6, 0.1 >,< 0.01, 1, 0.1 >,0.01 }
                                      pigment { color Gray70 }
                                      normal { bumps scale 0.001 }
                                      finish { ambient 0 }
                     }
#declare Forb =
               union {
                       object { Fin }
                       object { Fin translate x*0.09 }
                       box { < 0, -0.6, 0.03 >,< 0.1, 1, 0.06 > }
                                  pigment { color Gray70 }
                                   normal { bumps scale 0.001 }
                                  finish { ambient 0 }
                     }                                     

//object { Forb translate < 0.75, 0, -39 > }    
//object { Forb translate < 3, 0, -39 > }   
object { Forb rotate z*-90 translate < 2.1, 1, -39 > } 
//object { Forb translate < 0.75, 0, -40 > }   
//object { Forb translate < 0.75, 0, -41 > }   
object { Forb translate < 0.75, 0, -42 > }   
object { Forb translate < 0.75, 0, -43 > }   
object { Forb translate < 0.75, 0, -44 > }   
//object { Forb translate < 0.75, 0, -45 > }

#declare Rail =
               difference {
                           cylinder { < 0.8, 0, -41.5 >,< 0.8, 0, -44.6 >,0.02
                                     pigment { color Gray70 }
                                     finish { reflection 0.2 }
                                     }                                    
                           cylinder { < 0.8, 0, -41.4 >,< 0.8, 0, -44.7 >,0.016
                                     pigment { color Gray70 }
                                     finish { ambient 0 }
                                     } 
                          }                    
object { Rail }
object { Rail translate y*0.1 }   
object { Rail translate y*0.2 }  
object { Rail translate y*0.3 }  
object { Rail translate y*0.4 }  
object { Rail translate y*0.5 }
object { Rail translate y*0.6 }      
object { Rail translate y*0.7 }   
object { Rail translate y*0.8 }  
object { Rail translate y*0.9 }  
object { Rail translate y*-0.1 }  
object { Rail translate y*-0.2 }
object { Rail translate y*-0.3 }
object { Rail translate y*-0.4 }   
object { Rail translate y*-0.5 } 

// VINE ************************************** 

#declare Seye =
                union {
                        sphere { < 0, 0, 0 >,0.01
                                   pigment { color rgb < 0.8, 0.7, 0.5 > } 
                                   finish { ambient 0 }
                               }                                                  
                        sphere { < 0, 0, -0.004 >,0.007
                                   pigment { color Black } 
                                   finish { ambient 0 }
                               }                  
                        sphere { < 0, 0, 0 >,0.011
                                   pigment { color Clear } 
                                   finish { ambient 0 reflection 0.2 phong 1 phong_size 80 } 
                               }                                  
                                      scale < 0.95, 0.95, 0.7 >
                      }                                             

sphere_sweep {
               cubic_spline
               39
               < 1.4, -0.48, -45.6 >,0.024
               < 1.48, -0.49, -45.4 >,0.024
               < 1.6, -0.5, -45.3 >,0.029 
               < 1.7, -0.525, -45.2 >,0.038
               < 1.8, -0.55, -45 >,0.04 
               < 1.9, -0.55, -44.6 >,0.04
               < 1.8, -0.55, -44.3 >,0.04 
               < 1.9, -0.55, -44 >,0.04
               < 1.7,  -0.55, -43.75 >,0.04
               < 1.25, -0.55, -43.65 >,0.04
               < 1, -0.55, -43.5 >,0.04 
               < 0.85, -0.4, -43.5 >,0.035 
               < 0.83, -0.35, -43.45 >,0.032
               < 0.82, -0.3, -43.4 >,0.031
               < 0.75, -0.25, -43.4 >,0.03 
               < 0.72, -0.2, -43.4 >,0.03 
               < 0.75, -0.15, -43.4 >,0.03                
               < 0.8, -0.1, -43.43 >,0.03
               < 0.8, 0, -43.48 >,0.03 
               < 0.8, 0.1,  -43.5 >,0.029
               < 0.8, 0.15, -43.53 >,0.029      
               < 0.8, 0.2, -43.55 >,0.028
               < 0.75, 0.247, -43.6 >,0.027  // top 
               < 0.7, 0.2, -43.63 >,0.026
               < 0.72, 0.1, -43.675 >,0.026
               < 0.72, 0.05, -43.681 >,0.025
               < 0.81, 0, -43.82 >,0.024               
               < 0.82, -0.09, -44 >,0.023         // bottom
               < 0.82, -0.09, -44.1 >,0.022      // bottom
               < 0.81, 0.05, -44.171 >,0.021
               < 0.8,  0.1, -44.2 >,0.02
               < 0.75, 0.15, -44.25 >,0.019
               < 0.72, 0.2, -44.3 >,0.018
               < 0.75, 0.237, -44.35 >,0.017
               < 0.8, 0.2, -44.4 >,0.015
               < 0.8, 0.15, -44.4 >,0.012
               < 0.8, 0.1, -44.4 >,0.01
               < 0.8, 0, -44.4 >,0.005
               < 0.8, -0.1, -44.4 >,0.001      // tail
                  translate < 0.05, 0, 0.1 >
                   texture {
                             pigment { 
                                      crackle
                                      color_map {
                                                  [ 0 color Black ]   
                                                  [ 0.05 color Black ]  
                                                  [ 0.05 color  White  ]   
                                                  [ 0.95color  White  ]
                                                  [ 0.95color Black ]   
                                                  [ 1.0 color Black ]  
                                                 }
                                       scale < 0.02, 0.01, 0.01 >
                                      }
                              finish { ambient 0 }
                           } 
                  texture {
                           pigment { 
                                    spotted
                                    color_map {
                                                [ 0 color rgbt < 0, 0.9, 0, 0.3 > ] 
                                                [ 0.35 color rgbt < 0, 0.9, 0, 0.3 > ]
                                                [ 0.35 color rgbt < 0.3, 0.5, 0, 0.3 > ]
                                                [ 0.5 color rgbt < 0.6, 0.5, 0.2, 0.3 > ]  
                                                [ 0.65 color rgbt < 0.6, 0.5, 0.2, 0.3 > ]
                                                [ 0.75 color rgbt < 0, 0.9, 0, 0.3 > ]
                                                [ 0.9 color rgbt < 0, 0.9, 0, 0.3 > ]
                                                [ 1.0 color rgbt < 0.3, 0.5, 0.7, 0.3 > ]
                                               }
                                    scale 0.025
                                   }
                            normal { crackle scale 0.01 }                        
                            finish { ambient 0 reflection 0.1 phong 1 } 
                          }
              } 
              
#declare Tongue =
                 union {
                        sphere_sweep {
                                cubic_spline
                                10
                                < -0.06, -0.045, 0 >,0.0045
                                < -0.063, -0.045, 0 >,0.0045
                                < -0.075, -0.05, 0 >,0.0045
                                < -0.09, -0.06, 0 >,0.00425
                                < -0.1, -0.075, 0 >,0.004
                                < -0.11, -0.088, 0 >,0.0035
                                < -0.12, -0.1, 0 >,0.003
                                < -0.13, -0.105, 0.003 >,0.002
                                < -0.15, -0.11, 0.006 >,0.001
                                < -0.16, -0.11, 0.01 >,0.0005                                  
                                }                                     
                     sphere_sweep {
                                cubic_spline
                                5                              
                                < -0.11, -0.088, 0 >,0.0035
                                < -0.12, -0.1, 0 >,0.003
                                < -0.13, -0.105, -0.003 >,0.002
                                < -0.15, -0.11, -0.006 >,0.001
                                < -0.16, -0.11, -0.01 >,0.0005 
                                } 
                                   scale < 1, 1, 1.6 >
                                   pigment { color rgb < 0.9, 0.6, 0.4 > } 
                                   normal { granite scale 0.001 }
                                   finish { ambient 0 phong 0.8 phong_size 80 }
                      }                         
difference {                                                                       // head           
       union {                 
           sphere { < 0, 0, 0 >,0.06   scale < 1.5, 0.6, 0.8 >  
                         clipped_by {
                                      box { < -0.11, -0.008, -0.06 >,< 0.11, 0.06, 0.06 > }
                                    } 
                   }                   
           torus { 0.054, 0.004   scale < 1.5, 2.5, 0.8 > translate y*-0.006 }
             }
       union {
               sphere { < 0, 0.018, -0.045 >,0.01 }
               cone { < 0, 0.018, -0.044 >,0.01,< -0.1, 0.014, -0.046 >,0.03 }   
               sphere { < 0, 0.018, 0.044 >,0.01 }
               cone { < 0, 0.018, 0.045 >,0.01,< -0.1, 0.014, 0.046 >,0.03 }
               sphere { < 0, 0, 0 >,0.006
                           scale < 2.5, 1, 0.75 >
                           translate < -0.09, 0.01, -0.01 >
                      }                                                    
               sphere { < 0, 0, 0 >,0.006
                           scale < 2.5, 1, 0.75 >
                           translate < -0.09, 0.01, 0.01 >
                      }                 
             }               
                    rotate y*-45
                    translate < 1.5, -0.48, -45.35 > 
                    texture {
                             pigment { 
                                      crackle
                                      color_map {
                                                  [ 0 color Black ]   
                                                  [ 0.05 color Black ]  
                                                  [ 0.05 color  White  ]   
                                                  [ 0.95color  White  ]
                                                  [ 0.95color Black ]   
                                                  [ 1.0 color Black ]  
                                                 }
                                       scale < 0.02, 0.01, 0.01 >
                                      }
                              finish { ambient 0 }
                           } 
                   texture { 
                             pigment { 
                                      spotted 
                                      color_map {
                                                [ 0 color rgbt < 0, 0.9, 0, 0.3 > ] 
                                                [ 0.33 color rgbt < 0, 0.9, 0, 0.3 > ]
                                                [ 0.35 color rgbt < 0.3, 0.5, 0, 0.3 > ]
                                                [ 0.5 color rgbt < 0.6, 0.5, 0.2, 0.3 > ]  
                                                [ 0.65 color rgbt < 0.6, 0.5, 0.2, 0.3 > ]
                                                [ 0.75 color rgbt < 0, 0.9, 0, 0.3 > ]
                                                [ 0.9 color rgbt < 0, 0.9, 0, 0.3 > ]
                                                [ 1.0 color rgbt < 0.3, 0.5, 0.7, 0.3 > ]
                                               }
                                              scale 0.025
                                      }
                            normal { crackle scale 0.02 }                        
                            finish { ambient 0 reflection 0.1 phong 1 }
                           } 
          }  
union {                                                    
         object { Seye rotate < 15, 47, 0 > translate < 0.002, 0.015, -0.036 > }        // eyes
         object { Seye rotate < 15, -47, 0 > translate < 0.002, 0.015, 0.036 > }                
                     rotate y*-45
                     translate < 1.5, -0.48, -45.35 > 
      }               
    
object { Tongue rotate y*-45 translate < 1.49, -0.44, -45.36 > }                   
sphere_sweep {                                                  // jaw and underbelly
               cubic_spline
               9
               < 1.4, -0.48, -45.6 >,0.024
               < 1.48, -0.49, -45.4 >,0.024
               < 1.6, -0.5, -45.3 >,0.029 
               < 1.7, -0.525, -45.2 >,0.038
               < 1.8, -0.55, -45 >,0.04 
               < 1.9, -0.55, -44.6 >,0.04
               < 1.8, -0.55, -44.3 >,0.04 
               < 1.9, -0.55, -44 >,0.04
               < 1.7,  -0.55, -43.75 >,0.04               
               translate < 0.05, -0.005, 0.1 >
                       texture {
                             pigment { 
                                      crackle
                                      color_map {
                                                  [ 0 color Black ]   
                                                  [ 0.05 color Black ]  
                                                  [ 0.05 color  White  ]   
                                                  [ 0.95color  White  ]
                                                  [ 0.95color Black ]   
                                                  [ 1.0 color Black ]  
                                                 }
                                       scale < 0.02, 0.01, 0.01 >
                                      }
                              finish { ambient 0 } 
                              }
            }
sphere { < 0, 0, 0 >,0.06
                    clipped_by {
                                 box { < -0.1, -0.1, -0.1 >,< 0.1, 0.02, 0.1 > }
                               }  
                    scale < 1.45, 0.35, 0.78 >
                    rotate y*-45
                    translate < 1.5, -0.49, -45.35 > 
                    texture {
                             pigment { 
                                      crackle
                                      color_map {
                                                  [ 0 color Black ]   
                                                  [ 0.05 color Black ]  
                                                  [ 0.05 color  White  ]   
                                                  [ 0.95color  White  ]
                                                  [ 0.95color Black ]   
                                                  [ 1.0 color Black ]  
                                                 }
                                       scale < 0.02, 0.01, 0.01 >
                                      }
                              finish { ambient 0 }
                           } 
     }                                              



// LEAVES *********************************************

#declare Rib =                        
                       torus { 0.1, 0.002
                                  rotate < 90, -45, 0 >
                                  clipped_by {
                                               box { < 0, -0.15, -0.15 >,< 0.15, 0.15, 0.15 > }
                                             }
                                  pigment { color Green }
                                  finish { ambient 0 }           
                              } 
#declare Ribs =
               union {
                      object { Rib }
                      
                      object { Rib rotate x*25 }  
                      object { Rib rotate x*50 } 
                      object { Rib rotate x*75 } 
                        
                      object { Rib rotate < -27, 10, 0 > }  
                     
                      object { Rib rotate < -80, 30, 0 > } 
                                        
                      object { Rib rotate y*-90 rotate x*12 }  
                      object { Rib rotate y*-90 rotate x*37 } 
                      object { Rib rotate y*-90 rotate x*62 } 
                        
                      object { Rib rotate y*-100 rotate x*-12 }  
                      object { Rib rotate y*-110 rotate x*-37 } 
                      object { Rib rotate y*-120 rotate x*-60 } 
                                                                      
                               
                       torus { 0.1, 0.004
                                  rotate z*90
                                  rotate y*5
                             }
                                  pigment { color Green }
                                  finish { ambient 0 }
                     } 
#declare Stalk = 
                  torus { 0.1, 0.004
                                  rotate z*90
                                  rotate y*5
                                  clipped_by {
                                               box { < -0.01, 0.28, -0.05 >,< 0.01, 0, -0.15 > }
                                             }                           
                                             
                                  scale < 1, 0.28, 1.6 >
                                  pigment { color Green }
                                  finish { ambient 0 }
                           }
                                      
#declare Web =
               union {
                       object { Ribs }
                       sphere { < 0, 0, 0 >,0.1 }
                                   clipped_by {
                                                box { < -0.1, 0.05, -0.1 >,< 0.1, 0.15, 0.1 > }
                                              } 
                                   scale < 1, 0.6, 1.6 >           
                                   pigment { color rgb < 0.1, 0.5, 0.2 > }
                                   finish { ambient 0 }
                     }
#declare Leaf =
                union {
                        object { Web rotate x*10 translate < 0, -0.0295, 0.05 > }
                        object { Stalk }
                                 scale 0.5
                                 translate < 0.004, 0, 0.08 >
                      }
object { Leaf scale 0.2 rotate z*-90 rotate < -7, 85, 0 > translate < 1.58, -0.495, -45.28 > }
object { Leaf scale 0.22 rotate z*-90 rotate < 7, 85, 0 > translate < 1.605, -0.4975, -45.264 > }    
object { Leaf scale 0.23 rotate z*-90 rotate < -7, 85, 0 > translate < 1.63, -0.5, -45.248 > }
object { Leaf scale 0.24 rotate z*-90 rotate < 7, 85, 0 > translate < 1.655, -0.502, -45.23 > }   
object { Leaf scale 0.25 rotate z*-90 rotate < -7, 85, 0 > translate < 1.68, -0.504, -45.212 > }
object { Leaf scale 0.26 rotate z*-90 rotate < 7, 85, 0 > translate < 1.705, -0.51, -45.194 > }         
object { Leaf scale 0.27 rotate z*-90 rotate < -7, 85, 0 > translate < 1.73, -0.516, -45.176 > }
object { Leaf scale 0.28 rotate z*-90 rotate < 7, 80, 0 > translate < 1.755, -0.522, -45.152 > }   
object { Leaf scale 0.29 rotate z*-90 rotate < -7, 75, 0 > translate < 1.78, -0.527, -45.129 > }
object { Leaf scale 0.3 rotate z*-90 rotate < 7, 70, 0 > translate < 1.8, -0.532, -45.1 > }
 

#declare Twig =
                 union { 
                         
                        torus { 0.25, 0.01
                                 rotate z*90
                                 clipped_by {
                                              box { < -0.1, -0.3, -0.3 >,< 0.1, 0, 0 > }
                                            }                                       
                                                                   
                                    translate y*0.25
                                    scale < 1, 1.2, 0.8 > 
                                    pigment { color Green }
                                    finish { ambient 0 }
                              }
                         object { Leaf scale 0.65 rotate z*-90 rotate x*-45 translate < 0, 0.3, -0.2 > }       
                         object { Leaf scale 0.8 rotate z*-90 rotate x*-135 translate < 0, 0.25, -0.2 > }  
                         object { Leaf rotate z*-90 rotate x*-45 translate < 0, 0.2, -0.19 > } 
                         object { Leaf rotate z*-90 rotate x*-150 translate < 0, 0.1, -0.16 > }
                         object { Leaf rotate z*-90 rotate x*-45 translate < 0, 0.05, -0.1 > }
                         cone { < 0, 0.25 -0.25 >,0.01,< 0, 0.32, -0.25 >,0                                     
                                    scale < 1, 1.2, 0.8 > 
                                    pigment { color Green }
                                    finish { ambient 0 }
                               }     
                                   rotate z*-10  
                         }                                                  
#declare Ltwig =
                 union {
                         torus { 0.25, 0.01
                                    rotate z*90
                                    clipped_by {
                                                 box { < -0.1, -0.3, -0.3 >,< 0.1, 0, 0 > }
                                               }                                    
                                    translate y*0.25
                                    scale < 1, 1.2, 0.8 > 
                                    pigment { color Green }
                                    finish { ambient 0 }
                               }
                         object { Leaf scale 0.65 rotate z*-60 rotate x*-45 translate < 0, 0.3, -0.2 > }       
                         object { Leaf scale 0.8 rotate z*-60 rotate x*-135 translate < 0, 0.25, -0.2 > }  
                         object { Leaf rotate z*-60 rotate x*-45 translate < 0, 0.2, -0.19 > } 
                         object { Leaf rotate z*-60 rotate x*-150 translate < 0, 0.1, -0.16 > }
                         object { Leaf rotate z*-60 rotate x*-45 translate < 0, 0.05, -0.1 > }
                          cone { < 0, 0.25, -0.25 >,0.01,< 0, 0.32, -0.25 >,0                                     
                                    scale < 1, 1.2, 0.8 > 
                                    pigment { color Green }
                                    finish { ambient 0 }
                               }     
                                   rotate z*-10  
                         }                                                                                                             
#declare Rtwig =
                 union {
                         torus { 0.25, 0.01
                                    rotate z*90
                                    clipped_by {
                                                 box { < -0.1, 0, 0.3 >,< 0.1, -0.3, 0 > }
                                               }                                    
                                    translate y*0.25
                                    scale < 1, 1.2, 0.8 > 
                                    pigment { color Green }
                                    finish { ambient 0 }
                               } 
                         object { Leaf scale 0.65 rotate z*-90 rotate x*-135 translate < 0, 0.3, 0.2 > }       
                         object { Leaf scale 0.8 rotate z*-90 rotate x*-45 translate < 0, 0.25, 0.2 > }  
                         object { Leaf rotate z*-90 rotate x*-135 translate < 0, 0.2, 0.19 > } 
                         object { Leaf rotate z*-90 rotate x*-40 translate < 0, 0.1, 0.16 > }
                         object { Leaf rotate z*-90 rotate x*-135 translate < 0, 0.05, 0.1 > }
                          cone { < 0, 0.25, 0.25 >,0.01,< 0, 0.32, 0.25 >,0                                     
                                    scale < 1, 1.2, 0.8 > 
                                    pigment { color Green }
                                    finish { ambient 0 }
                               }     
                                    rotate z*-10         
                         } 
                                                 
object { Ltwig scale 0.6 translate < 0.87, 0, -43.38 > } 
object { Ltwig scale 0.6 translate < 0.82, -0.15, -43.3 > }   
object { Rtwig scale 0.6 rotate y*80 translate < 0.87, 0.15, -43.4 > }   
object { Rtwig scale 0.6 rotate y*60 translate < 0.87, -0.05, -43.35 > } 
object { Rtwig scale 0.6 rotate y*50 translate < 0.9, -0.38, -43.3 > }           
object { Ltwig scale 0.6 rotate z*-10 translate < 0.86, -0.28, -43.3 > }       
object { Rtwig scale 0.6 rotate y*50 translate < 0.8, 0.248, -43.5 > }   //  top        
object { Ltwig scale 0.6 rotate z*-10 translate < 0.81, 0.248, -43.5 > } // top 
object { Rtwig scale 0.5 rotate y*50 translate < 0.89, -0.09, -43.9 > }   //  bottom   
object { Ltwig scale 0.6 rotate z*-10 translate < 0.87, -0.08, -43.98 > }        
object { Ltwig scale 0.5 rotate z*-10 translate < 0.87, 0.05, -44.05 > } 
object { Ltwig scale 0.5 rotate z*-10 translate < 0.84, 0.11, -44.09 > }
object { Ltwig scale 0.4 rotate z*10 translate < 0.76, 0.23, -44.3 > }  
object { Rtwig scale 0.4 rotate y*50 translate < 0.84, 0.21, -44.3 > } 
object { Ltwig scale 0.3 rotate z*-10 translate < 0.86, 0.18, -44.3 > } 
object { Rtwig scale 0.2 rotate y*90 translate < 0.85, 0.11, -44.3 > } 

object { Ltwig scale 0.6 rotate y*80 translate < 1, -0.53, -43.44 > }    
object { Ltwig scale 0.36 rotate y*80 translate < 1.35, -0.53, -43.57 > } 
object { Rtwig scale 0.25 rotate y*70 translate < 1.6, -0.53, -43.55 > }

object { Rtwig scale 0.28 rotate y*90 translate < 2, -0.54, -44.47 > }          
            



// CORRUGATED IRON ************************************

#declare Age =
               texture {
                         pigment {
                                   bozo
                                   color_map {
                                               [ 0 color rgbt < 0.6, 0.4, 0.1, 0.2 > ]
                                               [ 0.3 color Clear ]
                                               [ 0.6 color rgbt < 0.8, 0.8, 0.9, 0.2 > ]
                                               [ 0.8 color rgbt < 0.6, 0.4, 0.4, 0.1 > ]
                                               [ 1.0 color Clear ]
                                              }
                                   scale 0.1
                                  }
                         finish { ambient 0 }
                        }                               
#declare One =
               cylinder { < 0, -1, 0 >,< 0, 1, 0 >,0.1  open
                                clipped_by {
                                            box { < -0.15, -1.1, 0 >,< 0.15, 1.1, 0.15 > }
                                           }
                                texture {           
                                          pigment { color rgb < 0.9, 0.9, 1 > }
                                          finish { ambient 0 }
                                         }
                                                                                 
                       }
                        
#declare Sheet =
                 union {
                         object { One }
                         object { One rotate y*180 translate x*0.2 }
                         object { One translate x*0.4 }                       
                         object { One rotate y*180 translate x*0.6 }
                         object { One translate x*0.8 }                      
                         object { One rotate y*180 translate x*1 }
                         object { One translate x*1.2 }                      
                         object { One rotate y*180 translate x*1.4 }
                         object { One translate x*1.6 }                      
                         object { One rotate y*180 translate x*1.8 }
                         object { One translate x*2 } 
                                      scale < 2, 1, 0.8 >
                                      
                        }
union {                        
       object { Sheet scale < 0.1, 1, 0.1 > translate y*1 }
       object { Sheet scale < 0.1, 1, 0.1 > translate < 0.4, 1, 0 > }
                     rotate z*15
                     translate < 0.8, 0.7, -38.97 >
      } 
      
object { Sheet scale < 0.1, 0.5, 0.1 > rotate z*-10 translate < 1.2, 2.5, -39.03 > }            
                                            
#declare Sheets =
                  union {                         
object { Sheet scale < 0.1, 1, 0.1 > translate < 0.7, 2.2, -39 > }                           
object { Sheet scale < 0.1, 1, 0.1 > translate < 1.1, 2, -39 > }   
object { Sheet scale < 0.1, 1, 0.1 > translate < 1.5, 2, -39 > }  
object { Sheet scale < 0.1, 1, 0.1 > translate < 1.9, 2, -39 > }  
object { Sheet scale < 0.1, 1, 0.1 > translate < 2.3, 2, -39 > }   
object { Sheet scale < 0.1, 1, 0.1 > translate < 2.7, 2, -39 > }
                         } 

#declare Tim =
              texture {  T_Wood10 scale 0.05 }
                       
#declare Shed =
                 difference {
                              object { Sheets }
                              box { < 1.9, 1.5, -40 >,< 2.5, 2.1, -37 >
                                          texture { Tim }
                                  }
                            }
#declare Sash =
               object { Sheets
                              clipped_by { 
                                            box { < 1.9, 1.5, -40 >,< 2.5, 2.1, -37 > }
                                         }
                      }
object { Sash translate < 0, -2.1, 39 > rotate x*30 translate < 0, 2.1, -39 > }
                                            
box { < 2.1, 0, 0 >,< 2.15, 0.05, -0.29 > rotate x*15 translate < 0, 1.5, -39 > texture { Tim } }   // prop
                                                                       
box { < 1.9, 1.5, -40 >,< 2.5, 2.3, -36 >                                                  // inside window
                  clipped_by {
                               box { < 1.8, 1.4, -39 >,< 2.6, 2.4, -35 > }
                             }  
                  texture { Tim }
     }                            
object { Shed }                                                                   
                         

object { Sheets scale < 1, 1.5, 1 > translate < -2.4, -2.5, 0 > }  
object { Sheets scale < 1, 1.5, 1 > translate < -4.4, -2.5, 0 > } 

plane { z, -39.1                                                        // rust
              clipped_by {
                            box { < -5, -0.6, -38 >,< 0.7, 4, -40 > }
                         }
              pigment {
                       bozo
                       color_map {
                                  [ 0 color Clear ]  
                                  [ 0.12 color Clear ]
                                  [ 0.25 color rgbt < 1, 0.9, 0.5, 0.65 > ]
                                  [ 0.35 color rgbt < 1, 0.6, 0.4, 0.65 > ] 
                                  [ 0.5 color Clear ]  
                                  [ 1 color Clear ] 
                                 }
                        scale < 0.06, 0.8, 0.8 >  
                       }
                normal { bumps 0.75 scale 0.01 }       
                finish { ambient 0.3 }
       } 

 
object { Sheet scale < 0.1, 0.25, 0.1 > translate < 3, 0.8, -39 > }    
object { Sheet scale < 0.1, 0.25, 0.1 > translate < 3.4, 0.8, -39 > }
object { Sheet scale < 0.1, 0.25, 0.1 > translate < 3.8, 0.8, -39 > }
object { Sheet scale < 0.1, 0.25, 0.1 > translate < 4.2, 0.8, -39 > }
object { Sheet scale < 0.1, 0.25, 0.1 > translate < 4.6, 0.8, -39 > }
object { Sheet scale < 0.1, 0.25, 0.1 > translate < 5, 0.8, -39 > }
object { Sheet scale < 0.1, 0.25, 0.1 > translate < 5.4, 0.8, -39 > }
object { Sheet scale < 0.1, 0.25, 0.1 > translate < 5.8, 0.8, -39 > }
object { Sheet scale < 0.1, 0.25, 0.1 > translate < 6.2, 0.8, -39 > }
object { Sheet scale < 0.1, 0.25, 0.1 > translate < 6.6, 0.8, -39 > }

#declare Rafter =
                 box { < 0, -1, 0.01 >,< 0.03, 1, 0.06 >
                             translate x*3.1
                             pigment { color rgb < 0.8, 0.7, 0.4 > }
                             finish { ambient 0 }
                     }        
#declare Roof =
               union {                              
object { Sheet scale < 0.1, 5, 0.1 >  translate < 3.1, 4, 0 > }   
object { Sheet scale < 0.1, 5, 0.1 >  translate < 3.5, 4, 0 > }  
object { Sheet scale < 0.1, 5, 0.1 >  translate < 3.9, 4, 0 > }  
object { Sheet scale < 0.1, 5, 0.1 >  translate < 4.3, 4, 0 > }      
object { Sheet scale < 0.1, 5, 0.1 >  translate < 4.7, 4, 0 > }   
object { Sheet scale < 0.1, 5, 0.1 >  translate < 5.1, 4, 0 > }                 
object { Sheet scale < 0.1, 5, 0.1 >  translate < 5.5, 4, 0 > }  
object { Sheet scale < 0.1, 5, 0.1 >  translate < 5.9, 4, 0 > }      
object { Sheet scale < 0.1, 5, 0.1 >  translate < 6.3, 4, 0 > }   

object { Rafter }
object { Rafter translate x*0.2 }   
object { Rafter translate x*0.4 }  
object { Rafter translate x*0.6 }  
object { Rafter translate x*0.8 }  
object { Rafter translate x*1 }  
object { Rafter translate x*1.2 }  
object { Rafter translate x*1.4 }  
object { Rafter translate x*1.6 }  
object { Rafter translate x*1.8 }       
                    rotate x*69
                    translate < 0, 1.4, -38.25 > 
                      }
object { Roof }                                                     
                                                                                                                                                                       
//BIRD ************************************************

#declare Apin =
               union {
                      disc { < 1, -6, 0 >,< 0, 0, 1 >,1 }
                      triangle { < 0, 0, 0 >,< 2, 0, 0 >,< 0, -6, 0 > }
                      triangle { < 2, 0, 0 >,< 2, -6, 0 >,< 0, -6, 0 > }
                                 pigment {
                                           gradient y
                                           color_map {
                                                       [ 0 color rgb < 0.725, 0.625, 0.4 > ]
                                                       [ 1 color rgb < 0.975, 0.875, 0.7 > ] 
                                                      }
                                                 scale 7
                                          }
                                 finish { ambient 0 }
                       } 
                       
#declare Lpin =                 
                cylinder { < 0, 0, 0 >,< 3.5, 0, 0 >,2
                                    scale < 1, 1, 0.1 > 
                                    pigment { color rgb < 0.7, 0.6, 0.3 > }
                                    finish { ambient 0 }
                         }
#declare Leading =
                 union {
                        object { Lpin }
                        object { Lpin translate < 3.25, 0.1, 0 > }
                        object { Lpin translate x*6.5 }
                        object { Lpin translate < 9.75, 0.1, 0 > } 
                        object { Lpin translate x*12.25 }
                                     rotate z*5
                        }


#declare Trail =
                union {                                                                                               
                       object { Apin }             
                       object { Apin translate x*2 }
                       object { Apin translate < 4, 0.2, 0 > }
                       object { Apin translate < 6, 0, 0 > }
                       object { Apin translate < 8, 0.2, 0 > }       
                       object { Apin translate < 10, 0.1, 0 > }
                       object { Apin translate < 12, 0, 0 > }
                       object { Apin translate < 14, 0.12, 0 > }     
                       object { Apin translate < 16, 0.1, 0 > }
                       object { Apin translate < 18, 0, 0 > }
                       object { Apin translate < 20, 0.12, 0 > } 
                     }
                     
#declare Spin =
               disc { < 0, 0, 0 >,< 0, 0, 1 >,5
                          scale < 0.15, 1, 1 >
                          pigment { color rgb < 0.7, 0.6, 0.3 > }
                          finish { ambient 0 }
                    }
#declare Fpin =
               union {
                      object { Spin }
                      object { Spin scale < 1.2, 0.5, 1 > translate y*4.5 }
                     }                     
#declare Tip =
               union {
                       object { Fpin translate y*-6 scale < 1, 1.3, 1 > rotate z*22 }
                       object { Fpin translate y*-6 scale < 1, 1.5, 1 > rotate z*32 }
                       object { Fpin translate y*-6 scale < 1.1, 1.6, 1 > rotate z*42 }
                       object { Fpin translate y*-6 scale < 1.2, 1.7, 1 > rotate z*52 }
                       object { Fpin translate y*-6 scale < 1.3, 1.8, 1 > rotate z*62 }
                       object { Fpin translate y*-6 scale < 1.4, 2, 1 > rotate z*72 }
                       object { Fpin translate y*-6 scale < 1.5, 2.1, 1 > rotate z*82 }
                       object { Fpin scale < 0.5, 0.5, 1 > rotate y*-5 rotate z*98 translate y*0.35 }
                                  translate < 18, 3, 0 >
                      }                                              
#declare Ritewing =
                  union {                      
                          object { Leading scale < 1.25, 1, 1 > }
                          object { Tip }                      
                          object { Trail rotate z*-3 }
                          object { Trail scale < 0.9, 0.4, 1 > translate z*-0.01 } 
                        }
#declare Lefwing =
                  union {
                          object { Leading scale < 1.25, 1, 1 > }
                          object { Tip }
                          object { Trail rotate z*-3 }
                          object { Trail scale  < 0.9, 0.4, 1 > translate z*0.01 } 
                              rotate y*180
                        } 
#declare Tfev =                
               object { Fpin 
                            scale < 1.5, 1, 1 >
                            translate y*-8
                      }
#declare Tail =
               union {
                        object { Tfev rotate z*45 }
                        object { Tfev rotate z*35 }
                        object { Tfev rotate z*25 }   
                        object { Tfev rotate z*15 }
                        object { Tfev rotate z*5 }    
                        object { Tfev rotate z*-45 }
                        object { Tfev rotate z*-35 }
                        object { Tfev rotate z*-25 }   
                        object { Tfev rotate z*-15 }
                        object { Tfev rotate z*-5 }
                                  translate y*-5
                      }                     
#declare Leg =
              union {
                      sphere { < 0, 0, 0 >,1
                                scale < 1, 2, 1 > 
                                   pigment { color rgb < 0.7, 0.6, 0.3 > }
                                   finish { ambient 0 }
                             }
                       cylinder { < 0, -2, 0 >,< 0, -4, 0 >,0.3
                                      
                                }
                       torus { 1, 0.2
                                   rotate z*-80 
                                   translate < 0.3, -5, 0 >
                             }                    
                       torus { 1, 0.2
                                   rotate z*80 
                                   translate < -0.3, -5, 0 >
                             }
                               pigment { color White }
                               finish { ambient 0 }
                     }                                                                                  
#declare Body =
              union {
                      object { Leg translate < 1.25, -6, -1.3 > }   
                      object { Leg translate < -1.25, -6, -1.3 > } 
                      sphere { < 0, 0, 0 >,1
                                  scale < 0.3, 1, 0.8 >
                                  translate < 0, 6.5, -1.25 >
                                  pigment { color White }
                                  finish { ambient 0 }
                              }    
                      sphere { < 0, 0, 0 >,2.3
                                 scale < 1.2, 3, 0.7 > 
                                 translate < 0, -2, -1 >
                             }                          
                      sphere { < 0, 0, 0 >,1.5
                                 scale < 0.6, 1, 0.8 > 
                                 translate < 0, 5, -1 >
                             } 
                                   pigment { color rgb < 0.7, 0.6, 0.3 > }
                                   finish { ambient 0 }
                    }
#declare Bird =
                union {                     
                        object { Body } 
                        object { Tail }                                                                                              
                        object { Ritewing }
                        object { Lefwing } 
                           scale 0.1
                       }
object { Bird scale 0.06 rotate < -45, -30, 0 > translate < 1.3, 0.6, -39 > }  
                     
// ANNEXE ******************************************* 

#declare Tim =
              texture {  T_Wood10 scale 0.05 }
                       

#declare Board =
                 box { < 6.49, 0, -39 >,< 6.5, 0.185, -30 >
                            texture { Tim }
                     } 
#declare Bracket =
                   triangle { < 6.25, 0.6, -30 >,< 6.5, 0.6, -30 >,< 6.5, 0.4, -30 >
                                       texture { Tim }
                            }                                
union {                                   // rh wall
        
        object { Board translate y*-0.2 }
       
        object { Board translate y*-0.4 }
        
        object { Board translate y*-0.6 } 
        
        object { Board }
       
        object { Board translate y*0.2 }
       
        object { Board translate y*0.4 }
            
        object { Board scale < 1, 1.5, 1 > translate x*-6.5 rotate z*90 translate < 6.5, 0.6, 0 > }   // shelf
        object { Bracket translate z*-0.5 }  
        object { Bracket translate z*-1.5 }
        object { Bracket translate z*-2}
        object { Bracket translate z*-2.5 }
        
        object { Board translate y*0.6 }
               
        object { Board translate y*0.8 } 
       
        object { Board translate y*1 }
       
        object { Board translate < 0, 1.2, 0.1 > }
       
        object { Board translate < 0, 1.4, 0.2 > } 
        
        object { Board translate < 0, 1.6, 0.3 > }
       
        object { Board translate < 0, 1.8, 0.6 > } 
      } 
#declare Plank =
                box { < 5, 0, -30.01 >,< 6.6, 0.165, -30 >
                        texture { Tim }
                    }              
union { 
                 
        object { Plank translate y*-0.18 }
       
        object { Plank translate y*-0.36 }
       
        object { Plank translate y*-0.54 }       
       
        object { Plank translate y*-0.72 }  
        
        object { Plank }
        
        object { Plank translate y*0.18 }
        
        object { Plank translate y*0.36 }
        
        object { Plank translate y*0.54 }
              
        object { Plank translate y*0.72 } 
        
        object { Plank translate y*0.9 }
        
        object { Plank translate y*1.08 }
        
        object { Plank translate y*1.26 } 
        
        object { Plank translate y*1.44 }
        
        object { Plank translate y*1.62 }
        
        object { Plank translate y*1.8 }
         
      }                                                                                                                      

box { < 5, -0.52, -30 >,< 6.5, 3.6, -29.9 >    // back wall
               pigment { color Gray50 }
               finish { ambient 0 }
    }
box { < 6.5, -0.52, -39 >,< 6.6, 1.1, -30 >     // rh wall
               pigment { color Yellow }
               finish { ambient 0 }
    } 
triangle { < 6.5, 1.1, -39 >,< 6.5, 1.1, -30 >,< 6.5, 4.5, -30 >
               pigment { color Yellow }
               finish { ambient 0 }
         }     
box { < 0.05, -0.52, 0.1 >,< 0.1, 3, 10 >      // lh wall
             rotate y*12
             translate < 3, 0, -39 >
             pigment { color Gray80  }
             finish { ambient 0 }
    } 
    
    
// TINS **************************************

#declare Tintop =                                                    // lid
                  union {
                         cylinder { < 0, 0, 0 >,< 0, 0.02, 0 >,0.02 }
                         torus { 0.02, 0.001 translate y*0.001 }   
                         torus { 0.02, 0.002 rotate z*5 translate y*0.007 }
                         torus { 0.02, 0.002 rotate z*5 translate y*0.014 }
                                    translate < 0.05, 0.2, 0 > 
                                    pigment { color rgb < 0.9, 0.9, 1 > }
                                    finish { ambient 0 reflection 0.2 phong 1 }
                         } 
#declare Tinhand =                                                // handle
                  union {
                          torus { 0.02, 0.001
                                  clipped_by {
                                               box { < -0.025, -0.01, -0.025 >,< 0, 0.01, 0.025 > }
                                             }
                                  translate x*-0.02
                                }                                                                    
                          torus { 0.02, 0.001
                                  clipped_by {
                                               box { < 0.025, -0.01, -0.025 >,< 0, 0.01, 0.025 > }
                                             }
                                  translate x*0.02
                                }
                          cylinder { < -0.02, 0, 0.02 >,< 0.02, 0, 0.02 >,0.001 }  
                          cylinder { < -0.02, 0, -0.02 >,< 0.02, 0, -0.02 >,0.001 }    
                          cylinder { < -0.015, 0, -0.02 >,< 0.015, 0, -0.02 >,0.002 }                                    
                                    rotate x*-30
                                    translate y*0.011
                                    pigment { color White }
                                    finish { ambient 0 }
                         }           
                                                                                                  
#declare Tin =
              union {                     
                     object { Tintop }
                     object { Tinhand rotate y*90 translate y*0.2 }
                     cylinder { < 0, 0, 0 >,< 0, 0.2, 0 >,0.1 }
                     torus { 0.1, 0.0024 }
                     torus { 0.1, 0.0024 translate y*0.2 }
                                pigment { color rgb < 0.9, 0.9, 1 > } 
                                normal { dents 1 scale 0.035 }
                                finish { ambient 0 reflection 0.2 phong 1 }
                    }
#declare Alable =
               texture {
                         pigment { color rgb < 0.8, 0.2, 0.1 > }
                         finish { ambient 0 }
                       }                                                            
#declare Blable =
               texture {
                         pigment { color rgb < 0.2, 0.4, 0.6 > }
                         finish { ambient 0 }
                       }                                             
#declare Atin =
               union {
                      object { Tin }
                      cylinder { < 0, 0.02, 0 >,< 0, 0.18, 0 >,0.101 
                                 texture { Alable }
                               }
                      }                                                                        
#declare Btin =
               union {
                      object { Tin }
                      cylinder { < 0, 0.02, 0 >,< 0, 0.18, 0 >,0.101 
                                 texture { Blable }
                               } 
                     }                                  
                                          
object { Atin  scale 0.5 rotate x*-10 translate < 1.05, -0.66, -44.5 > }   
object { Btin  scale 0.5 rotate < -90, 35, 0 > translate < 0.6, -0.64, -44 > }        
object { Btin  scale 0.5 rotate < -100, -15, 0 > translate < 0.6, -0.42, -44 > }   
object { Atin  scale 0.5 rotate < -10, -30, 0 > translate < 0.55, -0.25, -44 > }     
object { Atin  scale 0.5 rotate < 10, 60, 0 > translate < 0.6, -0.09, -44 > }  
object { Btin  scale 0.5 rotate < -40, 15, 0 > translate < 0.65, 0.15, -44 > }  
object { Atin translate < 6.35, 0.6, -32 > }    
object { Atin translate < 6.35, 0.6, -31.5 > }  
object { Btin translate < 6.35, 0.6, -32.4 > }     
object { Btin translate < 6.35, 0.6, -30.4 > } 

// POST and RAIL ******************************************************* 
#declare Old =
               texture {
                         pigment { color rgb < 0.6, 0.55, 0.55 > }
                         normal { bumps scale < 0.005, 0.05, 0.005 > }
                         finish { ambient 0 }
                       }
#declare Splint =
                  cylinder { < 0, -0.2, 0 >,< 0, 0.1, 0 >,0.003
                                texture { Old }
                           }                                                       
#declare Obit = 
                union {
                        box { < -0.036, 0, -0.036 >,< 0.036, 0.3, 0.036 > }
                        object { Splint translate < 0.036, 0.22, 0.02 > }    
                        object { Splint rotate x*1 translate < 0.036, 0.21, 0.012 > }
                        object { Splint translate < 0.036, 0.15, 0.002 > }
                        object { Splint rotate x*-1translate < 0.036, 0.2, -0.015 > }
                        object { Splint translate < 0.036, 0.22, 0.025 > }
                        object { Splint rotate x*1 translate < 0.036, 0.12, 0.033 > }           
                        object { Splint translate < -0.036, 0.22, 0.012 > }    
                        object { Splint rotate x*1translate < -0.036, 0.21, 0.018 > }
                        object { Splint translate < -0.036, 0.15, 0.022 > }
                        object { Splint rotate x*-1translate < -0.036, 0.2, -0.025 > }
                        object { Splint translate < -0.036, 0.22, 0.03 > }
                        object { Splint translate < -0.036, 0.12, 0.033 > }    
                        object { Splint rotate z*1 translate < -0.036, 0.15, 0.036 > }
                        object { Splint translate < -0.03, 0.2, 0.036 > }
                        object { Splint rotate z*-1translate < -0.02, 0.22, 0.036 > }
                        object { Splint translate < 0.026, 0.12, 0.036 > }           
                        object { Splint rotate z*1 translate < -0.036, 0.15, -0.036 > }
                        object { Splint translate < -0.03, 0.2, -0.036 > }
                        object { Splint rotate z*-1 translate < -0.02, 0.22, -0.036 > }
                        object { Splint translate < 0.026, 0.12, -0.036 > }
                           texture { Old }
                    }
#declare Opart =
                  union {
                         object { Obit rotate x*1 translate z*-0.07 }  
                         object { Obit rotate x*1 translate z*0.07 }
                         object { Obit scale < 1, 0.35, 1 > }
                         object { Obit scale < 1, 0.35, 1 > translate y*0.21 } 
                        }
#declare Oldpost =
                  union {                         
                         object { Opart }
                         object { Opart rotate y*180 translate y*0.3 }    
                         object { Opart  translate y*0.6 }
                         object { Opart rotate y*180 translate y*0.9 } 
                        }

#declare Arail =
                   union { 
                          object { Obit scale < 1.6, 3, 1 > rotate z*1 }  
                          object { Obit scale < 1.63, 3, 1 > rotate z*-1 translate y*0.9 }       
                          object { Obit scale < 1.6, 3, 1 > rotate z*-1 translate y*1.2 } 
                          object { Obit scale < 0.8, 0.35, 1 > translate y*-0.1 }   
                          object { Obit scale < 0.8, 0.35, 1 > translate y*2.1 }
                         }
                                                                                              
#declare Brail =
                   union { 
                          object { Obit scale < 1.65, 2.5, 1 > rotate z*1 }  
                          object { Obit scale < 1.7, 2.75, 1 > rotate z*-1 translate y*0.75 }       
                          object { Obit scale < 1.65, 3.37, 1 > rotate z*-1 translate y*1.1 }
                          object { Obit scale < 0.8, 0.35, 1 > translate y*-0.1 }   
                          object { Obit scale < 0.8, 0.35, 1 > translate y*2.1 } 
                         }
#declare Oldfence =
                   union {                                                  
object { Arail rotate z*-90 translate < 0.038, 0.75, 0 > }  
object { Arail rotate z*92  translate < 2.1, 0.45, 0 > }      
object { Brail rotate z*-90 translate < 0.038, 0.15, 0 > }  
object { Brail rotate z*90  translate < 2.1, 1.05, 0 > }                                                 
object { Oldpost  }                         
object { Oldpost translate x*2.1 }   
object { Oldpost rotate < 0, 15, 5 > translate x*-2.1 }    
object { Oldpost rotate < 10, 15, 15 > translate x*-4.2 }    
object { Oldpost rotate < 20, 15, 25 > translate x*-6.3 } 
object { Arail rotate z*90 translate < -0.038, 0.4, 0 > }  
object { Arail rotate z*92  translate < -0.038, 0.18, 0 > }      
object { Brail rotate z*-117 rotate y*160 translate < 0, 1.05, 0 > }    
object { Arail rotate z*92  translate < -2.1, 0.45, 0 > }      
object { Brail rotate z*-90 translate < -4.2, 0.15, 0 > }  
object { Brail rotate z*110 rotate y*-10 translate < -4.4, 0.75, 0.1 > } 
object { Arail rotate z*-110  rotate y*-10 translate < -2.1, 0.75, 0.04 > }
                         }
object { Oldfence scale 0.05 translate < 1.6, -0.54, -45.45  > } 

// ROOF PYTHON *****************************************

#declare Roofserp =
                    union {
sphere_sweep {
               cubic_spline
               12
               < 1.4, -0.48, -45.6 >,0.024
               < 1.48, -0.49, -45.4 >,0.024
               < 1.6, -0.5, -45.3 >,0.029 
               < 1.7, -0.525, -45.2 >,0.038
               < 1.8, -0.55, -45 >,0.04 
               < 1.9, -0.55, -44.6 >,0.04
               < 1.8, -0.55, -44.3 >,0.04 
               < 1.9, -0.55, -44 >,0.04
               < 1.7,  -0.55, -43.75 >,0.04
               < 1.25, -0.55, -43.65 >,0.04
               < 1, -0.55, -43.5 >,0.04 
               < 0.85, -0.4, -43.5 >,0.035           

                 texture {
                             pigment { 
                                      crackle
                                      color_map {
                                                  [ 0 color Black ]   
                                                  [ 0.05 color Black ]  
                                                  [ 0.05 color  White  ]   
                                                  [ 0.95color  White  ]
                                                  [ 0.95color Black ]   
                                                  [ 1.0 color Black ]  
                                                 }
                                       scale < 0.02, 0.01, 0.01 >
                                      }
                              finish { ambient 0 }
                           } 
                  texture {
                           pigment { 
                                    spotted
                                    color_map {
                                                [ 0 color rgbt < 0, 0.9, 0, 0.3 > ] 
                                                [ 0.35 color rgbt < 0, 0.9, 0, 0.3 > ]
                                                [ 0.35 color rgbt < 0.3, 0.5, 0, 0.3 > ]
                                                [ 0.5 color rgbt < 0.6, 0.5, 0.2, 0.3 > ]  
                                                [ 0.65 color rgbt < 0.6, 0.5, 0.2, 0.3 > ]
                                                [ 0.75 color rgbt < 0, 0.9, 0, 0.3 > ]
                                                [ 0.9 color rgbt < 0, 0.9, 0, 0.3 > ]
                                                [ 1.0 color rgbt < 0.3, 0.5, 0.7, 0.3 > ]
                                               }
                                    scale 0.025
                                   }
                            normal { crackle scale 0.01 }                        
                            finish { ambient 0 reflection 0.1 phong 1 } 
                          }
              }

difference {                                                                       // head           
       union {                 
           sphere { < 0, 0, 0 >,0.06   scale < 1.5, 0.6, 0.8 >  } 
           torus { 0.054, 0.004   scale < 1.5, 2.5, 0.8 > translate y*-0.006 }
             }
       union {
               sphere { < 0, 0.018, -0.045 >,0.01 }
               cone { < 0, 0.018, -0.044 >,0.01,< -0.1, 0.014, -0.046 >,0.03 }   
               sphere { < 0, 0.018, 0.044 >,0.01 }
               cone { < 0, 0.018, 0.045 >,0.01,< -0.1, 0.014, 0.046 >,0.03 } 
               sphere { < 0, 0, 0 >,0.006
                           scale < 2.5, 1, 0.75 >
                           translate < -0.09, 0.01, -0.01 >
                      }                                                    
               sphere { < 0, 0, 0 >,0.006
                           scale < 2.5, 1, 0.75 >
                           translate < -0.09, 0.01, 0.01 >
                      }                 
             }               
                    rotate y*-45
                    translate < 1.5, -0.48, -45.35 > 
                    texture {
                             pigment { 
                                      crackle
                                      color_map {
                                                  [ 0 color Black ]   
                                                  [ 0.05 color Black ]  
                                                  [ 0.05 color  White  ]   
                                                  [ 0.95color  White  ]
                                                  [ 0.95color Black ]   
                                                  [ 1.0 color Black ]  
                                                 }
                                       scale < 0.02, 0.01, 0.01 >
                                      }
                              finish { ambient 0 }
                           } 
                   texture { 
                             pigment { 
                                      spotted 
                                      color_map {
                                                [ 0 color rgbt < 0, 0.9, 0, 0.3 > ] 
                                                [ 0.35 color rgbt < 0, 0.9, 0, 0.3 > ]
                                                [ 0.35 color rgbt < 0.3, 0.5, 0, 0.3 > ]
                                                [ 0.5 color rgbt < 0.6, 0.5, 0.2, 0.3 > ]  
                                                [ 0.65 color rgbt < 0.6, 0.5, 0.2, 0.3 > ]
                                                [ 0.75 color rgbt < 0, 0.9, 0, 0.3 > ]
                                                [ 0.9 color rgbt < 0, 0.9, 0, 0.3 > ]
                                                [ 1.0 color rgbt < 0.3, 0.5, 0.7, 0.3 > ]
                                               }
                                              scale 0.025
                                      }
                            normal { crackle scale 0.02 }                        
                            finish { ambient 0 reflection 0.1 phong 1 }
                           } 
          }  
union {                                                    
         object { Seye rotate < 15, 47, 0 > translate < 0.002, 0.015, -0.036 > }        // eyes
         object { Seye rotate < 15, 133, 0 > translate < 0.002, 0.015, 0.036 > }                
                     rotate y*-45
                     translate < 1.5, -0.48, -45.35 > 
      }               
                    }
                    
object { Roofserp translate < -1.5, 0.5, 45 >  rotate < -20, -80, 15 > rotate x*-10 translate < 3.6, 1.65, -38 > } 

sphere_sweep {                                  // roofserp tail
               cubic_spline
               9
               < 1.94, 1.4, -38.95 >,0.03
               < 1.94, 1.45, -38.95 >,0.03
               < 1.97, 1.53, -39 >,0.03 
               < 2, 1.4, -39.05 >,0.028
               < 1.9, 1.3, -39.1 >,0.025 
               < 1.8, 1.25, -39.2 >,0.02
               < 1.6, 1.2, -39.2 >,0.0125 
               < 1.55, 1.05, -39.3 >,0.01
               < 1.54,  1, -39.4 >,0.004                 

                 texture {
                             pigment { 
                                      crackle
                                      color_map {
                                                  [ 0 color Black ]   
                                                  [ 0.05 color Black ]  
                                                  [ 0.05 color  White  ]   
                                                  [ 0.95color  White  ]
                                                  [ 0.95color Black ]   
                                                  [ 1.0 color Black ]  
                                                 }
                                       scale < 0.02, 0.01, 0.01 >
                                      }
                              finish { ambient 0 }
                           } 
                  texture {
                           pigment { 
                                    spotted
                                    color_map {
                                                [ 0 color rgbt < 0, 0.9, 0, 0.3 > ] 
                                                [ 0.35 color rgbt < 0, 0.9, 0, 0.3 > ]
                                                [ 0.35 color rgbt < 0.3, 0.5, 0, 0.3 > ]
                                                [ 0.5 color rgbt < 0.6, 0.5, 0.2, 0.3 > ]  
                                                [ 0.65 color rgbt < 0.6, 0.5, 0.2, 0.3 > ]
                                                [ 0.75 color rgbt < 0, 0.9, 0, 0.3 > ]
                                                [ 0.9 color rgbt < 0, 0.9, 0, 0.3 > ]
                                                [ 1.0 color rgbt < 0.3, 0.5, 0.7, 0.3 > ]
                                               }
                                    scale 0.025
                                   }
                            normal { crackle scale 0.01 }                        
                            finish { ambient 0 reflection 0.1 phong 1 } 
                          }
              }
// OVERHEAD GEAR ***********************************************

#declare Spoke = cylinder { < 0, 0, 0 >,< 0, 0.33, 0 >,0.025
                                  scale < 0.5, 1, 1 > 
                                   pigment { color Red }
                                   finish { ambient 0 } 
                          }
#declare Dpokes =
                 union {
                          object { Spoke }
                          object { Spoke rotate x*40 }    
                          object { Spoke rotate x*80 }   
                          object { Spoke rotate x*120 }   
                          object { Spoke rotate x*160 }   
                          object { Spoke rotate x*200 }   
                          object { Spoke rotate x*240 }   
                          object { Spoke rotate x*280 }   
                          object { Spoke rotate x*320 }
                        }
#declare Flyw =
                 union {
                        object { Dpokes }
                        difference {
                                     cylinder { < -0.06, 0, 0 >,< 0.06, 0, 0 >,0.355 }  
                                     cylinder { < -0.07, 0, 0 >,< 0.07, 0, 0 >,0.35 }
                                            pigment { color Gray50 }
                                            finish { ambient 0 reflection 0.2 }
                                   } 
                        cylinder { < -0.07, 0, 0 >,< 0.07, 0, 0 >,0.06 }
                        torus { 0.06, 0.01   rotate z*90  scale < 6, 1, 1 > }
                        torus { 0.32, 0.02   rotate z*90  scale < 2.5, 1, 1 > }
                        difference {
                                     cylinder { < -0.06, 0, 0 >,< 0.06, 0, 0 >,0.35 }  
                                     cylinder { < -0.07, 0, 0 >,< 0.07, 0, 0 >,0.32 }
                                   } 
                                  pigment { color Red }
                                  finish { ambient 0 } 
                          }    
#declare Bracket =
                  difference {
                               union {
                                       cylinder { < 0, 0, 0 >,< 0, 0, 0.4 >,0.05 }
                                       sphere { < 0, 0, 0 >,0.05 }
                                       sphere { < 0, 0, 0.4 >,0.05 }
                                      } 
                               box { < -0.06, 0.025, -0.06 >,< 0.06, 0.06, 0.45 > } 
                                        pigment { color Red }
                                        finish { ambient 0 }
                             }                                                                                                   

#declare Gear =
               union { 
                       cylinder { < 2.2, -2, 0.5 >,< 2.2, 0.5, 0.5 >,0.15      // post
                                          pigment { color Gray60 }
                                          normal { dents scale < 0.001, 0.01, 0.001 > }
                                          finish { ambient 0 }
                                }
                       cylinder { < 2.2, 0.18, 0.3 >,< 2.2, 0.18, 0.4 >,0.02 }    
                       cylinder { < 2.2, -0.15, 0.3 >,< 2.2, -0.15, 0.4 >,0.02 }         
                       object { Bracket rotate x*-90 translate < 2.2, -0.2, 0.35 > }
                       object { Bracket translate < 2.2, -0.06, -0.05 > }
                                       
                       cylinder { < 0, 0, 0 >,< 5, 0, 0 >,0.03            // shaft 
                                     pigment { color Gray50 } 
                                     finish { ambient 0 reflection 0.2 } 
                                }           
                       object { Flyw  translate x*1.5 }                                                          
                       object { Flyw  translate x*2.7 } 
                       torus { 0.03, 0.04 rotate z*90 translate x*2.2 } 
                       box { < -0.04, -0.035, -0.075 >,< 0.04, -0.015, 0.075 > translate x*2.2 }
                                        pigment { color Red }
                                        finish { ambient 0 } 
                     }                                                           
                       

                             

                              
object { Gear translate < 2.75, 3.2, -35 > }                                          
                                                       
// COCKATOO *****************************************

#declare Pale =
          texture {
            pigment { color rgb < 1, 0.95, 0.9 > }
            finish { ambient 0.2 }
                  }
#declare Feather =
              disc { < 0, 0, 0 >,< 0, 0, 1 >,0.25
                     scale < 0.2, 1, 1 >
                     texture { Pale }
                   }
#declare Sfther =
            sphere { < 0, 0, 0 >,0.25   
                     scale < 0.2, 0.5, 0.005 >
                     translate < 0.1, 0.175, 0 >
                     pigment { color rgb < 0.95, 0.92, 0.8 > }
                     finish { ambient 0.2 }
                   }


#declare Toe =
             torus { 0.06, 0.01
                     rotate 90*z
                     pigment { color Gray75 }
                   }
#declare Body =
            union {
                  sphere { < 0, 0, 0 >,0.16              //head
                           scale < 0.5, 1, 0.5 >
                           translate 0.28*y
                         }
                  sphere { < 0, 0, 0 >,0.07               // beak
                            scale < 0.5, 1, 1 >
                            translate < 0, 0.38, -0.06 >
                            pigment { color Gray50 }
                            finish { ambient 0 }
                          }
                  sphere { < 0, 0, 0 >,0.02               // eye
                            scale < 0.5, 1, 1 >
                            translate < 0.05, 0.38, -0.02 >
                            pigment { color Black } 
                          }
                  sphere { < 0, 0, 0 >,0.02               // eye
                            scale < 0.5, 1, 1 >
                            translate < -0.05, 0.38, -0.02 >
                            pigment { color Black }   
                          }    
                  sphere { < 0, 0, 0 >,0.4             // body
                           scale < 0.3, 1, 0.2 > 
                         }
                   object { Toe translate < 0.05, -0.3, -0.05 > }
                   object { Toe translate < -0.05, -0.3, -0.05 > }    
                      translate -0.15*y
                      pigment { color White }     
                      finish { ambient 0.2 }
                  }
#declare Inwing =                                                        
            union {
                 cone { < 0, -0.1, 0 >,0.1,< 0.4, 0.2, 0 >,0.05 
                         scale < 1, 1, 0.01 > }
                 sphere { < 0, 0, 0 >,0.15 
                           scale < 1, 0.5, 0.01 >
                           translate < 0.45, 0.2, 0 >
                        }
                  object { Feather translate < 0.1, -0.25, 0 > }
                  object { Feather translate < 0.17, -0.22, 0 > }  
                  object { Feather translate < 0.24, -0.19, 0 > }  
                  object { Feather translate < 0.31, -0.16, 0 > }  
                  object { Feather translate < 0.38, -0.13, 0 > }  
                  object { Feather translate < 0.45, -0.1, 0 > }  
                  object { Sfther translate < 0.03, -0.25, 0 > }  
                  object { Sfther translate < 0.1, -0.25, 0 > }
                  object { Sfther translate < 0.17, -0.22, 0 > }  
                  object { Sfther translate < 0.24, -0.19, 0 > }  
                  object { Sfther translate < 0.31, -0.16, 0 > }  
                  object { Sfther translate < 0.38, -0.13, 0 > }  
                  object { Sfther translate < 0.45, -0.1, 0 > }  
                  
                  object { Sfther rotate 15*z
                                  translate < 0.52, -0.19, 0 > }  
                  object { Sfther rotate 25*z
                                  translate < 0.59, -0.16, 0 > }  
                  object { Sfther rotate 35*z
                                  translate < 0.66, -0.13, 0 > }  
                  object { Sfther rotate 45*z
                                  translate < 0.73, -0.1, 0 > }  
                  object { Sfther rotate 57*z
                                  translate < 0.83, -0.06, 0 > }  
                  object { Sfther rotate 70*z
                                  translate < 0.95, -0.02, 0 > }  
                  
                     pigment { color White }
                     finish { ambient 0.2 }
                   }
#declare Stab =
              union {   
                  object { Feather 
                           scale 0.8
                           rotate 15*z
                           translate < 0.2, -0.55, 0 > 
                         }  
                  object { Feather 
                           scale 0.8
                           rotate 10*z
                           translate < 0.14, -0.59, 0 > 
                         }  
                  object { Feather 
                           scale 0.8
                           rotate 5*z
                           translate < 0.08, -0.62, 0 > 
                         }  
                  object { Feather 
                           scale 0.8  
                           translate < 0.02, -0.65, 0 > 
                         }  
              }           
#declare Flights =              
               union {
                  object { Feather   
                           scale 1.1
                           translate -1*y
                           rotate 6*z
                          } 
                  object { Feather         
                           translate -1.05*y
                           rotate 10*z   
                         }  
                  object { Feather 
                           scale 1.1
                           translate -1.1*y
                           rotate 14*z   
                         }  
                  object { Feather         
                           scale 1.1
                           translate -1.05*y
                           rotate 18*z   
                         }  
                  object { Feather 
                           scale 0.92
                           translate -1.1*y
                           rotate 22*z   
                         }  
                         
                  object { Feather 
                           scale 0.87  
                           translate -1.12*y 
                           rotate 26*z
                         }  
                  object { Feather
                           scale 0.85
                           rotate -140*z
                           translate < 0.56, -0.95, 0 >
                         }
                         
                  object { Feather
                           scale 0.75
                           rotate -130*z
                           translate < 0.6, -0.9, 0 >
                         }
                         
                  object { Feather
                           scale 0.7
                           rotate -118*z
                           translate < 0.68, -0.85, 0 >
                         }
               }          

#declare Outwing =                         
            union {
                 sphere { < 0, 0, 0 >,0.15 
                           scale < 1, 0.5, 0.01 >
                           translate < 0.45, 0.2, 0 >
                        }
                 disc { < 0, 0, 0 >,< 0, 0, 1 >,0.15 
                           scale < 1.3, 0.5, 1 >
                           translate < 0.45, 0.15, 0 >
                        }
        difference {
                 sphere { < 0, 0, 0 >,0.25  
                           scale < 1, 0.2, 0.01 > }
                 sphere { < 0, 0, 0 >,0.4 
                           scale < 1, 0.12, 0.5 > 
                           translate < 0.25, -0.05, 0 > 
                        } 
                           rotate -18*z
                           translate < 0.75, 0.18, 0 >
                    }
                   
               disc { < 0, 0, 0 >,< 0, 0, 1 >,0.3  
                           scale < 1, 0.2, 1 > 
                           rotate -15*z
                           translate < 0.7, 0.15, 0 >
                           texture { Pale }
                        }    

                 object { Flights translate < 0.4, 0.9, 0 > }
                    pigment { color White }
                    finish { ambient 0.2 }
                  }
              
#declare Flybird =
               union {
                     object { Body }
                     object { Inwing }
                     object { Inwing rotate 180*y }   
                     object { Stab }
                     object { Stab rotate 180*y }  
                     object { Outwing }
                     object { Outwing rotate 180*y }    
                     }  

object { Flybird scale 0.3 rotate < -45, -30, -20 > 
                 translate < 5.3, 3.87, -34.35 > }  
                                                     
// BLADES **************************************

#declare Trim =
                texture { 
                         pigment { color rgb < 0.6, 0.65, 0.75 > }
                         finish { ambient 0 }
                    }

#declare Bla =
               disc { < 0, -0.9, 0 >,< 0, 0, -1 >,1
                              clipped_by {
                                           cylinder { < 0.1, 0.95, 0.01 >,< 0.1, 0.95, -0.01 >,1 }
                                         } 
                              texture { Trim }
                    }
                    
#declare Bac =
                difference {
                             cylinder { < 0, -0.9, -0.002 >,< 0, -0.9, 0.002 >,1 }
                             union {             
                                     cylinder { < 0.1, -0.95, -0.003 >,< 0.1, -0.95, 0.003 >,1 }
                                     box { < -0.5 , 0, -0.1 >,< -1.1, -2, 0.1 > }
                                   }   
                                     texture { Trim }
                           }
                            
#declare Blad =
                 
                              union {
                                      object { Bla scale < 1.3, 1, 1 > rotate -z*5 }
                                      object { Bac } 
                                              clipped_by {
                                                           box { < 0, -0.2, -0.1 >,< 0.6, 0.2, 0.1 > }
                                                         }
                                    }                     
                                                           
                          
                            
#declare Hndl =
                 union {
                          difference {
                                      torus { 0.975, 0.025 rotate x*90 translate y*-0.875 }   
                                      torus { 0.975, 0.025 rotate x*90 translate y*-0.9 } 
                                              clipped_by {
                                                            box { < -0.25, 0.15, -0.1 >,< 0, -0.15, 0.1 > }
                                                         }                                             
                                     } 
                           cone { < 0, 0.101, 0 >,0.025,< 0.2, 0.101, 0 >,0 }
                                             texture { Trim }
                        }                               
#declare Spring =
                  cylinder { < 0, 0, -0.05 >,< 0, 0, 0.05 >,0.06 open
                                 clipped_by {
                                              box { < -0.08, -0.05, -0.1 >,< 0.08, 0.1, 0.1 > rotate z*30 }
                                            }
                                     texture { Trim }
                           } 
#declare Blade =
                union {
                        object { Blad }
                        object { Hndl translate y*-0.03 }
                        object { Spring translate < -0.3, 0.06, 0 > } 
                                    translate x*0.31
                                    rotate z*10
                      }                             
#declare Blades =
                  union {                           
                          object { Blade  }
                          object { Blade rotate x*180 }
                        }
                        
object { Blades scale 0.25 rotate < 70, -40, -1 >  translate < 1.05, -0.6, -44.72 > } 

// BARBED WIRE ***************************************************

#declare Gal =                                                            // wire texture
                 texture {
                            pigment { color rgb < 0.9, 0.9, 1 > }
                            finish { ambient 0
                                     reflection 0.2
                                     phong 1
                                   }
                         }

#declare Twist =
                sphere_sweep {
                               linear_spline
                               11
                               < -0.16, -0.16, -0.5 >,0.1
                               < 0, -0.225, 0 >,0.1    
                               < 0.16, -0.16, 0.5 >,0.1
                               < 0.225, 0, 1 >,0.1     
                               < 0.16, 0.16, 1.5 >,0.1    
                               < 0, 0.225, 2 >,0.1
                               < -0.16, 0.16, 2.5 >,0.1
                               < -0.225, 0, 3 >,0.1    
                               < -0.16, -0.16, 3.5 >,0.1  
                               < 0, -0.225, 4 >,0.1 
                               < -0.16, -0.16, 4.5 >,0.1
                                 texture { Gal }
                             }
                             
#declare Section =
                   union {
                           object { Twist }
                           object { Twist rotate z*180 }
                         }
#declare Stretch =
                   union {
                           object { Section }
                           object { Section translate z*4 }   
                           object { Section translate z*8 }
                         }                          
                                                                     
                                                                     
#declare Curve =
                   union {
                           object { Section }
                           object { Section rotate x*15 translate < 0, -0.11, 4.5 > }   
                           object { Section rotate x*30 translate < 0, -1.36, 9 > }
                         }
                         
                                                 
                                                                                              
                         
                                                              
                               
                             
#declare Corner =
                 torus { 0.45, 0.1 
                             rotate z*90
                             clipped_by {
                                          box { < -0.15, 0, -0.6 >,< 0.15, 0.6, 0.6 > }
                                        }
                                 texture { Gal }
                       }
#declare Barb =
               union {
                        object { Corner rotate y*10 translate y*0.425 }                          // 1st top
                        object { Corner rotate < 180, -10, 0 > translate < -0.2, -0.425, 0 > }  // 1st bottom                                         
                         cylinder { < -0.12, -0.44, -0.44 >,< -0.08, 0.44, -0.44 >,0.1 }            
                        object { Corner rotate < 180, -10, 0 > translate < 0.2, -0.425, 0 > }   // 2nd bottom
                        cylinder { < 0.1, 0.44, 0.44 >,< 0.12, -0.44, 0.44 >,0.1 }                     
                        object { Corner rotate y*10 translate < 0.4, 0.425, 0 > }                // 2nd top
                         cylinder { < 0.32, 0.44, -0.44 >,< 0.28, -0.44, -0.44 >,0.1 } 
                        cylinder { < -0.4, 0.44, 0.44 >,< -0.28, -0.44, 0.44 >,0.1 }               // l point
                        cylinder { < 0.53, -0.44, 0.44 >,< 0.49, 0.43, 0.44 >,0.1 }                 // r point
                        cone { < -0.4, 0.44, 0.44 >,0.1,< -0.85, 2.5, 0.8 >,0 }       
                        cone { < 0.52, -0.44, 0.44 >,0.1,< 0.95, -2.5, 0.8 >,0 }    
                                    texture { Gal }
                     }

#declare Barbs =
                union {                                      
                        object { Barb scale 0.05 }  
                        object { Barb scale 0.05 rotate x*180 }
                                   scale < 2, 1, 1 > 
                      }
#declare Barbit =
                 union {                      
                         object { Barbs scale 0.1 }                      
                         object { Stretch scale 0.01 rotate y*90 translate x*0.005 }                       
                         
                       }                                                                         
                       
#declare Bendbit =
                 union {                      
                         object { Barbs scale 0.1 }                      
                         object { Curve scale 0.01 rotate y*90 translate x*0.005 }                       
                         
                       } 
                                           

#declare Barun =
                union {                     
                         object { Barbit } 
                         object { Barbit rotate z*5 translate x*0.13 }  
                         object { Barbit rotate z*-5 translate < -0.13, 0.011, 0 > } 
                         object { Bendbit rotate x*180 translate < 0.26, 0.012, 0 > }
                         object { Bendbit rotate z*30 translate < -0.26, -0.025, 0 > } 
                         
                      }   
                       
object { Barun scale 0.8 rotate z*98 translate < 1.07, -0.275, -45 > }    
object { Barun scale 0.8 rotate z*112 translate < 1.12, -0.275, -45 > }                        

// CLOUDS *************************************************

#declare Clouds =
               union {
plane { y, 0                 // top of clouds
          
           pigment { 
                    wrinkles  
                               color_map {
                                          [ 0 color Clear ] 
                                          [ 0.65 color Clear ]
                                          [ 0.75 color White ]
                                          [ 1 color White ] 
                                         }
                              turbulence 0.6  lambda 2.5           
                      }
               finish { ambient 0.25 } 
               scale < 300, 1, 450 > 
                translate < 500, 215, 0 >
       }  
       
plane { y, 0                 // middle of clouds
          
           pigment { 
                    wrinkles  
                               color_map {
                                          [ 0 color Clear ] 
                                          [ 0.65 color Clear ]
                                          [ 0.75 color rgb < 0.96, 0.86, 0.93 > ]
                                          [ 1 color rgb < 0.82, 0.77, 0.84 > ] 
                                         }
                              turbulence 0.6  lambda 3.5           
                      }
               finish { ambient 0.12 } 
               scale < 300, 1, 450 > 
                translate < 500, 210, 50 >
       }  
                                                    
plane { y, 0                 // base of clouds
          
           pigment { 
                    wrinkles  
                               color_map {
                                          [ 0 color Clear ] 
                                          [ 0.65 color Clear ]
                                          [ 0.75 color rgb < 0.84, 0.82, 0.87 > ]
                                          [ 1 color rgb < 0.86, 0.76, 0.86 > ] 
                                         }
                              turbulence 0.6  lambda 4           
                      }
               finish { ambient 0.12 } 
               scale < 300, 1, 450 > 
                translate < 500, 220, 100 >
       } 
           }
object { Clouds translate < -300, -300, -100 > } 

                        
                                                                                                                                                                                                                 
                                                                                                                                                                                              
                               
                                                                                                            